/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.award.api.AwardPostResult;
import org.kuali.coeus.award.finance.timeAndMoney.TimeAndMoneyPosts;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardFinanceIntegrationService;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.service.AwardDirectFandADistributionService;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.history.TransactionDetailType;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.kra.timeandmoney.transactions.TransactionRuleImpl;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="timeAndMoneyService")
public class TimeAndMoneyServiceImpl
implements TimeAndMoneyService {
    private static final String AWARD_ID = "awardId";
    private static final String AWARD_FAMILY = "awardFamily";
    private static final String DOCUMENT_NUMBER = "documentNumber";
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="awardDirectFandADistributionService")
    private AwardDirectFandADistributionService awardDirectFandADistributionService;
    @Autowired
    @Qualifier(value="awardVersionService")
    private AwardVersionService awardVersionService;
    @Autowired
    @Qualifier(value="awardHierarchyService")
    private AwardHierarchyService awardHierarchyService;
    @Autowired
    @Qualifier(value="awardAmountInfoService")
    private AwardAmountInfoService awardAmountInfoService;
    @Autowired
    @Qualifier(value="sequenceAccessorService")
    private SequenceAccessorService sequenceAccessorService;
    @Autowired
    @Qualifier(value="awardFinanceIntegrationService")
    private AwardFinanceIntegrationService awardFinanceIntegrationService;
    private static Logger LOG = LogManager.getLogger(TimeAndMoneyServiceImpl.class);
    private static final String TIMEANDMONEY_DOCUMENT = "timeandmoney document";
    private static final String ROOT_AWARD = "000000-00000";
    private static final String INITIAL_TRANSACTION_COMMENT = "Initial Time And Money creation transaction";
    private static final String ENABLE_AWARD_ANT_OBL_DIRECT_INDIRECT_COST_TRUE = "1";
    public static final String ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST = "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST";
    public static final String AWARD_AMOUNT_INFOS = "awardAmountInfos";
    private static final String PROJECT_END_COMMENT = "Project End";
    private static final String OBLIGATED_END_COMMENT = "Obligated End";
    private static final String OBLIGATED_START_COMMENT = "Obligated Start";
    public static final String SINGLE_NODE_MONEY_TRANSACTION_COMMENT = "Single Node Money Transaction";
    public static final String TRANSACTION_SEQUENCE = "SEQ_TRANSACTION_ID";
    private TransactionRuleImpl transactionRuleImpl;

    public boolean isDirectIndirectViewEnabled() {
        boolean returnValue = false;
        String directIndirectEnabledValue = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST);
        if (directIndirectEnabledValue.equals(ENABLE_AWARD_ANT_OBL_DIRECT_INDIRECT_COST_TRUE)) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void addPostEntry(Long awardId, String awardNumber, String documentNumber) {
        TimeAndMoneyPosts timeAndMoneyPosts = new TimeAndMoneyPosts();
        timeAndMoneyPosts.setAwardId(awardId);
        timeAndMoneyPosts.setDocumentNumber(documentNumber);
        String awardFamily = AwardService.getAwardFamily(awardNumber);
        timeAndMoneyPosts.setAwardFamily(awardFamily);
        if (this.isTimeAndMoneyPostRestIntegrationOn()) {
            HashMap<String, Long> values = new HashMap<String, Long>();
            values.put(AWARD_ID, awardId);
            Award award = this.businessObjectService.findMatching(Award.class, values).stream().findFirst().orElse(null);
            this.transmitTimeAndMoneyPost(award, documentNumber, timeAndMoneyPosts);
        }
        this.dataObjectService.save((Object)timeAndMoneyPosts, new PersistenceOption[0]);
    }

    @Override
    public void resendPostEntry(Long awardId, String awardNumber, String documentNumber) {
        String awardFamily = AwardService.getAwardFamily(awardNumber);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(AWARD_FAMILY, awardFamily);
        values.put(DOCUMENT_NUMBER, documentNumber);
        values.put(AWARD_ID, awardId);
        TimeAndMoneyPosts timeAndMoneyPosts = this.dataObjectService.findMatching(TimeAndMoneyPosts.class, QueryByCriteria.Builder.andAttributes(values).build()).getResults().stream().findFirst().orElse(null);
        if (timeAndMoneyPosts != null && this.isTimeAndMoneyPostRestIntegrationOn()) {
            HashMap<String, Long> awardLookupValues = new HashMap<String, Long>();
            awardLookupValues.put(AWARD_ID, awardId);
            Award award = this.businessObjectService.findMatching(Award.class, awardLookupValues).stream().findFirst().orElse(null);
            this.transmitTimeAndMoneyPost(award, documentNumber, timeAndMoneyPosts);
            this.dataObjectService.save((Object)timeAndMoneyPosts, new PersistenceOption[0]);
        }
    }

    public boolean isTimeAndMoneyPostRestIntegrationOn() {
        return this.parameterService.getParameterValueAsBoolean("KC-T", "All", "T_M_POST_FIN_REST_INT_ENABLE");
    }

    public String transmitTimeAndMoneyPost(Award award, String docNumber, TimeAndMoneyPosts post) {
        AwardPostResult postResult = this.awardFinanceIntegrationService.transmitTimeAndMoneyPost(award, docNumber);
        post.setUpdateTimestamp(new Timestamp(System.currentTimeMillis()));
        post.setPostStatus(postResult.getProcessStatus());
        post.setPostDetails(postResult.getStatusDetails());
        return post.getPostStatus();
    }

    private void addNewAwardAmountInfoForInitialTransaction(Award rootAward, String documentNumber) {
        AwardAmountInfo rootAwardAmountInfo = rootAward.getLastAwardAmountInfo();
        AwardAmountInfo newAwardAmountInfo = new AwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(rootAward.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(rootAward.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(rootAwardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(rootAwardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(rootAwardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(null);
        newAwardAmountInfo.setAward(rootAward);
        if (this.isDirectIndirectViewEnabled()) {
            newAwardAmountInfo.setAmountObligatedToDate((ScaleTwoDecimal)rootAward.getObligatedTotalDirect().add((AbstractDecimal)rootAward.getObligatedTotalIndirect()));
            newAwardAmountInfo.setObligatedTotalDirect(rootAward.getObligatedTotalDirect());
            newAwardAmountInfo.setObligatedTotalIndirect(rootAward.getObligatedTotalIndirect());
            newAwardAmountInfo.setAnticipatedTotalAmount((ScaleTwoDecimal)rootAward.getAnticipatedTotalDirect().add((AbstractDecimal)rootAward.getAnticipatedTotalIndirect()));
            newAwardAmountInfo.setAnticipatedTotalDirect(rootAward.getAnticipatedTotalDirect());
            newAwardAmountInfo.setAnticipatedTotalIndirect(rootAward.getAnticipatedTotalIndirect());
            newAwardAmountInfo.setObliDistributableAmount((ScaleTwoDecimal)rootAward.getObligatedTotalDirect().add((AbstractDecimal)rootAward.getObligatedTotalIndirect()));
            newAwardAmountInfo.setAntDistributableAmount((ScaleTwoDecimal)rootAward.getAnticipatedTotalDirect().add((AbstractDecimal)rootAward.getAnticipatedTotalIndirect()));
        } else {
            newAwardAmountInfo.setAmountObligatedToDate(rootAwardAmountInfo.getAmountObligatedToDate());
            newAwardAmountInfo.setObligatedTotalDirect(rootAward.getObligatedTotalDirect());
            newAwardAmountInfo.setObligatedTotalIndirect(rootAward.getObligatedTotalIndirect());
            newAwardAmountInfo.setAnticipatedTotalAmount(rootAward.getAnticipatedTotal());
            newAwardAmountInfo.setAnticipatedTotalDirect(rootAward.getAnticipatedTotalDirect());
            newAwardAmountInfo.setAnticipatedTotalIndirect(rootAward.getAnticipatedTotalIndirect());
            newAwardAmountInfo.setObliDistributableAmount(rootAward.getObligatedTotal());
            newAwardAmountInfo.setAntDistributableAmount(rootAward.getAnticipatedTotal());
        }
        newAwardAmountInfo.setOriginatingAwardVersion(rootAward.getSequenceNumber());
        rootAward.getAwardAmountInfos().add(newAwardAmountInfo);
        this.businessObjectService.save((PersistableBusinessObject)rootAward);
    }

    @Override
    public TimeAndMoneyDocument setupTimeAndMoneyDocument(String rootAwardNumber, Award currentAward) throws WorkflowException {
        Award rootAward = this.awardVersionService.getWorkingAwardVersion(rootAwardNumber);
        this.generateDirectFandADistribution(currentAward);
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)this.documentService.getNewDocument(TimeAndMoneyDocument.class);
        timeAndMoneyDocument.getDocumentHeader().setDocumentDescription(TIMEANDMONEY_DOCUMENT);
        timeAndMoneyDocument.setRootAwardNumber(rootAwardNumber);
        timeAndMoneyDocument.setAwardNumber(rootAward.getAwardNumber());
        timeAndMoneyDocument.setAward(rootAward);
        AwardAmountTransaction aat = new AwardAmountTransaction();
        aat.setAwardNumber(ROOT_AWARD);
        aat.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
        String defaultTxnTypeStr = this.parameterService.getParameterValueAsString("KC-T", "Document", "TXN_TYPE_DEF_COPIED_AWARD");
        if (StringUtils.isNotEmpty((CharSequence)defaultTxnTypeStr)) {
            aat.setTransactionTypeCode(Integer.parseInt(defaultTxnTypeStr));
        }
        aat.setAwardNumber(rootAward.getAwardNumber());
        TransactionDetail transactionDetail = this.addTransactionDetails(ROOT_AWARD, rootAward.getAwardNumber(), rootAward.getSequenceNumber(), timeAndMoneyDocument.getDocumentNumber(), INITIAL_TRANSACTION_COMMENT, rootAward);
        if (rootAward.getAwardAmountInfos().size() < 2) {
            this.addNewAwardAmountInfoForInitialTransaction(rootAward, timeAndMoneyDocument.getDocumentNumber());
        } else {
            rootAward.getLastAwardAmountInfo().setTimeAndMoneyDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
            this.businessObjectService.save((PersistableBusinessObject)rootAward);
        }
        timeAndMoneyDocument.getAwardAmountTransactions().add(aat);
        this.documentService.saveDocument((Document)timeAndMoneyDocument);
        this.businessObjectService.save((PersistableBusinessObject)transactionDetail);
        return timeAndMoneyDocument;
    }

    protected TransactionDetail addTransactionDetails(String sourceAwardNumber, String destinationAwardNumber, Integer sequenceNumber, String documentNumber, String commentsString, Award rootAward) {
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setSourceAwardNumber(sourceAwardNumber);
        transactionDetail.setSequenceNumber(sequenceNumber);
        transactionDetail.setDestinationAwardNumber(destinationAwardNumber);
        if (this.isDirectIndirectViewEnabled()) {
            transactionDetail.setAnticipatedAmount((ScaleTwoDecimal)rootAward.getAnticipatedTotalDirect().add((AbstractDecimal)rootAward.getAnticipatedTotalIndirect()));
            transactionDetail.setAnticipatedDirectAmount(rootAward.getAnticipatedTotalDirect());
            transactionDetail.setAnticipatedIndirectAmount(rootAward.getAnticipatedTotalIndirect());
            transactionDetail.setObligatedAmount((ScaleTwoDecimal)rootAward.getObligatedTotalDirect().add((AbstractDecimal)rootAward.getObligatedTotalIndirect()));
            transactionDetail.setObligatedDirectAmount(rootAward.getObligatedTotalDirect());
            transactionDetail.setObligatedIndirectAmount(rootAward.getObligatedTotalIndirect());
        } else {
            transactionDetail.setAnticipatedAmount(rootAward.getAnticipatedTotal());
            transactionDetail.setAnticipatedDirectAmount(rootAward.getAnticipatedTotal());
            transactionDetail.setAnticipatedIndirectAmount(ScaleTwoDecimal.ZERO);
            transactionDetail.setObligatedAmount(rootAward.getObligatedTotal());
            transactionDetail.setObligatedDirectAmount(rootAward.getObligatedTotal());
            transactionDetail.setObligatedIndirectAmount(ScaleTwoDecimal.ZERO);
        }
        transactionDetail.setAwardNumber(rootAward.getAwardNumber());
        transactionDetail.setTransactionId(0L);
        transactionDetail.setTimeAndMoneyDocumentNumber(documentNumber);
        transactionDetail.setComments(commentsString);
        transactionDetail.setTransactionDetailType(TransactionDetailType.PRIMARY.toString());
        return transactionDetail;
    }

    protected void generateDirectFandADistribution(Award award) {
        if (award.getAwardEffectiveDate() != null) {
            this.businessObjectService.delete(award.getAwardDirectFandADistributions());
            Boolean autoGenerate = this.parameterService.getParameterValueAsBoolean("KC-AWARD", "Document", "AUTO_GENERATE_TIME_AND_MONEY_FUNDS_DIST_PERIODS");
            if (autoGenerate.booleanValue()) {
                award.setAwardDirectFandADistributions(this.awardDirectFandADistributionService.generateDefaultAwardDirectFandADistributionPeriods(award));
            }
        }
    }

    @Override
    public Award populateAwardHierarchyItems(TimeAndMoneyDocument timeAndMoneyDocument, String rootAwardNumber, List<String> order) {
        timeAndMoneyDocument.setAwardHierarchyItems(this.awardHierarchyService.getAwardHierarchy(rootAwardNumber, order));
        timeAndMoneyDocument.setAwardNumber(rootAwardNumber);
        Award tmpAward = this.getCurrentAward(timeAndMoneyDocument);
        if (tmpAward != null) {
            this.awardHierarchyService.populateAwardHierarchyNodesForTandMDoc(timeAndMoneyDocument.getAwardHierarchyItems(), timeAndMoneyDocument.getAwardHierarchyNodes(), tmpAward.getAwardNumber(), tmpAward.getSequenceNumber().toString(), timeAndMoneyDocument);
        } else {
            this.awardHierarchyService.populateAwardHierarchyNodesForTandMDoc(timeAndMoneyDocument.getAwardHierarchyItems(), timeAndMoneyDocument.getAwardHierarchyNodes(), null, null, timeAndMoneyDocument);
        }
        return tmpAward;
    }

    private Award getCurrentAward(TimeAndMoneyDocument timeAndMoneyDocument) {
        Award tmpAward = timeAndMoneyDocument.getAward();
        if (tmpAward == null) {
            tmpAward = this.awardVersionService.getWorkingAwardVersion(timeAndMoneyDocument.getAwardNumber());
        }
        return tmpAward;
    }

    private int findAwardHierarchyNodeIndex(Map.Entry<String, AwardHierarchyNode> awardHierarchyNode) {
        String nodeIndex = awardHierarchyNode.getValue().getAwardNumber().replaceAll("\\d*\\-0*", "");
        return Integer.parseInt(nodeIndex);
    }

    private String getNoCostExtensionCode() {
        return this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "No_Cost_Extension_Transaction_Type_Code");
    }

    @Override
    public void captureDateChangeTransactions(TimeAndMoneyDocument timeAndMoneyDocument, List<AwardHierarchyNode> awardHierarchyNodeItems) throws WorkflowException {
        boolean isNoCostExtension = timeAndMoneyDocument.getAwardAmountTransactions().get(0).getTransactionTypeCode() == null ? false : timeAndMoneyDocument.getAwardAmountTransactions().get(0).getTransactionTypeCode().equals(Integer.parseInt(this.getNoCostExtensionCode()));
        ArrayList<TransactionDetail> dateChangeTransactionDetailItems = new ArrayList<TransactionDetail>();
        this.updateDocumentFromSession(timeAndMoneyDocument);
        this.updateAwardAmountTransactions(timeAndMoneyDocument);
        for (Map.Entry<String, AwardHierarchyNode> awardHierarchyNode : timeAndMoneyDocument.getAwardHierarchyNodes().entrySet()) {
            AwardDocument awardDocument;
            Award award = this.awardVersionService.getWorkingAwardVersion(awardHierarchyNode.getValue().getAwardNumber());
            int index = this.findAwardHierarchyNodeIndex(awardHierarchyNode);
            AwardAmountInfo aai = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            boolean needToSaveAward = false;
            needToSaveAward |= this.inspectAndCaptureCurrentFundEffectiveDateChanges(awardHierarchyNodeItems, isNoCostExtension, aai, index, award, timeAndMoneyDocument, awardHierarchyNode, dateChangeTransactionDetailItems);
            aai = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            needToSaveAward |= this.inspectAndCaptureObligationExpirationDateChanges(awardHierarchyNodeItems, isNoCostExtension, aai, index, award, timeAndMoneyDocument, awardHierarchyNode, dateChangeTransactionDetailItems);
            aai = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            needToSaveAward |= this.inspectAndCaptureFinalExpirationDateChanges(awardHierarchyNodeItems, isNoCostExtension, aai, index, award, timeAndMoneyDocument, awardHierarchyNode, dateChangeTransactionDetailItems);
            if (award.getAwardNumber().equals(timeAndMoneyDocument.getAward().getAwardNumber()) && this.mustSetFandADistributions((awardDocument = (AwardDocument)this.documentService.getByDocumentHeaderId(award.getAwardDocument().getDocumentNumber())).getAward().getAwardDirectFandADistributions(), timeAndMoneyDocument.getAward().getAwardDirectFandADistributions())) {
                awardDocument.getAward().setAwardDirectFandADistributions(timeAndMoneyDocument.getAward().getAwardDirectFandADistributions());
                this.documentService.saveDocument((Document)awardDocument);
                needToSaveAward = true;
            }
            if (!needToSaveAward) continue;
            this.businessObjectService.save((PersistableBusinessObject)award);
        }
        this.businessObjectService.save(timeAndMoneyDocument.getAwardAmountTransactions());
        this.businessObjectService.save(dateChangeTransactionDetailItems);
        timeAndMoneyDocument.getAward().refreshReferenceObject(AWARD_AMOUNT_INFOS);
    }

    private boolean mustSetFandADistributions(List<AwardDirectFandADistribution> awardFandADistributions, List<AwardDirectFandADistribution> tAndMFandADistributions) {
        boolean needToSave = false;
        if (awardFandADistributions.size() != tAndMFandADistributions.size()) {
            needToSave = true;
            return needToSave;
        }
        for (AwardDirectFandADistribution awardDistribution : awardFandADistributions) {
            boolean found = false;
            for (AwardDirectFandADistribution tAndMDistribution : tAndMFandADistributions) {
                if (!awardDistribution.equals(tAndMDistribution)) continue;
                found = true;
            }
            if (found) continue;
            needToSave = true;
        }
        return needToSave;
    }

    protected boolean inspectAndCaptureFinalExpirationDateChanges(List<AwardHierarchyNode> awardHierarchyNodeItems, Boolean isNoCostExtension, AwardAmountInfo awardAmountInfo, Integer index, Award award, TimeAndMoneyDocument timeAndMoneyDocument, Map.Entry<String, AwardHierarchyNode> awardHierarchyNode, List<TransactionDetail> dateChangeTransactionDetailItems) {
        boolean needToSave = false;
        if (awardHierarchyNodeItems.get(index).isPopulatedFromClient() && awardHierarchyNodeItems.get(index).getFinalExpirationDate() != null && !awardHierarchyNodeItems.get(index).getFinalExpirationDate().equals(awardAmountInfo.getFinalExpirationDate())) {
            if (isNoCostExtension.booleanValue() && awardHierarchyNodeItems.get(index).getFinalExpirationDate().after(awardAmountInfo.getFinalExpirationDate())) {
                awardAmountInfo = this.getNewAwardAmountInfoForDateChangeTransaction(awardAmountInfo, award, timeAndMoneyDocument.getDocumentNumber());
                awardAmountInfo.setFinalExpirationDate(awardHierarchyNodeItems.get(index).getFinalExpirationDate());
                awardHierarchyNode.getValue().setFinalExpirationDate(awardHierarchyNodeItems.get(index).getFinalExpirationDate());
                award.getAwardAmountInfos().add(awardAmountInfo);
                TransactionDetail transactionDetail = this.createTransDetailForDateChanges(awardAmountInfo.getAwardNumber(), awardAmountInfo.getAwardNumber(), awardAmountInfo.getSequenceNumber(), timeAndMoneyDocument.getAwardNumber(), timeAndMoneyDocument.getDocumentNumber(), PROJECT_END_COMMENT);
                awardAmountInfo.setTransactionId(transactionDetail.getTransactionId());
                dateChangeTransactionDetailItems.add(transactionDetail);
            } else {
                awardAmountInfo = this.getNewAwardAmountInfoForDateChangeTransaction(awardAmountInfo, award, timeAndMoneyDocument.getDocumentNumber());
                awardAmountInfo.setFinalExpirationDate(awardHierarchyNodeItems.get(index).getFinalExpirationDate());
                awardHierarchyNode.getValue().setFinalExpirationDate(awardHierarchyNodeItems.get(index).getFinalExpirationDate());
                award.getAwardAmountInfos().add(awardAmountInfo);
            }
            needToSave = true;
        } else if (awardHierarchyNodeItems.get(index).isPopulatedFromClient() && awardHierarchyNodeItems.get(index).getFinalExpirationDate() == null) {
            awardHierarchyNode.getValue().setFinalExpirationDate(null);
        }
        if (awardHierarchyNodeItems.get(index).getCurrentFundEffectiveDate() != null && awardHierarchyNodeItems.get(index).getFinalExpirationDate() != null && awardHierarchyNodeItems.get(index).getFinalExpirationDate().equals(awardAmountInfo.getFinalExpirationDate()) && !awardHierarchyNodeItems.get(index).getFinalExpirationDate().equals(awardHierarchyNode.getValue().getFinalExpirationDate())) {
            awardHierarchyNode.getValue().setFinalExpirationDate(awardHierarchyNodeItems.get(index).getFinalExpirationDate());
        }
        return needToSave;
    }

    @Override
    public TransactionDetail createTransDetailForDateChanges(String sourceAwardNumber, String destinationAwardNumber, Integer sequenceNumber, String currentAwardNumber, String documentNumber, String commentsString) {
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setSourceAwardNumber(sourceAwardNumber);
        transactionDetail.setSequenceNumber(sequenceNumber);
        transactionDetail.setDestinationAwardNumber(destinationAwardNumber);
        transactionDetail.setAwardNumber(currentAwardNumber);
        transactionDetail.setTransactionDetailType(TransactionDetailType.DATE.toString());
        transactionDetail.setTransactionId(this.sequenceAccessorService.getNextAvailableSequenceNumber(TRANSACTION_SEQUENCE));
        transactionDetail.setTimeAndMoneyDocumentNumber(documentNumber);
        transactionDetail.setComments(commentsString);
        return transactionDetail;
    }

    @Override
    public AwardAmountInfo getNewAwardAmountInfoForDateChangeTransaction(AwardAmountInfo awardAmountInfo, Award award, String documentNumber) {
        AwardAmountInfo newAwardAmountInfo = new AwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(awardAmountInfo.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(award.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(null);
        newAwardAmountInfo.setAward(award);
        newAwardAmountInfo.setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
        newAwardAmountInfo.setAmountObligatedToDate(awardAmountInfo.getAmountObligatedToDate());
        newAwardAmountInfo.setObligatedTotalDirect(awardAmountInfo.getObligatedTotalDirect());
        newAwardAmountInfo.setObligatedTotalIndirect(awardAmountInfo.getObligatedTotalIndirect());
        newAwardAmountInfo.setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
        newAwardAmountInfo.setAnticipatedTotalAmount(awardAmountInfo.getAnticipatedTotalAmount());
        newAwardAmountInfo.setAnticipatedTotalDirect(awardAmountInfo.getAnticipatedTotalDirect());
        newAwardAmountInfo.setAnticipatedTotalIndirect(awardAmountInfo.getAnticipatedTotalIndirect());
        newAwardAmountInfo.setObligatedChangeDirect(ScaleTwoDecimal.ZERO);
        newAwardAmountInfo.setObligatedChangeIndirect(ScaleTwoDecimal.ZERO);
        newAwardAmountInfo.setAnticipatedChangeDirect(ScaleTwoDecimal.ZERO);
        newAwardAmountInfo.setAnticipatedChangeIndirect(ScaleTwoDecimal.ZERO);
        newAwardAmountInfo.setOriginatingAwardVersion(award.getSequenceNumber());
        return newAwardAmountInfo;
    }

    protected boolean inspectAndCaptureObligationExpirationDateChanges(List<AwardHierarchyNode> awardHierarchyNodeItems, Boolean isNoCostExtension, AwardAmountInfo aai, Integer index, Award award, TimeAndMoneyDocument timeAndMoneyDocument, Map.Entry<String, AwardHierarchyNode> awardHierarchyNode, List<TransactionDetail> dateChangeTransactionDetailItems) {
        boolean needToSave = false;
        Date previousObligationExpirationDate = aai.getObligationExpirationDate();
        Date currentObligationExpirationDate = awardHierarchyNodeItems.get(index).getObligationExpirationDate();
        if (awardHierarchyNodeItems.get(index).isPopulatedFromClient() && currentObligationExpirationDate != null && !currentObligationExpirationDate.equals(previousObligationExpirationDate)) {
            if (isNoCostExtension.booleanValue() && (previousObligationExpirationDate == null || currentObligationExpirationDate.after(previousObligationExpirationDate))) {
                aai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                aai.setObligationExpirationDate(currentObligationExpirationDate);
                awardHierarchyNode.getValue().setObligationExpirationDate(currentObligationExpirationDate);
                award.getAwardAmountInfos().add(aai);
                TransactionDetail transactionDetail = this.createTransDetailForDateChanges(aai.getAwardNumber(), aai.getAwardNumber(), aai.getSequenceNumber(), timeAndMoneyDocument.getAwardNumber(), timeAndMoneyDocument.getDocumentNumber(), OBLIGATED_END_COMMENT);
                aai.setTransactionId(transactionDetail.getTransactionId());
                dateChangeTransactionDetailItems.add(transactionDetail);
            } else {
                aai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                aai.setObligationExpirationDate(currentObligationExpirationDate);
                awardHierarchyNode.getValue().setObligationExpirationDate(currentObligationExpirationDate);
                award.getAwardAmountInfos().add(aai);
            }
            needToSave = true;
        } else if (awardHierarchyNodeItems.get(index).isPopulatedFromClient() && currentObligationExpirationDate == null) {
            awardHierarchyNode.getValue().setObligationExpirationDate(null);
        }
        if (awardHierarchyNodeItems.get(index).getCurrentFundEffectiveDate() != null && currentObligationExpirationDate != null && currentObligationExpirationDate.equals(previousObligationExpirationDate) && !currentObligationExpirationDate.equals(awardHierarchyNode.getValue().getObligationExpirationDate())) {
            awardHierarchyNode.getValue().setObligationExpirationDate(currentObligationExpirationDate);
        }
        return needToSave;
    }

    protected boolean inspectAndCaptureCurrentFundEffectiveDateChanges(List<AwardHierarchyNode> awardHierarchyNodeItems, Boolean isNoCostExtension, AwardAmountInfo aai, Integer index, Award award, TimeAndMoneyDocument timeAndMoneyDocument, Map.Entry<String, AwardHierarchyNode> awardHierarchyNode, List<TransactionDetail> dateChangeTransactionDetailItems) {
        Date currentEffectiveDate = awardHierarchyNodeItems.get(index).getCurrentFundEffectiveDate();
        Date previousEffectiveDate = aai.getCurrentFundEffectiveDate();
        boolean needToSave = false;
        if (awardHierarchyNodeItems.get(index).isPopulatedFromClient() && currentEffectiveDate != null && !currentEffectiveDate.equals(previousEffectiveDate)) {
            if (isNoCostExtension.booleanValue() && previousEffectiveDate != null && currentEffectiveDate.before(previousEffectiveDate)) {
                AwardAmountInfo tempAai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                needToSave = true;
                aai = tempAai;
                aai.setCurrentFundEffectiveDate(currentEffectiveDate);
                awardHierarchyNode.getValue().setCurrentFundEffectiveDate(currentEffectiveDate);
                award.getAwardAmountInfos().add(aai);
                TransactionDetail transactionDetail = this.createTransDetailForDateChanges(aai.getAwardNumber(), aai.getAwardNumber(), aai.getSequenceNumber(), timeAndMoneyDocument.getAwardNumber(), timeAndMoneyDocument.getDocumentNumber(), OBLIGATED_START_COMMENT);
                aai.setTransactionId(transactionDetail.getTransactionId());
                dateChangeTransactionDetailItems.add(transactionDetail);
            } else {
                AwardAmountInfo tempAai = this.getNewAwardAmountInfoForDateChangeTransaction(aai, award, timeAndMoneyDocument.getDocumentNumber());
                needToSave = true;
                aai = tempAai;
                aai.setCurrentFundEffectiveDate(currentEffectiveDate);
                awardHierarchyNode.getValue().setCurrentFundEffectiveDate(currentEffectiveDate);
                award.getAwardAmountInfos().add(aai);
            }
        } else if (awardHierarchyNodeItems.get(index).isPopulatedFromClient() && currentEffectiveDate == null) {
            awardHierarchyNode.getValue().setCurrentFundEffectiveDate(null);
        }
        if (awardHierarchyNodeItems.get(index).getCurrentFundEffectiveDate() != null && awardHierarchyNodeItems.get(index).getCurrentFundEffectiveDate().equals(aai.getCurrentFundEffectiveDate()) && !awardHierarchyNodeItems.get(index).getCurrentFundEffectiveDate().equals(awardHierarchyNode.getValue().getCurrentFundEffectiveDate())) {
            awardHierarchyNode.getValue().setCurrentFundEffectiveDate(awardHierarchyNodeItems.get(index).getCurrentFundEffectiveDate());
        }
        return needToSave;
    }

    private void updateDocumentFromSession(TimeAndMoneyDocument doc) {
        if (doc.getAwardHierarchyNodes() == null || doc.getAwardHierarchyNodes().size() == 0) {
            if (GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY") != null) {
                TimeAndMoneyDocument document = (TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY");
                doc.setAwardHierarchyItems(document.getAwardHierarchyItems());
                doc.setAwardHierarchyNodes(document.getAwardHierarchyNodes());
            } else {
                LOG.error("Can't Retrieve Time And Money Document from Session");
            }
        }
    }

    @Override
    public void updateAwardAmountTransactions(TimeAndMoneyDocument timeAndMoneyDocument) {
        AwardAmountTransaction aat;
        if (timeAndMoneyDocument.getAwardAmountTransactions().size() == 0 && (aat = timeAndMoneyDocument.getNewAwardAmountTransaction()) != null) {
            aat.setAwardNumber(timeAndMoneyDocument.getAwardNumber());
            aat.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
            timeAndMoneyDocument.getAwardAmountTransactions().add(aat);
        }
        if (timeAndMoneyDocument.getAwardAmountTransactions().size() > 0) {
            AwardAmountTransaction firstAatInList = timeAndMoneyDocument.getAwardAmountTransactions().get(0);
            timeAndMoneyDocument.getAwardAmountTransactions().forEach(awardAmountTransaction -> {
                awardAmountTransaction.setTransactionTypeCode(firstAatInList.getTransactionTypeCode());
                awardAmountTransaction.setNoticeDate(firstAatInList.getNoticeDate());
                awardAmountTransaction.setComments(firstAatInList.getComments());
                awardAmountTransaction.setAwardNumber(timeAndMoneyDocument.getAwardNumber());
                awardAmountTransaction.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
            });
        }
    }

    @Override
    public boolean captureMoneyChanges(List<AwardHierarchyNode> awardHierarchyNodeItems, TimeAndMoneyDocument timeAndMoneyDocument, List<TransactionDetail> moneyTransactionDetailItems, Map.Entry<String, AwardHierarchyNode> awardHierarchyNode) {
        Award award = this.awardVersionService.getWorkingAwardVersion(awardHierarchyNode.getValue().getAwardNumber());
        AwardAmountInfo aai = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
        boolean refreshNeeded = this.inspectAndCaptureAmountChanges(awardHierarchyNodeItems, aai, award, timeAndMoneyDocument, awardHierarchyNode.getValue());
        this.businessObjectService.save((PersistableBusinessObject)award);
        this.businessObjectService.save(moneyTransactionDetailItems);
        timeAndMoneyDocument.getAward().refreshReferenceObject(AWARD_AMOUNT_INFOS);
        return refreshNeeded;
    }

    private boolean inspectAndCaptureAmountChanges(List<AwardHierarchyNode> awardHierarchyNodeItems, AwardAmountInfo aai, Award award, TimeAndMoneyDocument timeAndMoneyDocument, AwardHierarchyNode awardHierarchyNode) {
        boolean result = this.isDirectIndirectViewEnabled() ? this.createAndValidateEnabledViewTransaction(aai, award, timeAndMoneyDocument, awardHierarchyNode, awardHierarchyNodeItems) : this.createAndValidateDisabledViewTransaction(aai, award, timeAndMoneyDocument, awardHierarchyNode, awardHierarchyNodeItems);
        return result;
    }

    private boolean createAndValidateEnabledViewTransaction(AwardAmountInfo aai, Award award, TimeAndMoneyDocument timeAndMoneyDocument, AwardHierarchyNode ahn, List<AwardHierarchyNode> awardHierarchyNodeItems) {
        boolean result = false;
        AwardHierarchyNode awardHierarchyNode = awardHierarchyNodeItems.get(1);
        this.transactionRuleImpl = new TransactionRuleImpl();
        PendingTransaction pendingTransaction = new PendingTransaction();
        pendingTransaction.setComments(SINGLE_NODE_MONEY_TRANSACTION_COMMENT);
        ScaleTwoDecimal currentObligatedDirect = aai.getObligatedTotalDirect();
        ScaleTwoDecimal currentObligatedIndirect = aai.getObligatedTotalIndirect();
        ScaleTwoDecimal currentAnticipatedDirect = aai.getAnticipatedTotalDirect();
        ScaleTwoDecimal currentAnticipatedIndirect = aai.getAnticipatedTotalIndirect();
        for (PendingTransaction penTran : timeAndMoneyDocument.getPendingTransactions()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)penTran.getSourceAwardNumber(), (CharSequence)ROOT_AWARD)) {
                currentObligatedDirect = (ScaleTwoDecimal)currentObligatedDirect.add((AbstractDecimal)penTran.getObligatedDirectAmount());
                currentObligatedIndirect = (ScaleTwoDecimal)currentObligatedIndirect.add((AbstractDecimal)penTran.getObligatedIndirectAmount());
                currentAnticipatedDirect = (ScaleTwoDecimal)currentAnticipatedDirect.add((AbstractDecimal)penTran.getAnticipatedDirectAmount());
                currentAnticipatedIndirect = (ScaleTwoDecimal)currentAnticipatedIndirect.add((AbstractDecimal)penTran.getAnticipatedIndirectAmount());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)penTran.getDestinationAwardNumber(), (CharSequence)ROOT_AWARD)) continue;
            currentObligatedDirect = (ScaleTwoDecimal)currentObligatedDirect.subtract((AbstractDecimal)penTran.getObligatedDirectAmount());
            currentObligatedIndirect = (ScaleTwoDecimal)currentObligatedIndirect.subtract((AbstractDecimal)penTran.getObligatedIndirectAmount());
            currentAnticipatedDirect = (ScaleTwoDecimal)currentAnticipatedDirect.subtract((AbstractDecimal)penTran.getAnticipatedDirectAmount());
            currentAnticipatedIndirect = (ScaleTwoDecimal)currentAnticipatedIndirect.subtract((AbstractDecimal)penTran.getAnticipatedIndirectAmount());
        }
        if (!(timeAndMoneyDocument.getPendingTransactions().size() != 0 || awardHierarchyNode.getObligatedTotalDirect().equals((Object)currentObligatedDirect) && awardHierarchyNode.getObligatedTotalIndirect().equals((Object)currentObligatedIndirect) && awardHierarchyNode.getAnticipatedTotalDirect().equals((Object)currentAnticipatedDirect) && awardHierarchyNode.getAnticipatedTotalIndirect().equals((Object)currentAnticipatedIndirect))) {
            ScaleTwoDecimal obligatedChangeDirect = (ScaleTwoDecimal)awardHierarchyNode.getObligatedTotalDirect().subtract((AbstractDecimal)currentObligatedDirect);
            ScaleTwoDecimal obligatedChangeIndirect = (ScaleTwoDecimal)awardHierarchyNode.getObligatedTotalIndirect().subtract((AbstractDecimal)currentObligatedIndirect);
            ScaleTwoDecimal anticipatedChangeDirect = (ScaleTwoDecimal)awardHierarchyNode.getAnticipatedTotalDirect().subtract((AbstractDecimal)currentAnticipatedDirect);
            ScaleTwoDecimal anticipatedChangeIndirect = (ScaleTwoDecimal)awardHierarchyNode.getAnticipatedTotalIndirect().subtract((AbstractDecimal)currentAnticipatedIndirect);
            if (this.transactionRuleImpl.processParameterEnabledRules(awardHierarchyNode, aai, timeAndMoneyDocument)) {
                this.populatePendingTransactionAndSave(award, timeAndMoneyDocument, pendingTransaction, obligatedChangeDirect, obligatedChangeIndirect, anticipatedChangeDirect, anticipatedChangeIndirect);
                result = true;
            } else {
                ahn.setAmountObligatedToDate((ScaleTwoDecimal)aai.getAmountObligatedToDate().add((AbstractDecimal)((ScaleTwoDecimal)obligatedChangeDirect.add((AbstractDecimal)obligatedChangeIndirect))));
                ahn.setObligatedTotalDirect(awardHierarchyNode.getObligatedTotalDirect());
                ahn.setObligatedTotalIndirect(awardHierarchyNode.getObligatedTotalIndirect());
                ahn.setObliDistributableAmount(awardHierarchyNode.getObliDistributableAmount());
                ahn.setAnticipatedTotalAmount((ScaleTwoDecimal)aai.getAnticipatedTotalAmount().add((AbstractDecimal)((ScaleTwoDecimal)anticipatedChangeDirect.add((AbstractDecimal)anticipatedChangeIndirect))));
                ahn.setAnticipatedTotalDirect(awardHierarchyNode.getAnticipatedTotalDirect());
                ahn.setAnticipatedTotalIndirect(awardHierarchyNode.getAnticipatedTotalIndirect());
                ahn.setAntDistributableAmount(awardHierarchyNode.getAntDistributableAmount());
            }
        }
        return result;
    }

    private void populatePendingTransactionAndSave(Award award, TimeAndMoneyDocument timeAndMoneyDocument, PendingTransaction pendingTransaction, ScaleTwoDecimal obligatedChangeDirect, ScaleTwoDecimal obligatedChangeIndirect, ScaleTwoDecimal anticipatedChangeDirect, ScaleTwoDecimal anticipatedChangeIndirect) {
        if (obligatedChangeDirect.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            pendingTransaction.setSourceAwardNumber(ROOT_AWARD);
            pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
        } else if (obligatedChangeDirect.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
            pendingTransaction.setDestinationAwardNumber(ROOT_AWARD);
        }
        if (obligatedChangeIndirect.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            pendingTransaction.setSourceAwardNumber(ROOT_AWARD);
            pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
        } else if (obligatedChangeIndirect.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
            pendingTransaction.setDestinationAwardNumber(ROOT_AWARD);
        }
        if (anticipatedChangeDirect.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            pendingTransaction.setSourceAwardNumber(ROOT_AWARD);
            pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
        } else if (anticipatedChangeDirect.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
            pendingTransaction.setDestinationAwardNumber(ROOT_AWARD);
        }
        if (anticipatedChangeIndirect.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            pendingTransaction.setSourceAwardNumber(ROOT_AWARD);
            pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
        } else if (anticipatedChangeIndirect.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
            pendingTransaction.setDestinationAwardNumber(ROOT_AWARD);
        }
        pendingTransaction.setObligatedDirectAmount((ScaleTwoDecimal)obligatedChangeDirect.abs());
        pendingTransaction.setObligatedIndirectAmount((ScaleTwoDecimal)obligatedChangeIndirect.abs());
        pendingTransaction.setAnticipatedDirectAmount((ScaleTwoDecimal)anticipatedChangeDirect.abs());
        pendingTransaction.setAnticipatedIndirectAmount((ScaleTwoDecimal)anticipatedChangeIndirect.abs());
        pendingTransaction.setObligatedAmount((ScaleTwoDecimal)((ScaleTwoDecimal)obligatedChangeDirect.add((AbstractDecimal)obligatedChangeIndirect)).abs());
        pendingTransaction.setAnticipatedAmount((ScaleTwoDecimal)((ScaleTwoDecimal)anticipatedChangeDirect.add((AbstractDecimal)anticipatedChangeIndirect)).abs());
        pendingTransaction.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
        pendingTransaction.setProcessedFlag(false);
        pendingTransaction.setSingleNodeTransaction(true);
        pendingTransaction.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
        timeAndMoneyDocument.getPendingTransactions().add(pendingTransaction);
        for (PendingTransaction penTran : timeAndMoneyDocument.getPendingTransactions()) {
            penTran.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
        }
        this.businessObjectService.save(timeAndMoneyDocument.getPendingTransactions());
    }

    private boolean createAndValidateDisabledViewTransaction(AwardAmountInfo aai, Award award, TimeAndMoneyDocument timeAndMoneyDocument, AwardHierarchyNode ahn, List<AwardHierarchyNode> awardHierarchyNodeItems) {
        boolean result = false;
        AwardHierarchyNode awardHierarchyNode = awardHierarchyNodeItems.get(awardHierarchyNodeItems.size() - 1);
        this.transactionRuleImpl = new TransactionRuleImpl();
        PendingTransaction pendingTransaction = new PendingTransaction();
        pendingTransaction.setComments(SINGLE_NODE_MONEY_TRANSACTION_COMMENT);
        pendingTransaction.setSingleNodeTransaction(true);
        ScaleTwoDecimal currentObligated = aai.getAmountObligatedToDate();
        ScaleTwoDecimal currentAnticipated = aai.getAnticipatedTotalAmount();
        for (PendingTransaction penTran : timeAndMoneyDocument.getPendingTransactions()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)penTran.getSourceAwardNumber(), (CharSequence)ROOT_AWARD)) {
                currentObligated = (ScaleTwoDecimal)currentObligated.add((AbstractDecimal)penTran.getObligatedAmount());
                currentAnticipated = (ScaleTwoDecimal)currentAnticipated.add((AbstractDecimal)penTran.getAnticipatedAmount());
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)penTran.getDestinationAwardNumber(), (CharSequence)ROOT_AWARD)) continue;
            currentObligated = (ScaleTwoDecimal)currentObligated.subtract((AbstractDecimal)penTran.getObligatedAmount());
            currentAnticipated = (ScaleTwoDecimal)currentAnticipated.subtract((AbstractDecimal)penTran.getAnticipatedAmount());
        }
        if (!(timeAndMoneyDocument.getPendingTransactions().size() != 0 || awardHierarchyNode.getAmountObligatedToDate().equals((Object)currentObligated) && awardHierarchyNode.getAnticipatedTotalAmount().equals((Object)currentAnticipated))) {
            ScaleTwoDecimal obligatedChange = (ScaleTwoDecimal)awardHierarchyNode.getAmountObligatedToDate().subtract((AbstractDecimal)currentObligated);
            ScaleTwoDecimal anticipatedChange = (ScaleTwoDecimal)awardHierarchyNode.getAnticipatedTotalAmount().subtract((AbstractDecimal)currentAnticipated);
            if (this.transactionRuleImpl.processParameterDisabledRules(awardHierarchyNode, aai, timeAndMoneyDocument)) {
                if (obligatedChange.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                    pendingTransaction.setSourceAwardNumber(ROOT_AWARD);
                    pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
                } else if (obligatedChange.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                    pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
                    pendingTransaction.setDestinationAwardNumber(ROOT_AWARD);
                }
                if (anticipatedChange.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                    pendingTransaction.setSourceAwardNumber(ROOT_AWARD);
                    pendingTransaction.setDestinationAwardNumber(award.getAwardNumber());
                } else if (anticipatedChange.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                    pendingTransaction.setSourceAwardNumber(award.getAwardNumber());
                    pendingTransaction.setDestinationAwardNumber(ROOT_AWARD);
                }
                pendingTransaction.setObligatedAmount((ScaleTwoDecimal)obligatedChange.abs());
                pendingTransaction.setAnticipatedAmount((ScaleTwoDecimal)anticipatedChange.abs());
                pendingTransaction.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                pendingTransaction.setProcessedFlag(false);
                timeAndMoneyDocument.getPendingTransactions().add(pendingTransaction);
                for (PendingTransaction penTran : timeAndMoneyDocument.getPendingTransactions()) {
                    penTran.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                }
                this.businessObjectService.save(timeAndMoneyDocument.getPendingTransactions());
                result = true;
            } else {
                ahn.setAmountObligatedToDate(awardHierarchyNode.getAmountObligatedToDate());
                ahn.setObliDistributableAmount(awardHierarchyNode.getObliDistributableAmount());
                ahn.setAnticipatedTotalAmount(awardHierarchyNode.getAnticipatedTotalAmount());
                ahn.setAntDistributableAmount(awardHierarchyNode.getAntDistributableAmount());
            }
        }
        return result;
    }
}

