/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.service.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.Strings;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.service.TimeAndMoneyVersionService;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class TimeAndMoneyVersionServiceImpl
implements TimeAndMoneyVersionService {
    public static final String ROOT_AWARD_NUMBER = "rootAwardNumber";
    public static final String DOCUMENT_STATUS = "documentStatus";
    private AwardVersionService awardVersionService;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private DataSource dataSource;
    private ParameterService parameterService;
    private GlobalVariableService globalVariableService;

    @Override
    public TimeAndMoneyDocument findOpenedTimeAndMoney(String rootAwardNumber) throws WorkflowException {
        Object result = null;
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)this.getBusinessObjectService().findBySinglePrimaryKey(TimeAndMoneyDocument.class, (Object)this.getCurrentTimeAndMoneyDocumentNumber(rootAwardNumber));
        if (timeAndMoneyDocument == null) {
            throw new WorkflowException("Missing Time and Money Document");
        }
        if (!VersionStatus.PENDING.toString().equals(timeAndMoneyDocument.getDocumentStatus())) {
            if (this.validateCreateNewTimeAndMoneyDocument(rootAwardNumber)) {
                timeAndMoneyDocument = this.editOrVersionTandMDocument(rootAwardNumber);
            } else {
                return null;
            }
        }
        return timeAndMoneyDocument;
    }

    @Override
    public boolean validateCreateNewTimeAndMoneyDocument(String awardNumber) {
        if (!this.allowTimeAndMoneyWhenPendingAwardExists() && this.awardVersionService.isPendingAwardInAwardHierarchy(awardNumber)) {
            this.globalVariableService.getMessageMap().putError("GLOBAL_ERRORS", "error.timeandmoney.create.pending.award.exists", new String[0]);
            return false;
        }
        return true;
    }

    protected boolean allowTimeAndMoneyWhenPendingAwardExists() {
        return this.parameterService.getParameterValueAsBoolean("KC-T", "Document", "ALLOW_TM_WHEN_PENDING_AWARD_EXISTS");
    }

    private TimeAndMoneyDocument editOrVersionTandMDocument(String rootAwardNumber) throws WorkflowException {
        Award rootAward = this.getAwardVersionService().getWorkingAwardVersion(rootAwardNumber);
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)this.getDocumentService().getNewDocument(TimeAndMoneyDocument.class);
        timeAndMoneyDocument.getDocumentHeader().setDocumentDescription("timeandmoney document");
        timeAndMoneyDocument.setRootAwardNumber(rootAwardNumber);
        timeAndMoneyDocument.setAwardNumber(rootAward.getAwardNumber());
        timeAndMoneyDocument.setAward(rootAward);
        AwardAmountTransaction aat = new AwardAmountTransaction();
        aat.setAwardNumber("000000-00000");
        aat.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
        aat.setTransactionTypeCode(null);
        timeAndMoneyDocument.getAwardAmountTransactions().add(aat);
        this.getDocumentService().saveDocument((Document)timeAndMoneyDocument);
        return timeAndMoneyDocument;
    }

    @Override
    public void updateDocumentStatus(TimeAndMoneyDocument document, VersionStatus status) {
        if (status.equals((Object)VersionStatus.ACTIVE)) {
            this.archiveActiveTimeAndMoneyDocs(document.getAwardNumber());
        }
        document.setDocumentStatus(status.toString());
        this.businessObjectService.save((PersistableBusinessObject)document);
    }

    private void archiveActiveTimeAndMoneyDocs(String awardNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(ROOT_AWARD_NUMBER, awardNumber);
        values.put(DOCUMENT_STATUS, VersionStatus.ACTIVE.name());
        List documents = this.businessObjectService.findMatching(TimeAndMoneyDocument.class, values);
        for (TimeAndMoneyDocument document : documents) {
            document.setDocumentStatus(VersionStatus.ARCHIVED.name());
            this.businessObjectService.save((PersistableBusinessObject)document);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getCurrentTimeAndMoneyDocumentNumber(String awardNumber) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("select * from (select document_number,  case TIME_AND_MONEY_DOC_STATUS when 'PENDING' then 1 when 'ACTIVE' then 2 else 3 end as STATUS_ORDER  from TIME_AND_MONEY_DOCUMENT where award_number = ? and TIME_AND_MONEY_DOC_STATUS != 'CANCELED' order by STATUS_ORDER, DOCUMENT_NUMBER) sorted_tm " + this.getLimitSql(connection, 1));){
            stmt.setString(1, awardNumber);
            stmt.setMaxRows(1);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    String getLimitSql(Connection connection, Integer num) throws SQLException {
        if (Strings.CI.contains((CharSequence)connection.getMetaData().getDatabaseProductName(), (CharSequence)"oracle")) {
            return "where rownum <= " + num;
        }
        if (Strings.CI.contains((CharSequence)connection.getMetaData().getDatabaseProductName(), (CharSequence)"mysql") || Strings.CI.contains((CharSequence)connection.getMetaData().getDatabaseProductName(), (CharSequence)"maria")) {
            return "limit 0, " + num;
        }
        throw new UnsupportedOperationException("Unsupported database detected");
    }

    public AwardVersionService getAwardVersionService() {
        return this.awardVersionService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

