/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.org;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationRepositoryService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="organizationRepositoryService")
public class OrganizationRepositoryServiceImpl
implements OrganizationRepositoryService {
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    public String getCognizantFedAgency(OrganizationContract organization) {
        RolodexContract rolodex;
        if (organization == null) {
            throw new IllegalArgumentException("organization is null");
        }
        StringBuilder fedAgency = new StringBuilder();
        if (organization.getCognizantAuditor() != null && (rolodex = this.rolodexService.getRolodex(organization.getCognizantAuditor())) != null) {
            fedAgency.append(rolodex.getOrganization());
            fedAgency.append(", ");
            fedAgency.append(StringUtils.trimToEmpty((String)rolodex.getFirstName()));
            fedAgency.append(" ");
            fedAgency.append(StringUtils.trimToEmpty((String)rolodex.getLastName()));
            fedAgency.append(" ");
            if (rolodex.getPhoneNumber() != null) {
                if (rolodex.getPhoneNumber().length() < 180) {
                    fedAgency.append(rolodex.getPhoneNumber());
                } else {
                    fedAgency.append(rolodex.getPhoneNumber().substring(0, 180));
                }
            }
        }
        return fedAgency.toString();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }
}

