/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.copy;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.standalone.StandaloneBudgetImportService;
import org.kuali.coeus.propdev.impl.copy.CopyMode;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyCriteria;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormBo;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsService;
import org.kuali.coeus.propdev.impl.preproposal.ProposalDevelopmentPreproposalFormsHelper;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildAppDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildInitializeWorkflowDto;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentCopyController
extends ProposalDevelopmentControllerBase {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentCopyController.class);
    public static final String COPY_DIALOG = "PropDev-CopyDialog-Section";
    private static final String IS_COPIED_PROPOSAL = "isCopiedProposal";
    @Autowired
    @Qualifier(value="documentTypeService")
    private DocumentTypeService documentTypeService;
    @Autowired
    @Qualifier(value="proposalCopyService")
    private ProposalCopyService proposalCopyService;
    @Autowired
    @Qualifier(value="preproposalFormsService")
    private PreproposalFormsService preproposalFormsService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="standaloneBudgetImportService")
    private StandaloneBudgetImportService standaloneBudgetImportService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copy"})
    public ModelAndView copy(@RequestParam(value="timeZone") String timeZone, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.getViewHelper(form).populatePreproposalForms(form);
        ProposalCopyCriteria proposalCopyCriteria = form.getProposalCopyCriteria();
        if (StringUtils.isNotBlank((CharSequence)proposalCopyCriteria.getLeadUnitNumber()) || proposalCopyCriteria.isHierarchyCopy()) {
            ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
            this.releaseLocksForLoggedInUser(form);
            ProposalDevelopmentDocument newDoc = !proposalCopyCriteria.isHierarchyCopy() ? this.getProposalCopyService().copyProposal(proposalDevelopmentDocument, proposalCopyCriteria) : this.getProposalCopyService().copyProposalHierarchy(form.getProposalDevelopmentDocument(), proposalCopyCriteria);
            if (newDoc != null) {
                String originalProposalNumber = proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber();
                String newProposalNumber = newDoc.getDevelopmentProposal().getProposalNumber();
                if (this.preproposalFormsService.isEnabled() && proposalCopyCriteria.getIncludePreproposalForms()) {
                    this.copyPreProposalForms(originalProposalNumber, timeZone, newDoc, form.getExternalUrl(newProposalNumber));
                }
                if (this.standaloneBudgetImportService.isEnabled() && proposalCopyCriteria.getIncludeBudget()) {
                    if ("FINAL".equals(proposalCopyCriteria.getBudgetVersions())) {
                        this.copyFinalBudget(originalProposalNumber, newProposalNumber, this.standaloneBudgetImportService.getFinalBudget(originalProposalNumber).getBudgetId());
                    } else {
                        this.copyAllBudgets(originalProposalNumber, newProposalNumber);
                    }
                }
                return this.returnToDocument(form, newDoc.getDocumentNumber());
            }
        }
        return null;
    }

    private ProposalDevelopmentViewHelperServiceImpl getViewHelper(ProposalDevelopmentDocumentForm form) {
        return (ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService();
    }

    private void copyFinalBudget(String originalProposalNumber, String newProposalNumber, String budgetId) {
        boolean success = this.standaloneBudgetImportService.copyBudgets(originalProposalNumber, newProposalNumber, List.of(budgetId));
        if (!success) {
            LOG.error("Failed to copy final budget {} for proposal {} to new proposal {}", (Object)budgetId, (Object)originalProposalNumber, (Object)newProposalNumber);
        }
    }

    private void copyAllBudgets(String originalProposalNumber, String newProposalNumber) {
        boolean success = this.standaloneBudgetImportService.copyAllBudgets(originalProposalNumber, newProposalNumber);
        if (!success) {
            LOG.error("Failed to copy budgets for proposal {} to new proposal {}", (Object)originalProposalNumber, (Object)newProposalNumber);
        }
    }

    private void copyPreProposalForms(String sourceProposalNumber, String timeZone, ProposalDevelopmentDocument newDoc, String proposalUrl) {
        try {
            LOG.debug("copyPreproposalForms");
            ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = this.preproposalFormsService.createHelper(newDoc, proposalUrl);
            List<Pair<KualiBuildAppDto, List<KualiBuildInitializeWorkflowDto>>> copied = this.preproposalFormsService.copyPreproposalForms(sourceProposalNumber, this.preproposalFormsService.getAllKualiBuildApps(newDoc.getDevelopmentProposal().getProposalTypeCode()), newDoc, preproposalFormsHelper.getEvaluator(), timeZone);
            copied.forEach(pair -> {
                KualiBuildAppDto app = (KualiBuildAppDto)pair.getLeft();
                ((List)pair.getRight()).stream().map(response -> {
                    LOG.debug("Build document id: {}", (Object)response.getDocumentId());
                    PreproposalFormBo preproposalFormBo = new PreproposalFormBo();
                    preproposalFormBo.setAppId(app.getId());
                    preproposalFormBo.setAppName(app.getName());
                    preproposalFormBo.setDocId(response.getDocumentId());
                    preproposalFormBo.setProposalNumber(newDoc.getDevelopmentProposal().getProposalNumber());
                    return preproposalFormBo;
                }).forEach(ppf -> newDoc.getDevelopmentProposal().getPreproposalForms().add((PreproposalFormBo)this.getDataObjectService().save(ppf, new PersistenceOption[0])));
            });
        }
        catch (RuntimeException e) {
            LOG.error("Failed to copy preproposal forms", (Throwable)e);
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=displayCopyDialog"})
    public ModelAndView displayCopyDialog(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        if (form.getDevelopmentProposal().isInHierarchy()) {
            return this.getModelAndViewService().showDialog("PropDev-Copy-Hierarchy-Or-Single-Dialog", true, (UifFormBase)form);
        }
        return this.copySingleProposal(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copyAllHierarchy"})
    public ModelAndView copyAllHierarchy(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setProposalCopyCriteria(new ProposalCopyCriteria(form.getProposalDevelopmentDocument()));
        form.getProposalCopyCriteria().setCopyMode(CopyMode.HIERARCHY);
        form.getProposalCopyCriteria().setIncludeBudget(true);
        form.getProposalCopyCriteria().setIncludeAttachments(true);
        form.getProposalCopyCriteria().setIncludePreproposalForms(true);
        return this.displayCopyDialogDirect(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=copySingleProposal"})
    public ModelAndView copySingleProposal(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        form.setProposalCopyCriteria(new ProposalCopyCriteria(form.getProposalDevelopmentDocument()));
        form.getProposalCopyCriteria().setCopyMode(CopyMode.SINGLE);
        return this.displayCopyDialogDirect(form);
    }

    public ModelAndView displayCopyDialogDirect(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ((ProposalDevelopmentViewHelperServiceImpl)form.getView().getViewHelperService()).populateQuestionnaires(form);
        return this.getModelAndViewService().showDialog(COPY_DIALOG, true, (UifFormBase)form);
    }

    protected ModelAndView returnToDocument(ProposalDevelopmentDocumentForm form, String newDocNum) {
        Properties props = new Properties();
        props.put("command", "displayDocSearchView");
        props.put("docId", newDocNum);
        props.put(IS_COPIED_PROPOSAL, "true");
        if (StringUtils.isNotBlank((CharSequence)form.getReturnFormKey())) {
            props.put("formKey", form.getReturnFormKey());
        }
        String docHandlerUrl = this.getDocHandlerUrl(form, props);
        return this.getModelAndViewService().performRedirect((UifFormBase)form, docHandlerUrl);
    }

    protected String getDocHandlerUrl(ProposalDevelopmentDocumentForm form, Properties props) {
        DocumentType docType = this.getDocumentTypeService().getDocumentTypeByName(form.getDocTypeName());
        String docHandlerUrl = docType.getResolvedDocumentHandlerUrl() + "&" + props.entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining("&"));
        if (this.isDashboardModeEnabled()) {
            String dashboardUrl = this.getConfigurationService().getPropertyValueAsString("dashboard.standalone.base.url");
            return dashboardUrl + "/dashboard/redir?to=" + URLEncoder.encode(docHandlerUrl, StandardCharsets.UTF_8);
        }
        return docHandlerUrl;
    }

    private boolean isDashboardModeEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "Dashboard_Mode_Enabled", Boolean.valueOf(false));
    }

    public DocumentTypeService getDocumentTypeService() {
        return this.documentTypeService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }

    public ProposalCopyService getProposalCopyService() {
        return this.proposalCopyService;
    }

    public void setProposalCopyService(ProposalCopyService proposalCopyService) {
        this.proposalCopyService = proposalCopyService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public PreproposalFormsService getPreproposalFormsService() {
        return this.preproposalFormsService;
    }

    public void setPreproposalFormsService(PreproposalFormsService preproposalFormsService) {
        this.preproposalFormsService = preproposalFormsService;
    }
}

