/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.document;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.KcDocumentBaseAuditRule;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.document.ExconProjectDestinationsAuditRule;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.excon.project.document.ExconProjectPersonsAuditRule;
import org.kuali.kra.excon.project.document.ExconProjectRule;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class ExconProjectDocumentRule
extends KcTransactionalDocumentRuleBase
implements ExconProjectRule,
DocumentAuditRule {
    private static final String NEW_EXCON_PROJECT = "document.exconProjectList[0]";

    @Override
    public boolean processAddExconProjectBusinessRules(ExconProject exconProject) {
        boolean rulePassed = true;
        return rulePassed &= this.processSaveExconProjectBusinessRules(exconProject, NEW_EXCON_PROJECT);
    }

    protected boolean processSaveExconProjectBusinessRules(ExconProject exconProject, String propertyPrefix) {
        boolean rulePassed = true;
        if (StringUtils.isEmpty((CharSequence)exconProject.getProjectTypeCode())) {
            this.reportError(propertyPrefix + ".projectTypeCode", "error.generic.required.field", "Project Type");
            rulePassed = false;
        }
        if (!StringUtils.isEmpty((CharSequence)exconProject.getSponsorCode()) && exconProject.getSponsor() == null) {
            this.reportError(propertyPrefix + ".sponsorCode", "error.invalid.sponsorCode", exconProject.getSponsorCode());
            rulePassed = false;
        }
        if (!StringUtils.isEmpty((CharSequence)exconProject.getLeadUnitNumber()) && exconProject.getUnit() == null) {
            this.reportError(propertyPrefix + ".unitNumber", "error.invalid.unit", exconProject.getLeadUnitNumber());
            rulePassed = false;
        }
        if (!StringUtils.isEmpty((CharSequence)exconProject.getRespPartyUsername()) && exconProject.getRespPartyPerson() == null) {
            this.reportError(propertyPrefix + ".respPartyUsername", "error.exconProjectResponsibleParty.isInvalid", exconProject.getRespPartyUsername());
            rulePassed = false;
        }
        return rulePassed;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = new KcDocumentBaseAuditRule().processRunAuditBusinessRules(document);
        retval &= new ExconProjectDestinationsAuditRule().processRunAuditBusinessRules(document);
        return retval &= new ExconProjectPersonsAuditRule().processRunAuditBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        return document instanceof ExconProjectDocument;
    }

    public boolean processRules(KcDocumentEventBaseExtension event) {
        return event.getRule().processRules(event);
    }
}

