/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardHierarchy
extends KcPersistableBusinessObjectBase
implements Cloneable {
    public static final String ROOTS_PARENT_AWARD_NUMBER = "000000-00000";
    public static final String UNIQUE_IDENTIFIER_FIELD = "awardNumber";
    private static final long serialVersionUID = 1L;
    private Long awardHierarchyId;
    private String rootAwardNumber;
    private String awardNumber;
    private String parentAwardNumber;
    private String originatingAwardNumber = "000000-00000";
    private AwardHierarchy root;
    private AwardHierarchy parent;
    private Boolean active = true;
    private transient Award award;
    private transient List<AwardHierarchy> children = new ArrayList<AwardHierarchy>();
    private transient BusinessObjectService boService;
    private transient VersionHistoryService versionHistoryService;

    public AwardHierarchy() {
    }

    public AwardHierarchy(AwardHierarchy rootNode, AwardHierarchy parentNode, String awardNumber, String originatingAwardNumber) {
        this();
        this.setRoot(rootNode);
        this.setParent(parentNode);
        this.setAwardNumber(awardNumber);
        this.setOriginatingAwardNumber(originatingAwardNumber);
    }

    public AwardHierarchy(String rootAwardNumber, String parentAwardNumber, String awardNumber, String originatingAwardNumber) {
        this();
        this.rootAwardNumber = rootAwardNumber;
        this.parentAwardNumber = parentAwardNumber;
        this.awardNumber = awardNumber;
        this.originatingAwardNumber = originatingAwardNumber;
    }

    public AwardHierarchy(String rootAwardNumber, String parentAwardNumber, String awardNumber) {
        this(rootAwardNumber, parentAwardNumber, awardNumber, awardNumber);
    }

    public static AwardHierarchy createRootNode(Award award) {
        AwardHierarchy rootNode = AwardHierarchy.createRootNode(award.getAwardNumber());
        rootNode.setAward(award);
        return rootNode;
    }

    public static AwardHierarchy createRootNode(String awardNumber) {
        return new AwardHierarchy(awardNumber, ROOTS_PARENT_AWARD_NUMBER, awardNumber, awardNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwardHierarchy)) {
            return false;
        }
        AwardHierarchy other = (AwardHierarchy)obj;
        if (this.awardNumber == null ? other.awardNumber != null : !this.awardNumber.equals(other.awardNumber)) {
            return false;
        }
        if (this.parentAwardNumber == null ? other.parentAwardNumber != null : !this.parentAwardNumber.equals(other.parentAwardNumber)) {
            return false;
        }
        return !(this.rootAwardNumber == null ? other.rootAwardNumber != null : !this.rootAwardNumber.equals(other.rootAwardNumber));
    }

    public Award getAward() {
        if (this.award == null) {
            this.lazyLoadAward();
        }
        return this.award;
    }

    public Long getAwardHierarchyId() {
        return this.awardHierarchyId;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public List<AwardHierarchy> getChildren() {
        return this.children;
    }

    public String getOriginatingAwardNumber() {
        return this.originatingAwardNumber;
    }

    public AwardHierarchy getParent() {
        if (!this.isRootNode() && this.parent == null && this.parentAwardNumber != null) {
            this.parent = this.findAwardHierarchyMatchingAwardNumber(this.parentAwardNumber);
        }
        return this.parent;
    }

    public String getParentAwardNumber() {
        return this.parentAwardNumber;
    }

    public AwardHierarchy getRoot() {
        if (this.isRootNode()) {
            this.root = this;
        } else if (this.root == null && this.rootAwardNumber != null) {
            this.root = this.findAwardHierarchyMatchingAwardNumber(this.rootAwardNumber);
        }
        return this.root;
    }

    public List<AwardHierarchy> getFlattenedListOfNodesInHierarchy() {
        ArrayList<AwardHierarchy> list = new ArrayList<AwardHierarchy>();
        this.addNodeToFlattenedList(list, this.findRootNode());
        return list;
    }

    public String getRootAwardNumber() {
        return this.rootAwardNumber;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.awardNumber == null ? 0 : this.awardNumber.hashCode());
        result = 31 * result + (this.parentAwardNumber == null ? 0 : this.parentAwardNumber.hashCode());
        result = 31 * result + (this.rootAwardNumber == null ? 0 : this.rootAwardNumber.hashCode());
        return result;
    }

    public boolean isRootNode() {
        return this.awardNumber.equals(this.rootAwardNumber);
    }

    public AwardHierarchy findNodeInHierarchy(String awardNumber) {
        AwardHierarchy rootNode = this.findRootNode(this);
        return this.findNode(rootNode, awardNumber);
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public void setAwardHierarchyId(Long awardHierarchyId) {
        this.awardHierarchyId = awardHierarchyId;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public void setChildren(List<AwardHierarchy> children) {
        this.children = children;
    }

    public void setOriginatingAwardNumber(String originatingDocumentNumber) {
        this.originatingAwardNumber = originatingDocumentNumber;
    }

    public void setParent(AwardHierarchy parent) {
        this.parent = parent;
        this.parentAwardNumber = parent != null ? parent.getAwardNumber() : ROOTS_PARENT_AWARD_NUMBER;
    }

    public void setParentAwardNumber(String parentAwardNumber) {
        this.parentAwardNumber = parentAwardNumber;
    }

    public void setRoot(AwardHierarchy root) {
        this.root = root;
        this.rootAwardNumber = root != null ? root.getAwardNumber() : null;
    }

    public void setRootAwardNumber(String rootAwardNumber) {
        this.rootAwardNumber = rootAwardNumber;
    }

    public boolean isNew() {
        return this.awardHierarchyId == null;
    }

    public boolean isPersisted() {
        return !this.isNew();
    }

    void addNodeToFlattenedList(List<AwardHierarchy> list, AwardHierarchy parentNode) {
        list.add(parentNode);
        if (parentNode.hasChildren()) {
            for (AwardHierarchy childNode : parentNode.getChildren()) {
                this.addNodeToFlattenedList(list, childNode);
            }
        }
    }

    AwardHierarchy findNode(AwardHierarchy testNode, String awardNumber) {
        AwardHierarchy foundNode;
        block2: {
            AwardHierarchy node;
            block1: {
                foundNode = null;
                if (!testNode.getAwardNumber().equals(awardNumber)) break block1;
                foundNode = testNode;
                break block2;
            }
            if (!testNode.hasChildren()) break block2;
            Iterator<AwardHierarchy> iterator = testNode.getChildren().iterator();
            while (iterator.hasNext() && (foundNode = this.findNode(node = iterator.next(), awardNumber)) == null) {
            }
        }
        return foundNode;
    }

    AwardHierarchy findRootNode() {
        return this.findRootNode(this);
    }

    private AwardHierarchy findAwardHierarchyMatchingAwardNumber(String searchAwardNumber) {
        List c = this.getBusinessObjectService().findMatching(AwardHierarchy.class, Map.of(UNIQUE_IDENTIFIER_FIELD, searchAwardNumber, "active", Boolean.TRUE));
        return c.size() == 1 ? (AwardHierarchy)c.iterator().next() : null;
    }

    private AwardHierarchy findRootNode(AwardHierarchy testNode) {
        return testNode.isRootNode() ? testNode : this.findRootNode(testNode.getParent());
    }

    private void lazyLoadAward() {
        List<VersionHistory> histories;
        VersionHistory vh = this.getVersionHistoryService().findActiveVersion(Award.class, this.awardNumber);
        this.award = vh != null ? (Award)vh.getSequenceOwner() : ((histories = this.getVersionHistoryService().loadVersionHistory(Award.class, this.awardNumber)).size() == 1 ? (Award)histories.get(0).getSequenceOwner() : null);
    }

    public AwardHierarchy clone() {
        AwardHierarchy copy;
        try {
            copy = (AwardHierarchy)super.clone();
            ArrayList<AwardHierarchy> copyChildren = new ArrayList<AwardHierarchy>();
            for (AwardHierarchy child : this.getChildren()) {
                copyChildren.add(child.clone());
            }
            copy.setChildren(copyChildren);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return copy;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    void setBusinessObjectService(BusinessObjectService boService) {
        this.boService = boService;
    }

    void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    BusinessObjectService getBusinessObjectService() {
        if (this.boService == null) {
            this.boService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.boService;
    }

    VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = KcServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }
}

