/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.reporting.printing.xmlstream;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.hierarchy.SponsorHierarchy;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.subcontracting.reporting.SubcontractingExpenditureCategoryAmounts;
import org.kuali.kra.award.subcontracting.reporting.SubcontractingExpenditureCategoryAmountsInDateRange;
import org.kuali.kra.printing.schema.NameAndAddressTypeDocument;
import org.kuali.kra.printing.schema.SubcontractReportPageType;
import org.kuali.kra.printing.schema.SubcontractReportsDocument;
import org.kuali.kra.subaward.reporting.printing.SubAwardPrintType;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SubawardXmlStream
implements XmlStream<SubcontractReportsDocument> {
    private static final String SF_295_REPORT = "SF295";
    private static final String ORGANIZATION_ID = "000001";
    private BusinessObjectService businessObjectService;
    private UnitService unitService;
    private KcPersonService kcPersonService;
    private String awardNumber;

    @Override
    public Class<SubcontractReportsDocument> type() {
        return SubcontractReportsDocument.class;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    @Override
    public Map<String, SubcontractReportsDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, SubcontractReportsDocument> xmlObjectList = new LinkedHashMap<String, SubcontractReportsDocument>();
        SubcontractReportsDocument subcontractReportsDocument = (SubcontractReportsDocument)SubcontractReportsDocument.Factory.newInstance();
        this.awardNumber = (String)reportParameters.get("awardNumber");
        SubcontractReportsDocument.SubcontractReports subcontractReports = (SubcontractReportsDocument.SubcontractReports)SubcontractReportsDocument.SubcontractReports.Factory.newInstance();
        this.setCompanyInfo(subcontractReports);
        if (reportParameters.get("printType").equals(SF_295_REPORT)) {
            this.setAdminActivity295(subcontractReports);
        } else {
            this.setAdminActivity(subcontractReports);
        }
        this.setContractorType(subcontractReports);
        this.setOfficials(subcontractReports);
        this.setReportingPeriod(subcontractReports);
        Calendar calendar = Calendar.getInstance();
        subcontractReports.setDateSubmitted(calendar);
        subcontractReportsDocument.setSubcontractReports(subcontractReports);
        xmlObjectList.put(SubAwardPrintType.SUB_AWARD_SF_294_PRINT_TYPE.getSubAwardPrintType(), subcontractReportsDocument);
        return xmlObjectList;
    }

    public void setCompanyInfo(SubcontractReportsDocument.SubcontractReports subcontractReports) {
        HashMap<String, String> organizationMap = new HashMap<String, String>();
        organizationMap.put("organizationId", ORGANIZATION_ID);
        Organization organization = (Organization)this.businessObjectService.findByPrimaryKey(Organization.class, organizationMap);
        HashMap<String, String> rolodexMap = new HashMap<String, String>();
        rolodexMap.put("rolodexId", organization.getContactAddressId().toString());
        Rolodex rolodex = (Rolodex)this.businessObjectService.findByPrimaryKey(Rolodex.class, rolodexMap);
        SubcontractReportsDocument.SubcontractReports.CompanyInfo companyInfo = (SubcontractReportsDocument.SubcontractReports.CompanyInfo)SubcontractReportsDocument.SubcontractReports.CompanyInfo.Factory.newInstance();
        NameAndAddressTypeDocument.NameAndAddressType nameAndAddressType = (NameAndAddressTypeDocument.NameAndAddressType)NameAndAddressTypeDocument.NameAndAddressType.Factory.newInstance();
        nameAndAddressType.setName(organization.getOrganizationName());
        nameAndAddressType.setCity(rolodex.getCity());
        nameAndAddressType.setState(rolodex.getState());
        nameAndAddressType.setZipCode(rolodex.getPostalCode());
        nameAndAddressType.setStreetAddress(rolodex.getAddressLine1() + " " + rolodex.getAddressLine2() + " " + rolodex.getAddressLine3());
        subcontractReports.setContractorIDNumber(organization.getDunsNumber());
        companyInfo.setNameAndAddressType(nameAndAddressType);
        subcontractReports.setCompanyInfo(companyInfo);
    }

    public void setReportingPeriod(SubcontractReportsDocument.SubcontractReports subcontractReports) {
        SubcontractReportsDocument.SubcontractReports.ReportingPeriod reportingPeriod = (SubcontractReportsDocument.SubcontractReports.ReportingPeriod)SubcontractReportsDocument.SubcontractReports.ReportingPeriod.Factory.newInstance();
        java.util.Date fromDate = new java.util.Date();
        int year = Calendar.getInstance().get(1);
        Date toDate = DateUtils.newDate(year, 9, 30);
        BigDecimal months = this.getMonthsBetweenDates(fromDate, toDate);
        if (months.intValue() > 0) {
            reportingPeriod.setIsMarchReport(true);
            reportingPeriod.setIsSeptReport(false);
        } else {
            reportingPeriod.setIsMarchReport(false);
            reportingPeriod.setIsSeptReport(true);
        }
        subcontractReports.setFiscalYearReportStart(String.valueOf(year));
        subcontractReports.setReportingPeriod(reportingPeriod);
    }

    private BigDecimal getMonthsBetweenDates(java.util.Date pFrom, java.util.Date pTo) {
        Calendar calendarStart = Calendar.getInstance();
        calendarStart.setTimeInMillis(pFrom.getTime());
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTimeInMillis(pTo.getTime());
        int yd = 12 * (calendarEnd.get(1) - calendarStart.get(1));
        int md = calendarEnd.get(2) - calendarStart.get(2);
        int dd = calendarEnd.get(5) - calendarStart.get(5);
        if (dd >= 15) {
            ++md;
        }
        int result = yd + md;
        ScaleTwoDecimal projectDuration = new ScaleTwoDecimal(result);
        return projectDuration.bigDecimalValue().setScale(0);
    }

    public void setAdminActivity(SubcontractReportsDocument.SubcontractReports subcontractReports) {
        SubcontractReportPageType subcontractReportPageType = (SubcontractReportPageType)SubcontractReportPageType.Factory.newInstance();
        ArrayList<SubcontractReportPageType> SubcontractReportPageTypeList = new ArrayList<SubcontractReportPageType>();
        HashMap<String, String> awardMap = new HashMap<String, String>();
        awardMap.put("awardNumber", this.awardNumber);
        List awardList = this.businessObjectService.findMatching(Award.class, awardMap);
        Award award = (Award)awardList.get(0);
        String sponsorCode = award.getPrimeSponsorCode();
        if (award.getPrimeSponsorCode() == null) {
            sponsorCode = award.getSponsorCode();
        }
        if (award != null) {
            HashMap<String, String> hierarchyMap = new HashMap<String, String>();
            hierarchyMap.put("hierarchyName", "Administering Activity");
            hierarchyMap.put("sponsorCode", sponsorCode);
            List sponsorHierarchyList = this.businessObjectService.findMatching(SponsorHierarchy.class, hierarchyMap);
            String administrativeActivity = ((SponsorHierarchy)sponsorHierarchyList.get(0)).getLevel1().toUpperCase();
            subcontractReportPageType.setAdministeringActivity(administrativeActivity);
            if (!(administrativeActivity.equalsIgnoreCase("ARMY") || administrativeActivity.equalsIgnoreCase("NAVY") || administrativeActivity.equalsIgnoreCase("AIR FORCE") || administrativeActivity.equalsIgnoreCase("NASA") || administrativeActivity.equalsIgnoreCase("DOE") || administrativeActivity.equalsIgnoreCase("DLA") || administrativeActivity.equalsIgnoreCase("GSA"))) {
                HashMap<String, String> sponsorMap = new HashMap<String, String>();
                sponsorMap.put("sponsorCode", sponsorCode);
                List sponsorList = this.businessObjectService.findMatching(Sponsor.class, sponsorMap);
                String sponsor = null;
                if (sponsorList.size() > 0) {
                    sponsor = ((Sponsor)sponsorList.get(0)).getSponsorName().toUpperCase();
                }
                subcontractReportPageType.setSponsor(sponsor);
            }
            this.setVendorType(subcontractReportPageType);
            SubcontractReportPageTypeList.add(subcontractReportPageType);
        }
        subcontractReports.setSubcontractReportPageArray(SubcontractReportPageTypeList.toArray(new SubcontractReportPageType[0]));
    }

    public void setContractorType(SubcontractReportsDocument.SubcontractReports subcontractReports) {
        SubcontractReportsDocument.SubcontractReports.ContractorType contractorType = (SubcontractReportsDocument.SubcontractReports.ContractorType)SubcontractReportsDocument.SubcontractReports.ContractorType.Factory.newInstance();
        HashMap<String, String> awardMap = new HashMap<String, String>();
        awardMap.put("awardNumber", this.awardNumber);
        List awardList = this.businessObjectService.findMatching(Award.class, awardMap);
        String awardNum = ((Award)awardList.get(0)).getSponsorAwardNumber();
        contractorType.setPrimeContractNumber(awardNum);
        contractorType.setIsPrime(true);
        contractorType.setIsSub(false);
        subcontractReports.setIncludeIndirectCosts(false);
        subcontractReports.setContractorType(contractorType);
    }

    public void setVendorType(SubcontractReportPageType subcontractReportPageType) {
        SubcontractingExpenditureCategoryAmounts subcontractingExpenditureCategoryAmounts = (SubcontractingExpenditureCategoryAmounts)this.getBusinessObjectService().findBySinglePrimaryKey(SubcontractingExpenditureCategoryAmounts.class, (Object)this.awardNumber);
        if (subcontractingExpenditureCategoryAmounts != null) {
            BigDecimal totalAmount = ((ScaleTwoDecimal)subcontractingExpenditureCategoryAmounts.getLargeBusinessExpenditureAmount().add((AbstractDecimal)subcontractingExpenditureCategoryAmounts.getSmallBusinessExpenditureAmount())).bigDecimalValue();
            ArrayList<SubcontractReportPageType.VendorType> vendorTypeList = new ArrayList<SubcontractReportPageType.VendorType>();
            SubcontractReportPageType.VendorType vendorTypeLargeBusiness = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
            vendorTypeLargeBusiness.setTypeOfVendor("LARGE BUSINESS");
            vendorTypeLargeBusiness.setActualAmount(subcontractingExpenditureCategoryAmounts.getLargeBusinessExpenditureAmount().bigDecimalValue());
            vendorTypeLargeBusiness.setActualPercent(this.getPct(subcontractingExpenditureCategoryAmounts.getLargeBusinessExpenditureAmount().bigDecimalValue(), totalAmount));
            vendorTypeList.add(vendorTypeLargeBusiness);
            SubcontractReportPageType.VendorType vendorTypeSmallBusiness = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
            vendorTypeSmallBusiness.setTypeOfVendor("SMALL BUSINESS");
            vendorTypeSmallBusiness.setActualAmount(subcontractingExpenditureCategoryAmounts.getSmallBusinessExpenditureAmount().bigDecimalValue());
            vendorTypeSmallBusiness.setActualPercent(this.getPct(subcontractingExpenditureCategoryAmounts.getSmallBusinessExpenditureAmount().bigDecimalValue(), totalAmount));
            vendorTypeList.add(vendorTypeSmallBusiness);
            SubcontractReportPageType.VendorType vendorTypeWomenOwned = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
            vendorTypeWomenOwned.setTypeOfVendor("WOMAN OWNED");
            vendorTypeWomenOwned.setActualAmount(subcontractingExpenditureCategoryAmounts.getWomanOwnedExpenditureAmount().bigDecimalValue());
            vendorTypeWomenOwned.setActualPercent(this.getPct(subcontractingExpenditureCategoryAmounts.getWomanOwnedExpenditureAmount().bigDecimalValue(), totalAmount));
            vendorTypeList.add(vendorTypeWomenOwned);
            SubcontractReportPageType.VendorType vendorTypeDisadvantaged = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
            vendorTypeDisadvantaged.setTypeOfVendor("DISADVANTAGED BUSINESS");
            vendorTypeDisadvantaged.setActualAmount(subcontractingExpenditureCategoryAmounts.getEightADisadvantageExpenditureAmount().bigDecimalValue());
            vendorTypeDisadvantaged.setActualPercent(this.getPct(subcontractingExpenditureCategoryAmounts.getEightADisadvantageExpenditureAmount().bigDecimalValue(), totalAmount));
            vendorTypeList.add(vendorTypeDisadvantaged);
            SubcontractReportPageType.VendorType vendorTypeHub = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
            vendorTypeHub.setTypeOfVendor("HUB");
            vendorTypeHub.setActualAmount(subcontractingExpenditureCategoryAmounts.getHubZoneExpenditureAmount().bigDecimalValue());
            vendorTypeHub.setActualPercent(this.getPct(subcontractingExpenditureCategoryAmounts.getHubZoneExpenditureAmount().bigDecimalValue(), totalAmount));
            vendorTypeList.add(vendorTypeHub);
            SubcontractReportPageType.VendorType vendorTypeVet = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
            vendorTypeVet.setTypeOfVendor("VET");
            vendorTypeVet.setActualAmount(subcontractingExpenditureCategoryAmounts.getVeteranOwnedExpenditureAmount().bigDecimalValue());
            vendorTypeVet.setActualPercent(this.getPct(subcontractingExpenditureCategoryAmounts.getVeteranOwnedExpenditureAmount().bigDecimalValue(), totalAmount));
            vendorTypeList.add(vendorTypeVet);
            SubcontractReportPageType.VendorType vendorTypeSdvo = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
            vendorTypeSdvo.setTypeOfVendor("SDVO");
            vendorTypeSdvo.setActualAmount(subcontractingExpenditureCategoryAmounts.getServiceDisabledVeteranOwnedExpenditureAmount().bigDecimalValue());
            vendorTypeSdvo.setActualPercent(this.getPct(subcontractingExpenditureCategoryAmounts.getServiceDisabledVeteranOwnedExpenditureAmount().bigDecimalValue(), totalAmount));
            vendorTypeList.add(vendorTypeSdvo);
            SubcontractReportPageType.VendorType vendorTypeHbcu = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
            vendorTypeHbcu.setTypeOfVendor("HBCU");
            vendorTypeHbcu.setActualAmount(subcontractingExpenditureCategoryAmounts.getHistoricalBlackCollegeExpenditureAmount().bigDecimalValue());
            vendorTypeHbcu.setActualPercent(this.getPct(subcontractingExpenditureCategoryAmounts.getHistoricalBlackCollegeExpenditureAmount().bigDecimalValue(), totalAmount));
            vendorTypeList.add(vendorTypeHbcu);
            subcontractReportPageType.setVendorTypeArray(vendorTypeList.toArray(new SubcontractReportPageType.VendorType[0]));
        }
    }

    public void setOfficials(SubcontractReportsDocument.SubcontractReports subcontractReports) {
        SubcontractReportsDocument.SubcontractReports.AdministeringOfficial administeringOfficial = (SubcontractReportsDocument.SubcontractReports.AdministeringOfficial)SubcontractReportsDocument.SubcontractReports.AdministeringOfficial.Factory.newInstance();
        HashMap<String, String> unitAdministratorMap = new HashMap<String, String>();
        unitAdministratorMap.put("unitNumber", this.unitService.getTopUnit().getUnitNumber());
        unitAdministratorMap.put("unitAdministratorTypeCode", "2");
        List unitAdministratorList = this.businessObjectService.findMatching(UnitAdministrator.class, unitAdministratorMap);
        for (UnitAdministrator unitAdministrator : unitAdministratorList) {
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(unitAdministrator.getPersonId());
            administeringOfficial.setName(person.getFullName());
            administeringOfficial.setPhoneNumber(person.getPhoneNumber());
            administeringOfficial.setTitle(person.getDirectoryTitle());
        }
        subcontractReports.setAdministeringOfficial(administeringOfficial);
    }

    public void setAdminActivity295(SubcontractReportsDocument.SubcontractReports subcontractReports) {
        ArrayList<SubcontractReportPageType> subcontractReportPageTypeList = new ArrayList<SubcontractReportPageType>();
        SubcontractingExpenditureCategoryAmountsInDateRange expenditureCategoryAmounts = null;
        List expenditureCategoryAmountsList = this.getBusinessObjectService().findAll(SubcontractingExpenditureCategoryAmountsInDateRange.class);
        for (SubcontractingExpenditureCategoryAmountsInDateRange expenditureCategoryAmount : expenditureCategoryAmountsList) {
            if (!expenditureCategoryAmount.getAwardNumber().equalsIgnoreCase(this.awardNumber)) continue;
            expenditureCategoryAmounts = expenditureCategoryAmount;
        }
        this.populateSubcontractReportPage("ARMY", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("NAVY", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("AIRFORCE", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("DLA", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("NASA", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("GSA", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("DOE", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("DOD", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("NIH", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("NSF", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("EPA", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("JET", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("EPA", subcontractReportPageTypeList, expenditureCategoryAmounts);
        this.populateSubcontractReportPage("OTHER", subcontractReportPageTypeList, expenditureCategoryAmounts);
        subcontractReports.setSubcontractReportPageArray(subcontractReportPageTypeList.toArray(new SubcontractReportPageType[0]));
    }

    public void populateSubcontractReportPage(String administratingActivity, List<SubcontractReportPageType> subcontractReportPageTypeList, SubcontractingExpenditureCategoryAmountsInDateRange expenditureCategoryAmounts) {
        SubcontractReportPageType subcontractReportPageType = (SubcontractReportPageType)SubcontractReportPageType.Factory.newInstance();
        subcontractReportPageType.setAdministeringActivity(administratingActivity);
        ArrayList<SubcontractReportPageType.VendorType> vendorTypeList = new ArrayList<SubcontractReportPageType.VendorType>(this.populateVendorType(administratingActivity, expenditureCategoryAmounts));
        subcontractReportPageType.setVendorTypeArray(vendorTypeList.toArray(new SubcontractReportPageType.VendorType[0]));
        subcontractReportPageTypeList.add(subcontractReportPageType);
    }

    public List<SubcontractReportPageType.VendorType> populateVendorType(String sponsorGroup, SubcontractingExpenditureCategoryAmountsInDateRange sECAIDR) {
        ScaleTwoDecimal largeBusinessTotal = (ScaleTwoDecimal)this.get295AmountForSponsorGroupFirst(sponsorGroup, "LARGE BUSINESS").add((AbstractDecimal)this.get295AmountForSponsorGroupSecond(sponsorGroup, "LARGE BUSINESS"));
        ScaleTwoDecimal smallBusinessTotal = (ScaleTwoDecimal)this.get295AmountForSponsorGroupFirst(sponsorGroup, "SMALL BUSINESS").add((AbstractDecimal)this.get295AmountForSponsorGroupSecond(sponsorGroup, "SMALL BUSINESS"));
        ScaleTwoDecimal totalAmount = (ScaleTwoDecimal)largeBusinessTotal.add((AbstractDecimal)smallBusinessTotal);
        ArrayList<SubcontractReportPageType.VendorType> vendorTypeList = new ArrayList<SubcontractReportPageType.VendorType>();
        this.populateVendorTypeAmounts(sponsorGroup, "LARGE BUSINESS", vendorTypeList, totalAmount);
        this.populateVendorTypeAmounts(sponsorGroup, "SMALL BUSINESS", vendorTypeList, totalAmount);
        this.populateVendorTypeAmounts(sponsorGroup, "WOMAN OWNED", vendorTypeList, totalAmount);
        this.populateVendorTypeAmounts(sponsorGroup, "DISADVANTAGED BUSINESS", vendorTypeList, totalAmount);
        this.populateVendorTypeAmounts(sponsorGroup, "HUB", vendorTypeList, totalAmount);
        this.populateVendorTypeAmounts(sponsorGroup, "VET", vendorTypeList, totalAmount);
        this.populateVendorTypeAmounts(sponsorGroup, "SDVO", vendorTypeList, totalAmount);
        this.populateVendorTypeAmounts(sponsorGroup, "HBCU", vendorTypeList, totalAmount);
        return vendorTypeList;
    }

    public void populateVendorTypeAmounts(String sponsorGroup, String vendorType, List<SubcontractReportPageType.VendorType> vendorTypeList, ScaleTwoDecimal totalAmount) {
        SubcontractReportPageType.VendorType vendorTypes = (SubcontractReportPageType.VendorType)SubcontractReportPageType.VendorType.Factory.newInstance();
        ScaleTwoDecimal amount = (ScaleTwoDecimal)this.get295AmountForSponsorGroupFirst(sponsorGroup, vendorType).add((AbstractDecimal)this.get295AmountForSponsorGroupSecond(sponsorGroup, vendorType));
        vendorTypes.setTypeOfVendor(vendorType);
        vendorTypes.setActualAmount(amount.bigDecimalValue());
        vendorTypes.setActualPercent(this.getPct(amount.bigDecimalValue(), totalAmount.bigDecimalValue()));
        vendorTypeList.add(vendorTypes);
    }

    public ScaleTwoDecimal get295AmountForSponsorGroupFirst(String sponsorGroup, String vendorType) {
        ArrayList awardsList = new ArrayList();
        ArrayList sponsorList = new ArrayList();
        ArrayList<Award> awardList = new ArrayList<Award>();
        List sECAIDRList = this.getBusinessObjectService().findAll(SubcontractingExpenditureCategoryAmountsInDateRange.class);
        HashMap<String, String> sponsorHierarchyMap = new HashMap<String, String>();
        sponsorHierarchyMap.put("hierarchyName", "Administering Activity");
        sponsorHierarchyMap.put("level1", sponsorGroup);
        ArrayList sponsorHierarchyList = new ArrayList(this.getBusinessObjectService().findMatching(SponsorHierarchy.class, sponsorHierarchyMap));
        for (SponsorHierarchy sponsorHierarchy : sponsorHierarchyList) {
            HashMap<String, String> awardMap = new HashMap<String, String>();
            awardMap.put("sponsorCode", sponsorHierarchy.getSponsorCode());
            awardsList.addAll(this.getBusinessObjectService().findMatching(Award.class, awardMap));
            HashMap sponsorMap = new HashMap();
            sponsorMap.put("sponsorCode", sponsorHierarchy.getSponsorCode());
            sponsorList.addAll(this.getBusinessObjectService().findMatching(Sponsor.class, (Map)sponsorMap));
        }
        for (Award award : awardsList) {
            boolean hasSponsor = false;
            for (Sponsor sponsor : sponsorList) {
                if (!award.getSponsorCode().equals(sponsor.getSponsorCode())) continue;
                hasSponsor = true;
            }
            if (!hasSponsor) continue;
            awardList.add(award);
        }
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (SubcontractingExpenditureCategoryAmountsInDateRange sECAIDR : sECAIDRList) {
            boolean hasAward = false;
            for (Award award : awardList) {
                if (award.getPrimeSponsorCode() != null || !award.getAwardNumber().equalsIgnoreCase(sECAIDR.getAwardNumber())) continue;
                hasAward = true;
            }
            if (!hasAward) continue;
            if (vendorType.equalsIgnoreCase("LARGE BUSINESS")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)sECAIDR.getLargeBusinessExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("SMALL BUSINESS")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)sECAIDR.getSmallBusinessExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("WOMAN OWNED")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)sECAIDR.getWomanOwnedExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("DISADVANTAGED BUSINESS")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)sECAIDR.getEightADisadvantageExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("HUB")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)sECAIDR.getHubZoneExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("VET")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)sECAIDR.getVeteranOwnedExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("SDVO")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)sECAIDR.getServiceDisabledVeteranOwnedExpenditureAmount());
            }
            if (!vendorType.equalsIgnoreCase("HBCU")) continue;
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)sECAIDR.getHistoricalBlackCollegeExpenditureAmount());
        }
        return amount;
    }

    public ScaleTwoDecimal get295AmountForSponsorGroupSecond(String sponsorGroup, String vendorType) {
        ArrayList awardsList = new ArrayList();
        ArrayList<Award> awardList = new ArrayList<Award>();
        ArrayList sponsorList = new ArrayList();
        List expenditureCategoryAmountList = this.getBusinessObjectService().findAll(SubcontractingExpenditureCategoryAmountsInDateRange.class);
        HashMap<String, String> sponsorHierarchyMap = new HashMap<String, String>();
        sponsorHierarchyMap.put("hierarchyName", "Administering Activity");
        sponsorHierarchyMap.put("level1", sponsorGroup);
        ArrayList sponsorHierarchyList = new ArrayList(this.getBusinessObjectService().findMatching(SponsorHierarchy.class, sponsorHierarchyMap));
        for (SponsorHierarchy sponsorHierarchy : sponsorHierarchyList) {
            HashMap<String, String> awardMap = new HashMap<String, String>();
            awardMap.put("primeSponsorCode", sponsorHierarchy.getSponsorCode());
            awardsList.addAll(this.getBusinessObjectService().findMatching(Award.class, awardMap));
            HashMap sponsorMap = new HashMap();
            sponsorMap.put("sponsorCode", sponsorHierarchy.getSponsorCode());
            sponsorList.addAll(this.getBusinessObjectService().findMatching(Sponsor.class, (Map)sponsorMap));
        }
        for (Award award : awardsList) {
            boolean hasSponsor = false;
            for (Sponsor sponsor : sponsorList) {
                if (award.getPrimeSponsorCode() == null || !award.getPrimeSponsorCode().equals(sponsor.getSponsorCode())) continue;
                hasSponsor = true;
            }
            if (!hasSponsor) continue;
            awardList.add(award);
        }
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (SubcontractingExpenditureCategoryAmountsInDateRange expenditureCategoryAmount : expenditureCategoryAmountList) {
            boolean hasAward = false;
            for (Award award : awardList) {
                if (!award.getAwardNumber().equalsIgnoreCase(expenditureCategoryAmount.getAwardNumber())) continue;
                hasAward = true;
            }
            if (!hasAward) continue;
            if (vendorType.equalsIgnoreCase("LARGE BUSINESS")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)expenditureCategoryAmount.getLargeBusinessExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("SMALL BUSINESS")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)expenditureCategoryAmount.getSmallBusinessExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("WOMAN OWNED")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)expenditureCategoryAmount.getWomanOwnedExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("DISADVANTAGED BUSINESS")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)expenditureCategoryAmount.getEightADisadvantageExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("HUB")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)expenditureCategoryAmount.getHubZoneExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("VET")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)expenditureCategoryAmount.getVeteranOwnedExpenditureAmount());
            }
            if (vendorType.equalsIgnoreCase("SDVO")) {
                amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)expenditureCategoryAmount.getServiceDisabledVeteranOwnedExpenditureAmount());
            }
            if (!vendorType.equalsIgnoreCase("HBCU")) continue;
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)expenditureCategoryAmount.getHistoricalBlackCollegeExpenditureAmount());
        }
        return amount;
    }

    private BigDecimal getPct(BigDecimal amt, BigDecimal totAmt) {
        BigDecimal pct = new BigDecimal("0.00");
        try {
            pct = amt.divide(totAmt, 3, 0);
            pct = pct.multiply(new BigDecimal("100"));
        }
        catch (ArithmeticException e) {
            pct = new BigDecimal("0");
        }
        return pct;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

