/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.preproposal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalForm;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormDatum;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsException;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsValueConverter;
import org.kuali.coeus.propdev.impl.preproposal.ProposalDevelopmentEvaluator;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildAppDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildGadgetDto;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ComponentFactory;

public class ProposalDevelopmentPreproposalFormsHelper
implements Serializable {
    private ProposalDevelopmentDocument document;
    private List<KualiBuildAppDto> availableApps;
    private KualiBuildAppDto currentApp;
    private List<PreproposalForm> preproposalForms;
    private List<PreproposalForm> relevantPreproposalForms;
    private boolean showAllForms = false;
    private PreproposalForm currentPreproposalForm;
    private String kualiBuildActionUri;
    private ProposalDevelopmentEvaluator evaluator;
    private PreproposalFormsValueConverter valueConverter;

    public ProposalDevelopmentPreproposalFormsHelper(ProposalDevelopmentDocument document) {
        this.document = document;
    }

    public List<? extends Component> dataComponentsFor(PreproposalForm preproposalForm, String fieldBindingObjectPath) {
        return IntStream.range(0, preproposalForm.getData().size()).mapToObj(i -> this.componentFor(fieldBindingObjectPath, preproposalForm.getData().get(i), i)).toList();
    }

    private InputField componentFor(String fieldBindingObjectPath, PreproposalFormDatum datum, int index) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance((String)"Uif-InputField");
        field.setReadOnly(Boolean.valueOf(true));
        field.setEnableAutoQuickfinder(false);
        field.setEnableAutoInquiry(false);
        field.setEnableAutoDirectInquiry(false);
        field.getBindingInfo().setBindingObjectPath(fieldBindingObjectPath);
        field.setLabel(datum.getLabel());
        field.setPropertyName("data[%s].value".formatted(String.valueOf(index)));
        KualiBuildGadgetDto.CustomFormKey customFormKey = datum.getGadget().getCustomFormKey();
        if (customFormKey != null && customFormKey.isEnabled() && this.evaluator.isValidKey(customFormKey.getValue())) {
            Optional<Object> pdValue = this.getEvaluator().evaluate(customFormKey.getValue());
            Optional<Object> buildValue = Optional.ofNullable(datum.getValue());
            if (!this.valueConverter.valuesMatch(datum.getGadget(), buildValue, pdValue)) {
                field.setAdditionalCssClasses(new ArrayList<String>(List.of("preproposalFormsDiscrepancy")));
                field.getFieldLabel().setAdditionalCssClasses(new ArrayList<String>(List.of("preproposalFormsDiscrepancyLabel")));
            }
            if ("proposal.url".equals(customFormKey.getValue())) {
                field.setRender(false);
            }
        }
        return field;
    }

    public boolean hasAvailableApps() {
        return !this.getAvailableApps().isEmpty();
    }

    public PreproposalForm setCurrentPreproposalFormByDocumentId(String documentId) {
        this.currentPreproposalForm = this.preproposalForms.stream().filter(pf -> pf.getDocument().getId().equals(documentId)).findFirst().orElseThrow(() -> new PreproposalFormsException("Document with id " + documentId + " not found"));
        return this.currentPreproposalForm;
    }

    public boolean isHasIrrelevantForms() {
        return this.preproposalForms.size() > this.relevantPreproposalForms.size();
    }

    public boolean canResubmit(KualiBuildAppDto app) {
        return this.availableApps.contains(app) && this.preproposalForms.stream().filter(p -> app.getId().equals(p.getApp().getId())).findFirst().map(PreproposalForm::isResubmittable).orElse(false) != false;
    }

    public List<PreproposalForm> getDisplayedPreproposalForms() {
        return this.showAllForms ? this.preproposalForms : this.relevantPreproposalForms;
    }

    public ProposalDevelopmentDocument getDocument() {
        return this.document;
    }

    public void setDocument(ProposalDevelopmentDocument document) {
        this.document = document;
    }

    public List<KualiBuildAppDto> getAvailableApps() {
        return this.availableApps;
    }

    public void setAvailableApps(List<KualiBuildAppDto> availableApps) {
        this.availableApps = availableApps;
    }

    public KualiBuildAppDto getCurrentApp() {
        return this.currentApp;
    }

    public void setCurrentApp(KualiBuildAppDto currentApp) {
        this.currentApp = currentApp;
    }

    public List<PreproposalForm> getPreproposalForms() {
        return this.preproposalForms;
    }

    public void setPreproposalForms(List<PreproposalForm> preproposalForms) {
        this.preproposalForms = preproposalForms;
    }

    public List<PreproposalForm> getRelevantPreproposalForms() {
        return this.relevantPreproposalForms;
    }

    public void setRelevantPreproposalForms(List<PreproposalForm> relevantPreproposalForms) {
        this.relevantPreproposalForms = relevantPreproposalForms;
    }

    public boolean isShowAllForms() {
        return this.showAllForms;
    }

    public void setShowAllForms(boolean showAllForms) {
        this.showAllForms = showAllForms;
    }

    public PreproposalForm getCurrentPreproposalForm() {
        return this.currentPreproposalForm;
    }

    public void setCurrentPreproposalForm(PreproposalForm currentPreproposalForm) {
        this.currentPreproposalForm = currentPreproposalForm;
    }

    public String getKualiBuildActionUri() {
        return this.kualiBuildActionUri;
    }

    public void setKualiBuildActionUri(String kualiBuildActionUri) {
        this.kualiBuildActionUri = kualiBuildActionUri;
    }

    public ProposalDevelopmentEvaluator getEvaluator() {
        return this.evaluator;
    }

    protected void setEvaluator(ProposalDevelopmentEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public PreproposalFormsValueConverter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(PreproposalFormsValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }
}

