/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.sponsor;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.impl.sponsor.dto.LiteSponsorDto;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="liteSponsorsController")
public class LiteSponsorsController
extends org.kuali.coeus.sys.framework.controller.rest.RestController {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;

    @GetMapping(value={"/api/v1/lite-sponsors"})
    @ResponseBody
    public List<LiteSponsorDto> getSponsorHierarchySummaries(@RequestParam(value="active", required=false) boolean active) {
        HashMap<String, Boolean> criteria = new HashMap<String, Boolean>();
        if (active) {
            criteria.put("active", Boolean.TRUE);
        }
        List sponsors = this.getBusinessObjectService().findMatching(Sponsor.class, criteria);
        return sponsors.stream().map(sponsor -> this.getCommonApiService().convertObject(sponsor, LiteSponsorDto.class)).collect(Collectors.toList());
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }
}

