/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Transient;
import org.kuali.coeus.common.framework.contact.Contactable;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.PropAwardPersonRoleService;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardAssociate;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncableProperty;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardSyncable;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.AbstractPerson;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class AwardContact
extends AwardAssociate
implements AbstractPerson {
    private static final String ROLODEX_ID_FIELD_NAME = "rolodexId";
    private static final long serialVersionUID = 4386300861743037298L;
    @AwardSyncableProperty(key=true)
    protected String personId;
    @AwardSyncableProperty(key=true)
    @AwardSyncable(scopes={AwardTemplateSyncScope.CONTAINING_CLASS_INHERIT})
    protected Integer rolodexId;
    @AwardSyncableProperty(key=true)
    @AwardSyncable(scopes={AwardTemplateSyncScope.CONTAINING_CLASS_INHERIT})
    protected String roleCode;
    private Long awardContactId;
    protected ContactRole contactRole;
    @AwardSyncableProperty
    private String fullName;
    private KcPerson person;
    private NonOrganizationalRolodex rolodex;
    private transient KcPersonService kcPersonService;
    @Transient
    private transient PropAwardPersonRoleService propAwardPersonRoleService;
    private transient GlobalVariableService globalVariableService;
    private transient PermissionService permissionService;

    public AwardContact() {
    }

    AwardContact(NonOrganizationalRolodex rolodex, ContactRole contactRole) {
        this();
        this.setRolodex(rolodex);
        this.setContactRole(contactRole);
    }

    AwardContact(KcPerson person, ContactRole role) {
        this();
        this.setPerson(person);
        this.setContactRole(role);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AwardContact)) {
            return false;
        }
        AwardContact other = (AwardContact)obj;
        if (this.getContactRole() == null ? other.getContactRole() != null : !this.getContactRole().equals(other.getContactRole())) {
            return false;
        }
        if (this.getContact() == null) {
            if (other.getContact() != null) {
                return false;
            }
        } else if (this.getContact().getFullName() == null) {
            if (other.getContact().getFullName() != null) {
                return false;
            }
        } else {
            return this.getContact().getFullName().equalsIgnoreCase(other.getContact().getFullName());
        }
        return true;
    }

    public Long getAwardContactId() {
        return this.awardContactId;
    }

    public Contactable getContact() {
        Contactable contact;
        Contactable contactable = contact = this.person != null ? this.person : this.rolodex;
        if (contact == null) {
            if (this.personId != null) {
                this.refreshPerson();
                contact = this.person;
            } else if (this.rolodexId != null) {
                this.refreshRolodex();
                contact = this.rolodex;
            }
        }
        return contact;
    }

    @Override
    public Award getParent() {
        return this.getAward();
    }

    public String getContactOrganizationName() {
        Contactable contact = this.getContact();
        return contact != null ? contact.getContactOrganizationName() : null;
    }

    public String getGenericId() {
        return this.rolodexId != null ? this.rolodexId.toString() : this.personId;
    }

    public String getOrganizationIdentifier() {
        return this.getContact() != null ? this.getContact().getOrganizationIdentifier() : null;
    }

    public ContactRole getContactRole() {
        return this.getRole();
    }

    public String getContactRoleCode() {
        return this.roleCode;
    }

    public String getEmailAddress() {
        return this.getContact() != null ? this.getContact().getEmailAddress() : null;
    }

    @Override
    public String getFullName() {
        this.getContact();
        return this.fullName;
    }

    @Override
    public KcPerson getPerson() {
        if (this.person == null && this.personId != null) {
            this.refreshPerson();
        }
        return this.person;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    public String getPhoneNumber() {
        return this.getContact() != null ? this.getContact().getPhoneNumber() : null;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public NonOrganizationalRolodex getRolodex() {
        if (this.rolodex == null && this.rolodexId != null) {
            this.refreshRolodex();
        }
        return this.rolodex;
    }

    @Override
    public Integer getRolodexId() {
        return this.rolodexId;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.getContactRole() == null ? 0 : this.getContactRole().hashCode());
        return 31 * result + (this.getContact() != null && this.getContact().getFullName() != null ? this.getContact().getFullName().hashCode() : 0);
    }

    public boolean isEmployee() {
        return this.getContact() != null && this.getContact() instanceof KcPerson;
    }

    @Override
    public void resetPersistenceState() {
        this.awardContactId = null;
    }

    public void setAwardContactId(Long awardContactid) {
        this.awardContactId = awardContactid;
    }

    public void setContactRole(ContactRole contactRole) {
        this.contactRole = contactRole;
        this.roleCode = contactRole != null ? contactRole.getRoleCode() : null;
    }

    public void setContactRoleCode(String roleCode) {
        this.roleCode = roleCode;
        this.refreshContactRole();
    }

    public void setEmailAddress(String emailAddress) {
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setPerson(KcPerson person) {
        if (person != null && person.getPersonId() == null) {
            person = null;
        }
        this.person = person;
        if (person != null) {
            this.rolodex = null;
            this.rolodexId = null;
            this.fullName = person.getFullName();
            this.personId = person.getPersonId();
        }
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        this.refreshPerson();
    }

    public void setPhoneNumber(String phoneNumber) {
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
        this.refreshContactRole();
    }

    public void setRolodex(NonOrganizationalRolodex rolodex) {
        if (rolodex != null && rolodex.getRolodexId() == null) {
            rolodex = null;
        }
        this.rolodex = rolodex;
        if (rolodex != null) {
            this.person = null;
            this.personId = null;
            this.fullName = rolodex.getFullName();
            this.rolodexId = rolodex.getRolodexId();
        }
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
        this.refreshRolodex();
    }

    public void setUnitName(String unitName) {
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected abstract <T extends ContactRole & PersistableBusinessObject> Class<T> getContactRoleType();

    protected abstract Map<String, Object> getContactRoleIdentifierMap();

    protected ContactRole refreshContactRole() {
        List contactRoles;
        ContactRole role = null;
        if (this.roleCode != null && !(contactRoles = this.getBusinessObjectService().findMatching(this.getContactRoleType(), this.getContactRoleIdentifierMap())).isEmpty()) {
            role = (ContactRole)contactRoles.iterator().next();
        }
        this.setContactRole(role);
        return role;
    }

    protected Map<String, Object> getIdentifierMap(String identifierField, Object identifierValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(identifierField, identifierValue);
        return map;
    }

    protected void refreshPerson() {
        if (!(this.personId == null || this.person != null && this.personId.equals(this.person.getPersonId()))) {
            this.setPerson(this.getKcPersonService().getKcPersonByPersonId(this.personId));
        }
    }

    protected void refreshRolodex() {
        NonOrganizationalRolodex rolodex = this.rolodexId != null ? (NonOrganizationalRolodex)this.getBusinessObjectService().findByPrimaryKey(NonOrganizationalRolodex.class, this.getIdentifierMap(ROLODEX_ID_FIELD_NAME, this.rolodexId)) : null;
        this.setRolodex(rolodex);
    }

    public ContactRole getRole() {
        return this.refreshContactRole();
    }

    protected PropAwardPersonRoleService getPropAwardPersonRoleService() {
        if (this.propAwardPersonRoleService == null) {
            this.propAwardPersonRoleService = KcServiceLocator.getService(PropAwardPersonRoleService.class);
        }
        return this.propAwardPersonRoleService;
    }

    public void setPropAwardPersonRoleService(PropAwardPersonRoleService propAwardPersonRoleService) {
        this.propAwardPersonRoleService = propAwardPersonRoleService;
    }

    protected GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    public boolean getCanViewDisclosureDisposition() {
        String genericId;
        String currentUser = this.getGlobalVariableService().getUserSession().getPerson().getPrincipalId();
        return currentUser.equalsIgnoreCase(genericId = this.getGenericId()) || this.getPermissionService().hasPermission(currentUser, "KC-SYS", "View COI Disclosure Disposition");
    }
}

