/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.hierarchy;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.budget.framework.income.BudgetProjectIncome;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.hierarchy.ProposalBudgetHierarchyService;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardAttachment;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwardFiles;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyBudgetTypeConstants;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyDao;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyErrorWarningDto;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyException;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcDataObject;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="proposalBudgetHierarchyService")
@Transactional
public class ProposalBudgetHierarchyServiceImpl
implements ProposalBudgetHierarchyService {
    private static final Logger LOG = LogManager.getLogger(ProposalBudgetHierarchyServiceImpl.class);
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private ProposalBudgetService budgetService;
    @Autowired
    @Qualifier(value="budgetSummaryService")
    private BudgetSummaryService budgetSummaryService;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="proposalHierarchyDao")
    private ProposalHierarchyDao proposalHierarchyDao;

    @Override
    public void persistProposalHierarchyBudget(DevelopmentProposal hierarchyProposal) {
        this.dataObjectService.save((Object)this.getHierarchyBudget(hierarchyProposal), new PersistenceOption[0]);
    }

    @Override
    public void synchronizeChildBudget(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, List<BudgetPeriod> oldBudgetPeriods) {
        this.synchronizeChildBudget(hierarchyProposal, childProposal, this.getSyncableBudget(childProposal), oldBudgetPeriods);
    }

    @Override
    public void synchronizeChildBudget(DevelopmentProposal hierarchyProposal, ProposalDevelopmentBudgetExt budget) {
        this.synchronizeChildBudget(hierarchyProposal, budget.getBudgetParent(), budget, budget.getBudgetPeriods());
    }

    @Override
    public void synchronizeAllChildBudgets(DevelopmentProposal hierarchyProposal) {
        List<BudgetPeriod> oldBudgetPeriods = this.getHierarchyBudget(hierarchyProposal).getBudgetPeriods();
        this.removeMergeableChildBudgetElements(this.getHierarchyBudget(hierarchyProposal));
        for (DevelopmentProposal childProposal : this.proposalHierarchyDao.getHierarchyChildProposals(hierarchyProposal.getProposalNumber())) {
            ProposalDevelopmentBudgetExt budget = this.getSyncableBudget(childProposal);
            this.synchronizeChildBudget(hierarchyProposal, childProposal, budget, oldBudgetPeriods);
            this.dataObjectService.save((Object)budget, new PersistenceOption[0]);
            this.dataObjectService.save((Object)childProposal, new PersistenceOption[0]);
        }
    }

    protected void synchronizeChildBudget(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, ProposalDevelopmentBudgetExt childBudget, List<BudgetPeriod> oldBudgetPeriods) {
        String hierarchyBudgetTypeCode = childProposal.getHierarchyBudgetType();
        String childProposalNumber = childProposal.getProposalNumber();
        ProposalDevelopmentBudgetExt parentBudget = this.getHierarchyBudget(hierarchyProposal);
        this.removeChildBudgetElements(hierarchyProposal, parentBudget, childProposal.getProposalNumber());
        this.synchBudgetPeriods(childBudget, parentBudget);
        boolean isOriginatingChildBudget = StringUtils.equals((CharSequence)childProposal.getProposalNumber(), (CharSequence)hierarchyProposal.getHierarchyOriginatingChildProposalNumber());
        try {
            if (isOriginatingChildBudget) {
                parentBudget.setUrRateClassCode(childBudget.getUrRateClassCode());
                parentBudget.setOhRateClassCode(childBudget.getOhRateClassCode());
            }
            HashMap<Integer, BudgetPerson> personMap = new HashMap<Integer, BudgetPerson>();
            for (BudgetPerson person : childBudget.getBudgetPersons()) {
                BudgetPerson newPerson = (BudgetPerson)this.deepCopy(person);
                newPerson.setBudget(parentBudget);
                newPerson.setPersonSequenceNumber(parentBudget.getNextValue("personSequenceNumber"));
                newPerson.setBudgetId(parentBudget.getBudgetId());
                newPerson.setHierarchyProposalNumber(childProposalNumber);
                newPerson.setHierarchyProposal(childProposal);
                newPerson.setVersionNumber(null);
                parentBudget.addBudgetPerson(newPerson);
                personMap.put(person.getPersonSequenceNumber(), newPerson);
            }
            HashMap<Integer, BudgetSubAwards> subAwardMap = new HashMap<Integer, BudgetSubAwards>();
            for (BudgetSubAwards childSubAwards : childBudget.getBudgetSubAwards()) {
                childSubAwards.getSubAwardXmlFileData();
                for (BudgetSubAwardAttachment origAttachment : childSubAwards.getBudgetSubAwardAttachments()) {
                    origAttachment.getData();
                }
                for (BudgetSubAwardFiles budgetSubAwardFiles : childSubAwards.getBudgetSubAwardFiles()) {
                    budgetSubAwardFiles.getSubAwardXmlFileData();
                }
                BudgetSubAwards newSubAwards = (BudgetSubAwards)this.deepCopy(childSubAwards);
                newSubAwards.setBudget(parentBudget);
                newSubAwards.setBudgetId(parentBudget.getBudgetId());
                newSubAwards.setBudgetVersionNumber(parentBudget.getBudgetVersionNumber());
                newSubAwards.setSubAwardNumber(parentBudget.getNextValue("subAwardNumber") != null ? parentBudget.getNextValue("subAwardNumber") : 1);
                newSubAwards.setVersionNumber(null);
                newSubAwards.setHierarchyProposalNumber(childProposalNumber);
                for (BudgetSubAwardAttachment attachment : newSubAwards.getBudgetSubAwardAttachments()) {
                    attachment.setBudgetSubAward(newSubAwards);
                    attachment.setId(null);
                    attachment.setVersionNumber(null);
                }
                for (BudgetSubAwardFiles files : newSubAwards.getBudgetSubAwardFiles()) {
                    files.setBudgetSubAward(newSubAwards);
                    files.setVersionNumber(null);
                }
                parentBudget.getBudgetSubAwards().add(newSubAwards);
                subAwardMap.put(childSubAwards.getSubAwardNumber(), newSubAwards);
            }
            List<BudgetPeriod> childPeriods = childBudget.getBudgetPeriods();
            Long budgetId = parentBudget.getBudgetId();
            for (BudgetCostShare costShare : childBudget.getBudgetCostShares()) {
                if (!StringUtils.isNotEmpty((CharSequence)costShare.getSourceAccount())) continue;
                BudgetCostShare newCostShare = (BudgetCostShare)this.deepCopy(costShare);
                newCostShare.setBudget(parentBudget);
                newCostShare.setBudgetId(budgetId);
                newCostShare.setDocumentComponentId(parentBudget.getNextValue(newCostShare.getDocumentComponentIdKey()));
                newCostShare.setObjectId(null);
                newCostShare.setVersionNumber(null);
                newCostShare.setHierarchyProposalNumber(childProposalNumber);
                newCostShare.setHiddenInHierarchy(true);
                parentBudget.add(newCostShare);
            }
            this.syncUnrecoveredFandA(childBudget, childProposalNumber, parentBudget, budgetId);
            Iterator<KcPersistableBusinessObjectBase> iterator = childPeriods.iterator();
            while (iterator.hasNext()) {
                CostElement costElement;
                Integer lineItemNumber;
                BudgetLineItem parentLineItem;
                BudgetPeriod childPeriod1;
                BudgetPeriod childPeriod = childPeriod1 = (BudgetPeriod)iterator.next();
                BudgetPeriod parentPeriod = this.findOrCreateMatchingPeriod(childPeriod, parentBudget);
                Integer budgetPeriod = parentPeriod.getBudgetPeriod();
                if (StringUtils.equals((CharSequence)hierarchyBudgetTypeCode, (CharSequence)HierarchyBudgetTypeConstants.SubBudget.code())) {
                    for (BudgetLineItem childLineItem : childPeriod.getBudgetLineItems()) {
                        parentLineItem = (BudgetLineItem)this.deepCopy(childLineItem);
                        parentLineItem.setGroupName((String)(StringUtils.isNotBlank((CharSequence)childLineItem.getGroupName()) ? childLineItem.getGroupName() : "Proposal #" + childProposalNumber));
                        lineItemNumber = parentBudget.getNextValue("budget.budgetLineItem.lineItemNumber");
                        parentLineItem.setHierarchyProposalNumber(childProposalNumber);
                        parentLineItem.setHierarchyProposal(childProposal);
                        parentLineItem.setBudgetLineItemId(null);
                        parentLineItem.setBudgetPeriodId(parentPeriod.getBudgetPeriodId());
                        parentLineItem.setBudgetPeriod(parentPeriod.getBudgetPeriod());
                        parentLineItem.setBudgetPeriodBO(parentPeriod);
                        parentLineItem.setBudget(parentBudget);
                        parentLineItem.setBudgetId(parentBudget.getBudgetId());
                        parentLineItem.setBudgetPeriod(budgetPeriod);
                        parentLineItem.setLineItemNumber(lineItemNumber);
                        parentLineItem.setVersionNumber(null);
                        parentLineItem.setObjectId(null);
                        if (parentLineItem.getSubAwardNumber() != null) {
                            BudgetSubAwards subAward = (BudgetSubAwards)subAwardMap.get(childLineItem.getSubAwardNumber());
                            parentLineItem.setSubAwardNumber(subAward.getSubAwardNumber());
                            parentLineItem.setBudgetSubAward(subAward);
                        }
                        for (BudgetLineItemCalculatedAmount calAmt : parentLineItem.getBudgetLineItemCalculatedAmounts()) {
                            calAmt.setBudgetLineItem(parentLineItem);
                            calAmt.setBudgetLineItemCalculatedAmountId(null);
                            calAmt.setBudgetLineItemId(null);
                            calAmt.setBudgetId(budgetId);
                            calAmt.setBudgetPeriod(budgetPeriod);
                            calAmt.setLineItemNumber(lineItemNumber);
                            calAmt.setVersionNumber(null);
                            calAmt.setObjectId(null);
                        }
                        for (BudgetPersonnelDetails details : parentLineItem.getBudgetPersonnelDetailsList()) {
                            BudgetPerson budgetPerson = (BudgetPerson)personMap.get(details.getPersonSequenceNumber());
                            details.setBudgetLineItem(parentLineItem);
                            details.setBudgetPerson(budgetPerson);
                            details.setJobCode(budgetPerson.getJobCode());
                            details.setPersonId(budgetPerson.getPersonRolodexTbnId());
                            details.setPersonSequenceNumber(budgetPerson.getPersonSequenceNumber());
                            details.setPersonNumber(parentBudget.getNextValue("budget.budgetPersonnelDetails.personNumber"));
                            details.setBudgetPersonnelLineItemId(null);
                            details.setBudget(parentBudget);
                            details.setBudgetId(budgetId);
                            details.setBudgetPeriod(budgetPeriod);
                            details.setLineItemNumber(lineItemNumber);
                            details.setVersionNumber(null);
                            details.setObjectId(null);
                            for (BudgetPersonnelCalculatedAmount calAmt : details.getBudgetPersonnelCalculatedAmounts()) {
                                calAmt.setBudgetPersonnelCalculatedAmountId(null);
                                calAmt.setBudgetPersonnelLineItem(details);
                                calAmt.setBudgetId(budgetId);
                                calAmt.setBudgetPeriod(budgetPeriod);
                                calAmt.setLineItemNumber(lineItemNumber);
                                calAmt.setVersionNumber(null);
                                calAmt.setObjectId(null);
                            }
                        }
                        parentPeriod.getBudgetLineItems().add(parentLineItem);
                    }
                    continue;
                }
                String directCostElement = this.parameterService.getParameterValueAsString(Budget.class, "proposalHierarchySubProjectDirectCostElement");
                String indirectCostElement = this.parameterService.getParameterValueAsString(Budget.class, "proposalHierarchySubProjectIndirectCostElement");
                if (childPeriod.getTotalIndirectCost().isNonZero()) {
                    costElement = (CostElement)this.dataObjectService.findUnique(CostElement.class, QueryByCriteria.Builder.forAttribute((String)"costElement", (Object)indirectCostElement).build());
                    parentLineItem = parentBudget.getNewBudgetLineItem();
                    parentLineItem.setLineItemDescription(childProposalNumber);
                    parentLineItem.setStartDate(parentPeriod.getStartDate());
                    parentLineItem.setEndDate(parentPeriod.getEndDate());
                    parentLineItem.setHierarchyProposalNumber(childProposalNumber);
                    parentLineItem.setHierarchyProposal(childProposal);
                    parentLineItem.setBudget(parentBudget);
                    parentLineItem.setBudgetId(parentBudget.getBudgetId());
                    parentLineItem.setBudgetPeriodId(parentPeriod.getBudgetPeriodId());
                    parentLineItem.setBudgetPeriod(parentPeriod.getBudgetPeriod());
                    parentLineItem.setBudgetPeriodBO(parentPeriod);
                    parentLineItem.setBudgetPeriod(budgetPeriod);
                    parentLineItem.setVersionNumber(null);
                    lineItemNumber = parentBudget.getNextValue("budget.budgetLineItem.lineItemNumber");
                    parentLineItem.setLineItemNumber(lineItemNumber);
                    parentLineItem.setLineItemSequence(lineItemNumber);
                    parentLineItem.setLineItemCost(childPeriod.getTotalIndirectCost());
                    parentLineItem.setIndirectCost(childPeriod.getTotalIndirectCost());
                    parentLineItem.setCostElementBO(costElement);
                    parentLineItem.setCostElement(costElement.getCostElement());
                    parentLineItem.setBudgetCategoryCode(costElement.getBudgetCategoryCode());
                    parentLineItem.setOnOffCampusFlag(costElement.getOnOffCampusFlag());
                    parentLineItem.setApplyInRateFlag(true);
                    parentPeriod.getBudgetLineItems().add(parentLineItem);
                }
                if (!childPeriod.getTotalDirectCost().isNonZero()) continue;
                costElement = (CostElement)this.dataObjectService.findUnique(CostElement.class, QueryByCriteria.Builder.forAttribute((String)"costElement", (Object)directCostElement).build());
                parentLineItem = parentBudget.getNewBudgetLineItem();
                parentLineItem.setLineItemDescription(childProposalNumber);
                parentLineItem.setStartDate(parentPeriod.getStartDate());
                parentLineItem.setEndDate(parentPeriod.getEndDate());
                parentLineItem.setHierarchyProposalNumber(childProposalNumber);
                parentLineItem.setHierarchyProposal(childProposal);
                parentLineItem.setBudget(parentBudget);
                parentLineItem.setBudgetId(parentBudget.getBudgetId());
                parentLineItem.setBudgetPeriodId(parentPeriod.getBudgetPeriodId());
                parentLineItem.setBudgetPeriod(parentPeriod.getBudgetPeriod());
                parentLineItem.setBudgetPeriodBO(parentPeriod);
                parentLineItem.setBudgetPeriod(budgetPeriod);
                parentLineItem.setVersionNumber(null);
                lineItemNumber = parentBudget.getNextValue("budget.budgetLineItem.lineItemNumber");
                parentLineItem.setLineItemNumber(lineItemNumber);
                parentLineItem.setLineItemSequence(lineItemNumber);
                parentLineItem.setLineItemCost(childPeriod.getTotalDirectCost());
                parentLineItem.setDirectCost(childPeriod.getTotalDirectCost());
                parentLineItem.setCostElementBO(costElement);
                parentLineItem.setCostElement(costElement.getCostElement());
                parentLineItem.setBudgetCategoryCode(costElement.getBudgetCategoryCode());
                parentLineItem.setOnOffCampusFlag(costElement.getOnOffCampusFlag());
                parentLineItem.setApplyInRateFlag(true);
                parentPeriod.getBudgetLineItems().add(parentLineItem);
            }
            parentBudget.setStartDate(parentBudget.getBudgetPeriod(0).getStartDate());
            parentBudget.setEndDate(parentBudget.getBudgetPeriod(parentBudget.getBudgetPeriods().size() - 1).getEndDate());
        }
        catch (Exception e) {
            LOG.error("Problem copying line items to parent", (Throwable)e);
            throw new ProposalHierarchyException("Problem copying line items to parent", e);
        }
        this.budgetService.recalculateBudget(parentBudget);
        childProposal.setLastSyncedBudget(childBudget);
        childBudget.setHierarchyLastSyncHashCode(this.computeHierarchyHashCode(childBudget));
    }

    private void syncUnrecoveredFandA(ProposalDevelopmentBudgetExt childBudget, String childProposalNumber, ProposalDevelopmentBudgetExt parentBudget, Long budgetId) {
        for (BudgetUnrecoveredFandA unrecoveredFandA : childBudget.getBudgetUnrecoveredFandAs()) {
            if (!StringUtils.isNotEmpty((CharSequence)unrecoveredFandA.getSourceAccount())) continue;
            Optional<BudgetUnrecoveredFandA> matchedUnrecoveredFandA = parentBudget.getBudgetUnrecoveredFandAs().stream().filter(parentUnrecoveredFandA -> parentUnrecoveredFandA.getFiscalYear().equals(unrecoveredFandA.getFiscalYear()) && parentUnrecoveredFandA.getApplicableRate().equals((Object)unrecoveredFandA.getApplicableRate()) && parentUnrecoveredFandA.getOnCampusFlag().equals(unrecoveredFandA.getOnCampusFlag()) && parentUnrecoveredFandA.getSourceAccount().equals(unrecoveredFandA.getSourceAccount())).findFirst();
            if (matchedUnrecoveredFandA.isPresent()) {
                BudgetUnrecoveredFandA parentUnrecoveredFandA2 = matchedUnrecoveredFandA.get();
                parentUnrecoveredFandA2.setAmount((ScaleTwoDecimal)parentUnrecoveredFandA2.getAmount().add((AbstractDecimal)unrecoveredFandA.getAmount()));
                continue;
            }
            BudgetUnrecoveredFandA newUnrecoveredFandA = (BudgetUnrecoveredFandA)this.deepCopy(unrecoveredFandA);
            newUnrecoveredFandA.setBudget(parentBudget);
            newUnrecoveredFandA.setBudgetId(budgetId);
            newUnrecoveredFandA.setDocumentComponentId(parentBudget.getNextValue(newUnrecoveredFandA.getDocumentComponentIdKey()));
            newUnrecoveredFandA.setObjectId(null);
            newUnrecoveredFandA.setVersionNumber(null);
            newUnrecoveredFandA.setHierarchyProposalNumber(childProposalNumber);
            newUnrecoveredFandA.setHiddenInHierarchy(true);
            parentBudget.add(newUnrecoveredFandA);
        }
    }

    protected void synchBudgetPeriods(ProposalDevelopmentBudgetExt childBudget, ProposalDevelopmentBudgetExt parentBudget) {
        ArrayList periodsToDelete = new ArrayList();
        parentBudget.getBudgetPeriods().forEach(parentBudgetPeriod -> {
            if (!childBudget.getBudgetPeriods().stream().anyMatch(childBudgetPeriod -> childBudgetPeriod.getStartDate().equals(parentBudgetPeriod.getStartDate()) && childBudgetPeriod.getEndDate().equals(parentBudgetPeriod.getEndDate()))) {
                periodsToDelete.add(parentBudgetPeriod);
            }
        });
        periodsToDelete.forEach(period -> {
            if (period.getBudgetModular() != null) {
                this.getDataObjectService().delete((Object)period.getBudgetModular());
            }
            parentBudget.getBudgetPeriods().remove(period);
        });
    }

    protected BudgetPeriod findOrCreateMatchingPeriod(BudgetPeriod childPeriod, Budget parentBudget) {
        int priorPeriodIndex = 0;
        int index = 0;
        for (BudgetPeriod period : parentBudget.getBudgetPeriods()) {
            if (period.getStartDate().equals(childPeriod.getStartDate()) && period.getEndDate().equals(childPeriod.getEndDate())) {
                return period;
            }
            if (period.getEndDate().before(childPeriod.getStartDate())) {
                priorPeriodIndex = index;
            }
            ++index;
        }
        int previousBudgetPeriod = parentBudget.getBudgetPeriods().size() == 0 ? 0 : parentBudget.getBudgetPeriods().get(priorPeriodIndex).getBudgetPeriod();
        BudgetPeriod result = new BudgetPeriod();
        result.setStartDate(childPeriod.getStartDate());
        result.setEndDate(childPeriod.getEndDate());
        result.setBudgetPeriod(previousBudgetPeriod + 1);
        result.setBudget(parentBudget);
        this.getBudgetSummaryService().addBudgetPeriod(parentBudget, result);
        return result;
    }

    @Override
    public void removeMergeableChildBudgetElements(ProposalDevelopmentBudgetExt parentBudget) {
        java.util.function.Predicate<HierarchyMaintainable> notFromHierarchy = mergeable -> mergeable.getHierarchyProposalNumber() == null;
        QueryByCriteria inHierarchyQuery = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.isNotNull((String)"hierarchyProposalNumber"), PredicateFactory.equal((String)"budgetId", (Object)parentBudget.getBudgetId())});
        this.dataObjectService.deleteMatching(BudgetUnrecoveredFandA.class, inHierarchyQuery);
        parentBudget.setBudgetUnrecoveredFandAs(parentBudget.getBudgetUnrecoveredFandAs().stream().filter(notFromHierarchy).collect(Collectors.toList()));
        this.dataObjectService.deleteMatching(BudgetCostShare.class, inHierarchyQuery);
        parentBudget.setBudgetCostShares(parentBudget.getBudgetCostShares().stream().filter(notFromHierarchy).collect(Collectors.toList()));
    }

    @Override
    public void removeChildBudgetElements(DevelopmentProposal parentProposal, ProposalDevelopmentBudgetExt parentBudget, String childProposalNumber) {
        QueryByCriteria query = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"hierarchyProposalNumber", (Object)childProposalNumber), PredicateFactory.equal((String)"budgetId", (Object)parentBudget.getBudgetId())});
        this.dataObjectService.deleteMatching(BudgetProjectIncome.class, query);
        this.dataObjectService.deleteMatching(BudgetCostShare.class, query);
        Iterator<KcPersistableBusinessObjectBase> iter = parentBudget.getBudgetSubAwards().iterator();
        while (iter.hasNext()) {
            BudgetSubAwards subAward = iter.next();
            if (!StringUtils.equals((CharSequence)childProposalNumber, (CharSequence)subAward.getHierarchyProposalNumber())) continue;
            List lineItems = this.getDataObjectService().findMatching(BudgetLineItem.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"budgetId", (Object)subAward.getBudgetId()), PredicateFactory.equal((String)"subAwardNumber", (Object)subAward.getSubAwardNumber())})).getResults();
            for (BudgetPeriod period : parentBudget.getBudgetPeriods()) {
                period.getBudgetLineItems().removeAll(lineItems);
            }
            iter.remove();
        }
        parentBudget.setBudgetCostShares(parentBudget.getBudgetCostShares().stream().filter(costShare -> !costShare.getHierarchyProposalNumber().equals(childProposalNumber)).collect(Collectors.toList()));
        iter = parentBudget.getBudgetPersons().iterator();
        while (iter.hasNext()) {
            BudgetPerson person = (BudgetPerson)iter.next();
            if (!StringUtils.equals((CharSequence)childProposalNumber, (CharSequence)person.getHierarchyProposalNumber())) continue;
            iter.remove();
        }
        ArrayList<BudgetPeriod> periodsToDelete = new ArrayList<BudgetPeriod>();
        for (int i = parentBudget.getBudgetPeriods().size() - 1; i >= 0; --i) {
            boolean deletePeriods = false;
            BudgetPeriod period = parentBudget.getBudgetPeriod(i);
            Iterator<BudgetLineItem> lineItemIter = period.getBudgetLineItems().iterator();
            while (lineItemIter.hasNext()) {
                BudgetLineItem lineItem = lineItemIter.next();
                if (!StringUtils.equals((CharSequence)childProposalNumber, (CharSequence)lineItem.getHierarchyProposalNumber())) continue;
                deletePeriods = true;
                lineItemIter.remove();
            }
            if (!deletePeriods || parentBudget.getBudgetPeriods().get(i).getBudgetLineItems().size() != 0 || i <= 0) continue;
            periodsToDelete.add(parentBudget.getBudgetPeriods().get(i));
        }
        for (BudgetPeriod period : periodsToDelete) {
            if (period.getBudgetModular() != null) {
                this.getDataObjectService().delete((Object)period.getBudgetModular());
            }
            parentBudget.getBudgetPeriods().remove(period);
        }
        parentBudget.setEndDate(parentBudget.getBudgetPeriods().get(parentBudget.getBudgetPeriods().size() - 1).getEndDate());
    }

    @Override
    public void initializeBudget(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal) throws ProposalHierarchyException {
        this.budgetService.addBudgetVersion(hierarchyProposal.getProposalDocument(), "Hierarchy Budget", null);
        ProposalDevelopmentBudgetExt parentBudget = this.getHierarchyBudget(hierarchyProposal);
        ProposalDevelopmentBudgetExt childBudget = this.getSyncableBudget(childProposal);
        for (int i = 0; i < childBudget.getBudgetPeriods().size(); ++i) {
            BudgetPeriod parentPeriod = parentBudget.getBudgetPeriod(i);
            BudgetPeriod childPeriod = childBudget.getBudgetPeriod(i);
            parentPeriod.setStartDate(childPeriod.getStartDate());
            parentPeriod.setEndDate(childPeriod.getEndDate());
            parentPeriod.setBudgetPeriod(childPeriod.getBudgetPeriod());
        }
        parentBudget.setCostSharingAmount(ScaleTwoDecimal.ZERO);
        parentBudget.setTotalCost(ScaleTwoDecimal.ZERO);
        parentBudget.setTotalDirectCost(ScaleTwoDecimal.ZERO);
        parentBudget.setTotalIndirectCost(ScaleTwoDecimal.ZERO);
        parentBudget.setUnderrecoveryAmount(ScaleTwoDecimal.ZERO);
        parentBudget.setOhRateClassCode(childBudget.getOhRateClassCode());
        parentBudget.setOhRateTypeCode(childBudget.getOhRateTypeCode());
        parentBudget.setUrRateClassCode(childBudget.getUrRateClassCode());
        this.dataObjectService.save((Object)parentBudget, new PersistenceOption[0]);
    }

    @Override
    public List<ProposalHierarchyErrorWarningDto> validateChildBudgetPeriods(DevelopmentProposal hierarchyProposal, DevelopmentProposal childProposal, boolean allowEndDateChange) throws ProposalHierarchyException {
        ArrayList<ProposalHierarchyErrorWarningDto> retval = new ArrayList<ProposalHierarchyErrorWarningDto>();
        ProposalDevelopmentBudgetExt parentBudget = this.getHierarchyBudget(hierarchyProposal);
        if (parentBudget != null) {
            ProposalDevelopmentBudgetExt childBudget = this.getSyncableBudget(childProposal);
            int correspondingStart = this.getCorrespondingParentPeriod(parentBudget.getBudgetPeriods(), childBudget);
            if (correspondingStart == -1) {
                retval.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.budget.startDateInconsistent", Boolean.TRUE, childProposal.getProposalNumber()));
            } else {
                int j;
                List<BudgetPeriod> parentPeriods = parentBudget.getBudgetPeriods();
                List<BudgetPeriod> childPeriods = childBudget.getBudgetPeriods();
                int i = correspondingStart;
                for (j = 0; i < parentPeriods.size() && j < childPeriods.size(); ++i, ++j) {
                    BudgetPeriod parentPeriod = parentPeriods.get(i);
                    BudgetPeriod childPeriod = childPeriods.get(j);
                    if (parentPeriod.getStartDate().equals(childPeriod.getStartDate()) && parentPeriod.getEndDate().equals(childPeriod.getEndDate())) continue;
                    retval.add(new ProposalHierarchyErrorWarningDto("error.hierarchy.budget.periodDurationInconsistent", Boolean.TRUE, childProposal.getProposalNumber()));
                    break;
                }
                if (retval.isEmpty() && !allowEndDateChange && (j < childPeriods.size() || childProposal.getRequestedEndDateInitial().after(hierarchyProposal.getRequestedEndDateInitial()))) {
                    retval.add(new ProposalHierarchyErrorWarningDto("question.hierarchy.extendDate.confirm", Boolean.TRUE, childProposal.getProposalNumber()));
                }
            }
        }
        return retval;
    }

    @Override
    public ProposalDevelopmentBudgetExt getHierarchyBudget(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        if (!hierarchyProposal.getBudgets().isEmpty()) {
            return hierarchyProposal.getBudgets().get(0);
        }
        return null;
    }

    @Override
    public ProposalDevelopmentBudgetExt getSyncableBudget(DevelopmentProposal childProposal) throws ProposalHierarchyException {
        if (childProposal.getFinalBudget() == null) {
            return childProposal.getLatestBudget();
        }
        return childProposal.getFinalBudget();
    }

    protected int getCorrespondingParentPeriod(List<BudgetPeriod> oldBudgetPeriods, Budget childBudget) {
        int correspondingStart = -1;
        Date childStart = childBudget.getBudgetPeriod(0).getStartDate();
        Date parentStart = oldBudgetPeriods.get(0).getStartDate();
        Date parentEnd = oldBudgetPeriods.get(oldBudgetPeriods.size() - 1).getEndDate();
        if (childStart.compareTo(parentStart) >= 0 && childStart.compareTo(parentEnd) < 0) {
            for (int i = 0; i < oldBudgetPeriods.size(); ++i) {
                if (!childStart.equals(oldBudgetPeriods.get(i).getStartDate())) continue;
                correspondingStart = i;
                break;
            }
        }
        return correspondingStart;
    }

    @Override
    public int computeHierarchyHashCode(Budget budget) {
        int prime = 31;
        int result = 1;
        this.budgetCalculationService.calculateBudget(budget);
        this.budgetCalculationService.calculateBudgetSummaryTotals(budget);
        result = prime * result + budget.getBudgetSummaryTotals().hashCode();
        return result;
    }

    @Override
    public List<ProposalDevelopmentBudgetExt> getHierarchyBudgets(DevelopmentProposal hierarchyProposal) throws ProposalHierarchyException {
        return hierarchyProposal.getProposalDocument().getDevelopmentProposal().getBudgets().stream().collect(Collectors.toList());
    }

    protected KcDataObject deepCopy(KcDataObject oldObject) {
        return (KcDataObject)this.getDataObjectService().copyInstance((Object)oldObject, new CopyOption[]{CopyOption.RESET_OBJECT_ID, CopyOption.RESET_PK_FIELDS, CopyOption.RESET_VERSION_NUMBER});
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    public ProposalBudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(ProposalBudgetService budgetService) {
        this.budgetService = budgetService;
    }
}

