/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.krms;

import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.rice.krms.api.engine.Facts;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentFactBuilderService")
public class ProposalDevelopmentFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private static final String COMPLETE = "C";

    @Override
    public void addFacts(Facts.Builder factsBuilder, KrmsRulesContext document) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        this.addBudgetFacts(factsBuilder, proposalDevelopmentDocument);
        this.addProposalFacts(factsBuilder, developmentProposal);
        factsBuilder.addFact("moduleCode", (Object)"3");
        factsBuilder.addFact("moduleItemKey", (Object)developmentProposal.getProposalNumber());
        factsBuilder.addFact("moduleSubItemKey", (Object)0);
    }

    private void addBudgetFacts(Facts.Builder factsBuilder, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ProposalDevelopmentBudgetExt budget = proposalDevelopmentDocument.getDevelopmentProposal().getFinalBudget();
        this.addObjectMembersAsFacts(factsBuilder, budget, "KC-PD-CONTEXT", "KC-PD");
    }

    private void addProposalFacts(Facts.Builder factsBuilder, DevelopmentProposal developmentProposal) {
        this.addObjectMembersAsFacts(factsBuilder, developmentProposal, "KC-PD-CONTEXT", "KC-PD");
        factsBuilder.addFact("DevelopmentProposal", (Object)developmentProposal);
        factsBuilder.addFact("proposalNarrativesComplete", (Object)this.isProposalNarrativesComplete(developmentProposal));
    }

    protected boolean isProposalNarrativesComplete(DevelopmentProposal developmentProposal) {
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (narrative.getNarrativeStatus() == null || COMPLETE.equals(narrative.getNarrativeStatus().getCode())) continue;
            return false;
        }
        return true;
    }
}

