/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.document;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.impl.document.IndexDocumentsForm;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.sys.framework.controller.BackLocationAction;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.web.struts.action.KualiAction;

public class IndexDocumentsAction
extends KualiAction
implements BackLocationAction {
    private static final String PERMISSION_USE_DOCUMENT_INDEX_FOR_SP = "Use Document Index";
    private transient GlobalVariableService globalVariableService;
    private transient PermissionService permissionService;
    private transient ElasticsearchIndexService elasticsearchIndexService;
    private transient ConfigurationService configurationService;
    private transient KewDocHeaderDao kewDocHeaderDao;

    public ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isNotAuthorized()) {
            throw new UnauthorizedAccessException("Unauthorized to index documents.");
        }
        if (this.isElasticsearchDisabled()) {
            this.getGlobalVariableService().getMessageMap().putError("indexableDocs", "error.elasticsearch.disabled", new String[0]);
            return mapping.findForward("basic");
        }
        return mapping.findForward("basic");
    }

    public ActionForward index(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isNotAuthorized()) {
            throw new UnauthorizedAccessException("Unauthorized to index documents.");
        }
        if (this.isElasticsearchDisabled()) {
            this.getGlobalVariableService().getMessageMap().putError("indexableDocs", "error.elasticsearch.disabled", new String[0]);
            return mapping.findForward("basic");
        }
        IndexDocumentsForm indexDocumentsForm = (IndexDocumentsForm)form;
        List<IndexDocumentsForm.Document> docs = indexDocumentsForm.getIndexableDocs();
        if (CollectionUtils.isEmpty(docs)) {
            this.getGlobalVariableService().getMessageMap().putError("indexableDocs", "error.document.missing.index", new String[0]);
            return mapping.findForward("basic");
        }
        boolean hasDocs = false;
        for (int i = 0; i < docs.size(); ++i) {
            IndexDocumentsForm.Document doc = docs.get(i);
            if (doc == null || !StringUtils.isNotBlank((CharSequence)doc.getDocumentNumber())) continue;
            String docNumber = doc.getDocumentNumber();
            hasDocs = true;
            if (this.getElasticsearchIndexService().index(docNumber, this.getKewDocHeaderDao().getAllNonActiveDocumentIds(docNumber)).get().booleanValue()) continue;
            this.getGlobalVariableService().getMessageMap().putError("indexableDocs[" + i + "].doc", "error.document.index", new String[]{docNumber});
        }
        if (!hasDocs) {
            this.getGlobalVariableService().getMessageMap().putError("indexableDocs", "error.document.missing.index", new String[0]);
            return mapping.findForward("basic");
        }
        return mapping.findForward("basic");
    }

    private boolean isNotAuthorized() {
        String principalId = this.getGlobalVariableService().getUserSession().getPrincipalId();
        return !this.getPermissionService().hasPermission(principalId, "KC-SYS", PERMISSION_USE_DOCUMENT_INDEX_FOR_SP);
    }

    private boolean isElasticsearchDisabled() {
        return !this.getConfigurationService().getPropertyValueAsBoolean("elasticsearch.enabled");
    }

    private GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    private PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    private ElasticsearchIndexService getElasticsearchIndexService() {
        if (this.elasticsearchIndexService == null) {
            this.elasticsearchIndexService = KcServiceLocator.getService(ElasticsearchIndexService.class);
        }
        return this.elasticsearchIndexService;
    }

    private ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    private KewDocHeaderDao getKewDocHeaderDao() {
        if (this.kewDocHeaderDao == null) {
            this.kewDocHeaderDao = KcServiceLocator.getService(KewDocHeaderDao.class);
        }
        return this.kewDocHeaderDao;
    }
}

