/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.api.person.ProposalPersonUnitContract;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplitable;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalUnitCreditSplit;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="EPS_PROP_PERSON_UNITS")
@IdClass(value=ProposalPersonUnitId.class)
public class ProposalPersonUnit
extends KcPersistableBusinessObjectBase
implements CreditSplitable,
ProposalPersonUnitContract {
    @Id
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER"), @JoinColumn(name="PROP_PERSON_NUMBER", referencedColumnName="PROP_PERSON_NUMBER")})
    private ProposalPerson proposalPerson;
    @Id
    @Column(name="UNIT_NUMBER")
    private String unitNumber;
    @Column(name="LEAD_UNIT_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private boolean leadUnit;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="UNIT_NUMBER", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit unit;
    @OneToMany(mappedBy="proposalPersonUnit", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ProposalUnitCreditSplit> creditSplits = new ArrayList<ProposalUnitCreditSplit>();
    @Transient
    private boolean delete;

    public List<ProposalUnitCreditSplit> getCreditSplits() {
        return this.creditSplits;
    }

    public void setCreditSplits(List<ProposalUnitCreditSplit> argCreditSplits) {
        this.creditSplits = argCreditSplits;
    }

    public final String getUnitNumber() {
        return this.unitNumber;
    }

    public final void setUnitNumber(String argUnitNumber) {
        this.unitNumber = argUnitNumber;
        if (StringUtils.isBlank((CharSequence)this.unitNumber)) {
            this.unit = null;
        } else {
            this.refreshReferenceObject("unit");
        }
    }

    public final boolean isLeadUnit() {
        return this.leadUnit;
    }

    public final void setLeadUnit(boolean argLeadUnit) {
        this.leadUnit = argLeadUnit;
    }

    public final Unit getUnit() {
        return this.unit;
    }

    public final void setUnit(Unit u) {
        this.unit = u;
    }

    public ProposalUnitCreditSplit getCreditSplit(int index) {
        while (this.getCreditSplits().size() <= index) {
            this.getCreditSplits().add(new ProposalUnitCreditSplit());
        }
        return this.getCreditSplits().get(index);
    }

    public String getName() {
        return this.getUnitNumber();
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public String getProposalNumber() {
        return this.getProposalPerson().getDevelopmentProposal().getProposalNumber();
    }

    public Integer getProposalPersonNumber() {
        return this.getProposalPerson().getProposalPersonNumber();
    }

    public ProposalPerson getProposalPerson() {
        return this.proposalPerson;
    }

    public void setProposalPerson(ProposalPerson proposalPerson) {
        this.proposalPerson = proposalPerson;
    }

    public static final class ProposalPersonUnitId
    implements Serializable,
    Comparable<ProposalPersonUnitId> {
        private ProposalPerson.ProposalPersonId proposalPerson;
        private String unitNumber;

        public ProposalPerson.ProposalPersonId getProposalPerson() {
            return this.proposalPerson;
        }

        public void setProposalPerson(ProposalPerson.ProposalPersonId proposalPerson) {
            this.proposalPerson = proposalPerson;
        }

        public String getUnitNumber() {
            return this.unitNumber;
        }

        public void setUnitNumber(String unitNumber) {
            this.unitNumber = unitNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("proposalPerson", (Object)this.proposalPerson).append("unitNumber", (Object)this.unitNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalPersonUnitId rhs = (ProposalPersonUnitId)other;
            return new EqualsBuilder().append((Object)this.proposalPerson, (Object)rhs.proposalPerson).append((Object)this.unitNumber, (Object)rhs.unitNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.proposalPerson).append((Object)this.unitNumber).toHashCode();
        }

        @Override
        public int compareTo(ProposalPersonUnitId other) {
            return new CompareToBuilder().append((Object)this.proposalPerson, (Object)other.proposalPerson).append((Object)this.unitNumber, (Object)other.unitNumber).toComparison();
        }
    }
}

