/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.award.api.AwardPostResult;
import org.kuali.coeus.award.finance.AwardAccount;
import org.kuali.coeus.award.finance.AwardPosts;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.impl.version.SequenceUtils;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardFinanceIntegrationService;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.infrastructure.AwardRoleConstants;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.award.notification.AwardNotification;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.excon.project.service.ExconProjectAssociatedInfoBean;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.QueryPagingRequest;

public class AwardServiceImpl
implements AwardService {
    private static final Logger LOG = LogManager.getLogger(AwardServiceImpl.class);
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String AWARD_ID = "awardId";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    public static final String SEQUENCE_OWNER_VERSION_NAME_VALUE = "sequenceOwnerVersionNameValue";
    public static final String AWARD_SEQUENCE_STATUS = "awardSequenceStatus";
    public static final String DOCUMENT_NUMBER = "documentNumber";
    private BusinessObjectService businessObjectService;
    private VersioningService versioningService;
    private DocumentService documentService;
    private VersionHistoryService versionHistoryService;
    private AwardDao awardDao;
    private SponsorHierarchyService sponsorHierarchyService;
    private AwardNumberService awardNumberService;
    private AwardFinanceIntegrationService awardFinanceIntegrationService;
    private AwardHierarchyService awardHierarchyService;
    private AwardVersionService awardVersionService;
    private ParameterService parameterService;
    private DataObjectService dataObjectService;

    @Override
    public List<Award> findAwardsForAwardNumber(String awardNumber) {
        return new ArrayList<Award>(this.businessObjectService.findMatchingOrderBy(Award.class, Collections.singletonMap(AWARD_NUMBER, awardNumber), SEQUENCE_NUMBER, true));
    }

    @Override
    public void createInitialAwardUsers(Award award) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KcAuthorizationService kraAuthService = KcServiceLocator.getService(KcAuthorizationService.class);
        SystemAuthorizationService systemAuthorizationService = KcServiceLocator.getService(SystemAuthorizationService.class);
        if (!systemAuthorizationService.hasRole(userId, award.getNamespace(), AwardRoleConstants.AWARD_MODIFIER.getAwardRole())) {
            kraAuthService.addDocumentLevelRole(userId, AwardRoleConstants.AWARD_MODIFIER.getAwardRole(), award);
        }
    }

    protected void setTotalsOnAward(Award award) {
        AwardAmountInfo aai = award.getLastAwardAmountInfo();
        if (aai == null) {
            return;
        }
        ScaleTwoDecimal obligatedDirectTotal = aai.getObligatedTotalDirect() != null ? aai.getObligatedTotalDirect() : ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal obligatedIndirectTotal = aai.getObligatedTotalIndirect() != null ? aai.getObligatedTotalIndirect() : ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal anticipatedDirectTotal = aai.getAnticipatedTotalDirect() != null ? aai.getAnticipatedTotalDirect() : ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal anticipatedIndirectTotal = aai.getAnticipatedTotalIndirect() != null ? aai.getAnticipatedTotalIndirect() : ScaleTwoDecimal.ZERO;
        aai.setAmountObligatedToDate((ScaleTwoDecimal)obligatedDirectTotal.add((AbstractDecimal)obligatedIndirectTotal));
        aai.setAnticipatedTotalAmount((ScaleTwoDecimal)anticipatedDirectTotal.add((AbstractDecimal)anticipatedIndirectTotal));
    }

    protected Award getActiveAwardVersion(Award award) {
        return this.awardVersionService.getActiveAwardVersion(award.getAwardNumber());
    }

    public boolean isDirectIndirectViewEnabled() {
        boolean returnValue = false;
        String directIndirectEnabledValue = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        if (directIndirectEnabledValue.equals("1")) {
            returnValue = true;
        }
        return returnValue;
    }

    protected AwardAmountInfo getPreviousAwardAmountInfo(Award award) {
        int awardAmountInfosSize = award.getAwardAmountInfos().size();
        if (awardAmountInfosSize > 1) {
            int previousAwardAmountInfoIndex = awardAmountInfosSize - 2;
            return award.getAwardAmountInfos().get(previousAwardAmountInfoIndex);
        }
        Award oldAward = this.getActiveAwardVersion(award);
        return oldAward != null ? oldAward.getLastAwardAmountInfo() : null;
    }

    @Override
    public void updateCurrentAwardAmountInfo(Award award) {
        if (award.getAwardNumber().endsWith("000000-00000") || award.getAwardNumber().endsWith("-00001")) {
            AwardAmountInfo currentAwardAmountInfo = award.getLastAwardAmountInfo();
            AwardAmountInfo previousAwardAmountInfo = this.getPreviousAwardAmountInfo(award);
            if (this.isDirectIndirectViewEnabled()) {
                this.setTotalsOnAward(award);
            }
            if (previousAwardAmountInfo != null) {
                currentAwardAmountInfo.setObligatedChange((ScaleTwoDecimal)currentAwardAmountInfo.getAmountObligatedToDate().subtract((AbstractDecimal)previousAwardAmountInfo.getAmountObligatedToDate()));
                currentAwardAmountInfo.setObligatedChangeDirect((ScaleTwoDecimal)currentAwardAmountInfo.getObligatedTotalDirect().subtract((AbstractDecimal)previousAwardAmountInfo.getObligatedTotalDirect()));
                currentAwardAmountInfo.setObligatedChangeIndirect((ScaleTwoDecimal)currentAwardAmountInfo.getObligatedTotalIndirect().subtract((AbstractDecimal)previousAwardAmountInfo.getObligatedTotalIndirect()));
                currentAwardAmountInfo.setAnticipatedChange((ScaleTwoDecimal)currentAwardAmountInfo.getAnticipatedTotalAmount().subtract((AbstractDecimal)previousAwardAmountInfo.getAnticipatedTotalAmount()));
                currentAwardAmountInfo.setAnticipatedChangeDirect((ScaleTwoDecimal)currentAwardAmountInfo.getAnticipatedTotalDirect().subtract((AbstractDecimal)previousAwardAmountInfo.getAnticipatedTotalDirect()));
                currentAwardAmountInfo.setAnticipatedChangeIndirect((ScaleTwoDecimal)currentAwardAmountInfo.getAnticipatedTotalIndirect().subtract((AbstractDecimal)previousAwardAmountInfo.getAnticipatedTotalIndirect()));
                currentAwardAmountInfo.setObliDistributableAmount((ScaleTwoDecimal)previousAwardAmountInfo.getObliDistributableAmount().add((AbstractDecimal)currentAwardAmountInfo.getObligatedChange()));
                currentAwardAmountInfo.setAntDistributableAmount((ScaleTwoDecimal)previousAwardAmountInfo.getAntDistributableAmount().add((AbstractDecimal)currentAwardAmountInfo.getAnticipatedChange()));
            } else {
                currentAwardAmountInfo.setObligatedChange(currentAwardAmountInfo.getAmountObligatedToDate());
                currentAwardAmountInfo.setObligatedChangeDirect(currentAwardAmountInfo.getObligatedTotalDirect());
                currentAwardAmountInfo.setObligatedChangeIndirect(currentAwardAmountInfo.getObligatedTotalIndirect());
                currentAwardAmountInfo.setAnticipatedChange(currentAwardAmountInfo.getAnticipatedTotalAmount());
                currentAwardAmountInfo.setAnticipatedChangeDirect(currentAwardAmountInfo.getAnticipatedTotalDirect());
                currentAwardAmountInfo.setAnticipatedChangeIndirect(currentAwardAmountInfo.getAnticipatedTotalIndirect());
                currentAwardAmountInfo.setObliDistributableAmount(currentAwardAmountInfo.getAmountObligatedToDate());
                currentAwardAmountInfo.setAntDistributableAmount(currentAwardAmountInfo.getAnticipatedTotalAmount());
            }
        }
    }

    @Override
    public Award getAward(Long awardId) {
        return awardId != null ? (Award)this.businessObjectService.findByPrimaryKey(Award.class, Collections.singletonMap(AWARD_ID, awardId)) : null;
    }

    @Override
    public Award getAward(String awardId) {
        return awardId != null ? (Award)this.businessObjectService.findByPrimaryKey(Award.class, Collections.singletonMap(AWARD_ID, awardId)) : null;
    }

    @Override
    public AwardDocument createNewAwardVersion(AwardDocument awardDocument) throws VersionException, WorkflowException {
        Award newVersion = this.getVersioningService().createNewVersion(awardDocument.getAward());
        newVersion.setCurrentVersionBudgets(new ArrayList<AwardBudgetExt>());
        return this.generateAndPopulateAwardDocument(awardDocument, newVersion);
    }

    @Override
    public void checkAwardNumber(Award award) {
        if ("000000-00000".equals(award.getAwardNumber())) {
            AwardNumberService awardNumberService = this.getAwardNumberService();
            String awardNumber = awardNumberService.getNextAwardNumber();
            award.setAwardNumber(awardNumber);
        }
        if ("000000-00000".equals(award.getAwardAmountInfos().get(0).getAwardNumber())) {
            award.getAwardAmountInfos().get(0).setAwardNumber(award.getAwardNumber());
        }
        award.getAwardApprovedSubawards().stream().filter(approvedSubaward -> "000000-00000".equals(approvedSubaward.getAwardNumber())).forEach(approvedSubaward -> approvedSubaward.setAwardNumber(award.getAwardNumber()));
        if (award.isPersisted()) {
            for (AwardComment comment : award.getAwardComments()) {
                comment.setAward(award);
            }
            for (AwardCustomData customData : award.getAwardCustomDataList()) {
                customData.setAward(award);
            }
        }
    }

    @Override
    public AwardDocument generateAndPopulateAwardDocument(AwardDocument oldAwardDocument, Award newVersion) throws WorkflowException {
        this.fixAttachments(oldAwardDocument, newVersion);
        this.incrementVersionNumberIfCanceledVersionsExist(newVersion);
        newVersion.getFundingProposals().clear();
        AwardDocument newAwardDocument = (AwardDocument)this.getDocumentService().getNewDocument(AwardDocument.class);
        newAwardDocument.getDocumentHeader().setDocumentDescription(oldAwardDocument.getDocumentHeader().getDocumentDescription());
        newAwardDocument.setAward(newVersion);
        newAwardDocument.setDocumentNextvalues(oldAwardDocument.getDocumentNextvalues());
        newAwardDocument.getDocumentNextvalues().forEach(nextValue -> nextValue.setDocumentKey(newAwardDocument.getDocumentNumber()));
        newVersion.setAwardDocument(newAwardDocument);
        newVersion.setAwardTransactionTypeCode(0);
        newVersion.getSyncChanges().clear();
        newVersion.getSyncStatuses().clear();
        newVersion.setSyncChild(false);
        newVersion.setAwardAmountInfos(this.minimizeAwardAmountInfoCollection(newVersion.getAwardAmountInfos()));
        newVersion.getAwardAmountInfos().get(0).setOriginatingAwardVersion(newVersion.getSequenceNumber());
        newVersion.getAwardAmountInfos().get(0).setTimeAndMoneyDocumentNumber(null);
        new SequenceUtils().sequenceAssociations(newVersion);
        this.synchNewCustomAttributes(newVersion, oldAwardDocument.getAward());
        return newAwardDocument;
    }

    public void fixAttachments(AwardDocument awardDocument, Award newVersion) {
        for (AwardAttachment attach : newVersion.getAwardAttachments()) {
            AwardAttachment orignalAttachment = this.findMatchingAwardAttachment(awardDocument.getAward().getAwardAttachments(), attach.getFileId());
            attach.setUpdateUser(orignalAttachment.getUpdateUser());
            attach.setUpdateTimestamp(orignalAttachment.getUpdateTimestamp());
            attach.setUpdateUserSet(true);
        }
    }

    @Override
    public void synchNewCustomAttributes(Award newAward, Award oldAward) {
        HashSet<Integer> availableCustomAttributes = new HashSet<Integer>();
        for (AwardCustomData awardCustomData : newAward.getAwardCustomDataList()) {
            availableCustomAttributes.add(awardCustomData.getCustomAttributeId().intValue());
        }
        if (oldAward.getAwardDocument() != null) {
            Map<String, CustomAttributeDocument> customAttributeDocuments = oldAward.getAwardDocument().getCustomAttributeDocuments();
            for (Map.Entry<String, CustomAttributeDocument> entry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = entry.getValue();
                if (availableCustomAttributes.contains(customAttributeDocument.getId().intValue()) || !customAttributeDocument.isCopyToNewDoc()) continue;
                AwardCustomData awardCustomData = new AwardCustomData();
                awardCustomData.setCustomAttributeId(customAttributeDocument.getId());
                awardCustomData.setCustomAttribute(customAttributeDocument.getCustomAttribute());
                CustomDataUtils.resetValueToDefault(awardCustomData);
                awardCustomData.setAward(newAward);
                newAward.getAwardCustomDataList().add(awardCustomData);
            }
            newAward.getAwardCustomDataList().removeAll(this.getInactiveCustomDataList(newAward.getAwardCustomDataList(), customAttributeDocuments));
        }
    }

    private List<AwardCustomData> getInactiveCustomDataList(List<AwardCustomData> awardCustomDataList, Map<String, CustomAttributeDocument> customAttributeDocuments) {
        ArrayList<AwardCustomData> inactiveCustomDataList = new ArrayList<AwardCustomData>();
        for (AwardCustomData awardCustomData : awardCustomDataList) {
            CustomAttributeDocument customAttributeDocument = customAttributeDocuments.get(awardCustomData.getCustomAttributeId().toString());
            if (customAttributeDocument != null && customAttributeDocument.isActive()) continue;
            inactiveCustomDataList.add(awardCustomData);
        }
        return inactiveCustomDataList;
    }

    private AwardAttachment findMatchingAwardAttachment(List<AwardAttachment> originalAwardList, String currentFileId) throws VersionException {
        for (AwardAttachment attach : originalAwardList) {
            if (!attach.getFileId().equals(currentFileId)) continue;
            return attach;
        }
        throw new VersionException("Unable to find matching attachment.");
    }

    protected void incrementVersionNumberIfCanceledVersionsExist(Award award) {
        List versionHistory = this.businessObjectService.findMatchingOrderBy(VersionHistory.class, this.getHashMap(award.getAwardNumber()), "sequenceOwnerSequenceNumber", false);
        Integer nextVersion = versionHistory.isEmpty() ? 1 : ((VersionHistory)versionHistory.get(0)).getSequenceOwnerSequenceNumber() + 1;
        award.setSequenceNumber(nextVersion);
    }

    protected Map<String, String> getHashMap(String awardNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SEQUENCE_OWNER_VERSION_NAME_VALUE, awardNumber);
        return map;
    }

    protected List<AwardAmountInfo> minimizeAwardAmountInfoCollection(List<AwardAmountInfo> awardAmountInfos) {
        ArrayList<AwardAmountInfo> returnList = new ArrayList<AwardAmountInfo>();
        returnList.add(awardAmountInfos.get(awardAmountInfos.size() - 1));
        return returnList;
    }

    protected VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    @Override
    public void updateAwardSequenceStatus(Award award, VersionStatus status) {
        if (status.equals((Object)VersionStatus.ACTIVE)) {
            this.archiveCurrentActiveAward(award.getAwardNumber());
        }
        award.setAwardSequenceStatus(status.toString());
        if (award.getAwardDocument() != null) {
            this.businessObjectService.save((PersistableBusinessObject)award);
        }
    }

    protected void archiveCurrentActiveAward(String awardNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AWARD_NUMBER, awardNumber);
        values.put(AWARD_SEQUENCE_STATUS, VersionStatus.ACTIVE.name());
        List awards = this.businessObjectService.findMatching(Award.class, values);
        for (Award award : awards) {
            award.setAwardSequenceStatus(VersionStatus.ARCHIVED.name());
            award.setAllowUpdateFieldsToBeReset(false);
            this.businessObjectService.save((PersistableBusinessObject)award);
        }
    }

    @Override
    public String getRootAwardNumber(String awardNumber) {
        return awardNumber.substring(0, 6) + "-00001";
    }

    @Override
    public Award getActiveOrNewestAward(String awardNumber) {
        List<VersionHistory> versions = this.getVersionHistoryService().loadVersionHistory(Award.class, awardNumber);
        VersionHistory newest = null;
        for (VersionHistory version : versions) {
            if (version.getStatus() == VersionStatus.ACTIVE) {
                newest = version;
                continue;
            }
            if (newest != null && (version.getStatus() == VersionStatus.CANCELED || version.getSequenceOwnerSequenceNumber() <= newest.getSequenceOwnerSequenceNumber())) continue;
            newest = version;
        }
        if (newest != null) {
            return (Award)newest.getSequenceOwner();
        }
        return null;
    }

    @Override
    public Award getAwardAssociatedWithDocument(String docNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(DOCUMENT_NUMBER, docNumber);
        List awards = this.businessObjectService.findMatching(Award.class, values);
        return (Award)awards.get(0);
    }

    @Override
    public Boolean isCreditSplitOptInEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-PD", "All", "ENABLE_OPT_IN_PERSONNEL_CREDIT_SPLIT_FUNCTIONALITY");
    }

    @Override
    public Boolean generateCreditSplitForPerson(AwardPerson person) {
        boolean optIn = this.isCreditSplitOptInEnabled();
        return !optIn || person.getIncludeInCreditAllocation() != false;
    }

    @Override
    public List<AwardPerson> getPersonsSelectedForCreditSplit(List<AwardPerson> projectPersons) {
        return projectPersons.stream().filter(this::generateCreditSplitForPerson).collect(Collectors.toList());
    }

    @Override
    public AwardPosts createPostEntry(Long awardId, String accountNumber, String awardNumber, String documentNumber, boolean posted) {
        AwardPosts awardPosts = this.cPostEntry(awardId, accountNumber, awardNumber, documentNumber, posted);
        return (AwardPosts)this.dataObjectService.save((Object)awardPosts, new PersistenceOption[0]);
    }

    private AwardPosts cPostEntry(Long awardId, String accountNumber, String awardNumber, String documentNumber, boolean posted) {
        AwardPosts awardPosts = new AwardPosts();
        awardPosts.setAwardId(awardId);
        awardPosts.setAccountNumber(accountNumber);
        awardPosts.setDocumentNumber(documentNumber);
        awardPosts.setPosted(posted);
        String awardFamily = AwardService.getAwardFamily(awardNumber);
        awardPosts.setAwardFamily(awardFamily);
        return awardPosts;
    }

    @Override
    public AwardPosts addPostEntry(Award award, String docNumber, String docStatus, boolean posted) {
        AwardPosts awardPosts = this.cPostEntry(award.getAwardId(), award.getAccountNumber(), award.getAwardNumber(), docNumber, posted);
        if (StringUtils.isNotBlank((CharSequence)award.getAccountNumber())) {
            if (this.canAddAwardAccount(award)) {
                this.addAccountInformation(award.getAwardId(), award.getAccountNumber());
            }
            if (this.isAwardPostAccountCreateEnabled()) {
                this.transmitAwardAccountPost(award, docNumber, docStatus, awardPosts);
            }
        }
        return (AwardPosts)this.dataObjectService.save((Object)awardPosts, new PersistenceOption[0]);
    }

    protected boolean canAddAwardAccount(Award award) {
        boolean canAddAccount = !this.awardFinanceIntegrationService.accountPostIsQueued(award.getAccountNumber(), award.getAwardNumber());
        return canAddAccount &= !this.awardFinanceIntegrationService.awardAccountExists(award.getAccountNumber());
    }

    @Override
    public void addAccountInformation(Long awardId, String accountNumber) {
        AwardAccount awardAccount = new AwardAccount();
        awardAccount.setCreatedByAwardId(awardId);
        awardAccount.setAccountNumber(accountNumber);
        this.dataObjectService.save((Object)awardAccount, new PersistenceOption[0]);
    }

    @Override
    public String transmitAwardAccountPost(Award award, String docNumber, String docStatus, AwardPosts post) {
        AwardPostResult postResult = this.awardFinanceIntegrationService.transmitAwardAccountPost(award, docNumber, docStatus);
        post.setPostStatus(postResult.getProcessStatus());
        post.setPostDetails(postResult.getStatusDetails());
        return post.getPostStatus();
    }

    @Override
    public String getAwardNumber(Long awardId) {
        return this.awardDao.getAwardNumber(awardId);
    }

    @Override
    public Collection<Award> retrieveAwardsByCriteria(Map<String, Object> fieldValues) {
        return this.getAwardDao().retrieveAwardsByCriteria(fieldValues);
    }

    @Override
    public ExconProjectAssociatedInfoBean.SyncAction createOrUpdateSpecialReview(String documentNumber, String referenceId, String specialReviewTypeCode, String approvalTypeCode, java.util.Date applicationDate, java.util.Date expirationDate, String protocolStatus) {
        AwardDocument document = (AwardDocument)this.businessObjectService.findBySinglePrimaryKey(AwardDocument.class, (Object)documentNumber);
        if (document != null) {
            ExconProjectAssociatedInfoBean.SyncAction syncAction;
            AwardSpecialReview toUpdate;
            Award award = document.getAward();
            Optional<AwardSpecialReview> sr = this.findSpecialReview(award, referenceId, specialReviewTypeCode);
            if (sr.isPresent()) {
                toUpdate = sr.get();
                syncAction = ExconProjectAssociatedInfoBean.SyncAction.UPDATE;
            } else {
                toUpdate = new AwardSpecialReview();
                toUpdate.setSpecialReviewNumber(award.getAwardDocument().getDocumentNextValue("SPECIAL_REVIEW_NUMBER"));
                toUpdate.setSpecialReviewTypeCode(specialReviewTypeCode);
                toUpdate.setAwardId(award.getAwardId());
                toUpdate.setApprovalTypeCode(approvalTypeCode);
                toUpdate.setProtocolNumber(referenceId);
                award.getSpecialReviews().add(toUpdate);
                syncAction = ExconProjectAssociatedInfoBean.SyncAction.CREATE;
            }
            toUpdate.setProtocolStatus(protocolStatus);
            if (applicationDate != null) {
                toUpdate.setApplicationDate(new Date(applicationDate.getTime()));
            }
            if (expirationDate != null) {
                toUpdate.setExpirationDate(new Date(expirationDate.getTime()));
            }
            this.businessObjectService.save((PersistableBusinessObject)award);
            return syncAction;
        }
        return ExconProjectAssociatedInfoBean.SyncAction.NOOP;
    }

    @Override
    public ExconProjectAssociatedInfoBean.SyncAction deleteSpecialReview(String documentNumber, String referenceId, String specialReviewTypeCode) {
        return Optional.ofNullable((AwardDocument)this.businessObjectService.findBySinglePrimaryKey(AwardDocument.class, (Object)documentNumber)).map(AwardDocument::getAward).map(award -> this.findSpecialReview((Award)award, referenceId, specialReviewTypeCode)).map(sr -> {
            this.businessObjectService.delete(sr);
            return ExconProjectAssociatedInfoBean.SyncAction.DELETE;
        }).orElse(ExconProjectAssociatedInfoBean.SyncAction.NOOP);
    }

    private Optional<AwardSpecialReview> findSpecialReview(Award award, String referenceId, String specialReviewTypeCode) {
        return award.getSpecialReviews().stream().filter(sr -> referenceId.equals(sr.getProtocolNumber()) && specialReviewTypeCode.equals(sr.getSpecialReviewTypeCode())).findFirst();
    }

    public AwardDao getAwardDao() {
        return this.awardDao;
    }

    public void setAwardDao(AwardDao awardDao) {
        this.awardDao = awardDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public AwardNumberService getAwardNumberService() {
        return this.awardNumberService;
    }

    public void setAwardNumberService(AwardNumberService awardNumberService) {
        this.awardNumberService = awardNumberService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public void synchExistingCustomAttributes(Award newAward, Award oldAward) {
        ArrayList<AwardCustomData> awardCustomDataList = new ArrayList<AwardCustomData>();
        if (oldAward.getAwardDocument() != null) {
            Map<String, CustomAttributeDocument> customAttributeDocuments = oldAward.getAwardDocument().getCustomAttributeDocuments();
            for (Map.Entry<String, CustomAttributeDocument> entry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = entry.getValue();
                if (customAttributeDocument.isCopyToNewDoc() || !customAttributeDocument.getDocumentTypeName().equals("AWRD")) continue;
                for (AwardCustomData awardCustomData : newAward.getAwardCustomDataList()) {
                    if (awardCustomData.getCustomAttributeId().longValue() != customAttributeDocument.getId().longValue()) continue;
                    awardCustomDataList.add(awardCustomData);
                }
            }
        }
        LOG.info("Synchronized Existing Custom Attributes");
        newAward.getAwardCustomDataList().removeAll(awardCustomDataList);
    }

    @Override
    public Optional<Award> verifyAwardSequencing(Award award) throws WorkflowException {
        Award maxSequencedAward;
        Optional<Award> lastAwardSequence = this.getLastAwardSequence(award.getAwardNumber());
        if (lastAwardSequence.isPresent() && (maxSequencedAward = lastAwardSequence.get()).getAwardSequenceStatus().equals(VersionStatus.PENDING.name()) && maxSequencedAward.getAwardDocument().getDocumentHeader().hasWorkflowDocument() && maxSequencedAward.getAwardDocument().getDocumentHeader().getWorkflowDocument().isFinal()) {
            this.updateAwardSequenceStatus(maxSequencedAward, VersionStatus.ACTIVE);
            this.getVersionHistoryService().updateVersionHistory(maxSequencedAward, VersionStatus.ACTIVE, GlobalVariables.getUserSession().getPrincipalName());
            LOG.info("An award sequencing issue has been detected. Found an Award with the max sequence in PENDING status and a FINAL document status. Fixing it! Document Number = " + maxSequencedAward.getAwardDocument().getDocumentNumber());
            return Optional.of(maxSequencedAward);
        }
        return Optional.empty();
    }

    private Optional<Award> getLastAwardSequence(String awardNumber) throws WorkflowException {
        List awards = this.businessObjectService.findMatchingOrderBy(Award.class, Map.of(AWARD_NUMBER, awardNumber, AWARD_SEQUENCE_STATUS, List.of(VersionStatus.ACTIVE.name(), VersionStatus.ARCHIVED.name(), VersionStatus.PENDING.name())), SEQUENCE_NUMBER, false, new QueryPagingRequest(0, 0)).getResults();
        if (awards.size() > 0) {
            Award award = (Award)awards.get(0);
            award.setAwardDocument((AwardDocument)this.getDocumentService().getByDocumentHeaderId(award.getAwardDocument().getDocumentHeader().getDocumentNumber()));
            return Optional.of(award);
        }
        return Optional.empty();
    }

    @Override
    public boolean isAwardPostAccountCreateEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-AWARD", "All", "AWD_POST_ACCT_FIN_REST_INT_ENABLE");
    }

    public AwardFinanceIntegrationService getAwardFinanceIntegrationService() {
        return this.awardFinanceIntegrationService;
    }

    public void setAwardFinanceIntegrationService(AwardFinanceIntegrationService awardFinanceIntegrationService) {
        this.awardFinanceIntegrationService = awardFinanceIntegrationService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    @Override
    public Integer hierarchyLevel(Award award) {
        AwardHierarchy rootAwardHierarchy = this.getAwardHierarchyService().loadFullHierarchyFromAnyNode(award.getAwardNumber());
        Map<String, AwardHierarchy> hierarchy = this.getAwardHierarchyService().getAwardHierarchy(rootAwardHierarchy, new ArrayList<String>());
        AwardHierarchy thisNode = hierarchy.get(award.getAwardNumber());
        return this.countParents(thisNode);
    }

    private Integer countParents(AwardHierarchy awardHierarchy) {
        if (awardHierarchy == null) {
            return 0;
        }
        if (StringUtils.equals((CharSequence)awardHierarchy.getParentAwardNumber(), (CharSequence)"000000-00000")) {
            return 0;
        }
        return 1 + this.countParents(awardHierarchy.getParent());
    }

    public AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }

    @Override
    public List<AwardNotification> getAggregatedNotifications(Award award) {
        if (award == null) {
            return Collections.emptyList();
        }
        String number = award.getAwardNumber();
        if (number == null) {
            return award.getAwardNotifications();
        }
        List versions = this.getBusinessObjectService().findMatching(Award.class, Map.of(AWARD_NUMBER, number));
        List<Long> versionIds = versions.stream().map(Award::getAwardId).filter(Objects::nonNull).toList();
        ArrayList<AwardNotification> results = new ArrayList<AwardNotification>();
        for (Long id : versionIds) {
            Map<String, Long> nfCriteria = Map.of("owningDocumentIdFk", id);
            List found = this.getBusinessObjectService().findMatching(AwardNotification.class, nfCriteria);
            results.addAll(found);
        }
        results.sort(Comparator.comparing(KcNotification::getCreateTimestamp, Comparator.nullsLast(Comparator.naturalOrder())));
        return results;
    }
}

