/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.document.authorization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;

public class ExconProjectDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = -8150615104002799843L;
    private KcWorkflowService kcWorkflowService;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        String userId = user.getPrincipalId();
        ExconProjectDocument exconProjectDocument = (ExconProjectDocument)document;
        if (exconProjectDocument.getExconProject().getProjectId() == null) {
            if (this.canCreateExconProject(userId)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.hasPermission(exconProjectDocument, user, "Modify") && exconProjectDocument.isEditable() && !this.isPessimisticLocked(exconProjectDocument, user)) {
                editModes.add("fullEntry");
            } else if (this.hasPermission(exconProjectDocument, user, "View")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canCreateExconProject(userId)) {
                editModes.add("createExconProject");
            }
        }
        return editModes;
    }

    private boolean canCreateExconProject(String userId) {
        return ExconProjectDocumentAuthorizer.getPermissionService().isAuthorized(userId, "KC-EXCON", "Create Project Document", new HashMap());
    }

    public boolean canOpen(Document document, Person user) {
        ExconProjectDocument exconProjectDocument = (ExconProjectDocument)document;
        if (exconProjectDocument.getExconProject().getProjectId() == null) {
            return this.hasPermission(exconProjectDocument, user, "Create");
        }
        return this.hasPermission(exconProjectDocument, user, "Open") || this.hasPermission(exconProjectDocument, user, "View");
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return this.isWaitingApproval(document) && !this.isWaitingComplete(document);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return this.canApprove(document, user);
    }

    @Override
    public boolean canComplete(Document document) {
        return super.canComplete(document) || this.isWaitingComplete(document);
    }

    @Override
    protected boolean isFinal(Document document) {
        return "F".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    protected boolean isProcessed(Document document) {
        boolean isProcessed = false;
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        if (status.equalsIgnoreCase("P")) {
            isProcessed = true;
        }
        return isProcessed;
    }

    @Override
    protected boolean isEnroute(Document document) {
        return "R".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    protected boolean isWaitingComplete(Document document) {
        return this.isEnroute(document) && document.getDocumentHeader().getWorkflowDocument().getRequestedActions().contains(ActionRequestType.COMPLETE);
    }

    protected boolean isWaitingApproval(Document document) {
        return this.isEnroute(document) && document.getDocumentHeader().getWorkflowDocument().getRequestedActions().contains(ActionRequestType.APPROVE);
    }

    private boolean hasPermission(ExconProjectDocument exconProjectDocument, Person user, String permissionName) {
        HashMap<String, String> roleQualifiers = new HashMap<String, String>();
        roleQualifiers.put("exportControl", exconProjectDocument.getExconProject().getProjectId() != null ? exconProjectDocument.getExconProject().getProjectId().toString() : null);
        if (!StringUtils.isEmpty((CharSequence)exconProjectDocument.getExconProject().getProjectTypeCode())) {
            roleQualifiers.put("projectTypeCode", exconProjectDocument.getExconProject().getProjectTypeCode());
        }
        return this.isAuthorized((BusinessObject)exconProjectDocument, "KC-EXCON", permissionName + " Project Document", user.getPrincipalId(), null, roleQualifiers);
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateExconProject(user.getPrincipalId());
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        ExconProjectDocument exconDoc = (ExconProjectDocument)document;
        return this.hasPermission(exconDoc, user, "Modify") && !this.isPessimisticLocked(exconDoc, user) && !exconDoc.isViewOnly() && !this.getKcWorkflowService().isInWorkflow(exconDoc);
    }

    protected boolean isPessimisticLocked(ExconProjectDocument document, Person user) {
        return document.getPessimisticLocks().stream().anyMatch(lock -> !lock.isOwnedByUser(user));
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }

    public KcWorkflowService getKcWorkflowService() {
        if (this.kcWorkflowService == null) {
            this.kcWorkflowService = KcServiceLocator.getService(KcWorkflowService.class);
        }
        return this.kcWorkflowService;
    }
}

