/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.web.struts.action;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardCloseout;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardFfataReporting;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.kra.subaward.web.struts.action.SubAwardAction;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardHomeAction
extends SubAwardAction {
    private static final String SUBAWARD_VERSION_EDITPENDING_PROMPT_KEY = "message.subaward.version.editpending.prompt";
    private static final String PENDING = "PENDING";
    private static final String SUB_AWARD_AMOUNT_INFO = "subAwardAmountInfo";
    private GlobalVariableService globalVariableService;

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        SubAwardForm subAwardMultiLookupForm = (SubAwardForm)form;
        String lookupResultsBOClassName = request.getParameter("lookupResultsBOClassName");
        String lookupResultsSequenceNumber = request.getParameter("lookupResultsSequenceNumber");
        subAwardMultiLookupForm.setLookupResultsBOClassName(lookupResultsBOClassName);
        subAwardMultiLookupForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        subAwardMultiLookupForm.getSubAwardDocument().getSubAward();
        return mapping.findForward("basic");
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        SubAward subaward = subAwardDocument.getSubAward();
        if (subaward.getVersionHistory().getStatusForOjb().equals(PENDING)) {
            response.sendRedirect(this.buildForwardUrl(subAwardForm.getDocId()));
            return null;
        }
        VersionHistory foundPending = this.findPendingVersion(subaward);
        if (foundPending != null) {
            String question = request.getParameter("buttonClicked");
            forward = question == null ? this.showPromptForEditingPendingVersion(mapping, form, request, response) : this.processPromptForEditingPendingVersionResponse(mapping, request, response, subAwardForm, foundPending);
        } else if (this.getVersionHistoryService().isAnotherUserEditingDocument(subAwardDocument.getDocumentNumber())) {
            this.getGlobalVariableService().getMessageMap().putError("document.documentHeader.documentNumber", "message.document.version.another.user.editing", new String[]{"Subaward", this.globalVariableService.getUserSession().getPerson().getFirstName(), this.globalVariableService.getUserSession().getPerson().getLastName(), this.globalVariableService.getUserSession().getPrincipalName()});
            forward = mapping.findForward("basic");
        } else {
            if (this.getVersionHistoryService().isVersionLockOn()) {
                this.getPessimisticLockService().generateNewLock(subAwardDocument.getDocumentNumber(), this.getVersionHistoryService().getVersionLockDescriptor(subAwardDocument.getDocumentTypeCode(), subAwardDocument.getDocumentNumber()), GlobalVariables.getUserSession().getPerson());
            }
            forward = this.createAndSaveNewSubAwardVersion(response, subAwardForm, subAwardDocument, subaward);
        }
        return forward;
    }

    private VersionHistory findPendingVersion(SubAward subaward) {
        List<VersionHistory> histories = this.getVersionHistoryService().loadVersionHistory(SubAward.class, subaward.getSubAwardCode());
        VersionHistory foundPending = null;
        for (VersionHistory history : histories) {
            if (history.getStatus() != VersionStatus.PENDING || subaward.getSequenceNumber() >= history.getSequenceOwnerSequenceNumber()) continue;
            foundPending = history;
            break;
        }
        return foundPending;
    }

    private ActionForward showPromptForEditingPendingVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performQuestionWithoutInput(mapping, form, request, response, "EDIT_OR_VERSION_QUESTION_ID", this.getResources(request).getMessage(SUBAWARD_VERSION_EDITPENDING_PROMPT_KEY), "confirmationQuestion", "cancel", "");
    }

    private ActionForward processPromptForEditingPendingVersionResponse(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, SubAwardForm subAwardForm, VersionHistory foundPending) throws WorkflowException, IOException {
        ActionForward forward;
        String buttonClicked = request.getParameter("buttonClicked");
        if ("1".equals(buttonClicked)) {
            forward = mapping.findForward("subAward");
        } else {
            this.initializeFormWithSubAward(subAwardForm, (SubAward)foundPending.getSequenceOwner());
            response.sendRedirect(this.buildForwardUrl(subAwardForm.getSubAwardDocument().getDocumentNumber()));
            forward = null;
        }
        return forward;
    }

    private void initializeFormWithSubAward(SubAwardForm subAwardForm, SubAward subAward) throws WorkflowException {
        this.reinitializeSubAwardForm(subAwardForm, this.findDocumentForSubAward(subAward));
    }

    private SubAwardDocument findDocumentForSubAward(SubAward subAward) throws WorkflowException {
        SubAwardDocument document = (SubAwardDocument)this.getDocumentService().getByDocumentHeaderId(subAward.getSubAwardDocument().getDocumentNumber());
        document.setSubAward(subAward);
        return document;
    }

    private ActionForward createAndSaveNewSubAwardVersion(HttpServletResponse response, SubAwardForm subAwardForm, SubAwardDocument subAwardDocument, SubAward subAward) throws Exception {
        subAwardForm.getSubAwardDocument().getSubAward().setNewVersion(true);
        SubAwardDocument newSubAwardDocument = this.getSubAwardService().createNewSubAwardVersion(subAwardForm.getSubAwardDocument());
        this.getDocumentService().saveDocument((Document)newSubAwardDocument);
        this.getSubAwardService().updateSubAwardSequenceStatus(newSubAwardDocument.getSubAward(), VersionStatus.PENDING);
        this.getSubAwardService().updateSubAwardFfataReportingToLatestAmountInfos(subAwardForm.getSubAwardDocument().getSubAward(), newSubAwardDocument.getSubAward());
        this.getVersionHistoryService().updateVersionHistory(newSubAwardDocument.getSubAward(), VersionStatus.PENDING, GlobalVariables.getUserSession().getPrincipalName());
        this.reinitializeSubAwardForm(subAwardForm, newSubAwardDocument);
        return new ActionForward(this.buildForwardUrl(newSubAwardDocument.getDocumentNumber()), true);
    }

    private void reinitializeSubAwardForm(SubAwardForm subAwardForm, SubAwardDocument document) throws WorkflowException {
        subAwardForm.populateHeaderFields(document.getDocumentHeader().getWorkflowDocument());
        subAwardForm.setDocument(document);
        subAwardForm.initialize();
    }

    public ActionForward addFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        SubAwardFundingSource fundingSources = subAwardForm.getNewSubAwardFundingSource();
        if (new SubAwardDocumentRule().processAddSubAwardFundingSourceBusinessRules(fundingSources, subAward)) {
            this.addFundingSourceToSubAward(subAwardForm.getSubAwardDocument().getSubAward(), fundingSources);
            subAwardForm.setNewSubAwardFundingSource(new SubAwardFundingSource());
        }
        return mapping.findForward("subAward");
    }

    boolean addFundingSourceToSubAward(SubAward subAward, SubAwardFundingSource fundingSources) {
        if (subAward.getSubAwardCode() == null) {
            String subAwardCode = this.getSubAwardService().getNextSubAwardCode();
            subAward.setSubAwardCode(subAwardCode);
        }
        fundingSources.setSubAward(subAward);
        return subAward.getSubAwardFundingSourceList().add(fundingSources);
    }

    public ActionForward deleteFundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        subAwardDocument.getSubAward().getSubAwardFundingSourceList().remove(selectedLineNumber);
        return mapping.findForward("subAward");
    }

    public ActionForward addContacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAward subAward;
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardContact subAwardContact = subAwardForm.getNewSubAwardContact();
        if (new SubAwardDocumentRule().processAddSubAwardContactBusinessRules(subAwardContact, subAward = subAwardForm.getSubAwardDocument().getSubAward())) {
            this.addContactsToSubAward(subAwardForm.getSubAwardDocument().getSubAward(), subAwardContact);
            subAwardForm.setNewSubAwardContact(new SubAwardContact());
        }
        return mapping.findForward("subAward");
    }

    boolean addContactsToSubAward(SubAward subAward, SubAwardContact subAwardContact) {
        if (subAward.getSubAwardCode() == null) {
            String subAwardCode = this.getSubAwardService().getNextSubAwardCode();
            subAward.setSubAwardCode(subAwardCode);
        }
        subAwardContact.setSubAward(subAward);
        return subAward.getSubAwardContactsList().add(subAwardContact);
    }

    public ActionForward deleteContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        subAwardDocument.getSubAward().getSubAwardContactsList().remove(selectedLineNumber);
        return mapping.findForward("subAward");
    }

    public ActionForward addCloseouts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardCloseout subAwardCloseout = subAwardForm.getNewSubAwardCloseout();
        if (new SubAwardDocumentRule().processAddSubAwardCloseoutBusinessRules(subAwardCloseout)) {
            if (subAwardCloseout.getDateFollowup() == null) {
                subAwardCloseout.setDateFollowup(this.getSubAwardService().getCalculatedFollowupDate(subAwardCloseout.getDateRequested()));
            }
            this.addCloseoutToSubAward(subAwardForm.getSubAwardDocument().getSubAward(), subAwardCloseout);
            subAwardForm.setNewSubAwardCloseout(new SubAwardCloseout());
        }
        return mapping.findForward("subAward");
    }

    boolean addCloseoutToSubAward(SubAward subAward, SubAwardCloseout subAwardCloseout) {
        if (subAward.getSubAwardCode() == null) {
            String subAwardCode = this.getSubAwardService().getNextSubAwardCode();
            subAward.setSubAwardCode(subAwardCode);
        }
        subAwardCloseout.setSubAward(subAward);
        return subAward.getSubAwardCloseoutList().add(subAwardCloseout);
    }

    public ActionForward deleteCloseout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        subAwardDocument.getSubAward().getSubAwardCloseoutList().remove(selectedLineNumber);
        return mapping.findForward("subAward");
    }

    public ActionForward addFfataReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean refreshAmountInfo;
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        SubAwardFfataReporting ffataReporting = subAwardForm.getNewSubAwardFfataReporting();
        ffataReporting.setSubAwardId(subAward.getSubAwardId());
        boolean bl = refreshAmountInfo = ffataReporting.getSubAwardAmountInfoId() != null && (ffataReporting.getSubAwardAmountInfo() == null || ffataReporting.getSubAwardAmountInfo() != null && !ffataReporting.getSubAwardAmountInfoId().equals(ffataReporting.getSubAwardAmountInfo().getSubAwardAmountInfoId()));
        if (refreshAmountInfo) {
            ffataReporting.refreshReferenceObject(SUB_AWARD_AMOUNT_INFO);
        }
        if (new SubAwardDocumentRule().processAddSubAwardFfataReportingBusinessRules(ffataReporting, subAward)) {
            this.addFfataReportToSubAward(subAwardForm.getSubAwardDocument().getSubAward(), ffataReporting);
            subAwardForm.setNewSubAwardFfataReporting(new SubAwardFfataReporting());
        }
        return mapping.findForward("subAward");
    }

    private boolean addFfataReportToSubAward(SubAward subAward, SubAwardFfataReporting ffataReporting) {
        ffataReporting.populateAttachment();
        ffataReporting.setSubAwardId(subAward.getSubAwardId());
        return subAward.getSubAwardFfataReporting().add(ffataReporting);
    }

    public ActionForward deleteFfataReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        subAwardDocument.getSubAward().getSubAwardFfataReporting().remove(selectedLineNumber);
        return mapping.findForward("subAward");
    }

    public ActionForward downloadFfataReportAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KcFile report;
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        Integer index = this.getSelectedLine(request);
        if (CollectionUtils.validIndexForList(index, subAwardDocument.getSubAwardList().get(0).getSubAwardFfataReporting()) && (report = (KcFile)subAwardDocument.getSubAwardList().get(0).getSubAwardFfataReporting().get(index)) != null && report.getData() != null) {
            this.streamToResponse(report.getData(), SubAwardHomeAction.getValidHeaderString(report.getName()), SubAwardHomeAction.getValidHeaderString(report.getType()), response);
        }
        return null;
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }
}

