/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.coi.impl;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.sys.framework.controller.BackLocationAction;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class CoiProjectAction
extends KualiAction
implements BackLocationAction {
    private static final Logger LOG = LogManager.getLogger(CoiProjectAction.class);
    private static final String PUSH_MESSAGE_KEY = "info.project.push.started";
    private static final String COI_NOT_ENABLED_KEY = "error.coi.projects.not.enabled";
    private static final String NOT_QUEUED_KEY = "error.coi.project.not.queued";
    private static final String PROJECT_PUSH = "ProjectPush";
    private transient Collection<ProjectRetrievalService> retrievalServices;
    private transient ProjectPublisher projectPublisher;
    private transient GlobalVariableService globalVariableService;
    private transient ConfigurationService configurationService;

    public ActionForward publishAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, PROJECT_PUSH, "Are you sure you want to push all projects to COI", "confirmationQuestion", "cancel", "");
        }
        if (PROJECT_PUSH.equals(question)) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("0".equals(buttonClicked)) {
                if (this.getConfigurationService().getPropertyValueAsBoolean("coi.projects.enabled")) {
                    Stats stats = new Stats();
                    this.getRetrievalServices().stream().peek(s -> {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Retrieving Projects from: " + s.getClass().getName());
                        }
                    }).flatMap(s -> s.retrieveProjects().stream()).forEach(p -> this.publishProject((Project)p, stats));
                    this.getGlobalVariableService().getMessageList().add(PUSH_MESSAGE_KEY, new String[]{String.valueOf(stats.pushed), String.valueOf(stats.total)});
                } else {
                    this.getGlobalVariableService().getMessageMap().putError("GLOBAL_ERRORS", COI_NOT_ENABLED_KEY, new String[]{"messaging"});
                }
            } else {
                return this.returnToSender(request, mapping, (KualiForm)form);
            }
        }
        return mapping.findForward("basic");
    }

    private void publishProject(Project project, Stats stats) {
        try {
            ++stats.total;
            this.getProjectPublisher().publishProject(project);
            ++stats.pushed;
        }
        catch (RuntimeException e) {
            LOG.error("Error queuing project {}", (Object)project.getSourceIdentifier(), (Object)e);
            this.getGlobalVariableService().getMessageMap().putError("GLOBAL_ERRORS", NOT_QUEUED_KEY, new String[]{e.getMessage()});
        }
    }

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public Collection<ProjectRetrievalService> getRetrievalServices() {
        if (this.retrievalServices == null) {
            this.retrievalServices = KcServiceLocator.getServicesOfType(ProjectRetrievalService.class);
        }
        return this.retrievalServices;
    }

    public void setRetrievalServices(Collection<ProjectRetrievalService> retrievalServices) {
        this.retrievalServices = retrievalServices;
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    private static class Stats {
        public int total;
        public int pushed;

        private Stats() {
        }
    }
}

