/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.preproposal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalForm;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormBo;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsService;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsValueConverter;
import org.kuali.coeus.propdev.impl.preproposal.ProposalDevelopmentEvaluator;
import org.kuali.coeus.propdev.impl.preproposal.ProposalDevelopmentEvaluatorImpl;
import org.kuali.coeus.propdev.impl.preproposal.ProposalDevelopmentPreproposalFormsHelper;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sQuestionnaireHelper;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.kualibuild.KualiBuildApiService;
import org.kuali.coeus.sys.framework.kualibuild.KualiBuildException;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildActionDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildAppDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildDocumentDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildGadgetDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildInitializeWorkflowDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildSubmitDocumentRequest;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildUpdateDocumentDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildUserDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildWithdrawSubmissionDto;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="preproposalFormsService")
public class PreproposalFormsServiceImpl
implements PreproposalFormsService {
    private static final Logger LOG = LogManager.getLogger(PreproposalFormsServiceImpl.class);
    public static final String FIELD_PROPOSAL_NUMBER = "proposalNumber";
    public static final String STATUS_SAVED = "saved";
    @Autowired
    @Qualifier(value="configurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kualiBuildApiService")
    private KualiBuildApiService kualiBuildApiService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="preproposalFormsValueConverter")
    private PreproposalFormsValueConverter valueConverter;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="proposalDevelopmentS2sQuestionnaireService")
    private ProposalDevelopmentS2sQuestionnaireService proposalDevelopmentS2sQuestionnaireService;

    @Override
    public void deleteAndSavePreproposalForms(DevelopmentProposal developmentProposal, List<PreproposalForm> preproposalForms) {
        if (!this.isEnabled()) {
            return;
        }
        List<PreproposalFormBo> toDelete = developmentProposal.getPreproposalForms().stream().filter(existing -> preproposalForms.stream().noneMatch(ppf -> existing.getAppId().equals(ppf.getApp().getId()))).toList();
        developmentProposal.getPreproposalForms().removeAll(toDelete);
        toDelete.forEach(arg_0 -> ((DataObjectService)this.getDataObjectService()).delete(arg_0));
        this.getDataObjectService().flush(PreproposalFormBo.class);
        if (!preproposalForms.isEmpty()) {
            List<PreproposalFormBo> bos = preproposalForms.stream().map(ppf -> {
                PreproposalFormBo persisted;
                String wfStatus = ppf.getDocument() != null && ppf.getDocument().getMeta() != null ? ppf.getDocument().getMeta().getWorkflowStatus() : null;
                Optional<PreproposalFormBo> existing = developmentProposal.getPreproposalForms().stream().filter(ppfBo -> ppfBo.getAppId().equals(ppf.getApp().getId())).findFirst();
                if (existing.isPresent()) {
                    if (Objects.equals(existing.get().getAppName(), ppf.getApp().getName()) && Objects.equals(existing.get().getDocId(), ppf.getDocument() != null ? ppf.getDocument().getId() : null) && Objects.equals(existing.get().getDocWorkflowStatus(), wfStatus)) {
                        persisted = existing.get();
                    } else {
                        persisted = existing.get();
                        persisted.setAppName(ppf.getApp().getName());
                        persisted.setDocId(ppf.getDocument() != null ? ppf.getDocument().getId() : null);
                        persisted.setDocWorkflowStatus(wfStatus);
                        this.getDataObjectService().save((Object)persisted, new PersistenceOption[]{PersistenceOption.FLUSH});
                    }
                } else {
                    persisted = new PreproposalFormBo(developmentProposal.getProposalNumber(), ppf.getApp().getId(), ppf.getApp().getName(), ppf.getDocument() != null ? ppf.getDocument().getId() : null, wfStatus);
                    this.getDataObjectService().save((Object)persisted, new PersistenceOption[]{PersistenceOption.FLUSH});
                }
                return persisted;
            }).toList();
            developmentProposal.getPreproposalForms().clear();
            developmentProposal.getPreproposalForms().addAll(bos);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.configurationService.getPropertyValueAsBoolean("proposalDevelopment.preproposalForms.enabled");
    }

    @Override
    public ProposalDevelopmentPreproposalFormsHelper createHelper(ProposalDevelopmentDocument document, String externalUrl) {
        ProposalDevelopmentQuestionnaireHelper questionnaireHelper = new ProposalDevelopmentQuestionnaireHelper(document);
        questionnaireHelper.setQuestionnaireAnswerService(this.questionnaireAnswerService);
        questionnaireHelper.populateAnswers();
        questionnaireHelper.updateChildIndicators();
        ProposalDevelopmentS2sQuestionnaireHelper s2sQuestionnaireHelper = new ProposalDevelopmentS2sQuestionnaireHelper(document);
        s2sQuestionnaireHelper.setQuestionnaireAnswerService(this.questionnaireAnswerService);
        s2sQuestionnaireHelper.setProposalDevelopmentS2sQuestionnaireService(this.proposalDevelopmentS2sQuestionnaireService);
        s2sQuestionnaireHelper.populateAnswers();
        s2sQuestionnaireHelper.updateChildIndicators();
        List<AnswerHeader> answerHeaders = Stream.of(questionnaireHelper.getAnswerHeaders(), s2sQuestionnaireHelper.getAnswerHeaders()).flatMap(Collection::stream).filter(AnswerHeader::isActive).filter(AnswerHeader::isHasVisibleQuestion).toList();
        ProposalDevelopmentEvaluatorImpl evaluator = new ProposalDevelopmentEvaluatorImpl(document, externalUrl, answerHeaders);
        ProposalDevelopmentPreproposalFormsHelper helper = new ProposalDevelopmentPreproposalFormsHelper(document);
        helper.setEvaluator(evaluator);
        helper.setValueConverter(this.valueConverter);
        List<KualiBuildAppDto> allApps = this.getAllKualiBuildApps(document.getDevelopmentProposal().getProposalTypeCode());
        LOG.debug("{}", allApps);
        List<PreproposalForm> preproposalForms = allApps.stream().map(app -> this.loadPreproposalForms((KualiBuildAppDto)app, document)).flatMap(Collection::stream).sorted(PreproposalForm.UI_ORDER).toList();
        LOG.debug("{}", preproposalForms);
        helper.setPreproposalForms(preproposalForms);
        helper.setRelevantPreproposalForms(allApps.stream().map(app -> preproposalForms.stream().filter(pf -> pf.getApp().getId().equals(app.getId())).findFirst()).flatMap(Optional::stream).sorted(PreproposalForm.UI_ORDER).toList());
        Set usedAppIds = preproposalForms.stream().filter(PreproposalForm::isActiveOrComplete).map(PreproposalForm::getApp).map(KualiBuildAppDto::getId).collect(Collectors.toSet());
        List<KualiBuildAppDto> availableApps = allApps.stream().filter(a -> !usedAppIds.contains(a.getId())).toList();
        helper.setAvailableApps(availableApps);
        return helper;
    }

    @Override
    public List<KualiBuildAppDto> getAllKualiBuildApps(String proposalTypeCode) {
        Collection applicationIds = this.parameterService.getParameterValuesAsString("KC-PD", "Document", "proposalDevelopment.preproposalForms.applicationIds");
        return applicationIds.stream().filter(StringUtils::isNotBlank).filter(applicationId -> this.buildAppApplies((String)applicationId, proposalTypeCode)).map(this::appForId).filter(Objects::nonNull).toList();
    }

    protected boolean buildAppApplies(String applicationId, String proposalTypeCode) {
        String parameterName = "proposalDevelopment.preproposalForms.proposalTypes." + applicationId;
        boolean exists = this.getParameterService().parameterExists("KC-PD", "Document", parameterName);
        if (exists) {
            Collection proposalTypes = this.getParameterService().getParameterValuesAsString("KC-PD", "Document", parameterName);
            return proposalTypes.stream().anyMatch(pt -> {
                try {
                    Pattern p = Pattern.compile(pt);
                    Matcher m = p.matcher(proposalTypeCode);
                    return m.matches();
                }
                catch (PatternSyntaxException e) {
                    this.globalVariableService.getMessageMap().putWarning("GLOBAL_ERRORS", "warning.preproposalForms.proposalTypePattern.invalid", new String[]{parameterName, pt});
                    return false;
                }
            });
        }
        return true;
    }

    private KualiBuildAppDto appForId(String appId) {
        KualiBuildAppDto app = this.kualiBuildApiService.appForId(appId);
        if (app == null) {
            LOG.warn("No Kuali Build application found for id {}", (Object)appId);
            this.globalVariableService.getMessageMap().putWarning("GLOBAL_ERRORS", "error.preproposalForms.appNotFound", new String[]{appId, this.kualiBuildApiService.getKualiBuildUrl()});
        }
        return app;
    }

    @Override
    public String getActionUrl(String actionId) {
        return this.kualiBuildApiService.getKualiBuildUrl() + this.kualiBuildApiService.actionForId(actionId).getHandlerUrl();
    }

    @Override
    public Optional<String> preparePreproposalFormAction(String actionId) {
        String username = this.globalVariableService.getUserSession().getLoggedInUserPrincipalName();
        Optional<KualiBuildUserDto> user = this.kualiBuildApiService.userForUsername(username);
        if (user.isEmpty()) {
            this.globalVariableService.getMessageMap().putError("GLOBAL_ERRORS", "error.preproposalForms.noUser", new String[]{username});
            return Optional.empty();
        }
        KualiBuildActionDto action = this.kualiBuildApiService.addUserToAction(actionId, user.get().getId());
        return Optional.of(this.kualiBuildApiService.getKualiBuildUrl() + action.getHandlerUrl());
    }

    @Override
    public List<PreproposalForm> loadPreproposalForms(KualiBuildAppDto app, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        String username = this.getGlobalVariableService().getUserSession().getLoggedInUserPrincipalName();
        return this.kualiBuildApiService.documentsCreatedWith(app.getId(), FIELD_PROPOSAL_NUMBER, this.proposalNumberFor(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber())).stream().map(kbDocument -> PreproposalForm.builder().withApp(app).withDocument((KualiBuildDocumentDto)kbDocument).withUsername(username).withValueConverter(this.valueConverter).build()).toList();
    }

    private String proposalNumberFor(String proposalNumber) {
        return "#" + proposalNumber;
    }

    @Override
    public KualiBuildInitializeWorkflowDto createPreproposalForm(KualiBuildAppDto app, ProposalDevelopmentDocument proposalDevelopmentDocument, ProposalDevelopmentEvaluator evaluator, String timeZone) {
        Map<String, Object> createdWithData = Collections.singletonMap(FIELD_PROPOSAL_NUMBER, this.proposalNumberFor(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber()));
        KualiBuildInitializeWorkflowDto initializeResponse = this.kualiBuildApiService.initializeWorkflow(app.getId(), createdWithData, timeZone);
        LOG.debug("{}", (Object)initializeResponse);
        this.submitPreproposalForm(initializeResponse.getDocumentId(), initializeResponse.getActionId(), "Saved by the system as a Preproposal Form.", this.proposalToAppData(evaluator, app));
        return initializeResponse;
    }

    @Override
    public List<Pair<KualiBuildAppDto, List<KualiBuildInitializeWorkflowDto>>> copyPreproposalForms(String sourceProposalNumber, List<KualiBuildAppDto> apps, ProposalDevelopmentDocument proposalDevelopmentDocument, ProposalDevelopmentEvaluator evaluator, String timeZone) {
        return apps.stream().map(app -> Pair.of((Object)app, this.kualiBuildApiService.documentsCreatedWith(app.getId(), FIELD_PROPOSAL_NUMBER, this.proposalNumberFor(sourceProposalNumber)))).map(pair -> {
            KualiBuildAppDto app = (KualiBuildAppDto)pair.getKey();
            List<KualiBuildInitializeWorkflowDto> docs = ((List)pair.getValue()).stream().map(document -> {
                KualiBuildInitializeWorkflowDto init = this.createPreproposalForm(app, proposalDevelopmentDocument, evaluator, timeZone);
                this.submitPreproposalForm(init.getDocumentId(), init.getActionId(), "Saved by the system as a Preproposal Form.", document.getData());
                this.updatePreproposalForm(init.getDocumentId(), this.proposalToAppData(evaluator, app));
                return init;
            }).toList();
            return Pair.of((Object)app, docs);
        }).toList();
    }

    @Override
    public PreproposalForm updatePreproposalForm(ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm) {
        PreproposalForm preproposalForm = proposalDevelopmentDocumentForm.getPreproposalFormsHelper().getCurrentPreproposalForm();
        this.submitPreproposalForm(preproposalForm.getDocument().getId(), preproposalForm.getActionId().orElseThrow(() -> new KualiBuildException("Action Id not found")), "", this.proposalToAppData(proposalDevelopmentDocumentForm.getPreproposalFormsHelper().getEvaluator(), preproposalForm.getApp()));
        return this.loadPreproposalForms(preproposalForm.getApp(), proposalDevelopmentDocumentForm.getProposalDevelopmentDocument()).stream().filter(pf -> preproposalForm.getDocument().getId().equals(pf.getDocument().getId())).findFirst().orElseThrow(() -> new KualiBuildException("Updated document not found"));
    }

    private void submitPreproposalForm(String documentId, String actionId, String comment, Map<String, Object> data) {
        KualiBuildSubmitDocumentRequest request = new KualiBuildSubmitDocumentRequest();
        request.setDocumentId(documentId);
        request.setActionId(actionId);
        request.setStatus(STATUS_SAVED);
        request.setComment(comment);
        request.setData(data);
        String submitResponse = this.kualiBuildApiService.submitDocument(request);
        LOG.debug("{}", (Object)submitResponse);
    }

    private KualiBuildUpdateDocumentDto updatePreproposalForm(String documentId, Map<String, Object> data) {
        KualiBuildUpdateDocumentDto updateResponse = this.kualiBuildApiService.updateDocument(documentId, data);
        LOG.debug("{}", (Object)updateResponse);
        return updateResponse;
    }

    protected Map<String, Object> proposalToAppData(ProposalDevelopmentEvaluator evaluator, KualiBuildAppDto app) {
        return this.evaluateGadgets(evaluator, app.getFormContainer().getSchema(), null);
    }

    protected Map<String, Object> evaluateGadgets(ProposalDevelopmentEvaluator evaluator, List<KualiBuildGadgetDto> gadgets, Object root) {
        return gadgets.stream().filter(KualiBuildGadgetDto::hasCustomFormKey).map(child -> this.evaluateAndPair(evaluator, (KualiBuildGadgetDto)child, root)).filter(p -> ((Optional)p.getRight()).isPresent()).collect(Collectors.toMap(Pair::getLeft, p -> ((Optional)p.getRight()).get()));
    }

    protected Pair<String, Optional<?>> evaluateAndPair(ProposalDevelopmentEvaluator evaluator, KualiBuildGadgetDto gadget, Object root) {
        Object object;
        String key = gadget.getCustomFormKey().getValue();
        Optional<Object> buildValue = (root == null ? evaluator.evaluate(key) : evaluator.evaluate(key, root)).map(val -> this.valueConverter.convertValueForBuild(gadget, val));
        if (buildValue.isPresent() && !gadget.getChildrenTemplate().isEmpty() && (object = buildValue.get()) instanceof Collection) {
            Collection values = (Collection)object;
            List<Map> data = values.stream().map(childRoot -> this.evaluateGadgets(evaluator, gadget.getChildrenTemplate(), childRoot)).toList();
            if ("Table".equals(gadget.getType())) {
                IntStream.range(0, data.size()).forEach(i -> ((Map)data.get(i)).put("_rowId", gadget.getId() + "-" + i));
            }
            return new ImmutablePair((Object)key, Optional.of(data));
        }
        if (buildValue.isPresent() && gadget.getDetails() != null && !gadget.getDetails().getOptions().isEmpty()) {
            return new ImmutablePair((Object)key, this.transformValueForGadgetWithOptions(gadget, buildValue.get()));
        }
        return new ImmutablePair((Object)key, buildValue);
    }

    protected Optional<?> transformValueForGadgetWithOptions(KualiBuildGadgetDto gadget, Object value) {
        record OptionValue(String id, String label) {
            OptionValue(KualiBuildGadgetDto.Option opt) {
                this(opt.getKey(), opt.getLbl());
            }
        }
        if ("Checkboxes".equals(gadget.getType())) {
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                List<OptionValue> optionValues = gadget.getDetails().getOptions().stream().filter(opt -> values.contains(opt.getLbl())).map(x$0 -> new OptionValue((KualiBuildGadgetDto.Option)x$0)).toList();
                return optionValues.isEmpty() ? Optional.empty() : Optional.of(optionValues);
            }
            return Optional.empty();
        }
        return gadget.getDetails().getOptions().stream().filter(opt -> value.equals(opt.getLbl())).map(x$0 -> new OptionValue((KualiBuildGadgetDto.Option)x$0)).findFirst();
    }

    @Override
    public boolean requiresUpgrade(PreproposalForm preproposalForm) {
        KualiBuildDocumentDto document = this.kualiBuildApiService.retrieveDocumentForUpgradeCheck(preproposalForm.getDocument().getId());
        if (document.getForm() == null || document.getForm().getId() == null || document.getDataset() == null || document.getDataset().getFormVersion() == null || document.getDataset().getFormVersion().getId() == null) {
            LOG.error("Response not fully populated when checking if document {} requires upgrading: {}", (Object)preproposalForm.getDocument().getId(), (Object)document);
            throw new KualiBuildException("Null data returned from Kuali Build when checking if the document for the Preproposal Form requires upgrading.");
        }
        return !"published".equalsIgnoreCase(document.getStatus()) && !document.getForm().getId().equals(document.getDataset().getFormVersion().getId());
    }

    @Override
    public PreproposalForm upgradeDocument(ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm) {
        PreproposalForm preproposalForm = proposalDevelopmentDocumentForm.getPreproposalFormsHelper().getCurrentPreproposalForm();
        if (this.requiresUpgrade(preproposalForm)) {
            this.kualiBuildApiService.upgradeDocument(preproposalForm.getDocument().getId());
            Set existingDocumentIds = proposalDevelopmentDocumentForm.getPreproposalFormsHelper().getPreproposalForms().stream().map(PreproposalForm::getDocument).map(KualiBuildDocumentDto::getId).collect(Collectors.toCollection(HashSet::new));
            existingDocumentIds.remove(preproposalForm.getDocument().getId());
            return this.loadPreproposalForms(preproposalForm.getApp(), proposalDevelopmentDocumentForm.getProposalDevelopmentDocument()).stream().filter(pf -> !existingDocumentIds.contains(pf.getDocument().getId())).findFirst().orElseThrow(() -> new KualiBuildException("Upgraded document not found"));
        }
        return preproposalForm;
    }

    @Override
    public boolean discardPreproposalForm(@NotNull PreproposalForm preproposalForm) {
        String status = this.kualiBuildApiService.discardDocument(preproposalForm.getDocument().getId());
        LOG.debug("Discard status: {}", (Object)status);
        if ("Ok".equalsIgnoreCase(status)) {
            this.globalVariableService.getMessageMap().putInfo("GLOBAL_INFO", "info.preproposalForms.discardSuccessful", Boolean.valueOf(true), new String[]{preproposalForm.getApp().getName()});
            return true;
        }
        this.globalVariableService.getMessageMap().putInfo("GLOBAL_INFO", "error.preproposalForms.discardFailed", Boolean.valueOf(true), new String[]{preproposalForm.getApp().getName(), status});
        return false;
    }

    @Override
    public boolean withdrawPreproposalForm(@NotNull PreproposalForm preproposalForm, String timeZone) {
        KualiBuildWithdrawSubmissionDto withdrawSubmission = this.kualiBuildApiService.withdrawSubmission(preproposalForm.getDocument().getId(), timeZone);
        if (withdrawSubmission.isSuccessful()) {
            this.globalVariableService.getMessageMap().putInfo("GLOBAL_INFO", "info.preproposalForms.withdrawSuccessful", Boolean.valueOf(true), new String[]{preproposalForm.getApp().getName()});
            return true;
        }
        this.globalVariableService.getMessageMap().putInfo("GLOBAL_INFO", "error.preproposalForms.withdrawFailed", Boolean.valueOf(true), new String[]{preproposalForm.getApp().getName(), withdrawSubmission.getReason()});
        return false;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public KualiBuildApiService getKualiBuildApiService() {
        return this.kualiBuildApiService;
    }

    public void setKualiBuildApiService(KualiBuildApiService kualiBuildApiService) {
        this.kualiBuildApiService = kualiBuildApiService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public PreproposalFormsValueConverter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(PreproposalFormsValueConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public ProposalDevelopmentS2sQuestionnaireService getProposalDevelopmentS2sQuestionnaireService() {
        return this.proposalDevelopmentS2sQuestionnaireService;
    }

    public void setProposalDevelopmentS2sQuestionnaireService(ProposalDevelopmentS2sQuestionnaireService proposalDevelopmentS2sQuestionnaireService) {
        this.proposalDevelopmentS2sQuestionnaireService = proposalDevelopmentS2sQuestionnaireService;
    }
}

