/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.permissions;

import java.io.Serializable;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.infrastructure.AwardTaskNames;
import org.kuali.rice.krad.util.GlobalVariables;

public class PermissionsHelper
implements Serializable {
    private final AwardForm form;

    public PermissionsHelper(AwardForm form) {
        this.form = form;
    }

    private Award getAward() {
        AwardDocument document = this.form.getAwardDocument();
        if (document == null || document.getAward() == null) {
            throw new IllegalArgumentException("invalid (null) AWARDDocument in AWARDForm");
        }
        return document.getAward();
    }

    public boolean getMaintainAwardReportTracking() {
        AwardTask task = new AwardTask(AwardTaskNames.MAINTAIN_REPORT_TRACKING.getAwardTaskName(), this.getAward());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }
}

