/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kuali.rice.krad.lookup.CollectionIncomplete;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean validIndexForList(int index, List<?> forList) {
        return forList != null && index >= 0 && index <= forList.size() - 1;
    }

    public static <T> T getFromList(int index, List<T> fromList) {
        if (!CollectionUtils.validIndexForList(index, fromList)) {
            return null;
        }
        return fromList.get(index);
    }

    public static <T, U> Map<T, U> zipMap(T[] keys, U[] values) {
        if (keys == null) {
            throw new IllegalArgumentException("keys is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Number of keys doesn't match number of values");
        }
        HashMap<T, U> map = new HashMap<T, U>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <T> List<T> createCorrectImplementationForCollection(Collection<T> collection) {
        if (collection instanceof CollectionIncomplete) {
            return new CollectionIncomplete(new ArrayList(), ((CollectionIncomplete)collection).getActualSizeIfTruncated());
        }
        return new ArrayList();
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, U, M extends Map<K, U>> Collector<Map.Entry<K, U>, ?, M> entriesToMap(Supplier<M> mapSupplier) {
        if (mapSupplier == null) {
            throw new IllegalArgumentException("mapSupplier cannot be null");
        }
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, mapSupplier);
    }

    public static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> entriesToMapWithReplacing() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, HashMap::new);
    }

    public static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> nullSafeEntriesToMap() {
        return CollectionUtils.nullSafeToMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> nullSafeToMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            HashMap result = new HashMap();
            for (Object item : list) {
                Object key = keyMapper.apply((Object)item);
                if (result.putIfAbsent(key, valueMapper.apply((Object)item)) == null) continue;
                throw new IllegalStateException(String.format("Duplicate key %s", key));
            }
            return result;
        });
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        if (keyExtractor == null) {
            throw new IllegalArgumentException("the keyExtractor must not be null");
        }
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        if (sourceIterator == null) {
            throw new IllegalArgumentException("sourceIterator is null");
        }
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> asStream(final Enumeration<T> sourceEnumeration) {
        if (sourceEnumeration == null) {
            throw new IllegalArgumentException("sourceEnumeration is null");
        }
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (sourceEnumeration.hasMoreElements()) {
                    action.accept(sourceEnumeration.nextElement());
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                while (sourceEnumeration.hasMoreElements()) {
                    action.accept(sourceEnumeration.nextElement());
                }
            }
        }, false);
    }

    public static <T, R> Collection<R> findDuplicates(Collection<T> source, Function<? super T, ? extends R> identityMapper) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (identityMapper == null) {
            throw new IllegalArgumentException("identityMapper is null");
        }
        return source.stream().map(identityMapper).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static <R> Collection<R> findDuplicates(Collection<R> source) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        return CollectionUtils.findDuplicates(source, Function.identity());
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        Object[] a = list.toArray();
        Arrays.sort(a, c);
        ListIterator<T> i = list.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set(a[j]);
        }
    }
}

