/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogDocumentAuthorizer;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.DocumentAuthorizer;
import org.kuali.rice.krad.document.DocumentPresentationController;
import org.kuali.rice.krad.exception.DocumentAuthorizationException;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.UrlFactory;

public class ProposalLogLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    public static final String PRINT_PROPOSAL_LOG_ACTION = "../printProposalLog.do";
    private static final long serialVersionUID = -7638045643796948730L;
    private static final String USERNAME_FIELD = "person.userName";
    private static final String STATUS_PENDING = "1";
    public static final String FOR_INSTITUTIONAL_PROPOSAL = "forInstitutionalProposal";
    public static final String LOG_STATUS = "logStatus";
    public static final String DOC_HANDLER = "docHandler";
    public static final String INITIATE = "initiate";
    public static final String PROPOSAL_NUMBER = "proposalNumber";
    public static final String INSTITUTIONAL_PROPOSAL_HOME_ACTION = "../institutionalProposalHome.do";
    public static final String MERGE = "merge";
    public static final String PAGE_ENTRY = "pageEntry";
    public static final String PROPOSAL_LOG_NUMBER = "proposalLogNumber";
    public static final String MERGE_PROPOSAL_LOG_ACTION = "../mergeProposalLog.do";
    public static final String PRINT_PROPOSAL_LOG = "printProposalLog";
    public static final String PI_ID = "piId";
    public static final String NEGOTIATION_NEGOTIATION = "negotiationNegotiation";
    public static final String BACK_LOCATION = "backLocation";
    public static final String FIELD_CONVERSIONS = "principalName:person.userName,principalId:personId";
    public static final String SELECT_TEXT = "select";
    public static final String CREATE_TEXT = "create&nbsp;IP";
    public static final String PRINT_LINK = "print";
    private KcPersonService kcPersonService;
    private DocumentDictionaryService documentDictionaryService;
    public static final String INST_PROP_DOC_NAME = "InstitutionalProposalDocument";

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        String userName = (String)lookupForm.getFieldsForLookup().get(USERNAME_FIELD);
        lookupForm.getFieldsForLookup().remove(FOR_INSTITUTIONAL_PROPOSAL);
        if (!StringUtils.isBlank((CharSequence)userName)) {
            KcPerson person = this.getKcPersonService().getKcPersonByUserName(userName);
            if (person != null) {
                lookupForm.getFieldsForLookup().put(PI_ID, person.getPersonId());
            }
            lookupForm.getFieldsForLookup().remove(USERNAME_FIELD);
        }
        List results = (List)super.performLookup(lookupForm, resultTable, bounded);
        if (StringUtils.containsIgnoreCase((CharSequence)lookupForm.getBackLocation(), (CharSequence)NEGOTIATION_NEGOTIATION)) {
            return this.cleanSearchResultsForNegotiationLookup(results);
        }
        return results;
    }

    public boolean getSearchResultsActualSizeKnown() {
        return false;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        if (!this.createIPEnabled()) {
            this.checkIsLookupForProposalCreation();
        }
        List results = super.getSearchResults(fieldValues);
        String returnLocation = fieldValues.get(BACK_LOCATION);
        List<ProposalLog> searchList = this.filterForPermissions(results);
        if (StringUtils.containsIgnoreCase((CharSequence)returnLocation, (CharSequence)NEGOTIATION_NEGOTIATION)) {
            return this.cleanSearchResultsForNegotiationLookup(searchList);
        }
        return searchList;
    }

    protected List<ProposalLog> filterForPermissions(List<ProposalLog> results) {
        List<ProposalLog> proposalLogs = CollectionUtils.createCorrectImplementationForCollection(results);
        ProposalLogDocumentAuthorizer authorizer = new ProposalLogDocumentAuthorizer();
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean dontFilterPending = this.createIPEnabled();
        proposalLogs.addAll(results.stream().filter(proposalLog -> dontFilterPending || proposalLog.getProposalNumber() != null).filter(proposalLog -> authorizer.canOpen((ProposalLog)proposalLog, user)).collect(Collectors.toList()));
        return proposalLogs;
    }

    private List<ProposalLog> cleanSearchResultsForNegotiationLookup(List<ProposalLog> searchResults) {
        List<ProposalLog> newResults = CollectionUtils.createCorrectImplementationForCollection(searchResults);
        newResults.addAll(searchResults.stream().filter(pl -> StringUtils.isBlank((CharSequence)pl.getInstProposalNumber())).collect(Collectors.toList()));
        return newResults;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList();
        if (this.isLookupToCreateProposal()) {
            if (STATUS_PENDING.equals(((ProposalLog)businessObject).getLogStatus())) {
                htmlDataList.add((HtmlData)this.getSelectLinkForProposalCreation((ProposalLog)businessObject));
            }
        } else {
            htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
            if (this.createIPEnabled() && STATUS_PENDING.equals(((ProposalLog)businessObject).getLogStatus()) && this.userCanCreateIP()) {
                htmlDataList.add((HtmlData)this.getSelectLinkForProposalCreation((ProposalLog)businessObject));
            }
            if (((ProposalLog)businessObject).isMergeCandidate()) {
                htmlDataList.add((HtmlData)this.getMergeLink(((ProposalLog)businessObject).getProposalNumber()));
            }
            if (((ProposalLog)businessObject).isSubmitted()) {
                this.removeEditLink(htmlDataList);
            }
            htmlDataList.add((HtmlData)this.getPrintLink(((ProposalLog)businessObject).getProposalNumber()));
        }
        return htmlDataList;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals(USERNAME_FIELD)) {
                    field.setFieldConversions(FIELD_CONVERSIONS);
                }
                if (!field.getPropertyName().equals(LOG_STATUS) || !this.isLookupToCreateProposal()) continue;
                field.setPropertyValue(STATUS_PENDING);
            }
        }
        return rows;
    }

    protected HtmlData.AnchorHtmlData getSelectLinkForProposalCreation(ProposalLog proposalLog) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(this.createIPEnabled() ? CREATE_TEXT : SELECT_TEXT);
        Properties parameters = new Properties();
        parameters.put("methodToCall", DOC_HANDLER);
        parameters.put("command", INITIATE);
        parameters.put("docTypeName", INST_PROP_DOC_NAME);
        parameters.put(PROPOSAL_NUMBER, proposalLog.getProposalNumber());
        String href = UrlFactory.parameterizeUrl((String)INSTITUTIONAL_PROPOSAL_HOME_ACTION, (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getMergeLink(String proposalNumber) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(MERGE);
        Properties parameters = new Properties();
        parameters.put("methodToCall", PAGE_ENTRY);
        parameters.put(PROPOSAL_LOG_NUMBER, proposalNumber);
        String href = UrlFactory.parameterizeUrl((String)MERGE_PROPOSAL_LOG_ACTION, (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getPrintLink(String proposalNumber) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(PRINT_LINK);
        Properties parameters = new Properties();
        parameters.put("methodToCall", PRINT_PROPOSAL_LOG);
        parameters.put(PROPOSAL_NUMBER, proposalNumber);
        String href = UrlFactory.parameterizeUrl((String)PRINT_PROPOSAL_LOG_ACTION, (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected void checkIsLookupForProposalCreation() {
        if (this.isLookupToCreateProposal()) {
            Person user = GlobalVariables.getUserSession().getPerson();
            DocumentAuthorizer documentAuthorizer = this.getDocumentDictionaryService().getDocumentAuthorizer(INST_PROP_DOC_NAME);
            DocumentPresentationController documentPresentationController = this.getDocumentDictionaryService().getDocumentPresentationController(INST_PROP_DOC_NAME);
            LOG.debug("calling canInitiate from getNewDocument()");
            if (!documentPresentationController.canInitiate(INST_PROP_DOC_NAME) || !documentAuthorizer.canInitiate(INST_PROP_DOC_NAME, user)) {
                throw new DocumentAuthorizationException(user.getPrincipalName(), INITIATE, INST_PROP_DOC_NAME);
            }
        }
    }

    protected boolean userCanCreateIP() {
        Person user = GlobalVariables.getUserSession().getPerson();
        DocumentAuthorizer documentAuthorizer = this.getDocumentDictionaryService().getDocumentAuthorizer(INST_PROP_DOC_NAME);
        DocumentPresentationController documentPresentationController = this.getDocumentDictionaryService().getDocumentPresentationController(INST_PROP_DOC_NAME);
        LOG.debug("calling canInitiate from getNewDocument()");
        return documentPresentationController.canInitiate(INST_PROP_DOC_NAME) && documentAuthorizer.canInitiate(INST_PROP_DOC_NAME, user);
    }

    private boolean isLookupToCreateProposal() {
        Map parameterList = this.getParameters();
        String[] paramArray = (String[])parameterList.get(FOR_INSTITUTIONAL_PROPOSAL);
        return ObjectUtils.isNotNull((Object)paramArray) && Boolean.TRUE.equals(Boolean.parseBoolean(paramArray[0]));
    }

    protected void removeEditLink(List<HtmlData> htmlDataList) {
        int editLinkIndex = -1;
        int currentIndex = 0;
        for (HtmlData htmlData : htmlDataList) {
            if ("edit".equals(htmlData.getMethodToCall())) {
                editLinkIndex = currentIndex;
                break;
            }
            ++currentIndex;
        }
        if (editLinkIndex != -1) {
            htmlDataList.remove(editLinkIndex);
        }
    }

    private boolean createIPEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-IP", "All", "Enable_Direct_IP_Creation");
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }
}

