/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.print;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.impl.print.BudgetBaseStream;
import org.kuali.coeus.common.budget.impl.print.ReportTypeVO;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.printing.schema.BudgetSummaryReportDocument;
import org.kuali.kra.printing.schema.ReportHeaderType;
import org.kuali.kra.printing.schema.ReportPageType;
import org.kuali.kra.printing.schema.ReportType;
import org.kuali.kra.printing.schema.SubReportType;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="budgetSummaryXmlStream")
@Scope(value="prototype")
public class BudgetSummaryXmlStream
extends BudgetBaseStream<BudgetSummaryReportDocument> {
    private static final Logger LOG = LogManager.getLogger(BudgetSummaryXmlStream.class);

    @Override
    public Class<BudgetSummaryReportDocument> type() {
        return BudgetSummaryReportDocument.class;
    }

    @Override
    public Map<String, BudgetSummaryReportDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, BudgetSummaryReportDocument> xmlObjectMap = new LinkedHashMap<String, BudgetSummaryReportDocument>();
        this.budget = (Budget)printableBusinessObject;
        if (this.budget != null) {
            for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetLineItems() == null || budgetPeriod.getBudgetLineItems().isEmpty()) {
                    LOG.debug("Skipping printing of empty budget period, for Budget period - " + budgetPeriod.getBudgetPeriod());
                    continue;
                }
                this.budgetPeriod = budgetPeriod;
                BudgetSummaryReportDocument budgetSummaryReportDocument = (BudgetSummaryReportDocument)BudgetSummaryReportDocument.Factory.newInstance();
                BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = this.getBudgetSummaryReport();
                budgetSummaryReportDocument.setBudgetSummaryReport(budgetSummaryReport);
                xmlObjectMap.put("Period" + budgetPeriod.getBudgetPeriod(), budgetSummaryReportDocument);
            }
        }
        return xmlObjectMap;
    }

    private BudgetSummaryReportDocument.BudgetSummaryReport getBudgetSummaryReport() {
        BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = (BudgetSummaryReportDocument.BudgetSummaryReport)BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
        BudgetParent budgetParent = this.budget.getBudgetParent();
        ReportHeaderType reportHeaderType = this.getReportHeaderTypeForCumulativeReport(budgetParent);
        budgetSummaryReport.setReportHeader(reportHeaderType);
        ReportPageType cumilativePageType = this.getBudgetSummaryReportPageType();
        budgetSummaryReport.setCumilativePage(cumilativePageType);
        ReportPageType[] reportPageTypeArray = this.getReportPageTypes();
        budgetSummaryReport.setReportPageArray(reportPageTypeArray);
        return budgetSummaryReport;
    }

    private ReportPageType[] getReportPageTypes() {
        ArrayList<ReportPageType> reportPageTypeList = new ArrayList<ReportPageType>();
        ReportPageType reportPageType = this.getBudgetSummaryReportPageType();
        reportPageTypeList.add(reportPageType);
        return reportPageTypeList.toArray(new ReportPageType[0]);
    }

    private ReportPageType getBudgetSummaryReportPageType() {
        ReportPageType reportPageType = (ReportPageType)ReportPageType.Factory.newInstance();
        ReportPageType.BudgetSummary budgetSummary = this.getBudgetSummary();
        reportPageType.setBudgetSummary(budgetSummary);
        ReportPageType.CalculationMethodology calculationMethodology = this.getCalculationMethodology();
        reportPageType.setCalculationMethodology(calculationMethodology);
        reportPageType.setPeriod(this.budgetPeriod.getBudgetPeriod());
        return reportPageType;
    }

    private ReportPageType.BudgetSummary getBudgetSummary() {
        ReportPageType.BudgetSummary budgetSummary = (ReportPageType.BudgetSummary)ReportPageType.BudgetSummary.Factory.newInstance();
        SubReportType subReportType = this.getSalarySummary();
        budgetSummary.setSalarySummaryFromEDI(subReportType);
        subReportType = this.getBudgetSummaryNonPersonnel();
        budgetSummary.setBudgetSummaryNonPersonnel(subReportType);
        subReportType = this.getBudgetIndirectCostsForReport();
        budgetSummary.setBudgetIndirectCostsForReport(subReportType);
        budgetSummary.setTotalDirectCost(this.budgetPeriod.getTotalDirectCost().doubleValue());
        budgetSummary.setTotalCostToSponsor(this.budgetPeriod.getTotalCost().doubleValue());
        budgetSummary.setTotalUnderrecoveryAmount(this.budgetPeriod.getUnderrecoveryAmount().doubleValue());
        budgetSummary.setTotalCostSharingAmount(this.budgetPeriod.getCostSharingAmount().doubleValue());
        return budgetSummary;
    }

    private SubReportType getSalarySummary() {
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        this.setReportTypeForBudgetSalarySummary(reportTypeList);
        this.setBudgetLASalaryForBudgetRateAndBase(reportTypeList, new ArrayList<ReportTypeVO>());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    void setReportTypeForBudgetSalarySummary(List<ReportType> reportTypeList) {
        this.setReportTypeListFromReportTypeVOListForBudgetSalarySummary(reportTypeList, this.getReportTypeVOList(this.budgetPeriod));
    }

    private void setReportTypeListFromReportTypeVOListForBudgetSalarySummary(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : reportTypeVOList) {
            String budgetSalarySummaryKey = this.getKeyForBudgetSalarySummary(reportTypeVO);
            if (reportTypeMap.containsKey(budgetSalarySummaryKey)) continue;
            ScaleTwoDecimal vacationRate = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal empBenefitRate = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal fringe = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal fringeCostSharing = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : reportTypeVOList) {
                String budgetSalarySummaryTempKey = this.getKeyForBudgetSalarySummary(tempReportTypeVO);
                if (!budgetSalarySummaryTempKey.equals(budgetSalarySummaryKey)) continue;
                if (vacationRate.isLessThan((AbstractDecimal)tempReportTypeVO.getVacationRate())) {
                    vacationRate = tempReportTypeVO.getVacationRate();
                }
                if (empBenefitRate.isLessThan((AbstractDecimal)tempReportTypeVO.getEmployeeBenefitRate())) {
                    empBenefitRate = tempReportTypeVO.getEmployeeBenefitRate();
                }
                fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)tempReportTypeVO.getFringe());
                fringeCostSharing = (ScaleTwoDecimal)fringeCostSharing.add((AbstractDecimal)tempReportTypeVO.getCalculatedCost());
            }
            ReportType reportType = this.getReportTypeForBudgetSalarySummary(vacationRate, empBenefitRate, fringe, fringeCostSharing, reportTypeVO);
            reportTypeMap.put(budgetSalarySummaryKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForBudgetSalarySummary(ScaleTwoDecimal vacationRate, ScaleTwoDecimal empBenefitRate, ScaleTwoDecimal fringe, ScaleTwoDecimal fringeCostSharing, ReportTypeVO reportTypeVO) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
        ReportType reportType = (ReportType)ReportType.Factory.newInstance();
        reportType.setStartDate(dateFormat.format(reportTypeVO.getStartDate()));
        reportType.setEndDate(dateFormat.format(reportTypeVO.getEndDate()));
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setPersonName(reportTypeVO.getPersonName());
        reportType.setPercentEffort(reportTypeVO.getPercentEffort() != null ? reportTypeVO.getPercentEffort().doubleValue() : 0.0);
        reportType.setPercentCharged(reportTypeVO.getPercentCharged() != null ? reportTypeVO.getPercentCharged().doubleValue() : 0.0);
        reportType.setVacationRate(vacationRate.toString().concat("%"));
        reportType.setEmployeeBenefitRate(empBenefitRate.toString().concat("%"));
        reportType.setCostSharingAmount(reportTypeVO.getCostSharingAmount().doubleValue());
        reportType.setCalculatedCost(fringeCostSharing.doubleValue());
        reportType.setFringe(fringe.doubleValue());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setInvestigatorFlag(reportTypeVO.getInvestigatorFlag());
        if (reportTypeVO.getBudgetCategoryCode() != null) {
            reportType.setBudgetCategoryCode(Integer.parseInt(reportTypeVO.getBudgetCategoryCode()));
        }
        reportType.setSalaryRequested(reportTypeVO.getSalaryRequested().doubleValue());
        return reportType;
    }

    private SubReportType getBudgetSummaryNonPersonnel() {
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.LAB_ALLOCATION.getRateClassType(), budgetLineItem));
            costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)this.getTotalCostSharingAmountByRateClassTypeFromLineItem(budgetLineItem, RateClassType.LAB_ALLOCATION.getRateClassType()));
        }
        ReportType reportType = this.getReportTypeForNonPersonnel("Other Direct Costs", "Allocated Lab Expense", calculatedCost, costSharingAmount);
        if (calculatedCost.doubleValue() > 0.0) {
            reportTypeList.add(reportType);
        }
        this.setReportTypeForBudgetSummaryNonPersonnel(reportTypeList);
        reportTypeList.sort(Comparator.comparing(ReportType::getBudgetCategoryDescription));
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForBudgetSummaryNonPersonnel(List<ReportType> reportTypeList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
            ReportTypeVO tempReportTypeVO = this.getReportTypeVOForBudgetSummaryNonPersonnel(budgetLineItem);
            tempReportTypeVOList.add(tempReportTypeVO);
        }
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String budgetSummaryNonPersKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(budgetSummaryNonPersKey)) continue;
            ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO reportTypeVO1 : tempReportTypeVOList) {
                String budgetSummaryNonPersTempKey = reportTypeVO1.getCostElementDesc();
                if (!budgetSummaryNonPersTempKey.equals(budgetSummaryNonPersKey)) continue;
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)reportTypeVO1.getCalculatedCost());
                costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)reportTypeVO1.getCostSharingAmount());
            }
            ReportType reportType = this.getReportTypeForBudgetSummaryNonPersonnel(calculatedCost, costSharingAmount, reportTypeVO);
            reportTypeMap.put(budgetSummaryNonPersKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForBudgetSummaryNonPersonnel(ScaleTwoDecimal calculatedCost, ScaleTwoDecimal costSharingAmount, ReportTypeVO reportTypeVO) {
        ReportType reportType = (ReportType)ReportType.Factory.newInstance();
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        reportType.setCostSharingAmount(costSharingAmount.doubleValue());
        return reportType;
    }

    private ReportTypeVO getReportTypeVOForBudgetSummaryNonPersonnel(BudgetLineItem budgetLineItem) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setBudgetCategoryDesc(budgetLineItem.getBudgetCategory().getDescription());
        reportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
        reportTypeVO.setCostSharingAmount(budgetLineItem.getCostSharingAmount());
        reportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
        return reportTypeVO;
    }
}

