/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.scheduling;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.scheduling.KcCronTriggerService;
import org.kuali.coeus.sys.framework.scheduling.util.KcCronTriggerParameterDetails;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.Truth;
import org.kuali.rice.coreservice.api.parameter.ParameterKey;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;

public class KcCronTriggerServiceImpl
implements KcCronTriggerService {
    private static final Logger LOG = LogManager.getLogger(KcCronTriggerServiceImpl.class);
    private static final String APPLICATION_ID = "KC";
    static final String FIRE_TIME_DATE_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    static final String PARAMETER_START_TIME_DATE_FORMAT = "dd-MMM-yyyy hh:mm a";
    private Map<ParameterKey, KcCronTriggerService.TriggerScheduleInfo> paramToTriggerActionMap;
    private DateTimeService dateTimeService;
    private ParameterService parameterService;

    @Override
    public Optional<KcCronTriggerService.TriggerScheduleInfo> findCronTriggerForParameter(String namespace, String component, String parameterName) throws SchedulerException {
        return this.findCronTriggerForParameter(ParameterKey.create((String)APPLICATION_ID, (String)namespace, (String)component, (String)parameterName));
    }

    @Override
    public Optional<KcCronTriggerService.TriggerScheduleInfo> findCronTriggerForParameter(ParameterKey parameterKey) throws SchedulerException {
        if (this.paramToTriggerActionMap == null) {
            this.buildParameterTriggerActionMap();
        }
        return Optional.ofNullable(this.paramToTriggerActionMap.get(parameterKey));
    }

    @Override
    public String updateTriggerWithNewParameterValue(String namespace, String component, String parameterName, String newValue) throws ParseException, SchedulerException {
        return this.updateTriggerWithNewParameterValue(ParameterKey.create((String)APPLICATION_ID, (String)namespace, (String)component, (String)parameterName), newValue);
    }

    @Override
    public String updateTriggerWithNewParameterValue(ParameterKey parameterKey, String newValue) throws ParseException, SchedulerException {
        Optional<KcCronTriggerService.TriggerScheduleInfo> mightBeTriggerInfo = this.findCronTriggerForParameter(parameterKey);
        if (mightBeTriggerInfo.isPresent()) {
            KcCronTriggerService.TriggerScheduleInfo triggerInfo = mightBeTriggerInfo.get();
            String paramName = parameterKey.getName();
            String successMessage = switch (triggerInfo.getTriggerActionType()) {
                case KcCronTriggerService.TriggerActionType.RESCHEDULE_CRON -> this.rescheduleCronTrigger(triggerInfo.getScheduler(), triggerInfo.getCronTrigger(), newValue, paramName);
                case KcCronTriggerService.TriggerActionType.ENABLE_DISABLE -> this.enableDisableCronTrigger(triggerInfo.getScheduler(), triggerInfo.getCronTrigger(), newValue, paramName);
                case KcCronTriggerService.TriggerActionType.CHANGE_START_TIME -> this.changeCronTriggerStartTime(triggerInfo.getScheduler(), triggerInfo.getCronTrigger(), newValue, paramName);
                case KcCronTriggerService.TriggerActionType.CHANGE_MISFIRE_SKIP -> this.changeCronTriggerMisfireSkipBehavior(triggerInfo.getCronTrigger(), newValue, paramName);
                default -> throw new UnsupportedOperationException(String.format("Unsupported trigger action type %s", triggerInfo.getTriggerActionType().name()));
            };
            LOG.info(successMessage);
            return successMessage;
        }
        return String.format("No trigger found associated with parameter %s", parameterKey.getName());
    }

    @Override
    public Date getCronStartTime(boolean isTriggerEnabled, String parameterNamespace, String parameterComponent, String startTimeParameterName) {
        String customStartTime = null;
        if (StringUtils.isNotBlank((CharSequence)startTimeParameterName)) {
            customStartTime = this.parameterService.getParameterValueAsString(parameterNamespace, parameterComponent, startTimeParameterName);
        }
        return this.getCronStartTime(isTriggerEnabled, customStartTime);
    }

    @Override
    public int getMisfireInstruction(boolean skipMisfires) {
        return skipMisfires ? 2 : 1;
    }

    private Date getCronStartTime(boolean isTriggerEnabled, String customStartTime) {
        Date disabledStartTime = this.getDisabledStartTime();
        Date cronStartTime = this.dateTimeService.getCurrentDate();
        if (!isTriggerEnabled) {
            return disabledStartTime;
        }
        if (!StringUtils.isBlank((CharSequence)customStartTime)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(PARAMETER_START_TIME_DATE_FORMAT);
            try {
                cronStartTime = this.convertParameterStartTimeToDate(customStartTime, dateFormat);
            }
            catch (Exception e) {
                cronStartTime = disabledStartTime;
                String defaultDateStr = dateFormat.format(cronStartTime);
                LOG.error("Not able to get the starttime for scheduler from system param table. Set it to " + defaultDateStr, (Throwable)e);
            }
        }
        return cronStartTime;
    }

    private Date getDisabledStartTime() {
        Calendar yearInAdvance = this.dateTimeService.getCurrentCalendar();
        yearInAdvance.add(1, 2);
        return yearInAdvance.getTime();
    }

    private Date convertParameterStartTimeToDate(String parameterStartTime, SimpleDateFormat dateFormat) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)parameterStartTime)) {
            try {
                return this.dateTimeService.convertToDate(parameterStartTime);
            }
            catch (ParseException e) {
                return dateFormat.parse(parameterStartTime);
            }
        }
        throw new UnsupportedOperationException("A string or numeric start time must be provided to this function");
    }

    private String rescheduleCronTrigger(Scheduler scheduler, CronTriggerImpl cronTrigger, String newCronExpression, String paramName) throws ParseException, SchedulerException {
        cronTrigger.setCronExpression(newCronExpression);
        scheduler.rescheduleJob(cronTrigger.getKey(), (Trigger)cronTrigger);
        String nextFireTime = new SimpleDateFormat(FIRE_TIME_DATE_FORMAT).format(cronTrigger.getNextFireTime());
        return String.format("Successfully re-scheduled trigger for %s to %s. The next time this trigger will fire will be at %s.", paramName, newCronExpression, nextFireTime);
    }

    private String enableDisableCronTrigger(Scheduler scheduler, CronTriggerImpl cronTrigger, String enabledDisabled, String paramName) throws SchedulerException {
        if (Truth.strToBooleanIgnoreCase((String)enabledDisabled).booleanValue()) {
            KcCronTriggerParameterDetails paramDetails = (KcCronTriggerParameterDetails)cronTrigger.getJobDataMap().get((Object)"CRON_TRIGGER_PARAMETER_DETAILS");
            Date startTime = this.getCronStartTime(true, paramDetails.getParameterNamespace(), paramDetails.getParameterComponent(), paramDetails.getStartTimeParameterName());
            cronTrigger.setStartTime(startTime);
            scheduler.rescheduleJob(cronTrigger.getKey(), (Trigger)cronTrigger);
            String nextFireTime = new SimpleDateFormat(FIRE_TIME_DATE_FORMAT).format(cronTrigger.getNextFireTime());
            return String.format("Successfully enabled trigger for %s. The next time this trigger will fire will be at %s.", paramName, nextFireTime);
        }
        cronTrigger.setStartTime(this.getDisabledStartTime());
        scheduler.rescheduleJob(cronTrigger.getKey(), (Trigger)cronTrigger);
        return String.format("Successfully disabled trigger for %s.", paramName);
    }

    private String changeCronTriggerStartTime(Scheduler scheduler, CronTriggerImpl cronTrigger, String startTime, String paramName) throws SchedulerException {
        KcCronTriggerParameterDetails paramDetails = (KcCronTriggerParameterDetails)cronTrigger.getJobDataMap().get((Object)"CRON_TRIGGER_PARAMETER_DETAILS");
        String namespace = paramDetails.getParameterNamespace();
        String component = paramDetails.getParameterComponent();
        boolean isTriggerEnabled = this.parameterService.getParameterValueAsBoolean(namespace, component, paramDetails.getTriggerEnabledParameterName());
        Date newStartTime = this.getCronStartTime(isTriggerEnabled, startTime);
        cronTrigger.setStartTime(newStartTime);
        scheduler.rescheduleJob(cronTrigger.getKey(), (Trigger)cronTrigger);
        String nextFireTime = new SimpleDateFormat(FIRE_TIME_DATE_FORMAT).format(cronTrigger.getNextFireTime());
        return String.format("Successfully changed start time of trigger for %s. The next time this trigger will fire will be at %s.", paramName, nextFireTime);
    }

    private String changeCronTriggerMisfireSkipBehavior(CronTriggerImpl cronTrigger, String skipMisfire, String paramName) {
        cronTrigger.setMisfireInstruction(this.getMisfireInstruction(Truth.strToBooleanIgnoreCase((String)skipMisfire, (Boolean)false)));
        return String.format("Successfully changed misfire skip of trigger for %s to %s", paramName, skipMisfire);
    }

    private void addTriggerActionToMap(KcCronTriggerParameterDetails parameterDetails, String parameterName, KcCronTriggerService.TriggerScheduleInfo scheduleInfo) {
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            ParameterKey parameterKey = ParameterKey.create((String)APPLICATION_ID, (String)parameterDetails.getParameterNamespace(), (String)parameterDetails.getParameterComponent(), (String)parameterName);
            this.paramToTriggerActionMap.put(parameterKey, scheduleInfo);
        }
    }

    private void buildMapEntriesForTrigger(KcCronTriggerParameterDetails parameterDetails, Scheduler scheduler, CronTriggerImpl cronTrigger) {
        if (StringUtils.isBlank((CharSequence)parameterDetails.getParameterNamespace()) || StringUtils.isBlank((CharSequence)parameterDetails.getParameterComponent())) {
            return;
        }
        this.addTriggerActionToMap(parameterDetails, parameterDetails.getCronExpressionParameterName(), new KcCronTriggerService.TriggerScheduleInfo(scheduler, cronTrigger, KcCronTriggerService.TriggerActionType.RESCHEDULE_CRON));
        this.addTriggerActionToMap(parameterDetails, parameterDetails.getTriggerEnabledParameterName(), new KcCronTriggerService.TriggerScheduleInfo(scheduler, cronTrigger, KcCronTriggerService.TriggerActionType.ENABLE_DISABLE));
        this.addTriggerActionToMap(parameterDetails, parameterDetails.getStartTimeParameterName(), new KcCronTriggerService.TriggerScheduleInfo(scheduler, cronTrigger, KcCronTriggerService.TriggerActionType.CHANGE_START_TIME));
        this.addTriggerActionToMap(parameterDetails, parameterDetails.getMisfireSkipParameterName(), new KcCronTriggerService.TriggerScheduleInfo(scheduler, cronTrigger, KcCronTriggerService.TriggerActionType.CHANGE_MISFIRE_SKIP));
    }

    private void buildParameterTriggerActionMap() throws SchedulerException {
        this.paramToTriggerActionMap = new HashMap<ParameterKey, KcCronTriggerService.TriggerScheduleInfo>();
        for (Scheduler scheduler : KcServiceLocator.getServicesOfType(Scheduler.class)) {
            for (String groupName : scheduler.getJobGroupNames()) {
                for (JobKey jobKey : scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName))) {
                    for (Trigger trigger : scheduler.getTriggersOfJob(jobKey)) {
                        if (!(trigger instanceof CronTriggerImpl)) continue;
                        CronTriggerImpl cronTrigger = (CronTriggerImpl)trigger;
                        KcCronTriggerParameterDetails paramDetails = (KcCronTriggerParameterDetails)cronTrigger.getJobDataMap().get((Object)"CRON_TRIGGER_PARAMETER_DETAILS");
                        this.buildMapEntriesForTrigger(paramDetails, scheduler, cronTrigger);
                    }
                }
            }
        }
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    @Override
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

