/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.question;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.coeus.common.questionnaire.impl.question.QuestionAuthorizationService;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="questionLookupableHelperService")
@Scope(value="prototype")
public class QuestionLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 7936563894902841571L;
    private static final String MAINTENANCE = "maintenance";
    private static final String NEW_MAINTENANCE = "../maintenanceQ";
    private static final String VIEW = "view";
    private static final String SEQUENCE_STATUS_CURRENT = "C";
    private static final String DOCHANDLER_LINK = "%s/DocHandler.do?command=displayDocSearchView&docId=%s";
    @Autowired
    @Qualifier(value="questionAuthorizationService")
    private transient QuestionAuthorizationService questionAuthorizationService;

    public List<Row> getRows() {
        if (this.getParameters().containsKey("multipleValues") && StringUtils.equals((CharSequence)((String[])this.getParameters().get("multipleValues"))[0], (CharSequence)"Yes") || this.getParameters().containsKey("multipleValues") && StringUtils.equals((CharSequence)((String[])this.getParameters().get("multipleValues"))[0], (CharSequence)"true") || this.getParameters().containsKey("conversionFields") && !StringUtils.isEmpty((CharSequence)((String[])this.getParameters().get("conversionFields"))[0])) {
            ArrayList<Row> retRows = new ArrayList<Row>();
            for (Row row : super.getRows()) {
                if ("status".equals(((Field)row.getFields().get(0)).getPropertyName())) continue;
                retRows.add(row);
            }
            return retRows;
        }
        return super.getRows();
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        fieldValues.put("sequenceStatus", SEQUENCE_STATUS_CURRENT);
        if (this.getParameters().containsKey("multipleValues") && StringUtils.equals((CharSequence)((String[])this.getParameters().get("multipleValues"))[0], (CharSequence)"Yes") || this.getParameters().containsKey("conversionFields") && !StringUtils.isEmpty((CharSequence)((String[])this.getParameters().get("conversionFields"))[0])) {
            fieldValues.put("status", "A");
        }
        return super.getSearchResults(fieldValues);
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        boolean hasViewPermission;
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        boolean hasModifyPermission = this.questionAuthorizationService.hasPermission("Modify Question");
        boolean bl = hasViewPermission = hasModifyPermission || this.questionAuthorizationService.hasPermission("View Question");
        if (hasModifyPermission) {
            HtmlData.AnchorHtmlData editHtmlData = this.getUrlData(businessObject, "edit", pkNames);
            editHtmlData.setHref(editHtmlData.getHref().replace(MAINTENANCE, NEW_MAINTENANCE));
            htmlDataList.add((HtmlData)editHtmlData);
            HtmlData.AnchorHtmlData copyHtmlData = this.getUrlData(businessObject, "copy", pkNames);
            copyHtmlData.setHref(copyHtmlData.getHref().replace(MAINTENANCE, NEW_MAINTENANCE));
            htmlDataList.add((HtmlData)copyHtmlData);
            HtmlData.AnchorHtmlData deleteHtmlData = this.getUrlData(businessObject, "delete", pkNames);
            deleteHtmlData.setHref(deleteHtmlData.getHref().replace(MAINTENANCE, NEW_MAINTENANCE));
            htmlDataList.add((HtmlData)deleteHtmlData);
        }
        if (hasViewPermission) {
            HtmlData.AnchorHtmlData viewHtmlData = new HtmlData.AnchorHtmlData();
            if (((Question)businessObject).getDocumentNumber() != null) {
                String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
                viewHtmlData.setHref(String.format(DOCHANDLER_LINK, workflowUrl, ((Question)businessObject).getDocumentNumber()).replace("&docId", "&readOnly=true&docId"));
            } else {
                viewHtmlData = this.getUrlData(businessObject, "edit", pkNames);
                viewHtmlData.setHref(viewHtmlData.getHref().replace(MAINTENANCE, NEW_MAINTENANCE) + "&readOnly=true");
            }
            viewHtmlData.setDisplayText(VIEW);
            htmlDataList.add((HtmlData)viewHtmlData);
        }
        return htmlDataList;
    }

    public void setQuestionAuthorizationService(QuestionAuthorizationService questionAuthorizationService) {
        this.questionAuthorizationService = questionAuthorizationService;
    }

    public QuestionAuthorizationService getQuestionAuthorizationService() {
        return this.questionAuthorizationService;
    }
}

