/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person.creditsplit;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.propdev.api.person.creditsplit.ProposalPersonCreditSplitContract;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplit;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;

@Entity
@Table(name="EPS_PROP_PER_CREDIT_SPLIT")
@IdClass(value=ProposalPersonCreditSplitId.class)
public final class ProposalPersonCreditSplit
extends KcPersistableBusinessObjectBase
implements CreditSplit,
ProposalPersonCreditSplitContract {
    @Id
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER"), @JoinColumn(name="PROP_PERSON_NUMBER", referencedColumnName="PROP_PERSON_NUMBER")})
    private ProposalPerson proposalPerson;
    @Id
    @Column(name="INV_CREDIT_TYPE_CODE")
    private String invCreditTypeCode;
    @Column(name="CREDIT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal credit;
    @ManyToOne
    @JoinColumn(name="INV_CREDIT_TYPE_CODE", referencedColumnName="INV_CREDIT_TYPE_CODE", insertable=false, updatable=false)
    private InvestigatorCreditType investigatorCreditType;

    public InvestigatorCreditType getInvestigatorCreditType() {
        return this.investigatorCreditType;
    }

    public void setInvestigatorCreditType(InvestigatorCreditType argInvCreditType) {
        this.investigatorCreditType = argInvCreditType;
    }

    public String getProposalNumber() {
        return this.getProposalPerson().getDevelopmentProposal().getProposalNumber();
    }

    public Integer getProposalPersonNumber() {
        return this.getProposalPerson().getProposalPersonNumber();
    }

    @Override
    public String getInvCreditTypeCode() {
        return this.invCreditTypeCode;
    }

    @Override
    public void setInvCreditTypeCode(String argInvCreditTypeCode) {
        this.invCreditTypeCode = argInvCreditTypeCode;
    }

    @Override
    public ScaleTwoDecimal getCredit() {
        return this.credit == null ? ScaleTwoDecimal.ZERO : this.credit;
    }

    @Override
    public void setCredit(ScaleTwoDecimal argCredit) {
        this.credit = argCredit;
    }

    public ProposalPerson getProposalPerson() {
        return this.proposalPerson;
    }

    public void setProposalPerson(ProposalPerson proposalPerson) {
        this.proposalPerson = proposalPerson;
    }

    public static final class ProposalPersonCreditSplitId
    implements Serializable,
    Comparable<ProposalPersonCreditSplitId> {
        private ProposalPerson.ProposalPersonId proposalPerson;
        private String invCreditTypeCode;

        public ProposalPerson.ProposalPersonId getProposalPerson() {
            return this.proposalPerson;
        }

        public void setProposalPerson(ProposalPerson.ProposalPersonId proposalPerson) {
            this.proposalPerson = proposalPerson;
        }

        public String getInvCreditTypeCode() {
            return this.invCreditTypeCode;
        }

        public void setInvCreditTypeCode(String invCreditTypeCode) {
            this.invCreditTypeCode = invCreditTypeCode;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("proposalPerson", (Object)this.proposalPerson).append("invCreditTypeCode", (Object)this.invCreditTypeCode).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalPersonCreditSplitId rhs = (ProposalPersonCreditSplitId)other;
            return new EqualsBuilder().append((Object)this.proposalPerson, (Object)rhs.proposalPerson).append((Object)this.invCreditTypeCode, (Object)rhs.invCreditTypeCode).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.proposalPerson).append((Object)this.invCreditTypeCode).toHashCode();
        }

        @Override
        public int compareTo(ProposalPersonCreditSplitId other) {
            return new CompareToBuilder().append((Object)this.proposalPerson, (Object)other.proposalPerson).append((Object)this.invCreditTypeCode, (Object)other.invCreditTypeCode).toComparison();
        }
    }
}

