/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.VersioningService;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.impl.version.SequenceUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.dao.SubAwardDao;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class SubAwardServiceImpl
implements SubAwardService {
    private static final Logger LOG = LogManager.getLogger(SubAwardServiceImpl.class);
    public static final String SUB_AWARD_CODE = "subAwardCode";
    public static final String SUB_AWARD_SEQUENCE_STATUS = "subAwardSequenceStatus";
    public static final String SUBAWARD_FOLLOW_UP = "Subaward_Follow_Up";
    public static final String AWARD_AWARD_NUMBER = "award.awardNumber";
    private BusinessObjectService businessObjectService;
    private VersioningService versioningService;
    private VersionHistoryService versionHistoryService;
    private DocumentService documentService;
    private SequenceAccessorService sequenceAccessorService;
    private ParameterService parameterService;
    private SubAwardDao subAwardDao;

    @Override
    public SubAwardDocument createNewSubAwardVersion(SubAwardDocument subAwardDocument) throws VersionException, WorkflowException {
        SubAward newVersion = this.getVersioningService().createNewVersion(subAwardDocument.getSubAward());
        this.incrementVersionNumberIfCanceledVersionsExist(newVersion);
        SubAwardDocument newSubAwardDocument = (SubAwardDocument)this.getDocumentService().getNewDocument(SubAwardDocument.class);
        newSubAwardDocument.getDocumentHeader().setDocumentDescription(subAwardDocument.getDocumentHeader().getDocumentDescription());
        newSubAwardDocument.setSubAward(newVersion);
        newVersion.setSubAwardDocument(newSubAwardDocument);
        return newSubAwardDocument;
    }

    protected void incrementVersionNumberIfCanceledVersionsExist(SubAward subAward) {
        Integer sequenceNumber = this.subAwardDao.getNextSequenceNumber(subAward.getSubAwardCode());
        if (!sequenceNumber.equals(subAward.getSequenceNumber())) {
            subAward.setSequenceNumber(sequenceNumber);
            new SequenceUtils().sequenceAssociations(subAward);
        }
    }

    @Override
    public void updateSubAwardSequenceStatus(SubAward subAward, VersionStatus status) {
        if (status.equals((Object)VersionStatus.ACTIVE)) {
            this.archiveCurrentActiveSubAward(subAward.getSubAwardCode());
        }
        subAward.setSubAwardSequenceStatus(status.toString());
        this.getBusinessObjectService().save((PersistableBusinessObject)subAward);
    }

    protected void archiveCurrentActiveSubAward(String subAwardCode) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(SUB_AWARD_CODE, subAwardCode);
        values.put(SUB_AWARD_SEQUENCE_STATUS, VersionStatus.ACTIVE.name());
        List subAwards = this.getBusinessObjectService().findMatching(SubAward.class, values);
        for (SubAward subAward : subAwards) {
            subAward.setSubAwardSequenceStatus(VersionStatus.ARCHIVED.name());
            this.getBusinessObjectService().save((PersistableBusinessObject)subAward);
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public String getNextSubAwardCode() {
        Long nextAwardNumber = this.sequenceAccessorService.getNextAvailableSequenceNumber("SUBAWARD_CODE_S", SubAward.class);
        return nextAwardNumber.toString();
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    protected boolean isCostSplitEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", "Enable_Subaward_DC_IDC");
    }

    @Override
    public SubAward calculateAmountInfo(SubAward subAward) {
        List<SubAwardAmountInfo> subAwardAmountInfoList = subAward.getSubAwardAmountInfoList();
        List<SubAwardAmountReleased> subAwardAmountReleasedList = subAward.getSubAwardAmountReleasedList();
        ScaleTwoDecimal totalAmountReleased = ScaleTwoDecimal.ZERO;
        this.initializeAmounts(subAward);
        if (subAwardAmountInfoList != null && subAwardAmountInfoList.size() > 0) {
            ScaleTwoDecimal obligatedTotalAccum = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal anticipatedTotalAccum = ScaleTwoDecimal.ZERO;
            for (SubAwardAmountInfo subAwardAmountInfo : subAwardAmountInfoList) {
                if (!this.isCostSplitEnabled()) {
                    if (subAwardAmountInfo.getObligatedChange() != null) {
                        obligatedTotalAccum = (ScaleTwoDecimal)obligatedTotalAccum.add((AbstractDecimal)subAwardAmountInfo.getObligatedChange());
                        subAward.setTotalObligatedAmount(obligatedTotalAccum);
                    }
                    if (subAwardAmountInfo.getAnticipatedChange() != null) {
                        anticipatedTotalAccum = (ScaleTwoDecimal)anticipatedTotalAccum.add((AbstractDecimal)subAwardAmountInfo.getAnticipatedChange());
                        subAward.setTotalAnticipatedAmount(anticipatedTotalAccum);
                    }
                } else {
                    if (subAwardAmountInfo.getObligatedChangeDirect() != null) {
                        subAward.setTotalObligatedAmount((ScaleTwoDecimal)subAward.getTotalObligatedAmount().add((AbstractDecimal)subAwardAmountInfo.getObligatedChangeDirect()));
                        subAward.setTotalObligatedDirectAmount((ScaleTwoDecimal)subAward.getTotalObligatedDirectAmount().add((AbstractDecimal)subAwardAmountInfo.getObligatedChangeDirect()));
                    }
                    if (subAwardAmountInfo.getObligatedChangeIndirect() != null) {
                        subAward.setTotalObligatedAmount((ScaleTwoDecimal)subAward.getTotalObligatedAmount().add((AbstractDecimal)subAwardAmountInfo.getObligatedChangeIndirect()));
                        subAward.setTotalObligatedIndirectAmount((ScaleTwoDecimal)subAward.getTotalObligatedIndirectAmount().add((AbstractDecimal)subAwardAmountInfo.getObligatedChangeIndirect()));
                    }
                    if (subAwardAmountInfo.getAnticipatedChangeDirect() != null) {
                        subAward.setTotalAnticipatedAmount((ScaleTwoDecimal)subAward.getTotalAnticipatedAmount().add((AbstractDecimal)subAwardAmountInfo.getAnticipatedChangeDirect()));
                        subAward.setTotalAnticipatedDirectAmount((ScaleTwoDecimal)subAward.getTotalAnticipatedDirectAmount().add((AbstractDecimal)subAwardAmountInfo.getAnticipatedChangeDirect()));
                    }
                    if (subAwardAmountInfo.getAnticipatedChangeIndirect() != null) {
                        subAward.setTotalAnticipatedAmount((ScaleTwoDecimal)subAward.getTotalAnticipatedAmount().add((AbstractDecimal)subAwardAmountInfo.getAnticipatedChangeIndirect()));
                        subAward.setTotalAnticipatedIndirectAmount((ScaleTwoDecimal)subAward.getTotalAnticipatedIndirectAmount().add((AbstractDecimal)subAwardAmountInfo.getAnticipatedChangeIndirect()));
                    }
                }
                if (subAwardAmountInfo.getModificationEffectiveDate() != null) {
                    subAward.setModificationEffectiveDate(subAwardAmountInfo.getModificationEffectiveDate());
                }
                if (subAwardAmountInfo.getModificationID() != null) {
                    subAward.setModificationId(subAwardAmountInfo.getModificationID());
                }
                if (subAwardAmountInfo.getPeriodofPerformanceStartDate() != null) {
                    subAward.setPerformanceStartDate(subAwardAmountInfo.getPeriodofPerformanceStartDate());
                }
                if (subAwardAmountInfo.getPeriodofPerformanceEndDate() != null) {
                    subAward.setPerformanceEnddate(subAwardAmountInfo.getPeriodofPerformanceEndDate());
                }
                subAwardAmountInfo.setObligatedAmount(obligatedTotalAccum);
                subAwardAmountInfo.setAnticipatedAmount(anticipatedTotalAccum);
            }
            for (SubAwardAmountReleased subAwardAmountReleased : subAwardAmountReleasedList) {
                if (subAwardAmountReleased.getAmountReleased() == null || StringUtils.equals((CharSequence)subAwardAmountReleased.getInvoiceStatus(), (CharSequence)DocumentStatus.DISAPPROVED.getCode()) || StringUtils.equals((CharSequence)subAwardAmountReleased.getInvoiceStatus(), (CharSequence)DocumentStatus.CANCELED.getCode()) || StringUtils.equals((CharSequence)subAwardAmountReleased.getInvoiceStatus(), (CharSequence)DocumentStatus.RECALLED.getCode())) continue;
                subAward.setTotalAmountReleased((ScaleTwoDecimal)totalAmountReleased.add((AbstractDecimal)subAwardAmountReleased.getAmountReleased()));
                totalAmountReleased = subAward.getTotalAmountReleased();
            }
        }
        subAward.setTotalAmountReleased(totalAmountReleased);
        subAward.setTotalAvailableAmount((ScaleTwoDecimal)subAward.getTotalObligatedAmount().subtract((AbstractDecimal)totalAmountReleased));
        return subAward;
    }

    public void initializeAmounts(SubAward subAward) {
        subAward.setTotalObligatedAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalObligatedDirectAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalObligatedIndirectAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalAnticipatedAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalAnticipatedDirectAmount(ScaleTwoDecimal.ZERO);
        subAward.setTotalAnticipatedIndirectAmount(ScaleTwoDecimal.ZERO);
    }

    @Override
    public String getFollowupDateDefaultLength() {
        return this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", SUBAWARD_FOLLOW_UP);
    }

    @Override
    public Date getCalculatedFollowupDate(Date baseDate) {
        return new Date(DateUtils.addDays((java.util.Date)baseDate, (int)this.getFollowupDateDefaultLengthInDays()).getTime());
    }

    @Override
    public String getCalculatedFollowupDateForAjaxCall(String baseDate) {
        String empty = "";
        String[] elements = baseDate.split("/");
        if (elements.length == 3) {
            try {
                int month = Integer.parseInt(elements[0]);
                int day = Integer.parseInt(elements[1]);
                int year = Integer.parseInt(elements[2]);
                if (year < 100) {
                    year += 2000;
                }
                Date requestedDate = new Date(year, month - 1, day - 1);
                Date followUpDate = this.getCalculatedFollowupDate(requestedDate);
                return followUpDate.getMonth() + 1 + "/" + (followUpDate.getDate() + 1) + "/" + followUpDate.getYear();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public int getFollowupDateDefaultLengthInDays() {
        int returnAmount;
        String followupDateRange = this.getFollowupDateDefaultLength();
        String rangeUnit = followupDateRange.substring(followupDateRange.length() - 1);
        int rangeAmount = Integer.parseInt(followupDateRange.substring(0, followupDateRange.length() - 1));
        if (StringUtils.equalsIgnoreCase((CharSequence)rangeUnit, (CharSequence)"D")) {
            returnAmount = rangeAmount;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)rangeUnit, (CharSequence)"W")) {
            returnAmount = rangeAmount * 7;
        } else {
            throw new IllegalArgumentException("An invalid range unit was set in the 'Subaward Follow Up' parameter: " + rangeUnit);
        }
        return returnAmount;
    }

    @Override
    public SubAward getActiveSubAward(Long subAwardId) {
        SubAward subAward = (SubAward)this.getBusinessObjectService().findBySinglePrimaryKey(SubAward.class, (Object)subAwardId);
        if (subAward != null) {
            this.calculateAmountInfo(subAward);
        }
        return subAward;
    }

    @Override
    public List<SubAward> getLinkedSubAwards(Award award) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AWARD_AWARD_NUMBER, award.getAwardNumber());
        List subAwardFundingSources = this.businessObjectService.findMatching(SubAwardFundingSource.class, values);
        TreeSet<String> subAwardSet = new TreeSet<String>();
        for (SubAwardFundingSource subAwardFundingSource : subAwardFundingSources) {
            subAwardSet.add(subAwardFundingSource.getSubAward().getSubAwardCode());
        }
        ArrayList<SubAward> subAwards = new ArrayList<SubAward>();
        for (String subAwardCode : subAwardSet) {
            VersionHistory activeVersion = this.getVersionHistoryService().findActiveVersion(SubAward.class, subAwardCode);
            if (activeVersion == null) {
                SubAward pendingSubAward;
                VersionHistory pendingVersion = this.getVersionHistoryService().findPendingVersion(SubAward.class, subAwardCode);
                if (pendingVersion == null || !this.isFundingSourceForAward(pendingSubAward = (SubAward)pendingVersion.getSequenceOwner(), award)) continue;
                subAwards.add(pendingSubAward);
                continue;
            }
            SubAward activeSubAward = (SubAward)activeVersion.getSequenceOwner();
            if (!this.isFundingSourceForAward(activeSubAward, award)) continue;
            subAwards.add(activeSubAward);
        }
        return subAwards;
    }

    protected boolean isFundingSourceForAward(SubAward subAward, Award award) {
        if (subAward == null || award == null) {
            return false;
        }
        if (subAward.getSubAwardFundingSourceList() == null) {
            return false;
        }
        for (SubAwardFundingSource fundingSource : subAward.getSubAwardFundingSourceList()) {
            if (fundingSource == null) continue;
            if (StringUtils.equals((CharSequence)fundingSource.getAwardNumber(), (CharSequence)award.getAwardNumber())) {
                return true;
            }
            if (fundingSource.getAwardId() == null || award.getAwardId() == null || !fundingSource.getAwardId().equals(award.getAwardId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateSubAwardFfataReportingToLatestAmountInfos(SubAward oldSubAward, SubAward newSubAward) {
        HashMap<Integer, SubAwardAmountInfo> amountInfosMap = new HashMap<Integer, SubAwardAmountInfo>();
        for (int i = 0; i < newSubAward.getSubAwardAmountInfoList().size(); ++i) {
            Integer oldSubAwardAmountInfoId = oldSubAward.getSubAwardAmountInfoList().get(i).getSubAwardAmountInfoId();
            SubAwardAmountInfo newSubAwardAmountInfo = newSubAward.getSubAwardAmountInfoList().get(i);
            amountInfosMap.put(oldSubAwardAmountInfoId, newSubAwardAmountInfo);
        }
        newSubAward.getSubAwardFfataReporting().forEach(subAwardFfataReporting -> {
            if (amountInfosMap.containsKey(subAwardFfataReporting.getSubAwardAmountInfoId())) {
                SubAwardAmountInfo subAwardAmountInfo = (SubAwardAmountInfo)amountInfosMap.get(subAwardFfataReporting.getSubAwardAmountInfoId());
                subAwardFfataReporting.setSubAwardAmountInfoId(subAwardAmountInfo.getSubAwardAmountInfoId());
                subAwardFfataReporting.setSubAwardAmountInfo(subAwardAmountInfo);
            }
        });
        this.getBusinessObjectService().save((PersistableBusinessObject)newSubAward);
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    protected VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public SubAwardDao getSubAwardDao() {
        return this.subAwardDao;
    }

    public void setSubAwardDao(SubAwardDao subAwardDao) {
        this.subAwardDao = subAwardDao;
    }
}

