/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.abstrct;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.abstrct.AbstractType;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="abstractTypeValuesFinder")
public class AbstractTypeValuesFinder
extends UifKeyValuesFinderBase {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public List<KeyValue> getKeyValues(ViewModel model, InputField field) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)model;
        String selectedAbstractType = this.getFieldValue(model, field);
        List abstractTypes = this.getDataObjectService().findAll(AbstractType.class).getResults();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        for (AbstractType abstractType : abstractTypes) {
            if (this.hasAbstract(form.getProposalDevelopmentDocument(), abstractType) && !StringUtils.equals((CharSequence)abstractType.getCode(), (CharSequence)selectedAbstractType)) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(abstractType.getCode(), abstractType.getDescription()));
        }
        return keyValues;
    }

    private boolean hasAbstract(ProposalDevelopmentDocument doc, AbstractType abstractType) {
        if (doc != null) {
            List<ProposalAbstract> proposalAbstracts = doc.getDevelopmentProposal().getProposalAbstracts();
            for (ProposalAbstract proposalAbstract : proposalAbstracts) {
                if (!proposalAbstract.getAbstractTypeCode().equals(abstractType.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    private String getFieldValue(ViewModel model, InputField field) {
        if (!StringUtils.startsWith((CharSequence)field.getBindingInfo().getBindingPath(), (CharSequence)"new")) {
            try {
                return (String)PropertyUtils.getNestedProperty((Object)model, (String)field.getBindingInfo().getBindingPath());
            }
            catch (Exception e) {
                throw new RuntimeException("could not retrieve abstract type from the input field", e);
            }
        }
        return "";
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

