/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.rest;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.rest.BadRequestException;
import org.kuali.coeus.sys.framework.rest.DataDictionaryValidationException;
import org.kuali.coeus.sys.framework.rest.NotImplementedException;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.coeus.sys.framework.validation.ErrorMessage;
import org.kuali.coeus.sys.framework.validation.ErrorMessageMap;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public abstract class RestController
implements HandlerExceptionResolver,
Ordered {
    private static final Logger LOG = LogManager.getLogger(RestController.class);
    private int order = 0;
    @Resource(name="restPropertyEditors")
    private Map<Class<?>, ? extends PropertyEditor> restPropertyEditors;

    @InitBinder
    public void initInstantBinder(WebDataBinder binder) {
        this.restPropertyEditors.forEach((arg_0, arg_1) -> ((WebDataBinder)binder).registerCustomEditor(arg_0, arg_1));
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (ex instanceof MethodArgumentNotValidException) {
            return this.validationError(request, response, handler, (MethodArgumentNotValidException)ex);
        }
        if (ex instanceof DataDictionaryValidationException) {
            return this.dataDictionaryValidationError(request, response, handler, (DataDictionaryValidationException)ex);
        }
        if (ex instanceof ResourceNotFoundException) {
            return this.resourceNotFoundError(request, response, handler, (ResourceNotFoundException)ex);
        }
        if (ex instanceof UnauthorizedAccessException) {
            return this.unauthorizedError(request, response, handler, (UnauthorizedAccessException)ex);
        }
        if (ex instanceof UnprocessableEntityException) {
            return this.unprocessableEntityError(request, response, handler, (UnprocessableEntityException)ex);
        }
        if (ex instanceof BadRequestException) {
            return this.badRequestError(request, response, handler, (BadRequestException)ex);
        }
        if (ex instanceof NotImplementedException) {
            return this.notImplementedError(request, response, handler, ex);
        }
        return this.unrecognizedException(request, response, handler, ex);
    }

    protected ModelAndView validationError(HttpServletRequest request, HttpServletResponse response, Object handler, MethodArgumentNotValidException ex) {
        String error;
        List fieldErrors = ex.getBindingResult().getFieldErrors();
        List globalErrors = ex.getBindingResult().getGlobalErrors();
        ArrayList<String> errors = new ArrayList<String>(fieldErrors.size() + globalErrors.size());
        for (FieldError fieldError : fieldErrors) {
            error = fieldError.getField() + ", " + fieldError.getDefaultMessage();
            errors.add(error);
        }
        for (ObjectError objectError : globalErrors) {
            error = objectError.getObjectName() + ", " + objectError.getDefaultMessage();
            errors.add(error);
        }
        return this.createJsonModelAndView(HttpStatus.BAD_REQUEST.value(), new ErrorMessage(errors), response);
    }

    protected ModelAndView createJsonModelAndView(int status, Object model, HttpServletResponse response) {
        response.setStatus(status);
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        return new ModelAndView((View)view, "Error", model);
    }

    protected ModelAndView dataDictionaryValidationError(HttpServletRequest request, HttpServletResponse response, Object handler, DataDictionaryValidationException ex) {
        return this.createJsonModelAndView(HttpStatus.UNPROCESSABLE_ENTITY.value(), new ErrorMessageMap(ex.getErrors()), response);
    }

    protected ModelAndView resourceNotFoundError(HttpServletRequest request, HttpServletResponse response, Object handler, ResourceNotFoundException ex) {
        return this.createJsonModelAndView(HttpStatus.NOT_FOUND.value(), this.generateSingleErrorFromExceptionMessage(ex), response);
    }

    protected ModelAndView unprocessableEntityError(HttpServletRequest request, HttpServletResponse response, Object handler, UnprocessableEntityException ex) {
        if (ex.getCause() != null) {
            LOG.info(ex.getMessage(), (Throwable)ex);
        }
        return this.createJsonModelAndView(HttpStatus.UNPROCESSABLE_ENTITY.value(), this.generateSingleErrorFromExceptionMessage(ex), response);
    }

    protected ModelAndView badRequestError(HttpServletRequest request, HttpServletResponse response, Object handler, BadRequestException ex) {
        return this.createJsonModelAndView(HttpStatus.BAD_REQUEST.value(), this.generateSingleErrorFromExceptionMessage(ex), response);
    }

    protected ModelAndView unauthorizedError(HttpServletRequest request, HttpServletResponse response, Object handler, UnauthorizedAccessException ex) {
        return this.createJsonModelAndView(HttpStatus.UNAUTHORIZED.value(), this.generateSingleErrorFromExceptionMessage(ex), response);
    }

    protected ErrorMessage generateSingleErrorFromExceptionMessage(Throwable ex) {
        return new ErrorMessage(Collections.singletonList(StringUtils.isNotBlank((CharSequence)ex.getMessage()) ? ex.getMessage() : "Unknown Error: " + ex.getClass().getName()));
    }

    protected ModelAndView unrecognizedException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        ErrorMessage exceptionMessage = this.generateSingleErrorFromExceptionMessage(ExceptionUtils.getRootCause((Throwable)ex));
        return this.createJsonModelAndView(HttpStatus.INTERNAL_SERVER_ERROR.value(), exceptionMessage, response);
    }

    protected ModelAndView notImplementedError(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        return this.createJsonModelAndView(HttpStatus.NOT_IMPLEMENTED.value(), this.generateSingleErrorFromExceptionMessage(ex), response);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Map<Class<?>, ? extends PropertyEditor> getRestPropertyEditors() {
        return this.restPropertyEditors;
    }

    public void setRestPropertyEditors(Map<Class<?>, ? extends PropertyEditor> restPropertyEditors) {
        this.restPropertyEditors = restPropertyEditors;
    }
}

