/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.auth.AuthUser;
import org.kuali.coeus.sys.framework.auth.CoreGroupsService;
import org.kuali.coeus.sys.framework.auth.CoreUserPushService;
import org.kuali.coeus.sys.framework.auth.CoreUsersPushStatus;
import org.kuali.coeus.sys.framework.auth.GroupDto;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.coeus.sys.impl.auth.CoreStreamingService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

public abstract class AbstractCoreUserPushService<T>
implements CoreUserPushService {
    private static final String INCLUDE_INACTIVE_PARAM = "includeInactive";
    private static final Logger LOG = LogManager.getLogger(AbstractCoreUserPushService.class);
    private static final String AUTH_USER_PUSH_USE_DEV_PASSWORD = "auth.user.push.use.dev.password";
    private static final String AUTH_USER_PUSH_DEV_PASSWORD = "auth.user.push.dev.password";
    private static final String PUSH_INACTIVE_NEW_USERS = "Push_Inactive_New_Users";
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="coreGroupsService")
    private CoreGroupsService coreGroupsService;
    @Autowired
    @Qualifier(value="coreStreamingService")
    private CoreStreamingService coreStreamingService;

    protected abstract List<T> getAllPeople();

    protected abstract AuthUser generateAuthUserFromPerson(T var1, Map<String, String> var2);

    protected abstract boolean validUserToPush(T var1);

    @Override
    public CoreUsersPushStatus pushAllUsers() {
        return this.pushAllUsers(() -> true);
    }

    @Override
    public CoreUsersPushStatus pushAllUsers(Supplier<Boolean> shouldContinueRunning) {
        CoreUsersPushStatus status = new CoreUsersPushStatus();
        Map<String, String> groupIdByUnitNumber = this.coreGroupsService.getAllGroups().filter(g -> StringUtils.isNotBlank((CharSequence)this.coreGroupsService.getUnitNumberForGroup((GroupDto)g))).collect(Collectors.toMap(g -> this.coreGroupsService.getUnitNumberForGroup((GroupDto)g), GroupDto::getId));
        LOG.info("Found {} groups for {}", (Object)groupIdByUnitNumber.size(), (Object)this.getClass().getSimpleName());
        Map peopleToSync = this.getAllPeople().stream().filter(this::validUserToPush).map(person -> this.generateAuthUserFromPerson(person, groupIdByUnitNumber)).collect(Collectors.toMap(u -> StringUtils.lowerCase((String)u.getUsername()), Function.identity(), (v1, v2) -> v1));
        Map peopleBySchoolId = peopleToSync.values().stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getSchoolId())).collect(Collectors.toMap(u -> StringUtils.lowerCase((String)u.getSchoolId()), Function.identity(), (v1, v2) -> v1));
        Map peopleByEmail = peopleToSync.values().stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getEmail())).collect(Collectors.toMap(u -> StringUtils.lowerCase((String)u.getEmail()), Function.identity(), (v1, v2) -> v1));
        List authServiceUsers = this.getAllAuthServiceUsers().takeWhile(authServicePerson -> (Boolean)shouldContinueRunning.get()).collect(Collectors.toList());
        Set existingUsernames = authServiceUsers.stream().map(AuthUser::getUsername).filter(StringUtils::isNotBlank).map(StringUtils::lowerCase).collect(Collectors.toSet());
        Set existingSchoolIds = authServiceUsers.stream().map(AuthUser::getSchoolId).filter(StringUtils::isNotBlank).map(StringUtils::lowerCase).collect(Collectors.toSet());
        Set existingEmails = authServiceUsers.stream().map(AuthUser::getEmail).filter(StringUtils::isNotBlank).map(StringUtils::lowerCase).collect(Collectors.toSet());
        LOG.info("Syncing {} users to auth service for {}", (Object)peopleToSync.size(), (Object)this.getClass().getSimpleName());
        status.setNumberOfUsers(peopleToSync.size());
        for (AuthUser authServicePerson2 : authServiceUsers) {
            String message;
            String emailKey;
            AuthUser matchedByEmail;
            String schoolKey;
            if (!shouldContinueRunning.get().booleanValue()) break;
            String authUsernameKey = StringUtils.lowerCase((String)authServicePerson2.getUsername());
            existingUsernames.add(authUsernameKey);
            if (StringUtils.isNotBlank((CharSequence)authServicePerson2.getSchoolId())) {
                existingSchoolIds.add(StringUtils.lowerCase((String)authServicePerson2.getSchoolId()));
            }
            if (StringUtils.isNotBlank((CharSequence)authServicePerson2.getEmail())) {
                existingEmails.add(StringUtils.lowerCase((String)authServicePerson2.getEmail()));
            }
            AuthUser person2 = null;
            if (StringUtils.isNotBlank((CharSequence)authServicePerson2.getSchoolId()) && (person2 = (AuthUser)peopleBySchoolId.remove(schoolKey = StringUtils.lowerCase((String)authServicePerson2.getSchoolId()))) != null) {
                peopleToSync.remove(StringUtils.lowerCase((String)person2.getUsername()));
                if (StringUtils.isNotBlank((CharSequence)person2.getEmail())) {
                    peopleByEmail.remove(StringUtils.lowerCase((String)person2.getEmail()));
                }
            }
            if (person2 == null && (person2 = (AuthUser)peopleToSync.remove(authUsernameKey)) != null) {
                if (StringUtils.isNotBlank((CharSequence)person2.getSchoolId())) {
                    peopleBySchoolId.remove(StringUtils.lowerCase((String)person2.getSchoolId()));
                }
                if (StringUtils.isNotBlank((CharSequence)person2.getEmail())) {
                    peopleByEmail.remove(StringUtils.lowerCase((String)person2.getEmail()));
                }
            }
            boolean duplicateConflict = false;
            if (person2 == null && StringUtils.isNotBlank((CharSequence)authServicePerson2.getEmail()) && (matchedByEmail = (AuthUser)peopleByEmail.remove(emailKey = StringUtils.lowerCase((String)authServicePerson2.getEmail()))) != null) {
                peopleToSync.remove(StringUtils.lowerCase((String)matchedByEmail.getUsername()));
                if (StringUtils.isNotBlank((CharSequence)matchedByEmail.getSchoolId())) {
                    peopleBySchoolId.remove(StringUtils.lowerCase((String)matchedByEmail.getSchoolId()));
                }
                if (StringUtils.isNotBlank((CharSequence)matchedByEmail.getSchoolId()) && StringUtils.isNotBlank((CharSequence)authServicePerson2.getSchoolId()) && !StringUtils.equalsIgnoreCase((CharSequence)matchedByEmail.getSchoolId(), (CharSequence)authServicePerson2.getSchoolId())) {
                    String message2 = "Duplicate email detected for different schoolId: " + matchedByEmail.getEmail();
                    status.getErrors().put(authServicePerson2.getUsername(), message2);
                    LOG.error(message2);
                    duplicateConflict = true;
                } else {
                    person2 = matchedByEmail;
                }
            }
            if (duplicateConflict) continue;
            try {
                if (person2 == null) {
                    status.addNumberNotFoundLocally();
                    continue;
                }
                if (!person2.isActive() && authServicePerson2.isActive()) {
                    this.disableUserInAuthService(authServicePerson2);
                    status.addNumberRemoved();
                    continue;
                }
                if (authServicePerson2.equals(person2)) {
                    status.addNumberSame();
                    continue;
                }
                if (Objects.equals(person2.getSchoolId(), authServicePerson2.getSchoolId())) {
                    person2.setRole(authServicePerson2.getRole());
                    this.updateUserInAuthService(person2, authServicePerson2.getId());
                    status.addNumberUpdated();
                    existingUsernames.add(StringUtils.lowerCase((String)person2.getUsername()));
                    if (StringUtils.isNotBlank((CharSequence)person2.getSchoolId())) {
                        existingSchoolIds.add(StringUtils.lowerCase((String)person2.getSchoolId()));
                    }
                    if (!StringUtils.isNotBlank((CharSequence)person2.getEmail())) continue;
                    existingEmails.add(StringUtils.lowerCase((String)person2.getEmail()));
                    continue;
                }
                String message3 = "Error updating user, updated schoolId detected for user with username " + person2.getUsername();
                status.getErrors().put(authServicePerson2.getUsername(), message3);
                LOG.error(message3);
            }
            catch (HttpClientErrorException | HttpServerErrorException e) {
                message = "Error disabling or updating user " + authServicePerson2.getUsername() + ":" + authServicePerson2.getSchoolId() + " to auth service - " + e.getMessage() + " -- " + e.getResponseBodyAsString();
                status.getErrors().put(authServicePerson2.getUsername(), message);
                LOG.error(message);
            }
            catch (Exception e) {
                message = "Error disabling or updating user " + authServicePerson2.getUsername() + ":" + authServicePerson2.getSchoolId() + " to auth service";
                status.getErrors().put(authServicePerson2.getUsername(), message);
                LOG.error(message, (Throwable)e);
            }
        }
        peopleToSync.values().stream().takeWhile(authServicePerson -> (Boolean)shouldContinueRunning.get()).forEach(personToAdd -> {
            try {
                String emailKey;
                String usernameKey = StringUtils.lowerCase((String)personToAdd.getUsername());
                String schoolKey = StringUtils.isNotBlank((CharSequence)personToAdd.getSchoolId()) ? StringUtils.lowerCase((String)personToAdd.getSchoolId()) : null;
                String string = emailKey = StringUtils.isNotBlank((CharSequence)personToAdd.getEmail()) ? StringUtils.lowerCase((String)personToAdd.getEmail()) : null;
                if (existingUsernames.contains(usernameKey)) {
                    String message = "Duplicate username detected: " + personToAdd.getUsername();
                    status.getErrors().put(personToAdd.getUsername(), message);
                    LOG.error(message);
                    return;
                }
                if (schoolKey != null && existingSchoolIds.contains(schoolKey)) {
                    String message = "Duplicate schoolId detected: " + personToAdd.getSchoolId();
                    status.getErrors().put(personToAdd.getUsername(), message);
                    LOG.error(message);
                    return;
                }
                if (emailKey != null && existingEmails.contains(emailKey)) {
                    String message = "Duplicate email detected: " + personToAdd.getEmail();
                    status.getErrors().put(personToAdd.getUsername(), message);
                    LOG.error(message);
                    return;
                }
                if (personToAdd.isActive() || this.pushInactiveNewUsers()) {
                    this.addUserToAuthService((AuthUser)personToAdd, this.getOrGenerateUserPassword((AuthUser)personToAdd));
                    status.addNumberAdded();
                    existingUsernames.add(usernameKey);
                    if (schoolKey != null) {
                        existingSchoolIds.add(schoolKey);
                    }
                    if (emailKey != null) {
                        existingEmails.add(emailKey);
                    }
                } else {
                    status.addNumberInactiveNotAdded();
                }
            }
            catch (HttpClientErrorException | HttpServerErrorException e) {
                String message = "Error adding user " + personToAdd.getUsername() + ":" + personToAdd.getSchoolId() + " to auth service - " + e.getMessage() + " -- " + e.getResponseBodyAsString();
                status.getErrors().put(personToAdd.getUsername(), message);
                LOG.error(message);
            }
            catch (Exception e) {
                String message = "Error adding user " + personToAdd.getUsername() + ":" + personToAdd.getSchoolId() + " to auth service";
                status.getErrors().put(personToAdd.getUsername(), message);
                LOG.error(message, (Throwable)e);
            }
        });
        StringBuilder infoMsg = new StringBuilder();
        infoMsg.append("Auth Service Bulk Push: Users Found: ").append(Integer.valueOf(status.getNumberOfUsers()).toString()).append(", Users Added: ").append(Integer.valueOf(status.getNumberAdded()).toString()).append(", Users Not Found Locally: ").append(Integer.valueOf(status.getNumberNotFoundLocally()).toString()).append(", Users Inactive Not Added: ").append(Integer.valueOf(status.getNumberInactiveNotAdded()).toString()).append(", Users Updated: ").append(Integer.valueOf(status.getNumberUpdated()).toString()).append(", Users Deleted: ").append(Integer.valueOf(status.getNumberRemoved()).toString()).append(", Users Errored: ").append(Integer.valueOf(status.getErrors().size()).toString());
        LOG.info(infoMsg.toString());
        return status;
    }

    protected String getOrGenerateUserPassword(AuthUser person) {
        if (this.useDevPassword()) {
            return this.getDevPassword();
        }
        return UUID.randomUUID().toString();
    }

    protected boolean useDevPassword() {
        return this.configurationService.getPropertyValueAsBoolean(AUTH_USER_PUSH_USE_DEV_PASSWORD);
    }

    protected String getDevPassword() {
        return this.configurationService.getPropertyValueAsString(AUTH_USER_PUSH_DEV_PASSWORD);
    }

    protected Stream<AuthUser> getAllAuthServiceUsers() {
        return this.getCoreStreamingService().streamAll(this.getUsersApiUrl(), Map.of(INCLUDE_INACTIVE_PARAM, Boolean.TRUE), AuthUser.class);
    }

    protected void addUserToAuthService(AuthUser newUser, String userPassword) {
        newUser.setPassword(userPassword);
        ResponseEntity result = this.restOperations.exchange(this.getUsersApiUrl(), HttpMethod.POST, new HttpEntity((Object)newUser, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.CREATED) {
            String body = (String)result.getBody();
            throw new RestClientException((String)(body != null ? body : "Failed to create user in auth service: " + newUser.getUsername() + ":" + newUser.getSchoolId()));
        }
    }

    protected void updateUserInAuthService(AuthUser updatedUser, String userId) {
        ResponseEntity result = this.restOperations.exchange(this.getUsersApiUrl() + userId, HttpMethod.PUT, new HttpEntity((Object)updatedUser, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.OK) {
            String body = (String)result.getBody();
            throw new RestClientException((String)(body != null ? body : "Failed to update user in auth service: " + updatedUser.getUsername() + ":" + updatedUser.getSchoolId()));
        }
    }

    protected void disableUserInAuthService(AuthUser disabledUser) {
        disabledUser.setActive(false);
        ResponseEntity result = this.restOperations.exchange(this.getUsersApiUrl() + disabledUser.getId(), HttpMethod.PUT, new HttpEntity((Object)disabledUser, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), String.class, new Object[0]);
        if (result.getStatusCode() != HttpStatus.OK) {
            String body = (String)result.getBody();
            throw new RestClientException((String)(body != null ? body : "Failed to disable user in auth service: " + disabledUser.getUsername() + ":" + disabledUser.getSchoolId()));
        }
    }

    protected boolean pushInactiveNewUsers() {
        return this.parameterService.getParameterValueAsBoolean("KC-SYS", "All", PUSH_INACTIVE_NEW_USERS);
    }

    protected String getUsersApiUrl() {
        return this.configurationService.getPropertyValueAsString("auth.users.url") + "/";
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public CoreGroupsService getCoreGroupsService() {
        return this.coreGroupsService;
    }

    public void setCoreGroupsService(CoreGroupsService coreGroupsService) {
        this.coreGroupsService = coreGroupsService;
    }

    public CoreStreamingService getCoreStreamingService() {
        return this.coreStreamingService;
    }

    public void setCoreStreamingService(CoreStreamingService coreStreamingService) {
        this.coreStreamingService = coreStreamingService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

