/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.person;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.excon.project.ExconProjectPersonRoleType;
import org.kuali.kra.excon.project.service.ExconProjectService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ExconPersonnelDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static final Logger LOG = LogManager.getLogger(ExconPersonnelDerivedRoleTypeServiceImpl.class);
    private static final String PROJECT_PERSON_ROLE_TYPE_CODE = "projectPersonRoleTypeCode";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="exconProjectService")
    private ExconProjectService exconProjectService;

    protected List<String> getRequiredAttributes() {
        return List.of("exportControl");
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        ExconProjectPersonRoleType personRoleType = (ExconProjectPersonRoleType)this.businessObjectService.findBySinglePrimaryKey(ExconProjectPersonRoleType.class, (Object)roleName);
        if (personRoleType == null) {
            LOG.warn(String.format("No Export Control project person type %s found", roleName));
            return List.of();
        }
        return Optional.ofNullable(qualification.get("exportControl")).map(this::mapStringToLong).map(this.exconProjectService::getExconProject).map(project -> project.getExconProjectPersons().stream().filter(person -> personRoleType.getProjectPersonRoleTypeCode().equals(person.getRoleTypeCode())).map(person -> RoleMembership.Builder.create(null, null, (String)person.getPerson().getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build()).collect(Collectors.toList())).orElse(List.of());
    }

    protected Long mapStringToLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        return true;
    }

    public void setExconProjectService(ExconProjectService exconProjectService) {
        this.exconProjectService = exconProjectService;
    }
}

