/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.pdf;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.pdf.CommonPdfService;
import org.kuali.coeus.common.api.pdf.PdfService;
import org.kuali.coeus.common.api.pdf.dto.ActionDto;
import org.kuali.coeus.common.api.pdf.dto.JobDto;
import org.kuali.coeus.common.api.pdf.dto.LinkDto;
import org.kuali.coeus.common.api.pdf.dto.SingleTargetAction;
import org.kuali.coeus.common.api.pdf.dto.Status;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.pdf.forms.PdfForms;
import org.kuali.coeus.common.framework.pdf.forms.PdfFormsService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component(value="commonPdfService")
public class CommonPdfServiceImpl
implements CommonPdfService {
    private static final Logger LOG = LogManager.getLogger(CommonPdfServiceImpl.class);
    private static final String APPLICATION_URL = "application.url";
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;
    @Autowired
    @Qualifier(value="pdfFormsService")
    private PdfFormsService pdfFormsService;
    @Autowired
    @Qualifier(value="pdfService")
    private PdfService pdfService;

    @Override
    public LinkDto createTopUnit() {
        return new LinkDto().url(this.getApplicationUrl() + "/research-common/api/v1/units/top-unit").method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken()).addHeader("Content-Type", "application/json");
    }

    @Override
    public String getApplicationUrl() {
        return this.configurationService.getPropertyValueAsString(APPLICATION_URL);
    }

    @Override
    public String getAuthToken() {
        return "Bearer " + this.getJwtService().createToken();
    }

    @Override
    public LinkDto createPdfFormLink(AttachmentFile pdf) {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/file-data/" + pdf.getFileDataId()).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken());
    }

    @Override
    public List<AttachmentDataSource> submit(List<String> selectedForms, BiFunction<PdfForms, JobDto, String> addAction) {
        try {
            JobDto job = new JobDto();
            Map<String, PdfForms> actionIdToForms = selectedForms.stream().map(this.getPdfFormsService()::byId).map(form -> CollectionUtils.entry((String)addAction.apply((PdfForms)form, job), form)).collect(CollectionUtils.entriesToMap());
            JobDto response = this.getPdfService().submitAndAwaitJob(job);
            return this.extractResponse(response, actionIdToForms);
        }
        catch (PrintingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new PrintingException(e);
        }
    }

    private List<AttachmentDataSource> extractResponse(JobDto response, Map<String, PdfForms> actionIdToForms) {
        if (response.getStatus() != Status.SUCCESS) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)response);
            }
            throw new PrintingException("Pdf failed to process (Job " + response.getJobId() + ")");
        }
        return actionIdToForms.entrySet().stream().map(entry -> {
            try {
                PrintableAttachment pdf = new PrintableAttachment();
                URL targetUrl = new URL(this.findActionUrl((String)entry.getKey(), response.getActions()));
                pdf.setData(IOUtils.toByteArray((URL)targetUrl));
                pdf.setName(((PdfForms)entry.getValue()).getPdfFormFile().getFileName());
                pdf.setType(((PdfForms)entry.getValue()).getPdfFormFile().getContentType());
                return pdf;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public LinkDto createMappingsLink(AttachmentFile mapping) {
        return new LinkDto().url(this.configurationService.getPropertyValueAsString(APPLICATION_URL) + "/research-common/api/v1/file-data/" + mapping.getFileDataId()).method(HttpMethod.GET.name()).addHeader("Authorization", this.getAuthToken());
    }

    private String findActionUrl(String actionId, List<? extends ActionDto<?>> actions) {
        return actions.stream().filter(a -> a.getActionId().equals(actionId)).map(a -> (SingleTargetAction)((Object)a)).map(a -> a.getTarget().getUrl()).findFirst().orElseThrow();
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    public PdfFormsService getPdfFormsService() {
        return this.pdfFormsService;
    }

    public void setPdfFormsService(PdfFormsService pdfFormsService) {
        this.pdfFormsService = pdfFormsService;
    }

    public PdfService getPdfService() {
        return this.pdfService;
    }

    public void setPdfService(PdfService pdfService) {
        this.pdfService = pdfService;
    }
}

