/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.coeus.common.framework.person.PropAwardPersonRoleService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="propAwardPersonRoleService")
public class PropAwardPersonRoleServiceImpl
implements PropAwardPersonRoleService {
    public static final String SPONSOR_HIERARCHIES_PARM = "PERSON_ROLE_SPONSOR_HIERARCHIES";
    public static final String NIH_MULTIPLE_PI_HIERARCHY = "NIH Multiple PI";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public PropAwardPersonRole getRole(String roleCode, String sponsorCode) {
        if (StringUtils.isBlank((CharSequence)roleCode)) {
            throw new IllegalArgumentException("The roleCode cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)sponsorCode)) {
            throw new IllegalArgumentException("The sponsorCode cannot be blank");
        }
        String hierarchyName = this.getSponsorHierarchy(sponsorCode);
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)"code", (Object)roleCode), PredicateFactory.equal((String)"sponsorHierarchyName", (Object)hierarchyName)});
        return (PropAwardPersonRole)this.getDataObjectService().findUnique(PropAwardPersonRole.class, criteria.build());
    }

    @Override
    public Collection<PropAwardPersonRole> getRolesByHierarchy(String sponsorCode) {
        if (StringUtils.isBlank((CharSequence)sponsorCode)) {
            throw new IllegalArgumentException("The sponsorCode cannot be blank");
        }
        String hierarchyName = this.getSponsorHierarchy(sponsorCode);
        return this.getDataObjectService().findMatching(PropAwardPersonRole.class, QueryByCriteria.Builder.forAttribute((String)"sponsorHierarchyName", (Object)hierarchyName).build()).getResults();
    }

    @Override
    public String getSponsorHierarchy(String sponsorCode) {
        if (this.areAllSponsorsMultiPi().booleanValue()) {
            return NIH_MULTIPLE_PI_HIERARCHY;
        }
        for (String hierarchyName : this.getRoleHierarchies()) {
            if (!this.getSponsorHierarchyService().isSponsorInHierarchy(sponsorCode, hierarchyName)) continue;
            return hierarchyName;
        }
        return "DEFAULT";
    }

    @Override
    public Boolean areAllSponsorsMultiPi() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "ALL_SPONSOR_HIERARCHY_AS_NIH");
    }

    protected Collection<String> getRoleHierarchies() {
        return this.getParameterService().getParameterValuesAsString("KC-GEN", "All", SPONSOR_HIERARCHIES_PARM);
    }

    protected DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    protected SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

