/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.docperm;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.docperm.PermissionsRule;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.util.ObjectUtils;

public class AddProposalUserEvent
extends KcDocumentEventBase {
    private static final Logger LOG = LogManager.getLogger(AddProposalUserEvent.class);
    private ProposalUserRoles proposalUserRoles;
    private List<ProposalUserRoles> list;

    public AddProposalUserEvent(ProposalDevelopmentDocument document, List<ProposalUserRoles> list, ProposalUserRoles proposalUserRoles) {
        super("adding proposal user to document " + AddProposalUserEvent.getDocumentId((Document)document), "", document);
        this.list = list;
        this.proposalUserRoles = (ProposalUserRoles)ObjectUtils.deepCopy((Serializable)proposalUserRoles);
        this.logEvent();
    }

    public void validate() {
        super.validate();
        if (this.proposalUserRoles == null) {
            throw new IllegalArgumentException("invalid (null) proposal user");
        }
    }

    @Override
    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)((Object)((Object)this)).getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.proposalUserRoles == null) {
            logMessage.append("null proposalUser");
        } else {
            logMessage.append(this.proposalUserRoles.toString());
        }
        LOG.debug((CharSequence)logMessage);
    }

    public Class getRuleInterfaceClass() {
        return PermissionsRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((PermissionsRule)rule).processAddProposalUserBusinessRules((ProposalDevelopmentDocument)this.getDocument(), this.list, this.proposalUserRoles);
    }
}

