/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.coeus.common.framework.person.PropAwardPersonRoleService;
import org.kuali.coeus.common.framework.person.attr.CitizenshipType;
import org.kuali.coeus.common.framework.person.attr.PersonTraining;
import org.kuali.coeus.common.framework.person.editable.PersonEditable;
import org.kuali.coeus.common.framework.rolodex.PersonRolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsorable;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.impl.auth.perm.ProposalDevelopmentPermissionsService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.propdev.impl.person.ProposalInvestigatorCertification;
import org.kuali.coeus.propdev.impl.person.ProposalPersonCertificationDetails;
import org.kuali.coeus.propdev.impl.person.ProposalPersonDegree;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.ProposalPersonYnq;
import org.kuali.coeus.propdev.impl.person.creditsplit.NamedCreditSplitable;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalPersonCreditSplit;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonQuestionnaireHelper;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="EPS_PROP_PERSON")
@IdClass(value=ProposalPersonId.class)
public class ProposalPerson
extends KcPersistableBusinessObjectBase
implements NamedCreditSplitable,
PersonRolodex,
PersonEditable,
AbstractPersonRoleAware,
ProposalPersonContract,
HierarchyMaintainable,
MutableInactivatable {
    private static final long serialVersionUID = -4110005875629288373L;
    @Id
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER")
    private DevelopmentProposal developmentProposal;
    @Column(name="CAN_PASSIVELY_DISCLOSE_COIS")
    @Convert(converter=BooleanYNConverter.class)
    private boolean canPassivelyDiscloseCois;
    @Deprecated
    @Column(name="CONFLICT_OF_INTEREST_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private boolean conflictOfInterestFlag;
    @Column(name="IS_OSC")
    @Convert(converter=BooleanYNConverter.class)
    private boolean otherSignificantContributorFlag;
    @Column(name="PERCENTAGE_EFFORT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal percentageEffort;
    @Column(name="FEDR_DEBR_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean fedrDebrFlag;
    @Column(name="FEDR_DELQ_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean fedrDelqFlag;
    @Column(name="ADD_CREDIT_SPLIT")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean includeInCreditAllocation;
    @Column(name="ROLODEX_ID")
    private Integer rolodexId;
    @Id
    @Column(name="PROP_PERSON_NUMBER")
    private Integer proposalPersonNumber;
    @Column(name="PROP_PERSON_ROLE_ID")
    private String proposalPersonRoleId;
    @Column(name="LAST_NOTIFICATION")
    private Timestamp lastNotification;
    @OneToOne(cascade={CascadeType.REFRESH})
    @PrimaryKeyJoinColumns(value={@PrimaryKeyJoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER"), @PrimaryKeyJoinColumn(name="PROP_PERSON_NUMBER", referencedColumnName="PROP_PERSON_NUMBER")})
    private ProposalInvestigatorCertification certification;
    @Transient
    private boolean delete;
    @Transient
    private boolean roleChanged;
    @OneToMany(mappedBy="proposalPerson", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="questionId")
    private List<ProposalPersonYnq> proposalPersonYnqs;
    @OneToMany(mappedBy="proposalPerson", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ProposalPersonUnit> units;
    @OneToMany(mappedBy="proposalPerson", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ProposalPersonDegree> proposalPersonDegrees;
    @OneToMany(mappedBy="proposalPerson", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<ProposalPersonCreditSplit> creditSplits;
    @OneToOne(cascade={CascadeType.REFRESH})
    @PrimaryKeyJoinColumns(value={@PrimaryKeyJoinColumn(name="PROPOSAL_NUMBER", referencedColumnName="PROPOSAL_NUMBER"), @PrimaryKeyJoinColumn(name="PROP_PERSON_NUMBER", referencedColumnName="PROP_PERSON_NUMBER")})
    private ProposalPersonCertificationDetails certificationDetails;
    @Transient
    private List<PersonTraining> personTrainings;
    @Transient
    private String simpleName;
    @Column(name="OPT_IN_UNIT_STATUS")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean optInUnitStatus = Boolean.FALSE;
    @Column(name="OPT_IN_CERTIFICATION_STATUS")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean optInCertificationStatus = Boolean.FALSE;
    @Transient
    private boolean unitdelete;
    @Column(name="PROJECT_ROLE")
    private String projectRole;
    @Column(name="ORDINAL_POSITION")
    private Integer ordinalPosition;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;
    @Column(name="PERSON_ID")
    private String personId;
    @Column(name="SSN")
    private String socialSecurityNumber;
    @Column(name="LAST_NAME")
    private String lastName;
    @Column(name="FIRST_NAME")
    private String firstName;
    @Column(name="MIDDLE_NAME")
    private String middleName;
    @Column(name="FULL_NAME")
    private String fullName;
    @Column(name="PRIOR_NAME")
    private String priorName;
    @Column(name="USER_NAME")
    private String userName;
    @Column(name="EMAIL_ADDRESS")
    private String emailAddress;
    @Column(name="DATE_OF_BIRTH")
    private Date dateOfBirth;
    @Column(name="AGE")
    private Integer age;
    @Column(name="AGE_BY_FISCAL_YEAR")
    private Integer ageByFiscalYear;
    @Column(name="GENDER")
    private String gender;
    @Column(name="RACE")
    private String race;
    @Column(name="EDUCATION_LEVEL")
    private String educationLevel;
    @Column(name="DEGREE")
    private String degree;
    @Column(name="MAJOR")
    private String major;
    @Column(name="IS_HANDICAPPED")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean handicappedFlag;
    @Column(name="HANDICAP_TYPE")
    private String handicapType;
    @Column(name="IS_VETERAN")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean veteranFlag;
    @Column(name="VETERAN_TYPE")
    private String veteranType;
    @Column(name="VISA_CODE")
    private String visaCode;
    @Column(name="VISA_TYPE")
    private String visaType;
    @Column(name="VISA_RENEWAL_DATE")
    private Date visaRenewalDate;
    @Column(name="HAS_VISA")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean hasVisa;
    @Column(name="OFFICE_LOCATION")
    private String officeLocation;
    @Column(name="OFFICE_PHONE")
    private String officePhone;
    @Column(name="SECONDRY_OFFICE_LOCATION")
    private String secondaryOfficeLocation;
    @Column(name="SECONDRY_OFFICE_PHONE")
    private String secondaryOfficePhone;
    @Column(name="SCHOOL")
    private String school;
    @Column(name="YEAR_GRADUATED")
    private String yearGraduated;
    @Column(name="DIRECTORY_DEPARTMENT")
    private String directoryDepartment;
    @Column(name="SALUTATION")
    private String saluation;
    @Column(name="COUNTRY_OF_CITIZENSHIP")
    private String countryOfCitizenship;
    @Column(name="PRIMARY_TITLE")
    private String primaryTitle;
    @Column(name="DIRECTORY_TITLE")
    private String directoryTitle;
    @Column(name="HOME_UNIT")
    private String homeUnit;
    @Column(name="IS_FACULTY")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean facultyFlag;
    @Column(name="IS_GRADUATE_STUDENT_STAFF")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean graduateStudentStaffFlag;
    @Column(name="IS_RESEARCH_STAFF")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean researchStaffFlag;
    @Column(name="IS_SERVICE_STAFF")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean serviceStaffFlag;
    @Column(name="IS_SUPPORT_STAFF")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean supportStaffFlag;
    @Column(name="IS_OTHER_ACCADEMIC_GROUP")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean otherAcademicGroupFlag;
    @Column(name="IS_MEDICAL_STAFF")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean medicalStaffFlag;
    @Column(name="VACATION_ACCURAL")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean vacationAccrualFlag;
    @Column(name="IS_ON_SABBATICAL")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean onSabbaticalFlag;
    @Column(name="ID_PROVIDED")
    private String idProvided;
    @Column(name="ID_VERIFIED")
    private String idVerified;
    @Column(name="ADDRESS_LINE_1")
    private String addressLine1;
    @Column(name="ADDRESS_LINE_2")
    private String addressLine2;
    @Column(name="ADDRESS_LINE_3")
    private String addressLine3;
    @Column(name="CITY")
    private String city;
    @Column(name="COUNTY")
    private String county;
    @Column(name="STATE")
    private String state;
    @Column(name="POSTAL_CODE")
    private String postalCode;
    @Column(name="COUNTRY_CODE")
    private String countryCode;
    @Column(name="FAX_NUMBER")
    private String faxNumber;
    @Column(name="PAGER_NUMBER")
    private String pagerNumber;
    @Column(name="MOBILE_PHONE_NUMBER")
    private String mobilePhoneNumber;
    @Column(name="ERA_COMMONS_USER_NAME")
    private String eraCommonsUserName;
    @Column(name="NSF_ID")
    private String nsfId;
    @Column(name="DIVISION")
    private String division;
    @Column(name="CITIZENSHIP_TYPE_CODE")
    private Integer citizenshipTypeCode;
    @Column(name="ACADEMIC_YEAR_EFFORT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal academicYearEffort;
    @Column(name="CALENDAR_YEAR_EFFORT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal calendarYearEffort;
    @Column(name="SUMMER_EFFORT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal summerEffort;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="CITIZENSHIP_TYPE_CODE", insertable=false, updatable=false)
    private CitizenshipType citizenshipType;
    @Transient
    private boolean selectedPerson;
    @Transient
    private Boolean active = true;
    @ManyToOne(targetEntity=Unit.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="HOME_UNIT", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit homeUnitRef;
    @Transient
    private transient boolean moveDownAllowed;
    @Transient
    private transient boolean moveUpAllowed;
    @Transient
    private boolean selected;
    @Transient
    private transient KcPersonService kcPersonService;
    @Transient
    private ProposalPersonQuestionnaireHelper questionnaireHelper;
    @Transient
    private transient PropAwardPersonRoleService propAwardPersonRoleService;
    @Transient
    private transient RolodexService rolodexService;
    @Transient
    private Timestamp createTimestamp;
    @Transient
    private transient ParameterService parameterService;
    @Transient
    private transient ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService;

    public boolean isMoveDownAllowed() {
        return this.moveDownAllowed;
    }

    public boolean isMoveUpAllowed() {
        return this.moveUpAllowed;
    }

    public void setMoveDownAllowed(boolean moveDownAllowed) {
        this.moveDownAllowed = moveDownAllowed;
    }

    public void setMoveUpAllowed(boolean moveUpAllowed) {
        this.moveUpAllowed = moveUpAllowed;
    }

    public ProposalPerson() {
        this.proposalPersonDegrees = new ArrayList<ProposalPersonDegree>();
        this.setUnits(new ArrayList<ProposalPersonUnit>());
        this.setCreditSplits(new ArrayList<ProposalPersonCreditSplit>());
        this.setProposalPersonYnqs(new ArrayList<ProposalPersonYnq>());
        this.roleChanged = false;
        this.delete = false;
        this.setFullName("");
        this.questionnaireHelper = new ProposalPersonQuestionnaireHelper(this);
    }

    @Override
    public void setFullName(String fullName) {
        this.fullName = fullName;
        this.setSimpleName(this.getFullName());
        this.setSimpleName(StringUtils.lowerCase((String)this.getSimpleName()));
        this.setSimpleName(StringUtils.deleteWhitespace((String)this.getSimpleName()));
        this.setSimpleName(StringUtils.remove((String)this.getSimpleName(), (char)'.'));
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getCreditSplitName() {
        return this.getFullName();
    }

    public Date getSalaryAnniversaryDate() {
        if (this.getPerson() != null) {
            return this.getPerson().getExtendedAttributes().getSalaryAnniversaryDate();
        }
        return null;
    }

    public boolean getInvestigatorFlag() {
        return this.isPrincipalInvestigator() || this.isMultiplePi() || this.isCoInvestigator() || this.isKeyPerson() && this.getOptInUnitStatus() != false;
    }

    @Override
    public boolean isInvestigator() {
        return this.getInvestigatorFlag();
    }

    @Override
    public boolean isPrincipalInvestigator() {
        return StringUtils.equals((CharSequence)"PI", (CharSequence)this.getProposalPersonRoleId());
    }

    public boolean isCoInvestigator() {
        return StringUtils.equals((CharSequence)"COI", (CharSequence)this.getProposalPersonRoleId());
    }

    public boolean isKeyPerson() {
        return StringUtils.equals((CharSequence)"KP", (CharSequence)this.getProposalPersonRoleId());
    }

    @Override
    public boolean isMultiplePi() {
        return StringUtils.equals((CharSequence)"MPI", (CharSequence)this.getProposalPersonRoleId());
    }

    public void setCreditSplits(List<ProposalPersonCreditSplit> creditSplit) {
        this.creditSplits = creditSplit;
    }

    public List<ProposalPersonCreditSplit> getCreditSplits() {
        return this.creditSplits;
    }

    public ProposalInvestigatorCertification getCertification() {
        return this.certification;
    }

    public void setCertification(ProposalInvestigatorCertification argCertification) {
        this.certification = argCertification;
    }

    public List<ProposalPersonUnit> getUnits() {
        return this.units;
    }

    public void setUnits(List<ProposalPersonUnit> argUnits) {
        this.units = argUnits;
    }

    public List<ProposalPersonDegree> getProposalPersonDegrees() {
        return this.proposalPersonDegrees;
    }

    public void setProposalPersonDegrees(List<ProposalPersonDegree> argDegrees) {
        this.proposalPersonDegrees = argDegrees;
    }

    public Integer getProposalPersonNumber() {
        return this.proposalPersonNumber;
    }

    public static String getUniqueId(String developmentProposalNumber, Integer proposalPersonNumber) {
        return developmentProposalNumber + "|" + proposalPersonNumber;
    }

    public String getUniqueId() {
        return ProposalPerson.getUniqueId(this.getDevelopmentProposal().getProposalNumber(), this.getProposalPersonNumber());
    }

    public void setProposalPersonNumber(Integer argProposalPersonNumber) {
        this.proposalPersonNumber = argProposalPersonNumber;
    }

    @Deprecated
    public boolean getConflictOfInterestFlag() {
        return this.conflictOfInterestFlag;
    }

    public boolean getCanPassivelyDiscloseCois() {
        return this.canPassivelyDiscloseCois;
    }

    public void setCanPassivelyDiscloseCois(boolean canPassivelyDiscloseCois) {
        this.canPassivelyDiscloseCois = canPassivelyDiscloseCois;
    }

    public ScaleTwoDecimal getPercentageEffort() {
        return this.percentageEffort;
    }

    public void setPercentageEffort(ScaleTwoDecimal argPercentageEffort) {
        this.percentageEffort = argPercentageEffort;
    }

    public Boolean getFedrDebrFlag() {
        return this.fedrDebrFlag;
    }

    public void setFedrDebrFlag(Boolean argFedrDebr) {
        this.fedrDebrFlag = argFedrDebr;
    }

    public Boolean getFedrDelqFlag() {
        return this.fedrDelqFlag;
    }

    public void setFedrDelqFlag(Boolean argFedrDelq) {
        this.fedrDelqFlag = argFedrDelq;
    }

    @Override
    public Integer getRolodexId() {
        return this.rolodexId;
    }

    @Override
    public void setRolodexId(Integer argRolodexId) {
        this.rolodexId = argRolodexId;
    }

    public RolodexContract getRolodex() {
        if (this.rolodexId == null) {
            return null;
        }
        return this.getRolodexService().getRolodex(this.rolodexId);
    }

    protected RolodexService getRolodexService() {
        if (this.rolodexService == null) {
            this.rolodexService = KcServiceLocator.getService(RolodexService.class);
        }
        return this.rolodexService;
    }

    protected void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public String getProposalPersonRoleId() {
        return this.proposalPersonRoleId;
    }

    public void setProposalPersonRoleId(String argPropPersonRoleId) {
        this.proposalPersonRoleId = argPropPersonRoleId;
    }

    public PropAwardPersonRole getRole() {
        if (StringUtils.isNotBlank((CharSequence)this.getProposalPersonRoleId()) && this.getDevelopmentProposal() != null && StringUtils.isNotBlank((CharSequence)this.getDevelopmentProposal().getSponsorCode())) {
            return this.getPropAwardPersonRoleService().getRole(this.getProposalPersonRoleId(), this.getDevelopmentProposal().getSponsorCode());
        }
        return null;
    }

    public void setConflictOfInterestFlag(boolean argConflictOfInterest) {
        this.conflictOfInterestFlag = argConflictOfInterest;
    }

    @Override
    public KcPerson getPerson() {
        if (this.personId == null) {
            return null;
        }
        return this.getKcPersonService().getKcPersonByPersonId(this.personId);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public void addDegree(ProposalPersonDegree d) {
        this.getProposalPersonDegrees().add(d);
    }

    public ProposalPersonDegree getProposalPersonDegree(int index) {
        while (this.getProposalPersonDegrees().size() <= index) {
            this.getProposalPersonDegrees().add(new ProposalPersonDegree());
        }
        return this.getProposalPersonDegrees().get(index);
    }

    public void addUnit(ProposalPersonUnit unit) {
        this.getUnits().add(unit);
    }

    public ProposalPersonUnit getUnit(int index) {
        while (this.getUnits().size() <= index) {
            this.getUnits().add(new ProposalPersonUnit());
        }
        return this.getUnits().get(index);
    }

    public ProposalPersonUnit getUnit(String unitNumber) {
        if (unitNumber == null) {
            return null;
        }
        for (ProposalPersonUnit unit : this.getUnits()) {
            if (unit == null || !unitNumber.equals(unit.getUnitNumber())) continue;
            return unit;
        }
        return null;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setUnitDelete(boolean delete) {
        this.unitdelete = delete;
    }

    public boolean isUnitDelete() {
        return this.unitdelete;
    }

    public ProposalPersonCreditSplit getCreditSplit(int index) {
        while (this.getCreditSplits().size() <= index) {
            this.getCreditSplits().add(new ProposalPersonCreditSplit());
        }
        return this.getCreditSplits().get(index);
    }

    public List<ProposalPersonYnq> getProposalPersonYnqs() {
        return this.proposalPersonYnqs;
    }

    public void setProposalPersonYnqs(List<ProposalPersonYnq> proposalPersonYnqs) {
        this.proposalPersonYnqs = proposalPersonYnqs;
    }

    public ProposalPersonYnq getProposalPersonYnq(int index) {
        while (this.getProposalPersonYnqs().size() <= index) {
            this.getProposalPersonYnqs().add(new ProposalPersonYnq());
        }
        return this.getProposalPersonYnqs().get(index);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.personId == null ? 0 : this.personId.hashCode());
        result = 31 * result + (this.rolodexId == null ? 0 : this.rolodexId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return obj.equals(this.getPersonId()) || obj.equals(this.getRolodexId());
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProposalPerson other = (ProposalPerson)obj;
        if (this.personId == null ? other.personId != null : !this.personId.equals(other.personId)) {
            return false;
        }
        return !(this.rolodexId == null ? other.rolodexId != null : !this.rolodexId.equals(other.rolodexId));
    }

    public boolean isRoleChanged() {
        return this.roleChanged;
    }

    public void setRoleChanged(boolean roleChanged) {
        this.roleChanged = roleChanged;
    }

    public boolean containsUnit(String unitNumber) {
        if (unitNumber == null) {
            return false;
        }
        for (ProposalPersonUnit unit : this.getUnits()) {
            if (unit == null || !unitNumber.equals(unit.getUnitNumber())) continue;
            return true;
        }
        return false;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    @Override
    public boolean isOtherSignificantContributorFlag() {
        return this.otherSignificantContributorFlag;
    }

    public void setOtherSignificantContributorFlag(boolean otherSignificantContributorFlag) {
        this.otherSignificantContributorFlag = otherSignificantContributorFlag;
    }

    public Boolean getOptInUnitStatus() {
        return this.optInUnitStatus;
    }

    public void setOptInUnitStatus(Boolean optInUnitStatus) {
        this.optInUnitStatus = optInUnitStatus;
    }

    public Boolean getOptInCertificationStatus() {
        return this.optInCertificationStatus;
    }

    public void setOptInCertificationStatus(Boolean optInCertificationStatus) {
        this.optInCertificationStatus = optInCertificationStatus;
    }

    @Override
    public String getProjectRole() {
        return this.projectRole;
    }

    public void setProjectRole(String projectRole) {
        this.projectRole = projectRole;
    }

    @Override
    public Integer getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(Integer ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String argPersonId) {
        this.personId = argPersonId;
    }

    @Override
    public void setSocialSecurityNumber(String argSocialSecurityNumber) {
        this.socialSecurityNumber = argSocialSecurityNumber;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String argLastName) {
        this.lastName = argLastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String argFirstName) {
        this.firstName = argFirstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    @Override
    public void setMiddleName(String argMiddleName) {
        this.middleName = argMiddleName;
    }

    public String getPriorName() {
        return this.priorName;
    }

    @Override
    public void setPriorName(String argPriorName) {
        this.priorName = argPriorName;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String argUserName) {
        this.userName = argUserName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String argEmailAddress) {
        this.emailAddress = argEmailAddress;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Override
    public void setDateOfBirth(Date argDateOfBirth) {
        this.dateOfBirth = argDateOfBirth;
    }

    public Integer getAge() {
        return this.age;
    }

    @Override
    public void setAge(Integer argAge) {
        this.age = argAge;
    }

    public Integer getAgeByFiscalYear() {
        return this.ageByFiscalYear;
    }

    @Override
    public void setAgeByFiscalYear(Integer argAgeByFiscalYear) {
        this.ageByFiscalYear = argAgeByFiscalYear;
    }

    public String getGender() {
        return this.gender;
    }

    @Override
    public void setGender(String argGender) {
        this.gender = argGender;
    }

    public String getRace() {
        return this.race;
    }

    @Override
    public void setRace(String argRace) {
        this.race = argRace;
    }

    public String getEducationLevel() {
        return this.educationLevel;
    }

    @Override
    public void setEducationLevel(String argEducationLevel) {
        this.educationLevel = argEducationLevel;
    }

    public String getDegree() {
        return this.degree;
    }

    @Override
    public void setDegree(String argDegree) {
        this.degree = argDegree;
    }

    public String getMajor() {
        return this.major;
    }

    @Override
    public void setMajor(String argMajor) {
        this.major = argMajor;
    }

    public Boolean getHandicappedFlag() {
        return this.handicappedFlag;
    }

    @Override
    public void setHandicappedFlag(Boolean argHandicapped) {
        this.handicappedFlag = argHandicapped;
    }

    public String getHandicapType() {
        return this.handicapType;
    }

    @Override
    public void setHandicapType(String argHandicapType) {
        this.handicapType = argHandicapType;
    }

    public Boolean getVeteranFlag() {
        return this.veteranFlag;
    }

    @Override
    public void setVeteranFlag(Boolean argVeteran) {
        this.veteranFlag = argVeteran;
    }

    public String getVeteranType() {
        return this.veteranType;
    }

    @Override
    public void setVeteranType(String argVeteranType) {
        this.veteranType = argVeteranType;
    }

    public String getVisaCode() {
        return this.visaCode;
    }

    @Override
    public void setVisaCode(String argVisaCode) {
        this.visaCode = argVisaCode;
    }

    public String getVisaType() {
        return this.visaType;
    }

    @Override
    public void setVisaType(String argVisaType) {
        this.visaType = argVisaType;
    }

    public Date getVisaRenewalDate() {
        return this.visaRenewalDate;
    }

    @Override
    public void setVisaRenewalDate(Date argVisaRenewalDate) {
        this.visaRenewalDate = argVisaRenewalDate;
    }

    public Boolean getHasVisa() {
        return this.hasVisa;
    }

    @Override
    public void setHasVisa(Boolean argHasVisa) {
        this.hasVisa = argHasVisa;
    }

    public String getOfficeLocation() {
        return this.officeLocation;
    }

    @Override
    public void setOfficeLocation(String argOfficeLocation) {
        this.officeLocation = argOfficeLocation;
    }

    public String getOfficePhone() {
        return this.officePhone;
    }

    @Override
    public void setOfficePhone(String argOfficePhone) {
        this.officePhone = argOfficePhone;
    }

    public String getSecondaryOfficeLocation() {
        return this.secondaryOfficeLocation;
    }

    @Override
    public void setSecondaryOfficeLocation(String argSecondaryOfficeLocation) {
        this.secondaryOfficeLocation = argSecondaryOfficeLocation;
    }

    public String getSecondaryOfficePhone() {
        return this.secondaryOfficePhone;
    }

    @Override
    public void setSecondaryOfficePhone(String argSecondaryOfficePhone) {
        this.secondaryOfficePhone = argSecondaryOfficePhone;
    }

    public String getSchool() {
        return this.school;
    }

    @Override
    public void setSchool(String argSchool) {
        this.school = argSchool;
    }

    public String getYearGraduated() {
        return this.yearGraduated;
    }

    @Override
    public void setYearGraduated(String argYearGraduated) {
        this.yearGraduated = argYearGraduated;
    }

    public String getDirectoryDepartment() {
        return this.directoryDepartment;
    }

    @Override
    public void setDirectoryDepartment(String argDirectoryDepartment) {
        this.directoryDepartment = argDirectoryDepartment;
    }

    public String getSaluation() {
        return this.saluation;
    }

    @Override
    public void setSaluation(String argSaluation) {
        this.saluation = argSaluation;
    }

    public String getCountryOfCitizenship() {
        return this.countryOfCitizenship;
    }

    @Override
    public void setCountryOfCitizenship(String argCountryOfCitizenship) {
        this.countryOfCitizenship = argCountryOfCitizenship;
    }

    public String getPrimaryTitle() {
        return this.primaryTitle;
    }

    @Override
    public void setPrimaryTitle(String argPrimaryTitle) {
        this.primaryTitle = argPrimaryTitle;
    }

    public String getDirectoryTitle() {
        return this.directoryTitle;
    }

    @Override
    public void setDirectoryTitle(String argDirectoryTitle) {
        this.directoryTitle = argDirectoryTitle;
    }

    public String getHomeUnit() {
        return this.homeUnit;
    }

    @Override
    public void setHomeUnit(String argHomeUnit) {
        this.homeUnit = argHomeUnit;
    }

    public Boolean getFacultyFlag() {
        return this.facultyFlag;
    }

    @Override
    public void setFacultyFlag(Boolean argFaculty) {
        this.facultyFlag = argFaculty;
    }

    public Boolean getGraduateStudentStaffFlag() {
        return this.graduateStudentStaffFlag;
    }

    @Override
    public void setGraduateStudentStaffFlag(Boolean argGraduateStudentStaff) {
        this.graduateStudentStaffFlag = argGraduateStudentStaff;
    }

    public Boolean getResearchStaffFlag() {
        return this.researchStaffFlag;
    }

    @Override
    public void setResearchStaffFlag(Boolean argResearchStaff) {
        this.researchStaffFlag = argResearchStaff;
    }

    public Boolean getServiceStaffFlag() {
        return this.serviceStaffFlag;
    }

    @Override
    public void setServiceStaffFlag(Boolean argServiceStaff) {
        this.serviceStaffFlag = argServiceStaff;
    }

    public Boolean getSupportStaffFlag() {
        return this.supportStaffFlag;
    }

    @Override
    public void setSupportStaffFlag(Boolean argSupportStaff) {
        this.supportStaffFlag = argSupportStaff;
    }

    public Boolean getOtherAcademicGroupFlag() {
        return this.otherAcademicGroupFlag;
    }

    public String getOrganization() {
        return this.getUnit().getUnitName();
    }

    @Override
    public void setOtherAcademicGroupFlag(Boolean argOtherAcademicGroup) {
        this.otherAcademicGroupFlag = argOtherAcademicGroup;
    }

    public Boolean getMedicalStaffFlag() {
        return this.medicalStaffFlag;
    }

    @Override
    public void setMedicalStaffFlag(Boolean argMedicalStaff) {
        this.medicalStaffFlag = argMedicalStaff;
    }

    public Boolean getVacationAccrualFlag() {
        return this.vacationAccrualFlag;
    }

    @Override
    public void setVacationAccrualFlag(Boolean argVacationAccrual) {
        this.vacationAccrualFlag = argVacationAccrual;
    }

    public Boolean getOnSabbaticalFlag() {
        return this.onSabbaticalFlag;
    }

    @Override
    public void setOnSabbaticalFlag(Boolean argOnSabbatical) {
        this.onSabbaticalFlag = argOnSabbatical;
    }

    public String getIdProvided() {
        return this.idProvided;
    }

    @Override
    public void setIdProvided(String argIdProvided) {
        this.idProvided = argIdProvided;
    }

    public String getIdVerified() {
        return this.idVerified;
    }

    @Override
    public void setIdVerified(String argIdVerified) {
        this.idVerified = argIdVerified;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    @Override
    public void setAddressLine1(String argAddressLine1) {
        this.addressLine1 = argAddressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    @Override
    public void setAddressLine2(String argAddressLine2) {
        this.addressLine2 = argAddressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    @Override
    public void setAddressLine3(String argAddressLine3) {
        this.addressLine3 = argAddressLine3;
    }

    public String getCity() {
        return this.city;
    }

    @Override
    public void setCity(String argCity) {
        this.city = argCity;
    }

    public String getCounty() {
        return this.county;
    }

    @Override
    public void setCounty(String argCounty) {
        this.county = argCounty;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String argState) {
        this.state = argState;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public void setPostalCode(String argPostalCode) {
        this.postalCode = argPostalCode;
    }

    public String getCountryCode() {
        return this.countryCode != null ? this.countryCode.trim() : null;
    }

    @Override
    public void setCountryCode(String argCountryCode) {
        this.countryCode = argCountryCode;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    @Override
    public void setFaxNumber(String argFaxNumber) {
        this.faxNumber = argFaxNumber;
    }

    public String getPagerNumber() {
        return this.pagerNumber;
    }

    @Override
    public void setPagerNumber(String argPagerNumber) {
        this.pagerNumber = argPagerNumber;
    }

    public String getMobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    @Override
    public void setMobilePhoneNumber(String argMobilePhoneNumber) {
        this.mobilePhoneNumber = argMobilePhoneNumber;
    }

    public String getEraCommonsUserName() {
        if (StringUtils.isBlank((CharSequence)this.eraCommonsUserName) && this.personId != null) {
            this.eraCommonsUserName = this.getKcPersonService().getKcPersonByPersonId(this.personId).getExtendedAttributes().getEraCommonUserName();
        }
        return this.eraCommonsUserName;
    }

    @Override
    public void setEraCommonsUserName(String argEraCommonsUserName) {
        this.eraCommonsUserName = argEraCommonsUserName;
    }

    public String getNsfId() {
        if (this.nsfId == null && this.personId != null) {
            this.nsfId = this.getKcPersonService().getKcPersonByPersonId(this.personId).getExtendedAttributes().getNsfId();
        }
        return this.nsfId;
    }

    public void setNsfId(String nsfId) {
        this.nsfId = nsfId;
    }

    public String getDivision() {
        return this.division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setHomeUnitRef(Unit unit) {
        this.homeUnitRef = unit;
    }

    public Unit getHomeUnitRef() {
        return this.homeUnitRef;
    }

    public Serializable getIdentifier() {
        return this.personId;
    }

    public Unit getUnit() {
        return this.homeUnitRef;
    }

    public void setIdentifier(Serializable identifier) {
        this.setPersonId((String)((Object)identifier));
    }

    public void setUnit(Unit unit) {
        this.setHomeUnitRef(unit);
    }

    public String getPhoneNumber() {
        return this.officePhone;
    }

    public String getContactOrganizationName() {
        return this.getUnit().getUnitName();
    }

    public String getOrganizationIdentifier() {
        return this.homeUnit;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    @Override
    public ContactRole getContactRole() {
        return this.getRole();
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public ProposalPersonCertificationDetails getCertificationDetails() {
        return this.certificationDetails;
    }

    public void setCertificationDetails(ProposalPersonCertificationDetails certificationDetails) {
        this.certificationDetails = certificationDetails;
    }

    @Override
    public Sponsorable getParent() {
        return this.getDevelopmentProposal();
    }

    @Override
    public String getInvestigatorRoleDescription() {
        return this.getRole().getDescription();
    }

    public boolean getAnyYNQsAnswered() {
        for (ProposalPersonYnq ynq : this.getProposalPersonYnqs()) {
            if (StringUtils.isEmpty((CharSequence)ynq.getAnswer())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getRoleCode() {
        return this.getRole().getRoleCode();
    }

    public ProposalPersonQuestionnaireHelper getQuestionnaireHelper() {
        if (this.questionnaireHelper != null && this.questionnaireHelper.getAnswerHeaders() == null) {
            this.questionnaireHelper.populateAnswers();
        }
        return this.questionnaireHelper;
    }

    public void setQuestionnaireHelper(ProposalPersonQuestionnaireHelper questionnaireHelper) {
        this.questionnaireHelper = questionnaireHelper;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Integer getCitizenshipTypeCode() {
        return this.citizenshipTypeCode;
    }

    @Override
    public void setCitizenshipTypeCode(Integer citizenshipTypeCode) {
        this.citizenshipTypeCode = citizenshipTypeCode;
    }

    public CitizenshipType getCitizenshipType() {
        return this.citizenshipType;
    }

    public void setCitizenshipType(CitizenshipType citizenshipType) {
        this.citizenshipType = citizenshipType;
    }

    protected PropAwardPersonRoleService getPropAwardPersonRoleService() {
        if (this.propAwardPersonRoleService == null) {
            this.propAwardPersonRoleService = KcServiceLocator.getService(PropAwardPersonRoleService.class);
        }
        return this.propAwardPersonRoleService;
    }

    public void setPropAwardPersonRoleService(PropAwardPersonRoleService propAwardPersonRoleService) {
        this.propAwardPersonRoleService = propAwardPersonRoleService;
    }

    public String getProposalNumber() {
        return this.getDevelopmentProposal().getProposalNumber();
    }

    public boolean isQuestionnairesCompleted() {
        boolean retVal = true;
        if (this.getQuestionnaireHelper() != null && this.getQuestionnaireHelper().getAnswerHeaders() != null) {
            for (AnswerHeader ah : this.getQuestionnaireHelper().getAnswerHeaders()) {
                retVal &= ah.isCompleted();
            }
        }
        return retVal;
    }

    public List<PersonTraining> getPersonTrainings() {
        if (CollectionUtils.isEmpty(this.personTrainings)) {
            this.personTrainings = KcServiceLocator.getService(BusinessObjectService.class).findMatching(PersonTraining.class, Collections.singletonMap("personId", this.getPersonId()));
        }
        return this.personTrainings;
    }

    public void setPersonTrainings(List<PersonTraining> personTrainings) {
        this.personTrainings = personTrainings;
    }

    public String getPersonName() {
        return this.getFullName();
    }

    public ScaleTwoDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public void setAcademicYearEffort(ScaleTwoDecimal academicYearEffort) {
        this.academicYearEffort = academicYearEffort;
    }

    public ScaleTwoDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public void setCalendarYearEffort(ScaleTwoDecimal calendarYearEffort) {
        this.calendarYearEffort = calendarYearEffort;
    }

    public ScaleTwoDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public void setSummerEffort(ScaleTwoDecimal summerEffort) {
        this.summerEffort = summerEffort;
    }

    public boolean isSelectedPerson() {
        return this.selectedPerson;
    }

    public void setSelectedPerson(boolean selectedPerson) {
        this.selectedPerson = selectedPerson;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public Timestamp getLastNotification() {
        return this.lastNotification;
    }

    public void setLastNotification(Timestamp lastNotification) {
        this.lastNotification = lastNotification;
    }

    public Boolean getIncludeInCreditAllocation() {
        if (this.includeInCreditAllocation == null) {
            this.includeInCreditAllocation = this.defaultIncludeInCreditAllocation(this.proposalPersonRoleId);
        }
        return this.includeInCreditAllocation;
    }

    public Boolean defaultIncludeInCreditAllocation(String proposalPersonRoleId) {
        Collection roles = this.getParameterService().getParameterValuesAsString("KC-PD", "All", "CREDIT_SPLIT_OPT_IN_DEFAULT_ROLES");
        return StringUtils.isNotBlank((CharSequence)proposalPersonRoleId) && roles.contains(proposalPersonRoleId);
    }

    public void setIncludeInCreditAllocation(Boolean includeInCreditAllocation) {
        this.includeInCreditAllocation = includeInCreditAllocation;
    }

    public boolean isRolodexCertificationEnabled() {
        return this.isNonEmployee() ? this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "ENABLE_ADDRESSBOOK_CERTIFICATION") : true;
    }

    public boolean needsCertification() {
        boolean isCertificationRequiredByRole = this.getRole() != null ? this.getRole().getCertificationRequired() : false;
        boolean isKeyPersonCertificationRequiredByRoleName = this.isKeyPerson() && this.getProposalDevelopmentPermissionsService().isKeyPersonRoleExempt(this);
        boolean isMultiplePiAddressBookExempt = this.isNonEmployee() && this.isMultiplePi() && this.isAddressBookMultiPiCertificationExempt();
        return this.getOptInCertificationStatus() != false || isKeyPersonCertificationRequiredByRoleName || this.isRolodexCertificationEnabled() && (isCertificationRequiredByRole || this.certificationIsRequiredByCoiDisclosureFeature()) && !isMultiplePiAddressBookExempt;
    }

    public boolean isNonEmployee() {
        return this.getRolodexId() != null;
    }

    public boolean certificationIsRequiredByCoiDisclosureFeature() {
        return this.isCoiDisclosureStatusFeatureEnabled() && (this.getProposalDevelopmentPermissionsService().isPiCoiKeyPersonsForcedToDiscloseWithCustomData(this.getDevelopmentProposal()) || this.getProposalDevelopmentPermissionsService().doesSponsorRequireKeyPersonCertification(this));
    }

    protected boolean isCoiDisclosureStatusFeatureEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "PROP_PERSON_COI_STATUS_FLAG");
    }

    public boolean isAddressBookMultiPiCertificationExempt() {
        return this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "EXEMPT_ADDRESSBOOK_MULTI_PI_CERT");
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected ProposalDevelopmentPermissionsService getProposalDevelopmentPermissionsService() {
        if (this.proposalDevelopmentPermissionsService == null) {
            this.proposalDevelopmentPermissionsService = KcServiceLocator.getService(ProposalDevelopmentPermissionsService.class);
        }
        return this.proposalDevelopmentPermissionsService;
    }

    public void setProposalDevelopmentPermissionsService(ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService) {
        this.proposalDevelopmentPermissionsService = proposalDevelopmentPermissionsService;
    }

    public static final class ProposalPersonId
    implements Serializable,
    Comparable<ProposalPersonId> {
        private String developmentProposal;
        private Integer proposalPersonNumber;

        public String getDevelopmentProposal() {
            return this.developmentProposal;
        }

        public void setDevelopmentProposal(String developmentProposal) {
            this.developmentProposal = developmentProposal;
        }

        public Integer getProposalPersonNumber() {
            return this.proposalPersonNumber;
        }

        public void setProposalPersonNumber(Integer proposalPersonNumber) {
            this.proposalPersonNumber = proposalPersonNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("developmentProposal", (Object)this.developmentProposal).append("proposalPersonNumber", (Object)this.proposalPersonNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            ProposalPersonId rhs = (ProposalPersonId)other;
            return new EqualsBuilder().append((Object)this.developmentProposal, (Object)rhs.developmentProposal).append((Object)this.proposalPersonNumber, (Object)rhs.proposalPersonNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.developmentProposal).append((Object)this.proposalPersonNumber).toHashCode();
        }

        @Override
        public int compareTo(ProposalPersonId other) {
            return new CompareToBuilder().append((Object)this.developmentProposal, (Object)other.developmentProposal).append((Object)this.proposalPersonNumber, (Object)other.proposalPersonNumber).toComparison();
        }
    }
}

