/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.questionnaire;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.container.TabGroup;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.util.UrlFactory;

public class QuestionnaireTabGroup
extends TabGroup {
    private CollectionGroup collectionGroupPrototype;

    public void performInitialization(Object model) {
        ProposalDevelopmentDocumentForm form = (ProposalDevelopmentDocumentForm)model;
        boolean readOnly = form.getEditModes() == null || !form.getEditModes().containsKey("fullEntry");
        ArrayList<Component> tabs = new ArrayList<Component>();
        String formKey = form.getFormKey();
        tabs.addAll(this.createTabs(form.getQuestionnaireHelper().getAnswerHeaders(), "questionnaireHelper", formKey, readOnly));
        tabs.addAll(this.createTabs(form.getS2sQuestionnaireHelper().getAnswerHeaders(), "s2sQuestionnaireHelper", formKey, readOnly));
        Collections.sort(tabs, new Comparator<Component>(this){

            @Override
            public int compare(Component c1, Component c2) {
                return ((GroupBase)c1).getHeader().getHeaderText().compareTo(((GroupBase)c2).getHeader().getHeaderText());
            }
        });
        this.setItems(tabs);
        super.performInitialization(model);
    }

    private List<Component> createTabs(List<AnswerHeader> answerHeaders, String helper, String formKey, boolean isReadOnly) {
        ArrayList<Component> tabs = new ArrayList<Component>();
        int index = 0;
        for (AnswerHeader answerHeader : answerHeaders) {
            if (answerHeader.isActive() || isReadOnly && answerHeader.isHasVisibleQuestion()) {
                GroupBase group = (GroupBase)ComponentFactory.getNewComponentInstance((String)"Uif-VerticalBoxGroup");
                group.setHeader((Header)ComponentFactory.getNewComponentInstance((String)"Uif-SectionHeader"));
                group.setId("PropDev-QuestionnairePage-" + StringUtils.removePattern((String)answerHeader.getLabel(), (String)"([^0-9a-zA-Z\\-_])"));
                String cssClass = "questionaire-" + (answerHeader.isCompleted() ? "" : "in") + "complete";
                group.setHeaderText(answerHeader.getLabel() + "&nbsp;<span class='" + cssClass + " icon-ok' />");
                group.getHeader().setRender(false);
                CollectionGroup questionCollection = (CollectionGroup)ComponentUtils.copy((Component)this.collectionGroupPrototype);
                this.initiateActionMenuItems(questionCollection.getHeader().getRightGroup(), index, helper, formKey, answerHeader.isNewerVersionPublished());
                questionCollection.setHeaderText(answerHeader.getLabel() + (answerHeader.isCompleted() ? "[color=green] (Complete)" : " [color=gray](Incomplete)") + "[/color]");
                questionCollection.setPropertyName(helper + ".answerHeaders[" + index + "].questions");
                group.setItems(Collections.singletonList(questionCollection));
                tabs.add((Component)group);
            }
            ++index;
        }
        return tabs;
    }

    protected void initiateActionMenuItems(Group group, int index, String helper, String formKey, boolean newerVersionPublished) {
        for (Component component : group.getItems()) {
            if (!(component instanceof Action)) continue;
            Action action = (Action)component;
            if (action.getActionLabel().equals("Print")) {
                Properties parameters = new Properties();
                parameters.put("methodToCall", "printQuestionnaire");
                parameters.put("formKey", formKey);
                parameters.put("helper", helper);
                parameters.put("index", String.valueOf(index));
                action.getActionUrl().setHref(UrlFactory.parameterizeUrl((String)"../kc-pd-krad/proposalDevelopment", (Properties)parameters));
            } else if (action.getActionLabel().equals("Update Available")) {
                action.setRender(newerVersionPublished);
            }
            action.addActionParameter("helper", helper);
            action.addActionParameter("index", String.valueOf(index));
        }
    }

    @ViewLifecycleRestriction
    public CollectionGroup getCollectionGroupPrototype() {
        return this.collectionGroupPrototype;
    }

    public void setCollectionGroupPrototype(CollectionGroup collectionGroupPrototype) {
        this.collectionGroupPrototype = collectionGroupPrototype;
    }
}

