/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.institutionalproposal.IpSequenceResetterDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="ipSequenceResetterDao")
public class IpSequenceResetterDaoImpl
implements IpSequenceResetterDao {
    public static final String MYSQL_PRODUCT = "MySQL";
    public static final String MARIADB_PRODUCT = "MariaDB";
    public static final String ORACLE_PRODUCT = "ORACLE";
    private static Logger LOG = LogManager.getLogger(IpSequenceResetterDaoImpl.class);
    private static String DROP_SEQUENCE_MYSQL = "DROP TABLE IF EXISTS SEQ_IP_FY_BASED_ID;";
    private static String CREATE_SEQUENCE_MYSQL = "CREATE TABLE SEQ_IP_FY_BASED_ID (\n  id bigint(19) not null auto_increment, primary key (id)\n);";
    private static String DROP_SEQUENCE_ORACLE = "DROP SEQUENCE SEQ_IP_FY_BASED_ID;";
    private static String CREATE_SEQUENCE_ORACLE = "CREATE SEQUENCE SEQ_IP_FY_BASED_ID INCREMENT BY 1 START WITH 1 MAXVALUE 9999 NOCACHE;";
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;

    @Override
    public void resetSequence() {
        try (Connection conn = this.getDataSource().getConnection();
             Statement statement = conn.createStatement();){
            String databaseType = conn.getMetaData().getDatabaseProductName();
            if (MYSQL_PRODUCT.equalsIgnoreCase(databaseType) || MARIADB_PRODUCT.equalsIgnoreCase(databaseType)) {
                statement.execute(DROP_SEQUENCE_MYSQL);
                statement.execute(CREATE_SEQUENCE_MYSQL);
            } else if (ORACLE_PRODUCT.equalsIgnoreCase(databaseType)) {
                statement.execute(DROP_SEQUENCE_ORACLE);
                statement.execute(CREATE_SEQUENCE_ORACLE);
            }
        }
        catch (SQLException e) {
            LOG.error("Problem accessing database.", (Throwable)e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

