/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.notification;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.custom.CustomDataContainer;
import org.kuali.coeus.common.framework.custom.CustomDataNotificationRenderer;
import org.kuali.coeus.common.notification.impl.NotificationRendererBase;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCfda;

public class InstitutionalProposalNotificationRenderer
extends NotificationRendererBase
implements CustomDataNotificationRenderer {
    private static final long serialVersionUID = 451541228341893685L;
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private InstitutionalProposal institutionalProposal;

    public InstitutionalProposalNotificationRenderer() {
    }

    public InstitutionalProposalNotificationRenderer(InstitutionalProposal institutionalProposal) {
        this.institutionalProposal = institutionalProposal;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(MM_DD_YYYY);
        Map<String, String> result = super.getDefaultReplacementParameters();
        if (this.institutionalProposal.getInstitutionalProposalDocument() != null) {
            result.put("{DOCUMENT_NUMBER}", this.institutionalProposal.getInstitutionalProposalDocument().getDocumentNumber());
        }
        result.put("{PROPOSAL_NUMBER}", this.institutionalProposal.getProposalNumber());
        result.put("{PROPOSAL_TITLE}", this.institutionalProposal.getTitle());
        result.put("{PI_NAME}", this.institutionalProposal.getPiName());
        result.put("{LEAD_UNIT}", this.institutionalProposal.getLeadUnitNumber());
        result.put("{LEAD_UNIT_NAME}", this.institutionalProposal.getLeadUnitName());
        result.put("{SPONSOR_CODE}", this.institutionalProposal.getSponsorCode());
        result.put("{SPONSOR_NAME}", this.institutionalProposal.getSponsorName());
        result.put("{ACTIVITY_TYPE_CODE}", this.institutionalProposal.getActivityTypeCode());
        result.put("{ACTIVITY_TYPE_NAME}", this.institutionalProposal.getActivityTypeFromCode().getDescription());
        if (this.institutionalProposal.getDeadlineDate() != null) {
            result.put("{DEADLINE_DATE}", dateFormatter.format(this.institutionalProposal.getDeadlineDate()));
        } else {
            result.put("{DEADLINE_DATE}", "");
        }
        result.put("{DEADLINE_TIME}", this.institutionalProposal.getDeadlineTime());
        result.put("{CFDA_NUMBER}", this.institutionalProposal.getProposalCfdas().stream().map(InstitutionalProposalCfda::getCfdaNumber).collect(Collectors.joining(",")));
        result.put("{OPPORTUNITY}", this.institutionalProposal.getOpportunity());
        result.putAll(this.getCustomDataReplacementParameters());
        return result;
    }

    public InstitutionalProposal getInstitutionalProposal() {
        return this.institutionalProposal;
    }

    public void setInstitutionalProposal(InstitutionalProposal institutionalProposal) {
        this.institutionalProposal = institutionalProposal;
    }

    @Override
    public CustomDataContainer getCustomDataContainer() {
        return this.institutionalProposal;
    }
}

