/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.common.impl.attachment;

import co.kuali.rice.coreservice.api.attachment.S3FileService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.impl.attachment.KcAttachmentDataDaoImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class KcAttachmentDataDaoS3Impl
extends KcAttachmentDataDaoImpl {
    private static final String INSERT_RECORD_ID_ONLY = "insert into file_data (id) values (?)";
    private static final Logger LOG = LogManager.getLogger(KcAttachmentDataDaoS3Impl.class);
    private S3FileService kcS3FileService;
    private ParameterService parameterService;

    @Override
    public byte[] getData(String id) {
        if (!this.isS3IntegrationEnabled()) {
            return super.getData(id);
        }
        String location = this.getLocation(id);
        if (StringUtils.isNotBlank((CharSequence)location)) {
            try {
                return this.getResourceLoader().getResource(location).getInputStream().readAllBytes();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching attachment data from S3, existing id: " + id);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            try {
                String dbMD5;
                String s3MD5;
                Object s3File = this.kcS3FileService.retrieveFile(id);
                byte[] s3Bytes = null;
                byte[] dbBytes = null;
                if (s3File != null) {
                    if (LOG.isDebugEnabled()) {
                        Method getFileMetaData = s3File.getClass().getMethod("getFileMetaData", new Class[0]);
                        LOG.debug("data found in S3, existing id: " + id + " metadata: " + String.valueOf(getFileMetaData.invoke(s3File, new Object[0])));
                    }
                    Method getFileContents = s3File.getClass().getMethod("getByteContents", new Class[0]);
                    s3Bytes = (byte[])getFileContents.invoke(s3File, new Object[0]);
                }
                if (s3Bytes == null || this.isS3DualRetrieveEnabled()) {
                    dbBytes = super.getData(id);
                }
                if (LOG.isErrorEnabled() && s3Bytes != null && dbBytes != null && !Objects.equals(s3MD5 = DigestUtils.md5Hex((byte[])s3Bytes), dbMD5 = DigestUtils.md5Hex((byte[])dbBytes))) {
                    LOG.error("S3 data MD5: " + s3MD5 + " does not equal DB data MD5: " + dbMD5 + " for id: " + id);
                }
                return s3Bytes != null ? s3Bytes : dbBytes;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String saveData(byte[] attachmentData, String id) {
        if (!this.isS3IntegrationEnabled()) {
            return super.saveData(attachmentData, id);
        }
        if (ArrayUtils.isEmpty((byte[])attachmentData)) {
            throw new IllegalArgumentException("attachmentData is null");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getLocation(id))) {
            return id;
        }
        String query = this.isS3DualSaveEnabled() ? "insert into file_data (id, data) values (?, ?)" : INSERT_RECORD_ID_ONLY;
        try (Connection connection = this.getDataSource().getConnection();){
            String string;
            block28: {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    boolean deleted;
                    String newId = this.saveDataInS3(attachmentData);
                    stmt.setString(1, newId);
                    if (this.isS3DualSaveEnabled()) {
                        try (ByteArrayInputStream is = new ByteArrayInputStream(attachmentData);){
                            stmt.setBinaryStream(2, (InputStream)is, attachmentData.length);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    stmt.executeUpdate();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created attachment data, new id: " + newId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)id) && (deleted = this.deleteAttachment(connection, id))) {
                        this.kcS3FileService.deleteFile(id);
                    }
                    string = newId;
                    if (stmt == null) break block28;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String saveDataInS3(byte[] attachmentData) {
        if (ArrayUtils.isEmpty((byte[])attachmentData)) {
            throw new IllegalArgumentException("attachmentData is null");
        }
        try {
            Class<?> s3FileClass = Class.forName("co.kuali.coeus.s3.api.S3File");
            Object s3File = s3FileClass.newInstance();
            Method setFileContents = s3FileClass.getMethod("setByteContents", byte[].class);
            setFileContents.invoke(s3File, new Object[]{attachmentData});
            return this.kcS3FileService.createFile(s3File);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeData(String id) {
        if (!this.isS3IntegrationEnabled()) {
            super.removeData(id);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing attachment data from S3, existing id: " + id);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            try (Connection conn = this.getDataSource().getConnection();){
                boolean deleted = this.deleteAttachment(conn, id);
                if (deleted) {
                    this.kcS3FileService.deleteFile(id);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected boolean isS3IntegrationEnabled() {
        if (this.parameterService.parameterExists("KC-GEN", "All", "S3_INTEGRATION_ENABLED").booleanValue()) {
            return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "S3_INTEGRATION_ENABLED");
        }
        return false;
    }

    protected boolean isS3DualSaveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "S3_DUAL_SAVE_ENABLED");
    }

    protected boolean isS3DualRetrieveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "S3_DUAL_RETRIEVE_ENABLED");
    }

    public S3FileService getKcS3FileService() {
        return this.kcS3FileService;
    }

    public void setKcS3FileService(S3FileService kcS3FileService) {
        this.kcS3FileService = kcS3FileService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

