/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.nonpersonnel;

import java.sql.Date;
import java.util.ArrayList;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.ApplyToPeriodsBudgetEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetDirectCostLimitEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetPeriodCostLimitEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.SaveBudgetLineItemEvent;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetAddPersonnelPeriodEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetSavePersonnelEvent;
import org.kuali.coeus.common.budget.impl.nonpersonnel.BudgetExpensesRuleEvent;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/proposalBudget"})
public class ProposalBudgetPeriodProjectCostController
extends ProposalBudgetControllerBase {
    public static final String NEW_FORMULATED_COST = "addProjectBudgetLineItemHelper.budgetLineItem.budgetFormulatedCosts";
    public static final String BUDGET_BUDGET_PERIODS = "budget.budgetPeriods_";
    public static final String BUDGET_LINE_ITEMS = "_.budgetLineItems";
    public static final String COST_ELEMENT = "costElement";
    public static final String ADD_PROJECT_PERSONNEL_HELPER_BUDGET_LINE_ITEM = "addProjectPersonnelHelper.budgetLineItem.";
    public static final String COST_ELEMENT_BO = "costElementBO";

    @Transactional
    @RequestMapping(params={"methodToCall=assignLineItemToPeriod"})
    public ModelAndView assignLineItemToPeriod(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        ModelAndView modelAndView = this.getModelAndViewService().getModelAndView((UifFormBase)form);
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
        BudgetPeriod budgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
        DialogResponse dialogResponse = form.getDialogResponse("PropBudget-ConfirmPeriodChangesDialog");
        if (dialogResponse == null && budgetPeriod.getBudgetPeriod() > 1 && !this.isBudgetLineItemExists(budget)) {
            modelAndView = this.getModelAndViewService().showDialog("PropBudget-ConfirmPeriodChangesDialog", true, (UifFormBase)form);
        } else {
            boolean confirmResetDefault;
            boolean bl = confirmResetDefault = dialogResponse == null || dialogResponse.getResponseAsBoolean();
            if (confirmResetDefault) {
                form.getAddProjectBudgetLineItemHelper().reset();
                form.getAddProjectBudgetLineItemHelper().setCurrentTabBudgetPeriod(budgetPeriod);
                modelAndView = this.getModelAndViewService().showDialog("PropBudget-NonPersonnelCostsPage-AddNonPersonnel-Dialog", true, (UifFormBase)form);
            }
        }
        return modelAndView;
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addSPELineItemToPeriod"})
    public ModelAndView addSPELineItemToPeriod(@RequestParam(value="budgetPeriod") String budgetPeriod, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        int budgetPeriodIndex = Integer.parseInt(budgetPeriod) - 1;
        String newLineItemPath = BUDGET_BUDGET_PERIODS + budgetPeriodIndex + BUDGET_LINE_ITEMS;
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetLineItem newBudgetLineItem = (BudgetLineItem)form.getNewCollectionLines().get(newLineItemPath);
        Date lineItemStartDate = newBudgetLineItem.getStartDate();
        Date lineItemEndDate = newBudgetLineItem.getEndDate();
        newBudgetLineItem.setBudget(budget);
        BudgetPeriod currentTabBudgetPeriod = budget.getBudgetPeriods().get(budgetPeriodIndex);
        this.getBudgetService().populateNewBudgetLineItem(newBudgetLineItem, currentTabBudgetPeriod);
        newBudgetLineItem.setStartDate(lineItemStartDate);
        newBudgetLineItem.setEndDate(lineItemEndDate);
        boolean rulePassed = this.isValidBudgetLineItem(budget, newBudgetLineItem, currentTabBudgetPeriod, "newCollectionLines['budget.budgetPeriods_0_.budgetLineItems']");
        if (rulePassed) {
            this.getBudgetCalculationService().populateCalculatedAmount((Budget)budget, newBudgetLineItem);
            this.getBudgetService().recalculateBudgetPeriod(budget, currentTabBudgetPeriod);
            this.getCollectionControllerService().addLine((UifFormBase)form);
            this.getDataObjectService().save((Object)budget, new PersistenceOption[0]);
            this.validateSPEBudgetExpenses(budget, currentTabBudgetPeriod);
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected boolean isValidBudgetLineItem(Budget budget, BudgetLineItem newBudgetLineItem, BudgetPeriod budgetPeriod, String errorPath) {
        boolean rulePassed = true;
        if (this.isPersonnelLineItem(newBudgetLineItem)) {
            BudgetPersonnelDetails newBudgetPersonnelDetail = this.getNewPersonnelLineItem(budget, budgetPeriod, newBudgetLineItem);
            rulePassed &= this.getKcBusinessRulesEngine().applyRules(new BudgetAddPersonnelPeriodEvent(budget, budgetPeriod, newBudgetLineItem, newBudgetPersonnelDetail, errorPath, COST_ELEMENT)).booleanValue();
        } else {
            rulePassed = this.isSaveBudgetLineItemRulePassed(budget, budgetPeriod, newBudgetLineItem, errorPath);
        }
        return rulePassed;
    }

    protected boolean isSaveBudgetLineItemRulePassed(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem, String errorPath) {
        return this.getKcBusinessRulesEngine().applyRules(new SaveBudgetLineItemEvent(budget, errorPath, newBudgetLineItem, budgetPeriod));
    }

    protected BudgetPersonnelDetails getNewPersonnelLineItem(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem) {
        BudgetPersonnelDetails newBudgetPersonnelDetail = new BudgetPersonnelDetails();
        newBudgetPersonnelDetail.setPersonSequenceNumber(BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonSequenceNumber());
        newBudgetPersonnelDetail.setStartDate(newBudgetLineItem.getStartDate());
        newBudgetPersonnelDetail.setEndDate(newBudgetLineItem.getEndDate());
        newBudgetPersonnelDetail.setBudgetLineItem(newBudgetLineItem);
        return newBudgetPersonnelDetail;
    }

    protected boolean isPersonnelLineItem(BudgetLineItem budgetLineItem) {
        String personnelBudgetCategoryTypeCode = this.getBudgetCalculationService().getPersonnelBudgetCategoryTypeCode();
        this.refreshCostElement(budgetLineItem);
        return budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(personnelBudgetCategoryTypeCode);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addLineItemToPeriod"})
    public ModelAndView addLineItemToPeriod(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod currentTabBudgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        BudgetLineItem newBudgetLineItem = form.getAddProjectBudgetLineItemHelper().getBudgetLineItem();
        newBudgetLineItem.setBudget(budget);
        this.getBudgetService().populateNewBudgetLineItem(newBudgetLineItem, currentTabBudgetPeriod);
        this.getBudgetCalculationService().populateCalculatedAmount((Budget)budget, newBudgetLineItem);
        currentTabBudgetPeriod.getBudgetLineItems().add(newBudgetLineItem);
        this.getBudgetService().recalculateBudgetPeriod(budget, currentTabBudgetPeriod);
        this.getDataObjectService().save((Object)budget, new PersistenceOption[0]);
        form.getAddProjectBudgetLineItemHelper().reset();
        this.validateBudgetExpenses(budget, currentTabBudgetPeriod);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editNonPersonnelPeriodDetails"})
    public ModelAndView editNonPersonnelPeriodDetails(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
            BudgetPeriod budgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
            form.getAddProjectBudgetLineItemHelper().reset();
            BudgetLineItem editBudgetLineItem = form.getBudget().getBudgetLineItems().get(Integer.parseInt(selectedLine));
            String editLineIndex = Integer.toString(budgetPeriod.getBudgetLineItems().indexOf(editBudgetLineItem));
            form.getAddProjectBudgetLineItemHelper().setBudgetLineItem((BudgetLineItem)this.getDataObjectService().copyInstance((Object)editBudgetLineItem, new CopyOption[0]));
            form.getAddProjectBudgetLineItemHelper().setEditLineIndex(editLineIndex);
            form.getAddProjectBudgetLineItemHelper().setCurrentTabBudgetPeriod(budgetPeriod);
            form.getAddProjectBudgetLineItemHelper().setBudgetCategoryTypeCode(editBudgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode());
        }
        return this.getModelAndViewService().showDialog("PropBudget-NonPersonnelCostsPage-EditNonPersonnel-Dialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editSPELineItemDetails"})
    public ModelAndView editSPELineItemDetails(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
            BudgetPeriod budgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
            form.getAddProjectBudgetLineItemHelper().reset();
            BudgetLineItem editBudgetLineItem = budgetPeriod.getBudgetLineItems().get(Integer.parseInt(selectedLine));
            String editLineIndex = Integer.toString(budgetPeriod.getBudgetLineItems().indexOf(editBudgetLineItem));
            form.getAddProjectBudgetLineItemHelper().setBudgetLineItem((BudgetLineItem)this.getDataObjectService().copyInstance((Object)editBudgetLineItem, new CopyOption[0]));
            form.getAddProjectBudgetLineItemHelper().setEditLineIndex(editLineIndex);
            form.getAddProjectBudgetLineItemHelper().setCurrentTabBudgetPeriod(budgetPeriod);
            form.getAddProjectBudgetLineItemHelper().setBudgetCategoryTypeCode(editBudgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode());
        }
        return this.getModelAndViewService().showDialog("PropBudget-SinglePointEntryPage-EditNonPersonnel-Dialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=refresh", "refreshCaller=PropBudget-EditNonPersonnelPeriod-Section"})
    public ModelAndView refreshNonPersonnelPeriodDetails(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        form.setUpdateComponentId("PropBudget-EditNonPersonnelPeriod-Section");
        this.getDataObjectService().wrap((Object)form.getAddProjectBudgetLineItemHelper().getBudgetLineItem()).fetchRelationship(COST_ELEMENT_BO);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=deleteBudgetLineItem"})
    public ModelAndView deleteBudgetLineItem(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            BudgetLineItem deletedBudgetLineItem = form.getBudget().getBudgetLineItems().get(Integer.parseInt(selectedLine));
            Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
            BudgetPeriod budgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
            budgetPeriod.getBudgetLineItems().remove(deletedBudgetLineItem);
            this.validateBudgetExpenses(budget, budgetPeriod);
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=deleteSPEBudgetLineItem"})
    public ModelAndView deleteSPEBudgetLineItem(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isNotEmpty((CharSequence)selectedLine)) {
            Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
            BudgetPeriod budgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
            BudgetLineItem deletedBudgetLineItem = budgetPeriod.getBudgetLineItems().get(Integer.parseInt(selectedLine));
            budgetPeriod.getBudgetLineItems().remove(deletedBudgetLineItem);
            this.validateBudgetExpenses(budget, budgetPeriod);
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=saveBudgetLineItem"})
    public ModelAndView saveBudgetLineItem(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.setEditedBudgetLineItem(form);
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod budgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        this.validateBudgetExpenses(budget, budgetPeriod);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=saveSPEBudgetLineItem"})
    public ModelAndView saveSPEBudgetLineItem(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod budgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        BudgetLineItem budgetLineItem = form.getAddProjectBudgetLineItemHelper().getBudgetLineItem();
        boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new BudgetSavePersonnelEvent((Budget)budget, budgetPeriod));
        rulePassed &= this.getKcBusinessRulesEngine().applyRules(new BudgetSaveEvent(budget)).booleanValue();
        if (rulePassed &= this.isSaveBudgetLineItemRulePassed(budget, budgetPeriod, budgetLineItem, ADD_PROJECT_PERSONNEL_HELPER_BUDGET_LINE_ITEM)) {
            return this.saveBudgetLineItem(form);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void validateBudgetExpenses(Budget budget, BudgetPeriod budgetPeriod) {
        this.validateExpenses(budget, budgetPeriod, BudgetConstants.BudgetAuditRules.NON_PERSONNEL_COSTS.getPageId());
    }

    protected void validateSPEBudgetExpenses(Budget budget, BudgetPeriod budgetPeriod) {
        this.validateExpenses(budget, budgetPeriod, BudgetConstants.BudgetAuditRules.SPE_LINEITEM_COSTS.getPageId());
    }

    protected void validateExpenses(Budget budget, BudgetPeriod budgetPeriod, String errorPath) {
        this.getBudgetCalculationService().calculateBudgetPeriod(budget, budgetPeriod);
        this.getKcBusinessRulesEngine().applyRules(new BudgetExpensesRuleEvent(budget, errorPath));
    }

    @Transactional
    @RequestMapping(params={"methodToCall=saveAndApplyToLaterPeriods"})
    public ModelAndView saveAndApplyToLaterPeriods(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod currentTabBudgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        BudgetLineItem budgetLineItem = form.getAddProjectBudgetLineItemHelper().getBudgetLineItem();
        this.setEditedBudgetLineItem(form);
        DialogResponse dialogResponse = form.getDialogResponse("PropBudget-NonPersonnelCosts-ApplyToLaterPeriods");
        boolean lineItemInLaterPeriods = this.isLineItemInLaterPeriods(budget, budgetLineItem);
        if (dialogResponse == null && lineItemInLaterPeriods) {
            return this.getModelAndViewService().showDialog("PropBudget-NonPersonnelCosts-ApplyToLaterPeriods", true, (UifFormBase)form);
        }
        if (dialogResponse != null && dialogResponse.getResponseAsBoolean() || !lineItemInLaterPeriods) {
            this.getBudgetCalculationService().applyToLaterPeriods(budget, currentTabBudgetPeriod, budgetLineItem);
            if (this.costElementChanged(budgetLineItem, form.getAddProjectBudgetLineItemHelper().getBudgetLineItem())) {
                this.resetCalculatedAmountsForAllPeriods(budget, budgetLineItem);
            }
            this.validateBudgetExpenses(budget, currentTabBudgetPeriod);
            super.save(form);
            return this.getKcCommonControllerService().closeDialog("PropBudget-NonPersonnelCostsPage-EditNonPersonnel-Dialog", form);
        }
        return null;
    }

    protected void resetCalculatedAmountsForAllPeriods(Budget budget, BudgetLineItem budgetLineItem) {
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : period.getBudgetLineItems()) {
                if (!lineItem.getLineItemNumber().equals(budgetLineItem.getLineItemNumber())) continue;
                this.resetCalculatedAmounts(lineItem);
            }
        }
    }

    protected void resetCalculatedAmounts(BudgetLineItem lineItem) {
        lineItem.setBudgetLineItemCalculatedAmounts(new ArrayList<BudgetLineItemCalculatedAmount>());
    }

    protected boolean isLineItemInLaterPeriods(Budget budget, BudgetLineItem budgetLineItem) {
        return budget.getBudgetLineItems().stream().anyMatch(lineItem -> budgetLineItem.getLineItemNumber().equals(lineItem.getBasedOnLineItem()) && budgetLineItem.getBudgetPeriod().compareTo(lineItem.getBudgetPeriod()) < 0);
    }

    protected BudgetLineItem setEditedBudgetLineItem(ProposalBudgetForm form) {
        BudgetLineItem budgetLineItem = form.getAddProjectBudgetLineItemHelper().getBudgetLineItem();
        BudgetPeriod budgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        this.setLineItemBudgetCategory(budgetLineItem);
        int editLineIndex = Integer.parseInt(form.getAddProjectBudgetLineItemHelper().getEditLineIndex());
        BudgetLineItem newBudgetLineItem = (BudgetLineItem)this.getDataObjectService().save((Object)budgetLineItem, new PersistenceOption[0]);
        if (this.costElementChanged(budgetPeriod.getBudgetLineItems().get(editLineIndex), newBudgetLineItem)) {
            this.resetCalculatedAmounts(newBudgetLineItem);
        }
        budgetPeriod.getBudgetLineItems().set(editLineIndex, newBudgetLineItem);
        return newBudgetLineItem;
    }

    @Transactional
    @RequestMapping(params={"methodToCall=syncToPeriodCostDirectLimit"})
    public ModelAndView syncToPeriodCostDirectLimit(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        boolean confirmResetDefault;
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod currentTabBudgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        BudgetLineItem budgetLineItem = this.getCurrentBudgetLineItem(form, currentTabBudgetPeriod);
        DialogResponse dialogResponse = form.getDialogResponse("PropBudget-NonPersonnelCosts-SyncToDirectCostLimit");
        if (dialogResponse == null && currentTabBudgetPeriod.getTotalDirectCostForSync().isGreaterThan((AbstractDecimal)currentTabBudgetPeriod.getDirectCostLimit())) {
            return this.getModelAndViewService().showDialog("PropBudget-NonPersonnelCosts-SyncToDirectCostLimit", true, (UifFormBase)form);
        }
        boolean bl = confirmResetDefault = dialogResponse == null || dialogResponse.getResponseAsBoolean();
        if (confirmResetDefault) {
            boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new ApplyToPeriodsBudgetEvent(budget, "addProjectBudgetLineItemHelper.budgetLineItem.", budgetLineItem, currentTabBudgetPeriod));
            if (rulePassed &= this.getKcBusinessRulesEngine().applyRules(new BudgetDirectCostLimitEvent(budget, currentTabBudgetPeriod, budgetLineItem, "addProjectBudgetLineItemHelper.budgetLineItem.")).booleanValue()) {
                boolean syncComplete = this.getBudgetCalculationService().syncToPeriodDirectCostLimit(budget, currentTabBudgetPeriod, budgetLineItem);
                form.getAddProjectBudgetLineItemHelper().setBudgetLineItem(budgetLineItem);
                if (!syncComplete) {
                    this.getGlobalVariableService().getMessageMap().putError("addProjectBudgetLineItemHelper.budgetLineItem.lineItemCost", "insufficient.amount.to.period.direct.cost.limit.sync", new String[0]);
                }
            }
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=syncToPeriodCostLimit"})
    public ModelAndView syncToPeriodCostLimit(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        boolean confirmResetDefault;
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod currentTabBudgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        BudgetLineItem budgetLineItem = this.getCurrentBudgetLineItem(form, currentTabBudgetPeriod);
        DialogResponse dialogResponse = form.getDialogResponse("PropBudget-NonPersonnelCosts-SyncToPeriodCostLimit");
        if (dialogResponse == null && currentTabBudgetPeriod.getTotalCost().isGreaterThan((AbstractDecimal)currentTabBudgetPeriod.getTotalCostLimit())) {
            return this.getModelAndViewService().showDialog("PropBudget-NonPersonnelCosts-SyncToPeriodCostLimit", true, (UifFormBase)form);
        }
        boolean bl = confirmResetDefault = dialogResponse == null || dialogResponse.getResponseAsBoolean();
        if (confirmResetDefault) {
            boolean rulePassed = this.getKcBusinessRulesEngine().applyRules(new ApplyToPeriodsBudgetEvent(budget, "addProjectBudgetLineItemHelper.budgetLineItem.", budgetLineItem, currentTabBudgetPeriod));
            if (rulePassed &= this.getKcBusinessRulesEngine().applyRules(new BudgetPeriodCostLimitEvent(budget, currentTabBudgetPeriod, budgetLineItem, "addProjectBudgetLineItemHelper.budgetLineItem.")).booleanValue()) {
                boolean syncComplete = this.getBudgetCalculationService().syncToPeriodCostLimit(budget, currentTabBudgetPeriod, budgetLineItem);
                form.getAddProjectBudgetLineItemHelper().setBudgetLineItem(budgetLineItem);
                if (!syncComplete) {
                    this.getGlobalVariableService().getMessageMap().putError("addProjectBudgetLineItemHelper.budgetLineItem.lineItemCost", "insufficient.amount.to.sync", new String[0]);
                }
            }
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    public BudgetLineItem getCurrentBudgetLineItem(ProposalBudgetForm form, BudgetPeriod currentTabBudgetPeriod) {
        int editLineIndex = Integer.parseInt(form.getAddProjectBudgetLineItemHelper().getEditLineIndex());
        BudgetLineItem budgetLineItem = currentTabBudgetPeriod.getBudgetLineItems().get(editLineIndex);
        if (budgetLineItem.getBudgetLineItemId() == null) {
            budgetLineItem = (BudgetLineItem)this.getDataObjectService().save((Object)budgetLineItem, new PersistenceOption[0]);
            currentTabBudgetPeriod.getBudgetLineItems().set(editLineIndex, budgetLineItem);
        }
        return budgetLineItem;
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editParticipantDetails"})
    public ModelAndView editParticipantDetails(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
        BudgetPeriod currentTabBudgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
        form.getAddProjectBudgetLineItemHelper().setCurrentTabBudgetPeriod(currentTabBudgetPeriod);
        String editLineIndex = Integer.toString(budget.getBudgetPeriods().indexOf(currentTabBudgetPeriod));
        form.getAddProjectBudgetLineItemHelper().setEditLineIndex(editLineIndex);
        return this.getModelAndViewService().showDialog("PropBudget-NonPersonnelCostsPage-EditParticipantSupport-Dialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=editSEPParticipantDetails"})
    public ModelAndView editSEPParticipantDetails(@RequestParam(value="budgetPeriodId") String budgetPeriodId, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        Long currentTabBudgetPeriodId = Long.parseLong(budgetPeriodId);
        BudgetPeriod currentTabBudgetPeriod = this.getBudgetPeriod(currentTabBudgetPeriodId, budget);
        form.getAddProjectBudgetLineItemHelper().setCurrentTabBudgetPeriod(currentTabBudgetPeriod);
        String editLineIndex = Integer.toString(budget.getBudgetPeriods().indexOf(currentTabBudgetPeriod));
        form.getAddProjectBudgetLineItemHelper().setEditLineIndex(editLineIndex);
        return this.getModelAndViewService().showDialog("PropBudget-SinglePointEntryPage-EditParticipantSupport-Dialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=saveParticipantDetails"})
    public ModelAndView saveParticipantDetails(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        BudgetPeriod currentTabBudgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        this.getDataObjectService().save((Object)currentTabBudgetPeriod, new PersistenceOption[0]);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    private BudgetPeriod getBudgetPeriod(Long currentTabBudgetPeriodId, Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (!budgetPeriod.getBudgetPeriodId().equals(currentTabBudgetPeriodId)) continue;
            return budgetPeriod;
        }
        return null;
    }

    private void setLineItemBudgetCategory(BudgetLineItem budgetLineItem) {
        if (this.budgetCategoryChanged(budgetLineItem)) {
            this.getDataObjectService().wrap((Object)budgetLineItem).fetchRelationship("budgetCategory");
            budgetLineItem.getCostElementBO().setBudgetCategory(budgetLineItem.getBudgetCategory());
            budgetLineItem.getCostElementBO().setBudgetCategoryCode(budgetLineItem.getBudgetCategoryCode());
        } else if (this.costElementChanged(budgetLineItem)) {
            this.refreshCostElement(budgetLineItem);
        }
    }

    protected void refreshCostElement(BudgetLineItem budgetLineItem) {
        this.getDataObjectService().wrap((Object)budgetLineItem).fetchRelationship(COST_ELEMENT_BO);
        budgetLineItem.setBudgetCategoryCode(budgetLineItem.getCostElementBO().getBudgetCategoryCode());
        budgetLineItem.setBudgetCategory(budgetLineItem.getCostElementBO().getBudgetCategory());
    }

    protected boolean costElementChanged(BudgetLineItem budgetLineItem) {
        return !budgetLineItem.getCostElement().equals(budgetLineItem.getCostElementBO().getCostElement());
    }

    protected boolean costElementChanged(BudgetLineItem budgetLineItem, BudgetLineItem previousBudgetLineItem) {
        return !budgetLineItem.getCostElement().equals(previousBudgetLineItem.getCostElement());
    }

    protected boolean budgetCategoryChanged(BudgetLineItem budgetLineItem) {
        return !budgetLineItem.getBudgetCategoryCode().equals(budgetLineItem.getBudgetCategory().getCode());
    }

    private boolean isBudgetLineItemExists(Budget budget) {
        boolean lineItemExists = false;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod() <= 1 || budgetPeriod.getBudgetLineItems().size() <= 0) continue;
            lineItemExists = true;
            break;
        }
        return lineItemExists;
    }

    @Transactional
    @RequestMapping(params={"methodToCall=addFormulatedCost"})
    public ModelAndView addFormulatedCost(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        this.getCollectionControllerService().addLine((UifFormBase)form);
        this.calculateAndUpdateFormulatedCost(form);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=updateFormulatedCost"})
    public ModelAndView updateFormulatedCost(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        String formulateCostIndex = form.getAddProjectBudgetLineItemHelper().getBudgetFormulatedCostIndex();
        form.getAddProjectBudgetLineItemHelper().getBudgetLineItem().getBudgetFormulatedCosts().set(Integer.parseInt(formulateCostIndex), form.getAddProjectBudgetLineItemHelper().getBudgetFormulatedCostDetail());
        this.calculateAndUpdateFormulatedCost(form);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=deleteFormulatedCost"})
    public ModelAndView deleteFormulatedCost(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        DialogResponse dialogResponse = form.getDialogResponse("PropBudget-FormulatedCost-DeleteConfirm");
        if (dialogResponse == null) {
            return this.getModelAndViewService().showDialog("PropBudget-FormulatedCost-DeleteConfirm", false, (UifFormBase)form);
        }
        if (dialogResponse.getResponseAsBoolean()) {
            this.getCollectionControllerService().deleteLine((UifFormBase)form);
            this.calculateAndUpdateFormulatedCost(form);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=refreshFormulatedUnitCost"})
    public ModelAndView refreshFormulatedUnitCost(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        String newLineItemPath = NEW_FORMULATED_COST;
        BudgetFormulatedCostDetail newBudgetFormulatedCostDetail = (BudgetFormulatedCostDetail)form.getNewCollectionLines().get(newLineItemPath);
        String leadUnitNumber = form.getBudget().getDevelopmentProposal().getOwnedByUnitNumber();
        String formulatedType = newBudgetFormulatedCostDetail.getFormulatedTypeCode();
        ScaleTwoDecimal unitCost = this.getBudgetRatesService().getUnitFormulatedCost(leadUnitNumber, formulatedType);
        newBudgetFormulatedCostDetail.setUnitCost(unitCost);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void calculateAndUpdateFormulatedCost(ProposalBudgetForm form) {
        BudgetLineItem budgetLineItem = form.getAddProjectBudgetLineItemHelper().getBudgetLineItem();
        this.getBudgetCalculationService().calculateAndUpdateFormulatedCost(budgetLineItem);
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetPeriod currentTabBudgetPeriod = form.getAddProjectBudgetLineItemHelper().getCurrentTabBudgetPeriod();
        this.getBudgetService().recalculateBudgetPeriod(budget, currentTabBudgetPeriod);
    }

    @ResponseBody
    @Transactional
    @RequestMapping(params={"methodToCall=resetEditLineItem"})
    public void resetEditLineItem(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        form.getAddProjectBudgetLineItemHelper().reset();
    }

    @Transactional
    @RequestMapping(params={"methodToCall=setAddUnitFormulatedCost"})
    public ModelAndView setUnitFormulatedCost(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        BudgetFormulatedCostDetail budgetFormulatedCostDetail = (BudgetFormulatedCostDetail)form.getNewCollectionLines().get(NEW_FORMULATED_COST);
        return this.setUnitFormulatedCost(form, budgetFormulatedCostDetail);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=setEditUnitFormulatedCost"})
    public ModelAndView setEditUnitFormulatedCost(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        BudgetFormulatedCostDetail budgetFormulatedCostDetail = form.getAddProjectBudgetLineItemHelper().getBudgetFormulatedCostDetail();
        return this.setUnitFormulatedCost(form, budgetFormulatedCostDetail);
    }

    protected ModelAndView setUnitFormulatedCost(ProposalBudgetForm form, BudgetFormulatedCostDetail budgetFormulatedCostDetail) {
        ScaleTwoDecimal unitCost = this.getBudgetRatesService().getUnitFormulatedCost(form.getBudget().getDevelopmentProposal().getUnitNumber(), budgetFormulatedCostDetail.getFormulatedTypeCode());
        budgetFormulatedCostDetail.setUnitCost(unitCost);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=displayEditFormulatedCost"})
    public ModelAndView displayEditFormulatedCost(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        form.getAddProjectBudgetLineItemHelper().setBudgetFormulatedCostIndex(selectedLine);
        BudgetFormulatedCostDetail budgetFormulatedCostDetail = form.getAddProjectBudgetLineItemHelper().getBudgetLineItem().getBudgetFormulatedCosts().get(Integer.parseInt(selectedLine));
        BudgetFormulatedCostDetail tmpBudgetFormulatedCostDetail = new BudgetFormulatedCostDetail();
        PropertyUtils.copyProperties((Object)tmpBudgetFormulatedCostDetail, (Object)budgetFormulatedCostDetail);
        form.getAddProjectBudgetLineItemHelper().setBudgetFormulatedCostDetail(tmpBudgetFormulatedCostDetail);
        return this.getModelAndViewService().showDialog("PropBudget-FormulatedCost-EditDetails", true, (UifFormBase)form);
    }
}

