/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import com.lowagie.text.exceptions.BadPasswordException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.standalone.modular.StandaloneModularBudgetCommunicationException;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormFileContract;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentAuthorizer;
import org.kuali.coeus.propdev.impl.auth.ProposalDevelopmentDocumentViewAuthorizer;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.s2s.FormPackageCompilationService;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sApplication;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sPackageInfo;
import org.kuali.coeus.propdev.impl.s2s.S2sPrintFormsInfo;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedForm;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.propdev.impl.s2s.nih.NihSubmissionImageService;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverride;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverrideApplicationData;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverrideAttachment;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.FormGenerationResults;
import org.kuali.coeus.s2sgen.api.generate.FormGeneratorService;
import org.kuali.coeus.s2sgen.api.print.FormElements;
import org.kuali.coeus.s2sgen.api.print.FormPackage;
import org.kuali.coeus.s2sgen.api.print.FormPackageService;
import org.kuali.coeus.s2sgen.api.print.FormPrintResult;
import org.kuali.coeus.s2sgen.api.print.FormPrintService;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.controller.ControllerFileUtils;
import org.kuali.coeus.sys.framework.util.XmlUtils;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.kuali.rice.krad.web.service.impl.CollectionControllerServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentS2SController
extends ProposalDevelopmentControllerBase {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentS2SController.class);
    private static final String GRANTS_GOV_FORM_VALIDATION_ERRORS = "grantsGovFormValidationErrors";
    private static final String CURRENT_GRANT_APPLICATION_XML = "Current Grant Application.xml";
    private static final String OVERRIDDEN_GRANT_APPLICATION_XML = "Overridden Grant Application.xml";
    private static final String ERROR_NO_GRANTS_GOV_FORM_SELECTED = "error.proposalDevelopment.no.grants.gov.form.selected";
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="s2sUserAttachedFormService")
    private S2sUserAttachedFormService s2sUserAttachedFormService;
    @Autowired
    @Qualifier(value="formPrintService")
    private FormPrintService formPrintService;
    @Autowired
    @Qualifier(value="proposalDevelopmentDocumentViewAuthorizer")
    private ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer;
    @Autowired
    @Qualifier(value="formGeneratorService")
    private FormGeneratorService formGeneratorService;
    @Autowired
    @Qualifier(value="nihSubmissionImageService")
    private NihSubmissionImageService nihSubmissionImageService;
    @Autowired
    @Qualifier(value="formPackageService")
    private FormPackageService formPackageService;
    @Autowired
    @Qualifier(value="formPackageCompilationService")
    private FormPackageCompilationService formPackageCompilationService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refresh", "refreshCaller=S2sOpportunity-LookupView"})
    public ModelAndView refresh(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        DevelopmentProposal proposal = document.getDevelopmentProposal();
        if (form.getNewS2sOpportunity() != null && StringUtils.isNotEmpty((CharSequence)form.getNewS2sOpportunity().getOpportunityId())) {
            proposal.setS2sOpportunity(form.getNewS2sOpportunity());
            proposal.getS2sOpportunity().setDevelopmentProposal(proposal);
            if (StringUtils.isBlank((CharSequence)form.getNewS2sOpportunity().getS2sSubmissionTypeCode())) {
                String defaultS2sSubmissionTypeCode = this.getProposalTypeService().getDefaultSubmissionTypeCode(proposal.getProposalTypeCode());
                proposal.getS2sOpportunity().setS2sSubmissionTypeCode(defaultS2sSubmissionTypeCode);
                this.getDataObjectService().wrap((Object)proposal.getS2sOpportunity()).fetchRelationship("s2sSubmissionType");
            }
            proposal.updateFromS2sOpportunity(form.getNewS2sOpportunity());
            form.setNewS2sOpportunity(new S2sOpportunity());
        }
        this.setAndValidateMandatoryForms(proposal);
        super.save(form, result, request, response);
        proposal.refreshNihOpportunity();
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=clearOpportunity"})
    public ModelAndView clearOpportunity(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).clearOpportunity(form.getDevelopmentProposal());
        form.getDevelopmentProposal().refreshNihOpportunity();
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=retrieveGrantApplicationXml"})
    public ModelAndView retrieveGrantApplicationXml(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        S2sAppSubmission submission = form.getDisplayedS2sAppSubmission();
        if (submission != null && submission.getS2sApplication() != null) {
            S2sApplication application = submission.getS2sApplication();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                StringReader in = new StringReader(application.getApplication());
                try {
                    XmlUtils.prettyPrint(new StreamSource(in), new StreamResult(out));
                    ControllerFileUtils.streamOutputToResponse(response, out, application.getContentType(), application.getName(), out.size());
                    ModelAndView modelAndView = null;
                    in.close();
                    return modelAndView;
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=retrieveGrantApplicationZip"})
    public ModelAndView retrieveGrantApplicationZip(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        Optional.ofNullable(document.getDevelopmentProposal().getDisplayedS2sAppSubmission()).ifPresent(submission -> {
            if (StringUtils.isNotBlank((CharSequence)submission.getGgApplicationZipFileId())) {
                try {
                    ControllerFileUtils.streamToResponse(submission.getGgApplicationZipData(), "Grant Submission Package.zip", "application/octet-stream", response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (submission.getGgTrackingId() != null) {
                this.getS2sSubmissionService().getApplicationZip(document.getDevelopmentProposal().getS2sOpportunity(), (S2sAppSubmission)submission).ifPresent(file -> {
                    if (ArrayUtils.isNotEmpty((byte[])file.getData())) {
                        submission.setGgApplicationZipData(file.getData());
                        this.getDataObjectService().save(submission, new PersistenceOption[]{PersistenceOption.FLUSH});
                        try {
                            ControllerFileUtils.streamToResponse(file, response);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=previewPackage"})
    public ModelAndView previewPackage(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        this.checkPrintAuthorization(proposalDevelopmentDocument);
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        Set includedFormNamespaces = developmentProposal.getS2sOppForms().stream().filter(S2sOppForms::getInclude).map(S2sOppForms::getOppNameSpace).collect(Collectors.toSet());
        FormPackage formPackage = this.getFormPackageService().retrieveFormPackage(includedFormNamespaces, (ProposalDevelopmentDocumentContract)proposalDevelopmentDocument);
        FormPackageCompilationService.JobExecResult jobExecResult = this.getFormPackageCompilationService().execfillFormsJob(formPackage.getFormElements());
        form.setS2sPackageInfo(new S2sPackageInfo(formPackage, jobExecResult, UUID.randomUUID().toString()));
        return this.getModelAndViewService().showDialog("PropDev-OpportunityPrintPackageDialog-Section", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=checkPackage"})
    public void checkPackage(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Optional<FormPackageCompilationService.JobFinalResult> finalResult = this.getFormPackageCompilationService().checkFinalResult(form.getS2sPackageInfo().getJobExecResult());
        if (finalResult.isPresent()) {
            response.sendError(200);
        } else {
            response.sendError(500);
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=fetchPackage"})
    public void fetchPackage(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        if (form.getS2sPackageInfo() == null || form.getS2sPackageInfo().isDownloadComplete()) {
            return;
        }
        this.checkPrintAuthorization(proposalDevelopmentDocument);
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        Optional<FormPackageCompilationService.JobFinalResult> finalResult = this.getFormPackageCompilationService().checkFinalResult(form.getS2sPackageInfo().getJobExecResult());
        if (finalResult.isPresent()) {
            FormPackageCompilationService.FileResult result = this.getFormPackageCompilationService().compileFormPackage(developmentProposal.getS2sOpportunity(), form.getS2sPackageInfo().getFormPackage(), finalResult.get());
            if (result.valid() && result.out() != null && !form.getS2sPackageInfo().isDownloadComplete()) {
                response.addCookie(this.createDownloadCookie(form.getS2sPackageInfo().getDownloadToken(), request));
                ControllerFileUtils.streamOutputToResponse(response, result.out(), "application/zip", "Grant Submission Preview.zip", result.out().size());
                response.getOutputStream().flush();
                form.getS2sPackageInfo().setDownloadComplete(true);
            } else {
                this.getGlobalVariableService().getMessageMap().putError("noField", "error.proposalDevelopment.grants.gov.form.preview.failed", new String[0]);
            }
        }
    }

    private Cookie createDownloadCookie(String downloadToken, HttpServletRequest httpRequest) {
        Cookie dlCookie = new Cookie("KualiDownloadToken", downloadToken);
        dlCookie.setDomain(httpRequest.getServerName());
        dlCookie.setPath("/");
        dlCookie.setSecure(httpRequest.isSecure());
        return dlCookie;
    }

    private void checkPrintAuthorization(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.proposalDevelopmentDocumentViewAuthorizer.initializeDocumentAuthorizerIfNecessary(proposalDevelopmentDocument);
        if (!((ProposalDevelopmentDocumentAuthorizer)this.proposalDevelopmentDocumentViewAuthorizer.getDocumentAuthorizer()).isAuthorizedToPrint(proposalDevelopmentDocument, this.getGlobalVariableService().getUserSession().getPerson())) {
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPrincipalName(), "printForms", "Proposal");
        }
    }

    @Deprecated
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printFormsXmlOld"})
    public ModelAndView printFormsXmlOld(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        form.getDevelopmentProposal().setGrantsGovSelectFlag(true);
        return this.printFormsOld(form, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printForms"})
    public ModelAndView printForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        this.checkPrintAuthorization(proposalDevelopmentDocument);
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        if (developmentProposal.getSelectedS2sOppForms().isEmpty()) {
            this.getGlobalVariableService().getMessageMap().putError("noField", ERROR_NO_GRANTS_GOV_FORM_SELECTED, new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        Set includedFormNamespaces = developmentProposal.getS2sOppForms().stream().filter(S2sOppForms::getSelectToPrint).map(S2sOppForms::getOppNameSpace).collect(Collectors.toSet());
        List<FormElements> formElements = this.formPackageService.retrieveFormElements(includedFormNamespaces, (ProposalDevelopmentDocumentContract)proposalDevelopmentDocument).stream().filter(Objects::nonNull).toList();
        FormPackageCompilationService.JobExecResult jobExecResult = this.getFormPackageCompilationService().execFlattenFormsJob(formElements);
        form.setS2sPrintFormsInfo(new S2sPrintFormsInfo(formElements, jobExecResult, UUID.randomUUID().toString()));
        return this.getModelAndViewService().showDialog("PropDev-OpportunityPrintFormsDialog-Section", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=checkForms"})
    public void checkForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Optional<FormPackageCompilationService.JobFinalResult> finalResult = this.getFormPackageCompilationService().checkFinalResult(form.getS2sPrintFormsInfo().getJobExecResult());
        if (finalResult.isPresent()) {
            response.sendError(200);
        } else {
            response.sendError(500);
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=fetchForms"})
    public void fetchForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        if (form.getS2sPrintFormsInfo() == null || form.getS2sPrintFormsInfo().isDownloadComplete()) {
            return;
        }
        this.checkPrintAuthorization(proposalDevelopmentDocument);
        Optional<FormPackageCompilationService.JobFinalResult> finalResult = this.getFormPackageCompilationService().checkFinalResult(form.getS2sPrintFormsInfo().getJobExecResult());
        if (finalResult.isPresent()) {
            try {
                FormPackageCompilationService.FileResult result = this.getFormPackageCompilationService().compileFlattenedForms(finalResult.get());
                if (result.valid() && result.out() != null && !form.getS2sPrintFormsInfo().isDownloadComplete()) {
                    response.addCookie(this.createDownloadCookie(form.getS2sPrintFormsInfo().getDownloadToken(), request));
                    ControllerFileUtils.streamOutputToResponse(response, result.out(), "application/pdf", this.getFileNameForFormPrinting(proposalDevelopmentDocument), result.out().size());
                    response.getOutputStream().flush();
                    form.getS2sPrintFormsInfo().setDownloadComplete(true);
                } else {
                    this.getGlobalVariableService().getMessageMap().putError("noField", "error.proposalDevelopment.grants.gov.form.print.failed", new String[0]);
                }
            }
            catch (Exception e) {
                if (this.isPasswordProtectedPdfException(e)) {
                    LOG.error("Password-protected PDF attachment detected", (Throwable)e);
                    this.getGlobalVariableService().getMessageMap().putError("noField", "error.s2s.protected.pdf.attachment", new String[0]);
                }
                throw e;
            }
        }
    }

    protected String getFileNameForFormPrinting(ProposalDevelopmentDocumentContract pdDoc) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(pdDoc.getDocumentNumber());
        fileName.append(pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber());
        fileName.append(".pdf");
        return fileName.toString();
    }

    private boolean isPasswordProtectedPdfException(Throwable throwable) {
        return ExceptionUtils.getThrowableList((Throwable)throwable).stream().anyMatch(t -> t.getClass().equals(BadPasswordException.class));
    }

    @Deprecated
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printFormsOld"})
    public ModelAndView printFormsOld(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        FormPrintResult formPrintResult;
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        this.checkPrintAuthorization(proposalDevelopmentDocument);
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        if (developmentProposal.getSelectedS2sOppForms().isEmpty()) {
            this.getGlobalVariableService().getMessageMap().putError("noField", ERROR_NO_GRANTS_GOV_FORM_SELECTED, new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        try {
            formPrintResult = this.getFormPrintService().printForm((ProposalDevelopmentDocumentContract)proposalDevelopmentDocument);
        }
        catch (StandaloneModularBudgetCommunicationException e) {
            LOG.error("Error communicating with standalone Budget service", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.standalone.budget.communication.error", new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        catch (S2SException e) {
            if (this.isPasswordProtectedPdfException(e)) {
                LOG.error("Password-protected PDF attachment detected", (Throwable)e);
                this.getGlobalVariableService().getMessageMap().putError("noField", "error.s2s.protected.pdf.attachment", new String[0]);
                return this.getModelAndViewService().getModelAndView((UifFormBase)form);
            }
            throw e;
        }
        this.setValidationErrorMessage(formPrintResult.getErrors());
        KcFile attachmentDataSource = formPrintResult.getFile();
        if ((attachmentDataSource == null || attachmentDataSource.getData() == null || attachmentDataSource.getData().length == 0) && !proposalDevelopmentDocument.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue() || CollectionUtils.isNotEmpty((Collection)formPrintResult.getErrors())) {
            boolean grantsGovErrorExists = this.copyAuditErrorsToPage();
            if (grantsGovErrorExists) {
                this.getGlobalVariableService().getMessageMap().putError(GRANTS_GOV_FORM_VALIDATION_ERRORS, "validation.errors.before.grantsGov.submission", new String[0]);
            }
            proposalDevelopmentDocument.getDevelopmentProposal().setGrantsGovSelectFlag(false);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().getGrantsGovSelectFlag().booleanValue()) {
            File grantsGovXmlDirectoryFile = this.getS2sSubmissionService().getGrantsGovSavedFile(proposalDevelopmentDocument.getDevelopmentProposal());
            byte[] bytes = new byte[(int)grantsGovXmlDirectoryFile.length()];
            try (FileInputStream fileInputStream = new FileInputStream(grantsGovXmlDirectoryFile);){
                fileInputStream.read(bytes);
            }
            int size = bytes.length;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(size);){
                outputStream.write(bytes);
                ControllerFileUtils.streamOutputToResponse(response, outputStream, "binary/octet-stream", grantsGovXmlDirectoryFile.getName(), size);
                response.flushBuffer();
            }
            proposalDevelopmentDocument.getDevelopmentProposal().setGrantsGovSelectFlag(false);
            return null;
        }
        ControllerFileUtils.streamToResponse(attachmentDataSource, response);
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printNIHForms"})
    public ModelAndView printNIHForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        this.checkPrintAuthorization(proposalDevelopmentDocument);
        if (!form.getDevelopmentProposal().isNihOpportunity().booleanValue()) {
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.nih.opportunity.not.nih", new String[0]);
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        S2sAppSubmission submission = proposalDevelopmentDocument.getDevelopmentProposal().getDisplayedS2sAppSubmission();
        return submission != null ? this.printNihSubmission(form, response, submission) : this.printNihPreview(form, response);
    }

    private ModelAndView printNihSubmission(ProposalDevelopmentDocumentForm form, HttpServletResponse response, S2sAppSubmission submission) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)submission.getNihApplicationPdfFileId())) {
            ControllerFileUtils.streamToResponse(submission.getNihApplicationPdfData(), "Grant Submission.pdf", "application/pdf", response);
            return null;
        }
        if (submission.isMissingSubmissionData()) {
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        String dunsNumber = proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber();
        try {
            KcFile s2sFileDto;
            Optional<KcFile> nihPdf = this.nihSubmissionImageService.getApplicationPdf(submission, dunsNumber);
            if (nihPdf.isPresent() && ArrayUtils.isNotEmpty((byte[])(s2sFileDto = nihPdf.get()).getData())) {
                submission.setNihApplicationPdfData(s2sFileDto.getData());
                this.getDataObjectService().save((Object)submission, new PersistenceOption[]{PersistenceOption.FLUSH});
                ControllerFileUtils.streamToResponse(s2sFileDto, response);
                return null;
            }
        }
        catch (S2sCommunicationException e) {
            LOG.error("Error communicating with the NIH Submission Image service", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.nih.service.unknown", new String[0]);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    private ModelAndView printNihPreview(ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        String dunsNumber = proposalDevelopmentDocument.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber();
        try {
            FormGenerationResults results = this.generateAndValidateForms(proposalDevelopmentDocument);
            if (CollectionUtils.isNotEmpty((Collection)results.getErrors()) || StringUtils.isBlank((CharSequence)results.getApplicationXml())) {
                this.setValidationErrorMessage(results.getErrors());
                this.copyAuditErrorsToPage();
                return this.getModelAndViewService().getModelAndView((UifFormBase)form);
            }
            Optional<KcFile> nihPdf = this.nihSubmissionImageService.getApplicationPdf(results.getApplicationXml(), results.getAttachments(), dunsNumber);
            if (nihPdf.isPresent()) {
                ControllerFileUtils.streamToResponse(nihPdf.get(), response);
                return null;
            }
        }
        catch (StandaloneModularBudgetCommunicationException | S2SException e) {
            if (this.isPasswordProtectedPdfException(e)) {
                LOG.error("Password-protected PDF attachment detected", e);
                this.getGlobalVariableService().getMessageMap().putError("noField", "error.s2s.protected.pdf.attachment", new String[0]);
            } else if (!(e.getCause() instanceof StandaloneModularBudgetCommunicationException)) {
                LOG.error("Failed to generate S2s forms", e);
                this.getGlobalVariableService().getMessageMap().putError("noField", e.getMessage(), new String[0]);
            } else {
                LOG.error("Error communicating with standalone Budget service", e);
                this.getGlobalVariableService().getMessageMap().putError("noField", "error.standalone.budget.communication.error", new String[0]);
            }
        }
        catch (S2sCommunicationException e) {
            LOG.error("Error communicating with the NIH Submission Image service", (Throwable)e);
            this.getGlobalVariableService().getMessageMap().putError("noField", "error.nih.service.unknown", new String[0]);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void setValidationErrorMessage(List<org.kuali.coeus.s2sgen.api.core.AuditError> errors) {
        if (errors != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error list size:" + errors.size() + String.valueOf(errors));
            }
            List auditErrors = errors.stream().filter(error -> error.getLevel() != AuditError.Level.WARNING).map(error -> new AuditError(error.getErrorKey(), "error.grantsgov.schemavalidation.generic.errorkey", error.getLink(), new String[]{error.getMessageKey()})).collect(Collectors.toList());
            List<AuditError> auditWarnings = errors.stream().filter(error -> error.getLevel() == AuditError.Level.WARNING).map(error -> new AuditError(error.getErrorKey(), "error.grantsgov.schemavalidation.generic.errorkey", error.getLink(), new String[]{error.getMessageKey()})).toList();
            if (!auditErrors.isEmpty()) {
                this.getGlobalVariableService().getAuditErrorMap().put("grantsGovAuditErrors", new AuditCluster("GrantsGov", auditErrors, "Grants.Gov Errors"));
            }
            if (!auditWarnings.isEmpty()) {
                this.getGlobalVariableService().getAuditErrorMap().put("grantsGovAuditErrors", new AuditCluster("GrantsGov", auditErrors, "Grants.Gov Warnings"));
            }
        }
    }

    protected boolean copyAuditErrorsToPage() {
        boolean auditClusterFound = false;
        for (String errorKey : this.getGlobalVariableService().getAuditErrorMap().keySet()) {
            AuditError auditError;
            AuditCluster auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(errorKey);
            if (StringUtils.equalsIgnoreCase((CharSequence)auditCluster.getCategory(), (CharSequence)"Grants.Gov Errors")) {
                auditClusterFound = true;
                for (Object error : auditCluster.getAuditErrorList()) {
                    auditError = (AuditError)error;
                    this.getGlobalVariableService().getMessageMap().putError(errorKey == null ? auditError.getErrorKey() : errorKey, auditError.getMessageKey(), auditError.getParams());
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)auditCluster.getCategory(), (CharSequence)"Grants.Gov Warnings")) continue;
            for (Object error : auditCluster.getAuditErrorList()) {
                auditError = (AuditError)error;
                this.getGlobalVariableService().getMessageMap().putWarning(errorKey == null ? auditError.getErrorKey() : errorKey, auditError.getMessageKey(), auditError.getParams());
            }
        }
        return auditClusterFound;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addUserAttachedForm"})
    public ModelAndView addUserAttachedForm(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        S2sUserAttachedForm s2sUserAttachedForm = form.getS2sUserAttachedForm();
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        MultipartFile userAttachedFormFile = s2sUserAttachedForm.getNewFormFile();
        s2sUserAttachedForm.setNewFormFileBytes(userAttachedFormFile.getBytes());
        s2sUserAttachedForm.setFormFileName(userAttachedFormFile.getOriginalFilename());
        s2sUserAttachedForm.setProposalNumber(proposalDevelopmentDocument.getDevelopmentProposal().getProposalNumber());
        try {
            List<S2sUserAttachedForm> userAttachedForms = this.getS2sUserAttachedFormService().extractNSaveUserAttachedForms(proposalDevelopmentDocument, s2sUserAttachedForm);
            proposalDevelopmentDocument.getDevelopmentProposal().getS2sUserAttachedForms().addAll(userAttachedForms);
            form.setS2sUserAttachedForm(new S2sUserAttachedForm());
        }
        catch (S2SException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            if (ex.getTabErrorKey() != null) {
                if (this.getGlobalVariableService().getMessageMap().getErrorMessagesForProperty(ex.getTabErrorKey()) == null) {
                    this.getGlobalVariableService().getMessageMap().putError(ex.getTabErrorKey(), ex.getErrorKey(), ex.getParams());
                }
            }
            this.getGlobalVariableService().getMessageMap().putError("noField", ex.getErrorKey(), ex.getParams());
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=viewUserAttachedFormXML"})
    public ModelAndView viewUserAttachedFormXML(ProposalDevelopmentDocumentForm form, HttpServletResponse response, @RequestParam(value="selectedLine") String selectedLine) throws Exception {
        DevelopmentProposal developmentProposal = form.getDevelopmentProposal();
        List<S2sUserAttachedForm> s2sAttachedForms = developmentProposal.getS2sUserAttachedForms();
        S2sUserAttachedForm selectedForm = s2sAttachedForms.get(Integer.parseInt(selectedLine));
        S2sUserAttachedFormFileContract userAttachedFormFile = selectedForm.getS2sUserAttachedFormFileList().get(0);
        if (userAttachedFormFile == null) {
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        ControllerFileUtils.streamToResponse(userAttachedFormFile.getXmlFile().getBytes(), selectedForm.getFormName() + ".xml", "text/xml", response);
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=viewUserAttachedFormPDF"})
    public ModelAndView viewUserAttachedFormPDF(ProposalDevelopmentDocumentForm form, HttpServletResponse response, @RequestParam(value="selectedLine") String selectedLine) throws Exception {
        DevelopmentProposal developmentProposal = form.getDevelopmentProposal();
        List<S2sUserAttachedForm> s2sAttachedForms = developmentProposal.getS2sUserAttachedForms();
        S2sUserAttachedForm selectedForm = s2sAttachedForms.get(Integer.parseInt(selectedLine));
        S2sUserAttachedFormFileContract userAttachedFormFile = selectedForm.getS2sUserAttachedFormFileList().get(0);
        if (userAttachedFormFile == null) {
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        ControllerFileUtils.streamToResponse(userAttachedFormFile.getFormFile(), selectedForm.getFormFileName(), "application/pdf", response);
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=deleteUserAttachedForm"})
    public ModelAndView deleteUserAttachedForm(ProposalDevelopmentDocumentForm form, @RequestParam(value="selectedLine") String selectedLine) {
        S2sUserAttachedForm deleteForm = form.getDevelopmentProposal().getS2sUserAttachedForms().remove(Integer.parseInt(selectedLine));
        this.getDataObjectService().delete((Object)deleteForm);
        this.getS2sUserAttachedFormService().resetFormAvailability(form.getProposalDevelopmentDocument(), deleteForm.getNamespace());
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refreshSubmissionDetails"})
    public ModelAndView refreshSubmissionDetails(ProposalDevelopmentDocumentForm form) {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        Optional.ofNullable(document.getDevelopmentProposal().getDisplayedS2sAppSubmission()).ifPresent(submission -> {
            try {
                this.getS2sSubmissionService().refreshSubmission(document.getDevelopmentProposal().getS2sOpportunity(), (S2sAppSubmission)submission);
            }
            catch (S2sCommunicationException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                this.getGlobalVariableService().getMessageMap().putError("noField", ex.getErrorKey(), new String[]{ex.getMessage()});
            }
        });
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveUserAttachedForm"})
    public ModelAndView saveUserAttachedForm(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (form.getEditableCollectionLines().containsKey(selectedCollectionPath)) {
            form.getEditableCollectionLines().get(selectedCollectionPath).remove(selectedLine);
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addNewS2sOverride"})
    public ModelAndView addNewS2sOverride(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        block4: {
            ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
            S2sOverride s2sOverride = form.getNewS2sOverride();
            s2sOverride.setDevelopmentProposal(document.getDevelopmentProposal());
            s2sOverride.getDevelopmentProposal().setS2sOverride(s2sOverride);
            form.setNewS2sOverride(new S2sOverride());
            if (document.getDevelopmentProposal().hasS2sOpportunity()) {
                try {
                    FormGenerationResults result = this.generateWithoutOverride(document);
                    if (result.isValid()) {
                        this.syncGenerationResultToOverride(result, document.getDevelopmentProposal().getS2sOverride());
                    }
                }
                catch (S2SException e) {
                    if (!LOG.isInfoEnabled()) break block4;
                    LOG.info("Error creating submission information for override", (Throwable)e);
                }
            }
        }
        return super.save(form);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormGenerationResults generateWithoutOverride(ProposalDevelopmentDocument document) {
        boolean requiresApplOverrideDisable;
        boolean bl = requiresApplOverrideDisable = document.getDevelopmentProposal().getS2sOverride() != null && document.getDevelopmentProposal().getS2sOverride().getApplicationOverride() != null && document.getDevelopmentProposal().getS2sOverride().getApplicationOverride().getApplication() != null && document.getDevelopmentProposal().getS2sOverride().isActive();
        if (requiresApplOverrideDisable) {
            String application = document.getDevelopmentProposal().getS2sOverride().getApplicationOverride().getApplication();
            try {
                document.getDevelopmentProposal().getS2sOverride().getApplicationOverride().setApplication(null);
                FormGenerationResults formGenerationResults = this.generateAndValidateForms(document);
                return formGenerationResults;
            }
            finally {
                document.getDevelopmentProposal().getS2sOverride().getApplicationOverride().setApplication(application);
            }
        }
        return this.generateAndValidateForms(document);
    }

    private FormGenerationResults generateAndValidateForms(ProposalDevelopmentDocument pdDoc) {
        return pdDoc.getDevelopmentProposal().isMultiProjectParent() ? this.getFormGeneratorService().generateAndValidateMPForms((ProposalDevelopmentDocumentContract)pdDoc, pdDoc.getHierarchyChildren()) : this.getFormGeneratorService().generateAndValidateForms((ProposalDevelopmentDocumentContract)pdDoc);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=removeExistingS2sOverride"})
    public ModelAndView removeExistingS2sOverride(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.getDataObjectService().delete((Object)form.getDevelopmentProposal().getS2sOverride());
        form.getDevelopmentProposal().setS2sOverride(null);
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=syncCurrentGrantInformation"})
    public ModelAndView syncCurrentGrantInformation(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ProposalDevelopmentDocument document = form.getProposalDevelopmentDocument();
        if (document.getDevelopmentProposal().hasS2sOpportunity()) {
            try {
                FormGenerationResults result = this.generateWithoutOverride(document);
                if (result.isValid()) {
                    this.syncGenerationResultToOverride(result, document.getDevelopmentProposal().getS2sOverride());
                }
                this.setValidationErrorMessage(result.getErrors());
                if (this.copyAuditErrorsToPage()) {
                    this.getGlobalVariableService().getMessageMap().putError(GRANTS_GOV_FORM_VALIDATION_ERRORS, "validation.errors.before.grantsGov.submission", new String[0]);
                }
            }
            catch (S2SException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Error creating submission information for override", (Throwable)e);
                }
                this.getGlobalVariableService().getMessageMap().putError("noField", "error.grantsgov.schemavalidation.generic.errorkey", new String[]{StringUtils.isNotBlank((CharSequence)e.getErrorMessage()) ? e.getErrorMessage() : e.getMessage()});
            }
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void syncGenerationResultToOverride(FormGenerationResults result, S2sOverride s2sOverride) {
        if (s2sOverride.getApplication() == null) {
            s2sOverride.setApplication(new S2sOverrideApplicationData());
        }
        S2sOverrideApplicationData data = s2sOverride.getApplication();
        data.setApplication(result.getApplicationXml());
        data.setName(CURRENT_GRANT_APPLICATION_XML);
        data.setAttachments(result.getAttachments().stream().map(attachment -> {
            S2sOverrideAttachment s2sOverrideAttachment = new S2sOverrideAttachment();
            s2sOverrideAttachment.setApplication(data);
            s2sOverrideAttachment.setContentId(attachment.getContentId());
            s2sOverrideAttachment.setName(attachment.getFileName());
            s2sOverrideAttachment.setData(attachment.getContent());
            s2sOverrideAttachment.setContentType(attachment.getContentType());
            return s2sOverrideAttachment;
        }).collect(Collectors.toList()));
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=pushCurrentToOverride"})
    public ModelAndView pushCurrentToOverride(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        S2sOverride s2sOverride = form.getDevelopmentProposal().getS2sOverride();
        if (s2sOverride != null && s2sOverride.getApplication() != null && s2sOverride.getApplication().getApplication() != null) {
            S2sOverrideApplicationData current = s2sOverride.getApplication();
            if (s2sOverride.getApplicationOverride() == null) {
                s2sOverride.setApplicationOverride(new S2sOverrideApplicationData());
            }
            S2sOverrideApplicationData override = s2sOverride.getApplicationOverride();
            override.setApplication(current.getApplication());
            override.setName(OVERRIDDEN_GRANT_APPLICATION_XML);
            override.setAttachments(current.getAttachments().stream().map(currentAttachment -> {
                S2sOverrideAttachment s2sOverrideAttachment = new S2sOverrideAttachment();
                s2sOverrideAttachment.setApplication(override);
                s2sOverrideAttachment.setContentId(currentAttachment.getContentId());
                s2sOverrideAttachment.setName(currentAttachment.getName());
                s2sOverrideAttachment.setData(currentAttachment.getData());
                s2sOverrideAttachment.setContentType(currentAttachment.getContentType());
                return s2sOverrideAttachment;
            }).collect(Collectors.toList()));
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=retrieveApplicationXml"})
    public ModelAndView retrieveApplicationXml(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws IOException {
        HttpServletRequest request = form.getRequest();
        String attachmentPath = request.getParameter("propertyPath");
        if (StringUtils.isBlank((CharSequence)attachmentPath)) {
            throw new RuntimeException("Selected attachment was not set for line action");
        }
        KcFile attachment = (KcFile)ObjectPropertyUtils.getPropertyValue((Object)form, (String)attachmentPath);
        byte[] data = attachment.getData();
        KRADUtils.addAttachmentToResponse((HttpServletResponse)response, (InputStream)new ByteArrayInputStream(data), (String)attachment.getType(), (String)attachment.getName(), (long)data.length);
        response.flushBuffer();
        return null;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=save", "pageId=PropDev-OpportunityPage"})
    public ModelAndView saveOpportunityPage(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws IOException {
        this.setApplicationOverride(form.getDevelopmentProposal().getS2sOverride());
        return super.save(form);
    }

    protected void setApplicationOverride(S2sOverride s2sOverride) throws IOException {
        S2sOverrideApplicationData applicationOverride;
        MultipartFile file;
        byte[] content;
        if (s2sOverride != null && s2sOverride.getApplicationOverride() != null && s2sOverride.getApplicationOverride().getMultipartFile() != null && ArrayUtils.isNotEmpty((byte[])(content = (file = (applicationOverride = s2sOverride.getApplicationOverride()).getMultipartFile()).getBytes()))) {
            applicationOverride.setApplication(new String(content));
            applicationOverride.setName(file.getOriginalFilename());
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=replaceS2sOverrideApplication"})
    public ModelAndView replaceS2sOverrideApplication(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws IOException {
        this.setApplicationOverride(form.getDevelopmentProposal().getS2sOverride());
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updateHashS2sOverrideApplication"})
    public ModelAndView updateHashS2sOverrideApplication(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.updateHashApp(form);
        return super.save(form);
    }

    private void updateHashApp(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        boolean updated;
        S2sOverride s2sOverride = form.getDevelopmentProposal().getS2sOverride();
        if (s2sOverride != null && s2sOverride.getApplicationOverride() != null && s2sOverride.getApplicationOverride().isHeaderVersion1Form() && (updated = s2sOverride.getApplicationOverride().updateSha1HashInXml())) {
            this.getGlobalVariableService().getMessageMap().putInfoForSectionId("PropDev-OpportunityPage-Override-Override", "info.s2s.override.app.hash.update", new String[0]);
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updateHashFileUploadLine"})
    public ModelAndView updateHashFileUploadLine(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        CollectionControllerServiceImpl.CollectionActionParameters parameters = new CollectionControllerServiceImpl.CollectionActionParameters((UifFormBase)form, true);
        Runnable runnable = () -> this.processCollectionUpdateHashLine(form, parameters.getSelectedCollectionId(), parameters.getSelectedCollectionPath(), parameters.getSelectedLineIndex());
        ViewLifecycle.encapsulateLifecycle((View)form.getView(), (Object)form, (ViewPostMetadata)form.getViewPostMetadata(), null, (HttpServletRequest)form.getRequest(), (Runnable)runnable);
        return super.save(form);
    }

    private void processCollectionUpdateHashLine(ProposalDevelopmentDocumentForm form, String collectionId, String collectionPath, int lineIndex) {
        Collection collection = (Collection)ObjectPropertyUtils.getPropertyValue((Object)form, (String)collectionPath);
        if (collection == null) {
            throw new RuntimeException("Unable to get collection property from model for path: " + collectionPath);
        }
        if (collection instanceof List) {
            boolean updated;
            S2sOverrideAttachment attachment = (S2sOverrideAttachment)((List)collection).get(lineIndex);
            if (attachment != null && (updated = attachment.updateSha1HashInXml())) {
                String collectionLabel = (String)form.getViewPostMetadata().getComponentPostData(collectionId, "collectionLabel");
                this.getGlobalVariableService().getMessageMap().putInfoForSectionId(collectionId, "info.s2s.override.att.hash.update", new String[]{collectionLabel});
            }
        } else {
            throw new RuntimeException("Only List collection implementations are supported for the update hash by index method");
        }
    }

    public FormPrintService getFormPrintService() {
        return this.formPrintService;
    }

    public void setFormPrintService(FormPrintService formPrintService) {
        this.formPrintService = formPrintService;
    }

    public S2sUserAttachedFormService getS2sUserAttachedFormService() {
        return this.s2sUserAttachedFormService;
    }

    public void setS2sUserAttachedFormService(S2sUserAttachedFormService s2sUserAttachedFormService) {
        this.s2sUserAttachedFormService = s2sUserAttachedFormService;
    }

    public ProposalDevelopmentDocumentViewAuthorizer getProposalDevelopmentDocumentViewAuthorizer() {
        return this.proposalDevelopmentDocumentViewAuthorizer;
    }

    public void setProposalDevelopmentDocumentViewAuthorizer(ProposalDevelopmentDocumentViewAuthorizer proposalDevelopmentDocumentViewAuthorizer) {
        this.proposalDevelopmentDocumentViewAuthorizer = proposalDevelopmentDocumentViewAuthorizer;
    }

    public FormGeneratorService getFormGeneratorService() {
        return this.formGeneratorService;
    }

    public void setFormGeneratorService(FormGeneratorService formGeneratorService) {
        this.formGeneratorService = formGeneratorService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public FormPackageService getFormPackageService() {
        return this.formPackageService;
    }

    public void setFormPackageService(FormPackageService formPackageService) {
        this.formPackageService = formPackageService;
    }

    public NihSubmissionImageService getNihSubmissionImageService() {
        return this.nihSubmissionImageService;
    }

    public void setNihSubmissionImageService(NihSubmissionImageService nihSubmissionImageService) {
        this.nihSubmissionImageService = nihSubmissionImageService;
    }

    public FormPackageCompilationService getFormPackageCompilationService() {
        return this.formPackageCompilationService;
    }

    public void setFormPackageCompilationService(FormPackageCompilationService formPackageCompilationService) {
        this.formPackageCompilationService = formPackageCompilationService;
    }
}

