/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.modular;

import java.util.List;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="modularBudgetService")
public class ModularBudgetServiceImpl
implements ModularBudgetService {
    @Autowired
    @Qualifier(value="classicModularBudgetService")
    private ModularBudgetService classicModularBudgetService;
    @Autowired
    @Qualifier(value="standaloneModularBudgetService")
    private ModularBudgetService standaloneModularBudgetService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    public List<? extends BudgetModularContract> getModularBudgetAmounts(BudgetContract budgetContract) {
        return this.shouldRetrieveRemoteModularBudget() ? this.standaloneModularBudgetService.getModularBudgetAmounts(budgetContract) : this.classicModularBudgetService.getModularBudgetAmounts(budgetContract);
    }

    protected boolean shouldRetrieveRemoteModularBudget() {
        return this.parameterService.getParameterValueAsBoolean("KC-B", "All", "Standalone_Modular_Budget_Enabled", Boolean.valueOf(false));
    }

    public ModularBudgetService getClassicModularBudgetService() {
        return this.classicModularBudgetService;
    }

    public void setClassicModularBudgetService(ModularBudgetService classicModularBudgetService) {
        this.classicModularBudgetService = classicModularBudgetService;
    }

    public ModularBudgetService getStandaloneModularBudgetService() {
        return this.standaloneModularBudgetService;
    }

    public void setStandaloneModularBudgetService(ModularBudgetService standaloneModularBudgetService) {
        this.standaloneModularBudgetService = standaloneModularBudgetService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

