/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.cache;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cache.annotation.AnnotationCacheOperationSource;

public class PackageFilteringCacheOperationSource
extends AnnotationCacheOperationSource {
    private static final long serialVersionUID = 1085099677986781087L;
    private List<String> includedPackages = List.of();
    private List<String> excludedPackages = List.of();

    public boolean isCandidateClass(Class<?> targetClass) {
        if (CollectionUtils.isNotEmpty(this.includedPackages) && this.includedPackages.stream().noneMatch(includedPackage -> targetClass.getName().startsWith((String)includedPackage))) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(this.excludedPackages) && this.excludedPackages.stream().anyMatch(excludedPackage -> targetClass.getName().startsWith((String)excludedPackage))) {
            return false;
        }
        return super.isCandidateClass(targetClass);
    }

    public List<String> getIncludedPackages() {
        return this.includedPackages;
    }

    public void setIncludedPackages(List<String> includedPackages) {
        this.includedPackages = includedPackages;
    }

    public List<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(List<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }
}

