/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.pdf.forms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.pdf.dto.MappingDefinitionDto;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.pdf.forms.PdfForms;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.PdfBoxUtils;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;

public class PdfFormsMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final Set<String> MAPPING_MIME_TYPES = Set.of("application/json");
    private static final Set<String> PDF_FORM_MIME_TYPES = Set.of("application/pdf");
    private static final String MAPPING_FILE_FIELD_NAME = "mappingFile.formFile";
    private static final String PDF_FORM_FILE_FIELD_NAME = "pdfFormFile.formFile";
    private static final String ERROR_DELETION_PDF_FORM_DEFAULT = "error.deletion.pdf.form.default";
    private static final String ERROR_PDF_FORM_MISSING_PDF_FORM = "error.pdf.form.missing.pdf.form";
    private static final String ERROR_PDF_FORM_MISSING_MAPPING_FILE = "error.pdf.form.missing.mapping.file";
    public static final String ERROR_PDF_FORM_INVALID_MAPPING_FILE = "error.pdf.form.invalid.mapping.file";
    public static final String ERROR_PDF_FORM_INVALID_PDF_FORM = "error.pdf.form.invalid.pdf.form";
    public static final String ERROR_PDF_INVALID_FILE_TYPE = "error.pdf.invalid.file.type";
    public static final String ERROR_PDF_FORM_UNIQUE_DESCRIPTION = "error.pdf.form.unique.description";
    private transient ObjectMapper objectMapper;

    @Override
    protected boolean processGlobalRouteDocumentBusinessRules(MaintenanceDocument document) {
        return super.processGlobalRouteDocumentBusinessRules(document) && this.canDelete(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    private boolean canDelete(MaintenanceDocument document) {
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (newMaintainable.getMaintenanceAction().equals("Delete") && ((PdfForms)newMaintainable.getBusinessObject()).isSystemDefault()) {
            this.getGlobalVariableService().getMessageMap().putError("GLOBAL_ERRORS", ERROR_DELETION_PDF_FORM_DEFAULT, new String[0]);
            return false;
        }
        return true;
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        PdfForms pdfForms = (PdfForms)document.getNewMaintainableObject().getDataObject();
        result &= this.validateMapping(pdfForms);
        result &= this.validatePdfForm(pdfForms);
        result &= this.validateMappingAndPdfForm(pdfForms);
        return result &= this.validateUniqueDescriptionAndModule(document);
    }

    private boolean validateMapping(PdfForms pdfForms) {
        block7: {
            String contentType;
            AttachmentFile mappingFile = pdfForms.getMappingFile();
            String string = StringUtils.isNotBlank((CharSequence)mappingFile.getContentType()) ? mappingFile.getContentType() : (contentType = mappingFile.getFormFile() != null ? mappingFile.getFormFile().getContentType() : null);
            if (contentType != null && !MAPPING_MIME_TYPES.contains(contentType)) {
                this.putFieldError(MAPPING_FILE_FIELD_NAME, ERROR_PDF_INVALID_FILE_TYPE, MAPPING_MIME_TYPES.toString());
                return false;
            }
            try {
                byte[] content;
                Object object = mappingFile.getData() != null ? mappingFile.getData() : (content = (Object)(mappingFile.getFormFile() != null ? mappingFile.getFormFile().getFileData() : null));
                if (content == null) break block7;
                try {
                    List mappings = (List)this.getObjectMapper().readValue(content, (TypeReference)new TypeReference<List<MappingDefinitionDto>>(this){});
                    if (CollectionUtils.isEmpty((Collection)mappings) || mappings.stream().anyMatch(m -> StringUtils.isBlank((CharSequence)m.getKey()) || StringUtils.isBlank((CharSequence)m.getAction()) || StringUtils.isBlank((CharSequence)m.getExpression()))) {
                        this.putFieldError(MAPPING_FILE_FIELD_NAME, ERROR_PDF_FORM_INVALID_MAPPING_FILE);
                    }
                }
                catch (IOException | ClassCastException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e.getMessage(), (Throwable)e);
                    }
                    this.putFieldError(MAPPING_FILE_FIELD_NAME, ERROR_PDF_FORM_INVALID_MAPPING_FILE);
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private boolean validatePdfForm(PdfForms pdfForms) {
        String contentType;
        AttachmentFile pdfFormFile = pdfForms.getPdfFormFile();
        String string = StringUtils.isNotBlank((CharSequence)pdfFormFile.getContentType()) ? pdfFormFile.getContentType() : (contentType = pdfFormFile.getFormFile() != null ? pdfFormFile.getFormFile().getContentType() : null);
        if (contentType != null && !PDF_FORM_MIME_TYPES.contains(contentType)) {
            this.putFieldError(PDF_FORM_FILE_FIELD_NAME, ERROR_PDF_INVALID_FILE_TYPE, PDF_FORM_MIME_TYPES.toString());
            return false;
        }
        try {
            byte[] content;
            Object object = pdfFormFile.getData() != null ? pdfFormFile.getData() : (content = (Object)(pdfFormFile.getFormFile() != null ? pdfFormFile.getFormFile().getFileData() : null));
            if (content != null && !PdfBoxUtils.isValidAcroPdf(content)) {
                this.putFieldError(PDF_FORM_FILE_FIELD_NAME, ERROR_PDF_FORM_INVALID_PDF_FORM);
                return false;
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private boolean validateMappingAndPdfForm(PdfForms pdfForms) {
        AttachmentFile pdfFormFile = pdfForms.getPdfFormFile();
        AttachmentFile mappingFile = pdfForms.getMappingFile();
        boolean pdfFormFilePresent = StringUtils.isNotBlank((CharSequence)pdfFormFile.getFileName()) || pdfFormFile.getFormFile() != null && StringUtils.isNotBlank((CharSequence)pdfFormFile.getFormFile().getFileName());
        boolean mappingFilePresent = StringUtils.isNotBlank((CharSequence)mappingFile.getFileName()) || mappingFile.getFormFile() != null && StringUtils.isNotBlank((CharSequence)mappingFile.getFormFile().getFileName());
        boolean valid = true;
        if (!mappingFilePresent) {
            this.putFieldError(MAPPING_FILE_FIELD_NAME, ERROR_PDF_FORM_MISSING_MAPPING_FILE);
            valid = false;
        }
        if (!pdfFormFilePresent) {
            this.putFieldError(PDF_FORM_FILE_FIELD_NAME, ERROR_PDF_FORM_MISSING_PDF_FORM);
            valid = false;
        }
        return valid;
    }

    private boolean validateUniqueDescriptionAndModule(MaintenanceDocument document) {
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (!newMaintainable.getMaintenanceAction().equals("Delete")) {
            PdfForms newPdfForms = (PdfForms)document.getNewMaintainableObject().getDataObject();
            List forms = this.getBoService().findMatching(PdfForms.class, Map.of("description", newPdfForms.getDescription(), "moduleCode", newPdfForms.getModuleCode()));
            if (forms.stream().anyMatch(f -> !f.getId().equals(newPdfForms.getId()))) {
                this.putFieldError("description", ERROR_PDF_FORM_UNIQUE_DESCRIPTION);
                return false;
            }
        }
        return true;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = (ObjectMapper)KcServiceLocator.getService("pdfObjectMapper");
        }
        return this.objectMapper;
    }
}

