/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.impl.custom.arg.ArgValueLookupValuesFinder;
import org.kuali.coeus.common.util.Wrapper;
import org.kuali.rice.core.api.util.KeyValue;

public class CustomDataEntry {
    private Long customAttributeId;
    private String name;
    private String label;
    private String group;
    private Boolean allowsMultipleValues;
    private List<String> values;
    private List<String> displayValues;

    public Long getCustomAttributeId() {
        return this.customAttributeId;
    }

    public void setCustomAttributeId(Long customAttributeId) {
        this.customAttributeId = customAttributeId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean getAllowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public void setAllowsMultipleValues(Boolean allowsMultipleValues) {
        this.allowsMultipleValues = allowsMultipleValues;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public List<String> getDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(List<String> displayValues) {
        this.displayValues = displayValues;
    }

    public static CustomDataEntry createEntry(DocumentCustomData customData) {
        boolean argValue;
        CustomAttribute customAttribute = customData.getCustomAttribute();
        CustomDataEntry customDataEntry = new CustomDataEntry();
        customDataEntry.setCustomAttributeId(customData.getCustomAttributeId());
        customDataEntry.setLabel(customAttribute.getLabel());
        customDataEntry.setName(customAttribute.getName());
        customDataEntry.setGroup(customAttribute.getGroupName());
        customDataEntry.setAllowsMultipleValues(customAttribute.getAllowsMultipleValues());
        if (customAttribute.getAllowsMultipleValues()) {
            customData.deserializeListValue();
            List<Wrapper<String>> deserializedListValue = customData.getDeserializedListValue();
            customDataEntry.setValues(deserializedListValue == null ? List.of() : deserializedListValue.stream().map(Wrapper::getValue).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        } else {
            customDataEntry.setValues(Stream.of(customData.getValue()).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        }
        boolean bl = argValue = StringUtils.isNotBlank((CharSequence)customData.getCustomAttribute().getLookupClass()) && customData.getCustomAttribute().getLookupClass().equals(ArgValueLookup.class.getName());
        if (argValue) {
            ArgValueLookupValuesFinder valuesFinder = new ArgValueLookupValuesFinder();
            valuesFinder.setArgName(customData.getCustomAttribute().getLookupReturn());
            valuesFinder.setAddBlankOption(false);
            customDataEntry.displayValues = valuesFinder.getKeyValues().stream().filter(kvValue -> customDataEntry.getValues().contains(kvValue.getKey())).map(KeyValue::getValue).collect(Collectors.toList());
        } else {
            customDataEntry.displayValues = Collections.emptyList();
        }
        return customDataEntry;
    }
}

