/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.print;

import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.ContactInfoType;
import gov.nih.era.projectmgmt.sbir.cgap.commonNamespace.PostalAddressType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.AnimalSubjectDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ApplicantOrganizationType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.BudgetTotalsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreApplicantSubmissionQualifiersType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreApplicationCategoryType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreBudgetTotalsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreFederalAgencyReceiptQualifiersType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreFederalDebtDelinquencyQuestionsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreProjectDatesType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreStateIntergovernmentalReviewType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreStateReceiptQualifiersType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.CoreSubmissionCategoryType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.DescriptionBlockType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.EquipmentCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OtherAgencyQuestionsType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.OtherDirectCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ParticipantPatientCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ParticipantType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.PersonFullNameType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectRoleType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectSiteType;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.ProjectSurveyDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.TravelCostsDocument;
import gov.nih.era.projectmgmt.sbir.cgap.researchandrelatedNamespace.TravelType;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryMap;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryMapping;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelRateAndBase;
import org.kuali.coeus.common.budget.framework.personnel.TbnPerson;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.org.OrganizationYnq;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.print.CompensationInfo;
import org.kuali.coeus.propdev.impl.print.KeyPersonInfo;
import org.kuali.coeus.propdev.impl.print.ProposalBaseStream;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.ynq.ProposalYnq;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractResearchAndRelatedStream<T extends XmlObject>
extends ProposalBaseStream<T> {
    private static final Logger LOG = LogManager.getLogger(AbstractResearchAndRelatedStream.class);
    protected static final String EMPTY_STRING = " ";
    protected static final String REPORT_NAME = "Research and Related";
    protected static final String SPECIAL_REVIEW_CODE_2 = "2";
    protected static final String IACU_APPROVAL_PENDING_VALUE = "Pending";
    protected static final String BUDGET_JUSTIFICATION_IDENTIFIER = "budgetJust";
    private static final String CATEGORY_CODE_EQUIPMENT_RENTAL = "13";
    private static final String CATEGORY_CODE_EQUIPMENT = "20";
    private static final String CATEGORY_CODE_TRAVEL_FOREIGN = "23";
    private static final String CATEGORY_CODE_TRAVEL_DOMESTIC = "7";
    private static final String CATEGORY_CODE_PARTICIPANT_TRAVEL = "31";
    private static final String CATEGORY_CODE_PARTICIPANT_SUBSISTANCE = "36";
    private static final String CATEGORY_CODE_PARTICIPANT_STIPENDS = "32";
    private static final String CATEGORY_CODE_PARTICIPANT_OTHER = "2";
    private static final String CATEGORY_CODE_PARTICIPANT_TUITION = "35";
    private static final String CATEGORY_CODE_OUTPATIENT = "33";
    private static final String CATEGORY_CODE_INPATIENT = "9";
    protected static final String DEFAULT_VALUE_UNKNOWN = "Unknown";
    private static final String PROPOSALQUESTION_ID15 = "15";
    private static final String ANSWER_INDICATOR_VALUE = "Y";
    private static final String DEFAULT_ANSWER = "This question has not been answered";
    private static final String STEMCELL = "18";
    private static final String INTERNATIONAL_ACTIVITIES = "H1";
    private static final String PROPRIETARY_INFO = "G8";
    private static final String HISTORICAL_SITES = "G6";
    private static final String GENETICALLY_ENGINEERED = "G4";
    private static final String HAZARDOUS_MATERIALS = "G3";
    private static final String NSFSMALL_GRANT = "14";
    private static final String NSF_BEGINNING_INV = "12";
    private static final String LOBBYING_ACTIVITIES = "H4";
    private static final String ANSWER_PARAMETER = "answer";
    private static final String QUESTION_ID_PARAMETER = "questionId";
    private static final String ORGANIZATION_ID_PARAMETER = "organizationId";
    public static final String KEY_MAPPING_NAME = "mappingName";
    public static final String KEY_TARGET_CATEGORY_CODE = "targetCategoryCode";
    private static final String RATE_CLASS_TYPE_EMPLOYEE_BENEFITS = "E";
    private static final String RATE_CLASS_TYPE_VACATION = "V";
    private static final String RATE_TYPE_ADMINISTRATIVE_SALARIES = "2";
    private static final String RATE_TYPE_SUPPORT_STAFF_SALARIES = "3";
    private static final String PERIOD_TYPE_ACADEMIC_MONTHS = "2";
    private static final String PERIOD_TYPE_SUMMER_MONTHS = "4";
    private static final String SENIOR_PERSONNEL_CATEGORY_CODE = "1";
    private static final String KEYPERSON_OTHER = "Other (Specify)";
    private static final String APPOINTMENT_TYPE_SUM_EMPLOYEE = "SUM EMPLOYEE";
    private static final String APPOINTMENT_TYPE_TMP_EMPLOYEE = "TMP EMPLOYEE";
    public static final String VALUE_UNKNOWN = "Unknown";
    public static final String BUDGET_PERSON = "budgetPerson";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="budgetPersonService")
    private BudgetPersonService budgetPersonService;
    @Autowired
    @Qualifier(value="sponsorHierarchyService")
    private SponsorHierarchyService sponsorHierarchyService;

    protected AnimalSubjectDocument.AnimalSubject getAnimalSubject(DevelopmentProposal developmentProposal) {
        AnimalSubjectDocument.AnimalSubject animalSubject = (AnimalSubjectDocument.AnimalSubject)AnimalSubjectDocument.AnimalSubject.Factory.newInstance();
        List<ProposalSpecialReview> specialReviewList = developmentProposal.getPropSpecialReviews();
        if (specialReviewList != null) {
            for (ProposalSpecialReview proposalSpecialReview : specialReviewList) {
                if (proposalSpecialReview.getSpecialReviewTypeCode() == null || !proposalSpecialReview.getSpecialReviewTypeCode().equals("2")) continue;
                animalSubject.setVertebrateAnimalsUsedQuestion(true);
                String animalWelfareAssurance = this.getAnimalWelfareAssuranceNumber(developmentProposal);
                if (animalWelfareAssurance != null) {
                    animalSubject.setAssuranceNumber(animalWelfareAssurance);
                }
                if (proposalSpecialReview.getApplicationDate() != null) {
                    animalSubject.setIACUCApprovalDate(this.getDateTimeService().getCalendar((java.util.Date)proposalSpecialReview.getApplicationDate()));
                    break;
                }
                animalSubject.setIACUCApprovalPending(IACU_APPROVAL_PENDING_VALUE);
                break;
            }
        }
        return animalSubject;
    }

    protected String getAnimalWelfareAssuranceNumber(DevelopmentProposal developmentProposal) {
        String animalWelfareAssurance = null;
        Organization organization = this.getOrganizationFromDevelopmentProposal(developmentProposal);
        if (organization != null && organization.getAnimalWelfareAssurance() != null) {
            animalWelfareAssurance = organization.getAnimalWelfareAssurance();
        }
        return animalWelfareAssurance;
    }

    protected Organization getOrganizationFromDevelopmentProposal(DevelopmentProposal developmentProposal) {
        Organization organization = null;
        ProposalSite proposalSite = developmentProposal.getApplicantOrganization();
        if (proposalSite != null) {
            organization = proposalSite.getOrganization();
        }
        return organization;
    }

    protected CoreSubmissionCategoryType getSubmissionCategoryForResearchCoverPage(String activityDescription, String creationStatusCode) {
        CoreSubmissionCategoryType coreSubmissionCategoryType = (CoreSubmissionCategoryType)CoreSubmissionCategoryType.Factory.newInstance();
        coreSubmissionCategoryType.setProjectCategory(activityDescription == null ? EMPTY_STRING : activityDescription);
        coreSubmissionCategoryType.setSubmissionStatus(creationStatusCode == null ? EMPTY_STRING : creationStatusCode);
        return coreSubmissionCategoryType;
    }

    protected BudgetTotalsType getBudgetTotals(ScaleTwoDecimal totalCost, ScaleTwoDecimal costSharingAmount) {
        BudgetTotalsType budgetTotalType = (BudgetTotalsType)BudgetTotalsType.Factory.newInstance();
        budgetTotalType.setFederalCost(totalCost.bigDecimalValue());
        budgetTotalType.setApplicantCost(costSharingAmount.bigDecimalValue());
        budgetTotalType.setStateCost(new BigDecimal(0));
        budgetTotalType.setLocalCost(new BigDecimal(0));
        budgetTotalType.setOtherCost(new BigDecimal(0));
        budgetTotalType.setProgramIncome(new BigDecimal(0));
        return budgetTotalType;
    }

    protected DescriptionBlockType getBudgetJustification(String proposalNumber) {
        DescriptionBlockType descBlockType = (DescriptionBlockType)DescriptionBlockType.Factory.newInstance();
        descBlockType.setFileIdentifier(proposalNumber + BUDGET_JUSTIFICATION_IDENTIFIER);
        return descBlockType;
    }

    protected OtherDirectCostsDocument.OtherDirectCosts[] getOtherDirectCosts(DevelopmentProposal developmentProposal, List<BudgetLineItem> budgetLineItems) {
        ArrayList<OtherDirectCostsDocument.OtherDirectCosts> otherDirectCostList = new ArrayList<OtherDirectCostsDocument.OtherDirectCosts>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryOther(budgetLineItem)) continue;
            OtherDirectCostsDocument.OtherDirectCosts otherDirectCost = (OtherDirectCostsDocument.OtherDirectCosts)OtherDirectCostsDocument.OtherDirectCosts.Factory.newInstance();
            otherDirectCost.setCost(budgetLineItem.getLineItemCost().bigDecimalValue());
            otherDirectCost.setDescription(budgetLineItem.getLineItemDescription());
            otherDirectCost.setType(this.getOtherCategoryMapTypeDescription(developmentProposal, budgetLineItem));
            otherDirectCostList.add(otherDirectCost);
        }
        return otherDirectCostList.toArray(new OtherDirectCostsDocument.OtherDirectCosts[0]);
    }

    private String getOtherCategoryMapTypeDescription(DevelopmentProposal developmentProposal, BudgetLineItem budgetLineItem) {
        BudgetCategoryMap budgetCategoryMap = this.getBudgetCategoryMap(developmentProposal, budgetLineItem);
        if (budgetCategoryMap != null) {
            return budgetCategoryMap.getDescription();
        }
        return "Other Direct Costs";
    }

    private BudgetCategoryMap getBudgetCategoryMap(DevelopmentProposal developmentProposal, BudgetLineItem budgetLineItem) {
        boolean isNih = this.getSponsorHierarchyService().isSponsorNihOsc(developmentProposal.getSponsorCode()) || this.getSponsorHierarchyService().isSponsorNihMultiplePi(developmentProposal.getSponsorCode());
        String mappingName = isNih ? "NIH_PRINTING" : "NSF_PRINTING";
        BudgetCategoryMap budgetCategoryMap = null;
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put("budgetCategoryCode", budgetLineItem.getBudgetCategoryCode());
        categoryMap.put(KEY_MAPPING_NAME, mappingName);
        List<BudgetCategoryMapping> budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        if (!budgetCategoryList.isEmpty()) {
            BudgetCategoryMapping budgetCategoryMapping = budgetCategoryList.get(0);
            categoryMap = new HashMap();
            categoryMap.put(KEY_MAPPING_NAME, mappingName);
            categoryMap.put(KEY_TARGET_CATEGORY_CODE, budgetCategoryMapping.getTargetCategoryCode());
            List budgetCategoryMaps = this.getBusinessObjectService().findMatching(BudgetCategoryMap.class, categoryMap);
            if (!budgetCategoryMaps.isEmpty()) {
                budgetCategoryMap = (BudgetCategoryMap)budgetCategoryMaps.get(0);
            }
        }
        return budgetCategoryMap;
    }

    protected boolean isBudgetCategoryOther(BudgetLineItem budgetLineItem) {
        boolean isOther = true;
        if (this.isBudgetCategoryEquipment(budgetLineItem) || this.isBudgetCategoryTravel(budgetLineItem) || this.isBudgetCategoryParticipantPatient(budgetLineItem) || budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equals("P") || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_TUITION)) {
            isOther = false;
        }
        return isOther;
    }

    protected boolean isBudgetCategoryEquipment(BudgetLineItem budgetLineItem) {
        return budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_EQUIPMENT_RENTAL) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_EQUIPMENT);
    }

    protected BigDecimal getTravelTotal(List<BudgetLineItem> budgetLineItems) {
        ScaleTwoDecimal cost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryTravel(budgetLineItem)) continue;
            cost = (ScaleTwoDecimal)cost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
        }
        return cost.bigDecimalValue();
    }

    protected boolean isBudgetCategoryTravel(BudgetLineItem budgetLineItem) {
        return budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_TRAVEL_DOMESTIC) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_TRAVEL_FOREIGN);
    }

    protected boolean isBudgetCategoryParticipantPatient(BudgetLineItem budgetLineItem) {
        return budgetLineItem.getBudgetCategoryCode().equals("2") || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_STIPENDS) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_SUBSISTANCE) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_TRAVEL) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_INPATIENT) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_OUTPATIENT) || budgetLineItem.getBudgetCategoryCode().equals(CATEGORY_CODE_PARTICIPANT_TUITION);
    }

    protected EquipmentCostsDocument.EquipmentCosts[] getEquipmentCosts(List<BudgetLineItem> budgetLineItems) {
        ArrayList<EquipmentCostsDocument.EquipmentCosts> equipmentCostList = new ArrayList<EquipmentCostsDocument.EquipmentCosts>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryEquipment(budgetLineItem)) continue;
            EquipmentCostsDocument.EquipmentCosts equipmentCost = (EquipmentCostsDocument.EquipmentCosts)EquipmentCostsDocument.EquipmentCosts.Factory.newInstance();
            equipmentCost.setCost(budgetLineItem.getLineItemCost().bigDecimalValue());
            equipmentCost.setDescription(budgetLineItem.getLineItemDescription());
            equipmentCost.setEquipmentDescription(budgetLineItem.getBudgetCategory().getDescription());
            equipmentCostList.add(equipmentCost);
        }
        return equipmentCostList.toArray(new EquipmentCostsDocument.EquipmentCosts[0]);
    }

    protected PersonFullNameType getContactPersonFullName(String lastName, String firstName, String middleName) {
        PersonFullNameType personFullNameType = (PersonFullNameType)PersonFullNameType.Factory.newInstance();
        personFullNameType.setLastName(lastName);
        personFullNameType.setFirstName(firstName);
        personFullNameType.setMiddleName(middleName);
        return personFullNameType;
    }

    protected ApplicantOrganizationType.OrganizationContactPerson getOrganizationContactPerson(ProposalSite proposalSite) {
        Rolodex rolodex = proposalSite.getRolodex();
        ApplicantOrganizationType.OrganizationContactPerson orgContactPerson = (ApplicantOrganizationType.OrganizationContactPerson)ApplicantOrganizationType.OrganizationContactPerson.Factory.newInstance();
        if (rolodex != null) {
            orgContactPerson.setName(this.getContactPersonFullName(rolodex.getLastName(), rolodex.getFirstName(), rolodex.getMiddleName()));
            orgContactPerson.setPositionTitle(rolodex.getTitle());
            orgContactPerson.setContactInformation(this.getPersonContactInformation(proposalSite));
        } else {
            orgContactPerson.setName(this.getContactPersonFullName("Unknown", "Unknown", "Unknown"));
            orgContactPerson.setPositionTitle("Unknown");
            orgContactPerson.setContactInformation(this.getOrganizationPersonContactInformationWithDefaultValues());
        }
        return orgContactPerson;
    }

    protected ContactInfoType getPersonContactInformation(ProposalSite proposalSite) {
        String officePhone;
        String faxNumber;
        Rolodex rolodex = proposalSite.getRolodex();
        ContactInfoType contactInfoType = (ContactInfoType)ContactInfoType.Factory.newInstance();
        String emailAddress = rolodex.getEmailAddress();
        if (emailAddress != null) {
            contactInfoType.setEmail(emailAddress);
        }
        if ((faxNumber = rolodex.getFaxNumber()) != null) {
            contactInfoType.setFaxNumber(faxNumber);
        }
        if ((officePhone = rolodex.getPhoneNumber()) != null) {
            contactInfoType.setPhoneNumber(officePhone);
        }
        contactInfoType.setPostalAddress(this.getOrganizationAddress(proposalSite));
        return contactInfoType;
    }

    protected ContactInfoType getOrganizationPersonContactInformationWithDefaultValues() {
        ContactInfoType contactInfoType = (ContactInfoType)ContactInfoType.Factory.newInstance();
        contactInfoType.setEmail("Unknown");
        contactInfoType.setFaxNumber("Unknown");
        contactInfoType.setPhoneNumber("Unknown");
        contactInfoType.setPostalAddress(this.getPostalAddressWithDefaultValues());
        return contactInfoType;
    }

    protected PostalAddressType getOrganizationAddress(ProposalSite proposalSite) {
        PostalAddressType postalAddressType = (PostalAddressType)PostalAddressType.Factory.newInstance();
        postalAddressType.setStreetArray(this.getStreetAddress(proposalSite.getAddressLine1(), proposalSite.getAddressLine2(), proposalSite.getAddressLine3()));
        String city = proposalSite.getCity();
        postalAddressType.setCity(city == null || city.trim().equals("") ? "Unknown" : city);
        postalAddressType.setState(proposalSite.getState());
        String postalCode = proposalSite.getPostalCode();
        postalAddressType.setPostalCode(postalCode == null || postalCode.trim().equals("") ? "Unknown" : postalCode);
        String county = proposalSite.getCounty();
        postalAddressType.setCountry(county == null || county.trim().equals("") ? "Unknown" : county);
        return postalAddressType;
    }

    private PostalAddressType getPostalAddressWithDefaultValues() {
        PostalAddressType postalAddressType = (PostalAddressType)PostalAddressType.Factory.newInstance();
        postalAddressType.setStreetArray(this.getStreetAddress("Unknown", "Unknown", "Unknown"));
        postalAddressType.setCity("Unknown");
        postalAddressType.setState("Unknown");
        postalAddressType.setPostalCode("Unknown");
        postalAddressType.setCountry("Unknown");
        return postalAddressType;
    }

    private String[] getStreetAddress(String address1, String address2, String address3) {
        ArrayList<String> streetAddress = new ArrayList<String>();
        if (address1 != null) {
            streetAddress.add(address1);
        }
        if (address2 != null) {
            streetAddress.add(address2);
        }
        if (address3 != null) {
            streetAddress.add(address3);
        }
        return streetAddress.toArray(new String[0]);
    }

    protected OtherAgencyQuestionsType getOtherAgencyQuestionsForResearchCoverPage(DevelopmentProposal developmentProposal) {
        OtherAgencyQuestionsType otherAgencyQuestionsType = (OtherAgencyQuestionsType)OtherAgencyQuestionsType.Factory.newInstance();
        otherAgencyQuestionsType.setOtherAgencyIndicator(false);
        for (ProposalYnq proposalYnq : developmentProposal.getProposalYnqs()) {
            if (!proposalYnq.getQuestionId().equals(PROPOSALQUESTION_ID15) || proposalYnq.getAnswer() == null) continue;
            otherAgencyQuestionsType.setOtherAgencyIndicator(proposalYnq.getAnswer().equals(ANSWER_INDICATOR_VALUE));
            otherAgencyQuestionsType.setOtherAgencyNames(proposalYnq.getExplanation() == null ? EMPTY_STRING : proposalYnq.getExplanation());
        }
        return otherAgencyQuestionsType;
    }

    protected boolean getAnswerFromOrganizationYnq(OrganizationYnq organizationYnq) {
        return organizationYnq.getAnswer().equals(ANSWER_INDICATOR_VALUE);
    }

    protected ProjectSurveyDocument.ProjectSurvey getProjectSurvey(DevelopmentProposal developmentProposal) {
        ProjectSurveyDocument.ProjectSurvey projectSurvey = (ProjectSurveyDocument.ProjectSurvey)ProjectSurveyDocument.ProjectSurvey.Factory.newInstance();
        List<ProposalYnq> proposalYnqs = developmentProposal.getProposalYnqs();
        if (!proposalYnqs.isEmpty()) {
            for (ProposalYnq proposalYnq : proposalYnqs) {
                String explanation;
                boolean questionAnswered = false;
                String answer = proposalYnq.getAnswer();
                String questionId = proposalYnq.getQuestionId();
                String string = explanation = proposalYnq.getExplanation() == null ? EMPTY_STRING : proposalYnq.getExplanation();
                if (ANSWER_INDICATOR_VALUE.equals(answer)) {
                    questionAnswered = true;
                }
                this.setProjectSurvey(projectSurvey, questionAnswered, questionId, explanation);
            }
        } else {
            this.setDefaultValuesToProjectSurvey(projectSurvey);
        }
        if (this.getProposalYNQ(LOBBYING_ACTIVITIES) != null) {
            projectSurvey.setH4Question(true);
        }
        projectSurvey.setCBQuestion(false);
        projectSurvey.setCBText(DEFAULT_ANSWER);
        projectSurvey.setEnvExemptionQuestion(false);
        projectSurvey.setEnvExemptionCBText(DEFAULT_ANSWER);
        projectSurvey.setEnvImpactQuestion(false);
        projectSurvey.setEnvImpactText(DEFAULT_ANSWER);
        return projectSurvey;
    }

    private void setDefaultValuesToProjectSurvey(ProjectSurveyDocument.ProjectSurvey projectSurvey) {
        projectSurvey.setG3Question(false);
        projectSurvey.setG3Text(DEFAULT_ANSWER);
        projectSurvey.setG4Question(false);
        projectSurvey.setG4Text(DEFAULT_ANSWER);
        projectSurvey.setG6Question(false);
        projectSurvey.setG6Text(DEFAULT_ANSWER);
        projectSurvey.setG8Question(false);
        projectSurvey.setG8Text(DEFAULT_ANSWER);
        projectSurvey.setH1Question(false);
        projectSurvey.setH1Text(DEFAULT_ANSWER);
    }

    private void setProjectSurvey(ProjectSurveyDocument.ProjectSurvey projectSurvey, boolean questionAnswered, String questionId, String explanation) {
        if (questionId.equals(HAZARDOUS_MATERIALS)) {
            projectSurvey.setG3Question(questionAnswered);
            projectSurvey.setG3Text(explanation);
        } else if (questionId.equals(GENETICALLY_ENGINEERED)) {
            projectSurvey.setG4Question(questionAnswered);
            projectSurvey.setG4Text(explanation);
        } else if (questionId.equals(HISTORICAL_SITES)) {
            projectSurvey.setG6Question(questionAnswered);
            projectSurvey.setG6Text(explanation);
        } else if (questionId.equals(PROPRIETARY_INFO)) {
            projectSurvey.setG8Question(questionAnswered);
            projectSurvey.setG8Text(explanation);
        } else if (questionId.equals(INTERNATIONAL_ACTIVITIES)) {
            projectSurvey.setH1Question(questionAnswered);
            projectSurvey.setH1Text(explanation);
        } else if (questionId.equals(LOBBYING_ACTIVITIES)) {
            projectSurvey.setH4Question(questionAnswered);
        } else if (questionId.equals(NSFSMALL_GRANT)) {
            projectSurvey.setSmallGrantQuestion(questionAnswered);
        } else if (questionId.equals(NSF_BEGINNING_INV)) {
            projectSurvey.setNSFbeginningInvestQuestion(questionAnswered);
        } else if (questionId.equals(STEMCELL)) {
            projectSurvey.setStemCellQuestion(questionAnswered);
            projectSurvey.setStemCellText(explanation);
        }
    }

    private ProposalYnq getProposalYNQ(String questionId) {
        ProposalYnq proposalYnq = null;
        HashMap<String, String> proposalYnqMap = new HashMap<String, String>();
        proposalYnqMap.put(QUESTION_ID_PARAMETER, questionId);
        proposalYnqMap.put(ANSWER_PARAMETER, ANSWER_INDICATOR_VALUE);
        List proposalYnqs = this.businessObjectService.findMatching(ProposalYnq.class, proposalYnqMap);
        if (proposalYnqs != null && !proposalYnqs.isEmpty()) {
            proposalYnq = (ProposalYnq)proposalYnqs.get(0);
        }
        return proposalYnq;
    }

    protected BigDecimal getSalaryWagesTotal(List<BudgetLineItem> budgetLineItems) {
        ScaleTwoDecimal salaryAndWagesTotal = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                salaryAndWagesTotal = (ScaleTwoDecimal)salaryAndWagesTotal.add((AbstractDecimal)this.getSalaryWagesTotalForLineItem(budgetPersDetails));
            }
        }
        return salaryAndWagesTotal.bigDecimalValue();
    }

    private ScaleTwoDecimal getSalaryWagesTotalForLineItem(BudgetPersonnelDetails budgetPersDetails) {
        ScaleTwoDecimal salaryAndWages = ScaleTwoDecimal.ZERO;
        salaryAndWages = (ScaleTwoDecimal)salaryAndWages.add((AbstractDecimal)budgetPersDetails.getSalaryRequested());
        salaryAndWages = (ScaleTwoDecimal)salaryAndWages.add((AbstractDecimal)this.getFringeCost(budgetPersDetails));
        return salaryAndWages;
    }

    protected ScaleTwoDecimal getFringeCost(BudgetPersonnelDetails budgetPersDetails) {
        ScaleTwoDecimal fringe = ScaleTwoDecimal.ZERO;
        for (BudgetPersonnelRateAndBase budgetPersRateBase : budgetPersDetails.getBudgetPersonnelRateAndBaseList()) {
            if (!this.isRateAndBaseOfRateClassTypeEB(budgetPersRateBase) && !this.isRateAndBaseOfRateClassTypeVacation(budgetPersRateBase)) continue;
            fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)budgetPersRateBase.getCalculatedCost());
        }
        return fringe;
    }

    protected ScaleTwoDecimal getTotalSalaryRequested(BudgetPeriod budgetPeriod) {
        ScaleTwoDecimal salary = ScaleTwoDecimal.ZERO;
        List<BudgetLineItem> lineItems = budgetPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : lineItems) {
            List<BudgetPersonnelDetails> persDetailsList = budgetLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails budgetPersonnelDetails : persDetailsList) {
                salary = (ScaleTwoDecimal)salary.add((AbstractDecimal)budgetPersonnelDetails.getSalaryRequested());
            }
        }
        return salary;
    }

    protected ScaleTwoDecimal getTotalFringe(BudgetPeriod budgetPeriod) {
        ScaleTwoDecimal fringe = ScaleTwoDecimal.ZERO;
        List<BudgetLineItem> lineItems = budgetPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : lineItems) {
            List<BudgetPersonnelDetails> persDetailsList = budgetLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails budgetPersonnelDetails : persDetailsList) {
                for (BudgetPersonnelRateAndBase budgetPersRateBase : budgetPersonnelDetails.getBudgetPersonnelRateAndBaseList()) {
                    if (!this.isRateAndBaseOfRateClassTypeEBVacationOnLA(budgetPersRateBase)) continue;
                    fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)budgetPersRateBase.getCalculatedCost());
                }
            }
        }
        return fringe;
    }

    private boolean isRateAndBaseOfRateClassTypeEBVacationOnLA(BudgetPersonnelRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug("isRateAndBaseOfRateClassTypeEB : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.EMPLOYEE_BENEFITS.getRateClassType().equals(rateAndBase.getRateClass().getRateClassTypeCode()) && !rateAndBase.getRateTypeCode().equals(RATE_TYPE_SUPPORT_STAFF_SALARIES) || RateClassType.VACATION.getRateClassType().equals(rateAndBase.getRateClass().getRateClassTypeCode()) && !rateAndBase.getRateTypeCode().equals("2");
    }

    private boolean isRateAndBaseOfRateClassTypeEB(AbstractBudgetRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug("isRateAndBaseOfRateClassTypeEB : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.EMPLOYEE_BENEFITS.getRateClassType().equals(rateAndBase.getRateClass().getRateClassTypeCode()) && !rateAndBase.getRateTypeCode().equals(RATE_TYPE_SUPPORT_STAFF_SALARIES);
    }

    private boolean isRateAndBaseOfRateClassTypeVacation(AbstractBudgetRateAndBase rateAndBase) {
        if (rateAndBase == null) {
            LOG.debug("isRateAndBaseOfRateClassTypeVacation : Rate and Base is null");
            return false;
        }
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass() != null && RateClassType.VACATION.getRateClassType().equals(rateAndBase.getRateClass().getRateClassTypeCode()) && !rateAndBase.getRateTypeCode().equals("2");
    }

    protected BigDecimal getParticipantPatientTotal(List<BudgetLineItem> budgetLineItems) {
        ScaleTwoDecimal cost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryParticipantPatient(budgetLineItem)) continue;
            cost = (ScaleTwoDecimal)cost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
        }
        return cost.bigDecimalValue();
    }

    protected BigDecimal getOtherDirectTotal(List<BudgetLineItem> budgetLineItems) {
        ScaleTwoDecimal cost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryOther(budgetLineItem)) continue;
            cost = (ScaleTwoDecimal)cost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
        }
        return cost.bigDecimalValue();
    }

    protected TravelCostsDocument.TravelCosts[] getTravelCosts(List<BudgetLineItem> budgetLineItems) {
        ArrayList<TravelCostsDocument.TravelCosts> travelCostList = new ArrayList<TravelCostsDocument.TravelCosts>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryTravel(budgetLineItem)) continue;
            TravelCostsDocument.TravelCosts travelCost = (TravelCostsDocument.TravelCosts)TravelCostsDocument.TravelCosts.Factory.newInstance();
            if (CATEGORY_CODE_TRAVEL_FOREIGN.equals(budgetLineItem.getBudgetCategoryCode())) {
                travelCost.setType(TravelType.FOREIGN);
            } else {
                travelCost.setType(TravelType.DOMESTIC);
            }
            travelCost.setCost(budgetLineItem.getLineItemCost().bigDecimalValue());
            travelCost.setDescription(budgetLineItem.getLineItemDescription());
            travelCostList.add(travelCost);
        }
        return travelCostList.toArray(new TravelCostsDocument.TravelCosts[0]);
    }

    protected ParticipantPatientCostsDocument.ParticipantPatientCosts[] getParticipantPatientCost(DevelopmentProposal developmentProposal, List<BudgetLineItem> budgetLineItems) {
        ArrayList<ParticipantPatientCostsDocument.ParticipantPatientCosts> participantPatientCostList = new ArrayList<ParticipantPatientCostsDocument.ParticipantPatientCosts>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryParticipantPatient(budgetLineItem)) continue;
            ParticipantPatientCostsDocument.ParticipantPatientCosts participantPatientCost = (ParticipantPatientCostsDocument.ParticipantPatientCosts)ParticipantPatientCostsDocument.ParticipantPatientCosts.Factory.newInstance();
            participantPatientCost.setCost(budgetLineItem.getLineItemCost().bigDecimalValue());
            participantPatientCost.setDescription(budgetLineItem.getLineItemDescription());
            participantPatientCost.setType(this.getParticipantPatientType(developmentProposal, budgetLineItem));
            participantPatientCostList.add(participantPatientCost);
        }
        return participantPatientCostList.toArray(new ParticipantPatientCostsDocument.ParticipantPatientCosts[0]);
    }

    private ParticipantType.Enum getParticipantPatientType(DevelopmentProposal developmentProposal, BudgetLineItem budgetLineItem) {
        BudgetCategoryMap budgetCategoryMap = this.getBudgetCategoryMap(developmentProposal, budgetLineItem);
        ParticipantType.Enum participantType = budgetCategoryMap != null ? (budgetCategoryMap.getTargetCategoryCode().equals("41") ? ParticipantType.INPATIENT : (budgetCategoryMap.getTargetCategoryCode().equals("90") ? ParticipantType.OUTPATIENT : (budgetCategoryMap.getTargetCategoryCode().equals("79") ? ParticipantType.SUBSISTENCE : (budgetCategoryMap.getTargetCategoryCode().equals("77") ? ParticipantType.TRAVEL : (budgetCategoryMap.getTargetCategoryCode().equals("75") ? ParticipantType.STIPENDS : ParticipantType.OTHER))))) : ParticipantType.OTHER;
        return participantType;
    }

    protected BigDecimal getEquipmentTotal(List<BudgetLineItem> budgetLineItems) {
        ScaleTwoDecimal cost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!this.isBudgetCategoryEquipment(budgetLineItem)) continue;
            cost = (ScaleTwoDecimal)cost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
        }
        return cost.bigDecimalValue();
    }

    protected List<OrganizationYnq> getOrganizationYNQ(String questionId) {
        HashMap<String, String> organizationYnqMap = new HashMap<String, String>();
        organizationYnqMap.put(ORGANIZATION_ID_PARAMETER, questionId);
        List organizationYnqs = this.businessObjectService.findMatching(OrganizationYnq.class, organizationYnqMap);
        return organizationYnqs;
    }

    protected ProjectRoleType.Enum getProjectRoleType(DevelopmentProposal developmentProposal, BudgetPerson budgetPerson) {
        ProjectRoleType.Enum roleType = ProjectRoleType.Enum.forString(budgetPerson.getRole());
        if (this.isPI(developmentProposal, budgetPerson)) {
            roleType = ProjectRoleType.PI_PD;
        } else if (this.isCoPI(developmentProposal, budgetPerson)) {
            roleType = ProjectRoleType.CO_PI_PD;
        } else if (this.isKeyPerson(developmentProposal, budgetPerson)) {
            roleType = ProjectRoleType.KEY_PERSON;
        } else if (roleType == null) {
            roleType = ProjectRoleType.OTHER;
        }
        return roleType;
    }

    private boolean isKeyPerson(DevelopmentProposal developmentProposal, BudgetPerson budgetPerson) {
        List<ProposalPerson> proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!this.isSamePerson(budgetPerson, proposalPerson)) continue;
            return true;
        }
        return false;
    }

    private boolean isCoPI(DevelopmentProposal developmentProposal, BudgetPerson budgetPerson) {
        List<ProposalPerson> proposalPersons = developmentProposal.getInvestigators();
        for (ProposalPerson proposalPerson : proposalPersons) {
            if (!this.isSamePerson(budgetPerson, proposalPerson)) continue;
            return true;
        }
        return false;
    }

    private boolean isPI(DevelopmentProposal developmentProposal, BudgetPerson budgetPerson) {
        ProposalPerson proposalPerson = developmentProposal.getPrincipalInvestigator();
        return this.isSamePerson(budgetPerson, proposalPerson);
    }

    private boolean isSamePerson(BudgetPerson budgetPerson, ProposalPerson proposalPerson) {
        if (proposalPerson.getPersonId() != null && proposalPerson.getPersonId().equals(budgetPerson.getPersonId())) {
            return true;
        }
        return proposalPerson.getRolodexId() != null && proposalPerson.getRolodexId().equals(budgetPerson.getRolodexId());
    }

    protected CoreApplicationCategoryType getApplicationCategoryForResearchCoverPage(String propTypeDesc) {
        CoreApplicationCategoryType coreApplicationCategoryType = (CoreApplicationCategoryType)CoreApplicationCategoryType.Factory.newInstance();
        coreApplicationCategoryType.setCategoryIdentifier(propTypeDesc == null ? EMPTY_STRING : propTypeDesc);
        return coreApplicationCategoryType;
    }

    protected void setApplicantSubmissionQualifiersForResearchCoverPage(DevelopmentProposal developmentProposal, CoreApplicantSubmissionQualifiersType coreApplicantSubmissionQualifiersType) {
        coreApplicantSubmissionQualifiersType.setApplicationDate(this.getDateTimeService().getCalendar((java.util.Date)developmentProposal.getRequestedEndDateInitial()));
    }

    protected void setFederalAgencyReceiptQualifiersForResearchCoverPage(DevelopmentProposal developmentProposal, CoreFederalAgencyReceiptQualifiersType coreFederalAgencyReceiptQualifiersType) {
        coreFederalAgencyReceiptQualifiersType.setAgencyName(developmentProposal.getSponsor().getAcronym());
        if (developmentProposal.hasS2sOpportunity() && developmentProposal.getS2sOpportunity().getOpeningDate() != null) {
            coreFederalAgencyReceiptQualifiersType.setAgencyReceiptDate(developmentProposal.getS2sOpportunity().getOpeningDate());
        }
    }

    protected CoreStateReceiptQualifiersType setStateReceiptQualifiersForResearchCoverPage(DevelopmentProposal developmentProposal, CoreStateReceiptQualifiersType coreStateReceiptQualifiersType) {
        if (developmentProposal.getDeadlineDate() != null) {
            coreStateReceiptQualifiersType.setStateReceiptDate(this.getDateTimeService().getCalendar((java.util.Date)developmentProposal.getDeadlineDate()));
        }
        return coreStateReceiptQualifiersType;
    }

    protected void setStateIntergovernmentalReviewForResearchCoverPage(DevelopmentProposal developmentProposal, CoreStateIntergovernmentalReviewType coreStateIntergovernmentalReviewType) {
        if (developmentProposal.getDeadlineDate() != null) {
            coreStateIntergovernmentalReviewType.setReviewAvailabilityDate(this.getDateTimeService().getCalendar((java.util.Date)developmentProposal.getDeadlineDate()));
        }
        coreStateIntergovernmentalReviewType.setSubjectToReviewQuestion(true);
    }

    protected CoreFederalDebtDelinquencyQuestionsType setFederalDebtDelinquencyQuestionForResearchCoverPage(DevelopmentProposal developmentProposal, CoreFederalDebtDelinquencyQuestionsType coreFederalDebtDelinquencyQuestionsType) {
        CoreFederalDebtDelinquencyQuestionsType ccoreFedDebtQuestionsType = (CoreFederalDebtDelinquencyQuestionsType)CoreFederalDebtDelinquencyQuestionsType.Factory.newInstance();
        ccoreFedDebtQuestionsType.setApplicantDelinquentIndicator(false);
        return ccoreFedDebtQuestionsType;
    }

    protected CoreProjectDatesType getProjectDatesForResearchCoverPage(Date startDate, Date endDate) {
        CoreProjectDatesType coreProjectDatesType = (CoreProjectDatesType)CoreProjectDatesType.Factory.newInstance();
        coreProjectDatesType.setProjectStartDate(this.getDateTimeService().getCalendar((java.util.Date)startDate));
        coreProjectDatesType.setProjectEndDate(this.getDateTimeService().getCalendar((java.util.Date)endDate));
        return coreProjectDatesType;
    }

    protected CoreBudgetTotalsType getBudgetTotalsForResearchCoverPage(Budget budget) {
        CoreBudgetTotalsType coreBudgetTotalsType = (CoreBudgetTotalsType)CoreBudgetTotalsType.Factory.newInstance();
        if (budget != null && budget.getVersionNumber() > 0L) {
            if (!budget.getModularBudgetFlag().booleanValue()) {
                coreBudgetTotalsType.setApplicantCost(budget.getCostSharingAmount().bigDecimalValue());
                coreBudgetTotalsType.setFederalCost(budget.getTotalCost().bigDecimalValue());
                coreBudgetTotalsType.setOtherCost(budget.getTotalIndirectCost().bigDecimalValue());
            }
        } else {
            coreBudgetTotalsType.setApplicantCost(BigDecimal.ZERO);
            coreBudgetTotalsType.setFederalCost(BigDecimal.ZERO);
            coreBudgetTotalsType.setOtherCost(BigDecimal.ZERO);
        }
        coreBudgetTotalsType.setLocalCost(BigDecimal.ZERO);
        coreBudgetTotalsType.setProgramIncome(BigDecimal.ZERO);
        coreBudgetTotalsType.setStateCost(BigDecimal.ZERO);
        return coreBudgetTotalsType;
    }

    protected ProjectSiteType getProjectSiteForResearchCoverPage(DevelopmentProposal developmentProposal) {
        ProposalSite performingOrg = developmentProposal.getPerformingOrganization();
        ProjectSiteType projectSiteType = (ProjectSiteType)ProjectSiteType.Factory.newInstance();
        projectSiteType.setOrganizationName(performingOrg.getLocationName());
        projectSiteType.setCongressionalDistrict(performingOrg.getFirstCongressionalDistrictName());
        projectSiteType.setPostalAddress(this.getOrganizationAddress(performingOrg));
        return projectSiteType;
    }

    protected PostalAddressType getPostalAddress(ProposalPerson proposalPerson) {
        PostalAddressType postalAddressType = (PostalAddressType)PostalAddressType.Factory.newInstance();
        postalAddressType.setStreetArray(this.getStreetAddress(proposalPerson.getAddressLine1(), proposalPerson.getAddressLine2(), proposalPerson.getAddressLine3()));
        String city = proposalPerson.getCity();
        postalAddressType.setCity(city == null || city.trim().equals("") ? "Unknown" : city);
        postalAddressType.setState(proposalPerson.getState());
        String postalCode = proposalPerson.getPostalCode();
        postalAddressType.setPostalCode(postalCode == null || postalCode.trim().equals("") ? "Unknown" : postalCode);
        String country = proposalPerson.getCountryCode();
        postalAddressType.setCountry(country == null || country.trim().equals("") ? "Unknown" : country);
        return postalAddressType;
    }

    protected ContactInfoType getPersonContactInformation(ProposalPerson proposalPerson) {
        String officePhone;
        String faxNumber;
        if (proposalPerson == null) {
            return null;
        }
        ContactInfoType contactInfoType = (ContactInfoType)ContactInfoType.Factory.newInstance();
        String emailAddress = proposalPerson.getEmailAddress();
        if (emailAddress != null) {
            contactInfoType.setEmail(emailAddress);
        }
        if ((faxNumber = proposalPerson.getFaxNumber()) != null) {
            contactInfoType.setFaxNumber(faxNumber);
        }
        if ((officePhone = proposalPerson.getOfficePhone()) != null) {
            contactInfoType.setPhoneNumber(officePhone);
        }
        contactInfoType.setPostalAddress(this.getPostalAddress(proposalPerson));
        return contactInfoType;
    }

    protected void sortKeyPersonWithName(List<ProposalPerson> proposalPersonList) {
        proposalPersonList.sort(Comparator.comparing(ProposalPerson::getFullName));
    }

    protected List<KeyPersonInfo> getBudgetPersonsForCategoryMap(DevelopmentProposal developmentProposal, BudgetPeriod budgetPeriod, String categoryCode, String categoryMappingName) {
        ArrayList<KeyPersonInfo> keyPersons = new ArrayList<KeyPersonInfo>();
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put(KEY_TARGET_CATEGORY_CODE, categoryCode);
        categoryMap.put(KEY_MAPPING_NAME, categoryMappingName);
        List<BudgetCategoryMapping> budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        block0: for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
                if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) continue;
                this.addSeniorPerson(keyPersons, lineItem);
                continue block0;
            }
        }
        for (KeyPersonInfo keyPersonInfo : keyPersons) {
            this.setKeyPersonCompensationForPeriod(budgetPeriod, keyPersonInfo);
        }
        return keyPersons;
    }

    private void setKeyPersonCompensationForPeriod(BudgetPeriod budgetPeriod, KeyPersonInfo keyPersonInfo) {
        CompensationInfo compensationInfo = new CompensationInfo();
        this.setCompensationForPeriod(keyPersonInfo, budgetPeriod, compensationInfo);
        this.setKeyPersonComp(keyPersonInfo, compensationInfo);
    }

    private void setKeyPersonCompensation(Budget budget, KeyPersonInfo keyPersonComp) {
        CompensationInfo compensationInfo = new CompensationInfo();
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            this.setCompensationForPeriod(keyPersonComp, budgetPeriod, compensationInfo);
        }
        this.setKeyPersonComp(keyPersonComp, compensationInfo);
    }

    private void setKeyPersonComp(KeyPersonInfo keyPersonComp, CompensationInfo compensationInfo) {
        keyPersonComp.setAcademicMonths(compensationInfo.getAcademicMonths());
        keyPersonComp.setCalendarMonths(compensationInfo.getCalendarMonths());
        keyPersonComp.setSummerMonths(compensationInfo.getSummerMonths());
        keyPersonComp.setBaseSalary(compensationInfo.getBaseSalary());
        keyPersonComp.setRequestedSalary(compensationInfo.getRequestedSalary());
        keyPersonComp.setFundsRequested(compensationInfo.getFundsRequested());
        keyPersonComp.setFringe(compensationInfo.getFringe());
        keyPersonComp.setCostSharingAmount(compensationInfo.getCostSharingAmount());
        keyPersonComp.setNonFundsRequested(compensationInfo.getNonFundsRequested());
        keyPersonComp.setFringeCostSharing(compensationInfo.getFringeCostSharing());
    }

    private void addSeniorPerson(List<KeyPersonInfo> keyPersons, BudgetLineItem lineItem) {
        for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
            KeyPersonInfo keyPerson;
            budgetPersonnelDetails.refreshReferenceObject(BUDGET_PERSON);
            if (budgetPersonnelDetails.getBudgetPerson().getRolodexId() != null) {
                keyPerson = this.getKeyPersonFromRolodex(budgetPersonnelDetails);
                this.addToKeyPersonList(keyPerson, keyPersons);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)budgetPersonnelDetails.getBudgetPerson().getTbnId())) {
                keyPerson = this.getKeyPersonFromTbnPerson(budgetPersonnelDetails);
                this.addToKeyPersonList(keyPerson, keyPersons);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)budgetPersonnelDetails.getBudgetPerson().getPersonId())) continue;
            keyPerson = this.getKeyPersonFromKcPerson(budgetPersonnelDetails.getPersonId());
            this.addToKeyPersonList(keyPerson, keyPersons);
        }
    }

    protected List<KeyPersonInfo> getBudgetPersonsForCategoryMap(DevelopmentProposal developmentProposal, Budget budget, String categoryCode, String categoryMappingName) {
        KeyPersonInfo keyPerson = null;
        ArrayList<KeyPersonInfo> keyPersons = new ArrayList<KeyPersonInfo>();
        List<ProposalPerson> proposalPersons = developmentProposal.getProposalPersons();
        for (ProposalPerson proposalPerson : proposalPersons) {
            keyPerson = this.getKeyPersonFromProposalPerson(proposalPerson);
            keyPersons.add(keyPerson);
        }
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put(KEY_TARGET_CATEGORY_CODE, categoryCode);
        categoryMap.put(KEY_MAPPING_NAME, categoryMappingName);
        List<BudgetCategoryMapping> budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
            block2: for (BudgetPeriod budgetPeriod : budgetPeriods) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) continue;
                    this.addSeniorPerson(keyPersons, lineItem);
                    continue block2;
                }
            }
        }
        for (KeyPersonInfo keyPersonComp : keyPersons) {
            this.setKeyPersonCompensation(budget, keyPersonComp);
        }
        return keyPersons;
    }

    private void addToKeyPersonList(KeyPersonInfo keyPerson, List<KeyPersonInfo> keyPersons) {
        if (!keyPersons.contains(keyPerson)) {
            keyPersons.add(keyPerson);
        }
    }

    private KeyPersonInfo getKeyPersonFromProposalPerson(ProposalPerson proposalPerson) {
        KeyPersonInfo keyPerson = null;
        if (proposalPerson.getRolodexId() != null) {
            Rolodex rolodexPerson = (Rolodex)this.getBusinessObjectService().findBySinglePrimaryKey(Rolodex.class, (Object)proposalPerson.getRolodexId());
            keyPerson = this.getKeyPeronInfo(rolodexPerson);
        } else if (StringUtils.isNotBlank((CharSequence)proposalPerson.getPersonId())) {
            keyPerson = this.getKeyPersonFromKcPerson(proposalPerson.getPersonId());
        }
        return keyPerson;
    }

    private KeyPersonInfo getKeyPersonFromKcPerson(String personId) {
        KeyPersonInfo keyPerson = null;
        KcPerson kcPerson = null;
        try {
            kcPerson = this.kcPersonService.getKcPersonByPersonId(personId);
        }
        catch (Exception e) {
            LOG.error("Person not found " + String.valueOf(e));
        }
        if (kcPerson != null) {
            keyPerson = new KeyPersonInfo();
            keyPerson.setPersonId(kcPerson.getPersonId());
            keyPerson.setFirstName(kcPerson.getFirstName() == null ? "Unknown" : kcPerson.getFirstName());
            keyPerson.setLastName(kcPerson.getLastName() == null ? "Unknown" : kcPerson.getLastName());
            keyPerson.setMiddleName(kcPerson.getMiddleName());
            keyPerson.setNonMITPersonFlag(false);
            keyPerson.setRole(KEYPERSON_OTHER);
        }
        return keyPerson;
    }

    private KeyPersonInfo getKeyPersonFromTbnPerson(BudgetPersonnelDetails budgetPersonnelDetails) {
        KeyPersonInfo keyPerson = null;
        TbnPerson tbnPerson = budgetPersonnelDetails.getBudgetPerson().getTbnPerson();
        if (tbnPerson != null) {
            keyPerson = new KeyPersonInfo();
            String[] tbnNames = tbnPerson.getPersonName().split(EMPTY_STRING);
            int nameIndex = 0;
            keyPerson.setPersonId(tbnPerson.getTbnId());
            keyPerson.setFirstName(tbnNames.length >= 1 ? tbnNames[nameIndex++] : "Unknown");
            keyPerson.setMiddleName(tbnNames.length >= 3 ? tbnNames[nameIndex++] : EMPTY_STRING);
            keyPerson.setLastName(tbnNames.length >= 2 ? tbnNames[nameIndex++] : "Unknown");
            keyPerson.setRole(tbnPerson.getPersonName());
            keyPerson.setNonMITPersonFlag(false);
        }
        return keyPerson;
    }

    private KeyPersonInfo getKeyPersonFromRolodex(BudgetPersonnelDetails budgetPersonnelDetails) {
        budgetPersonnelDetails.getBudgetPerson().refreshReferenceObject("rolodex");
        Rolodex rolodexPerson = budgetPersonnelDetails.getBudgetPerson().getRolodex();
        KeyPersonInfo keyPerson = this.getKeyPeronInfo(rolodexPerson);
        return keyPerson;
    }

    private KeyPersonInfo getKeyPeronInfo(Rolodex rolodexPerson) {
        KeyPersonInfo keyPerson = new KeyPersonInfo();
        keyPerson.setRolodexId(rolodexPerson.getRolodexId());
        keyPerson.setFirstName(rolodexPerson.getFirstName() == null ? "Unknown" : rolodexPerson.getFirstName());
        keyPerson.setLastName(rolodexPerson.getLastName() == null ? "Unknown" : rolodexPerson.getLastName());
        keyPerson.setMiddleName(rolodexPerson.getMiddleName());
        keyPerson.setRole(StringUtils.isNotBlank((CharSequence)rolodexPerson.getTitle()) ? rolodexPerson.getTitle() : KEYPERSON_OTHER);
        keyPerson.setNonMITPersonFlag(true);
        return keyPerson;
    }

    protected List<BudgetCategoryMapping> getBudgetCategoryMappings(Map<String, String> conditionMap) {
        List budgetCategoryCollection = this.businessObjectService.findMatching(BudgetCategoryMapping.class, conditionMap);
        ArrayList<BudgetCategoryMapping> budgetCategoryMappings = new ArrayList<BudgetCategoryMapping>();
        if (budgetCategoryCollection != null) {
            budgetCategoryMappings.addAll(budgetCategoryCollection);
        }
        return budgetCategoryMappings;
    }

    private void setCompensationForPeriod(KeyPersonInfo keyPerson, BudgetPeriod budgetPeriod, CompensationInfo compensationInfo) {
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetPersonnelDetails personDetails : lineItem.getBudgetPersonnelDetailsList()) {
                if (!this.keyPersonEqualsBudgetPerson(keyPerson, personDetails)) continue;
                BigDecimal numberOfMonths = this.getNumberOfMonths(personDetails.getStartDate(), personDetails.getEndDate()).bigDecimalValue();
                if (personDetails.getPeriodTypeCode().equals("2")) {
                    BigDecimal academicMonths = personDetails.getPercentEffort().bigDecimalValue().multiply(numberOfMonths).multiply(new ScaleTwoDecimal(0.01).bigDecimalValue());
                    if (lineItem.getBudgetCategoryCode().equals(SENIOR_PERSONNEL_CATEGORY_CODE)) {
                        compensationInfo.setAcademicMonths((ScaleTwoDecimal)compensationInfo.getAcademicMonths().add((AbstractDecimal)new ScaleTwoDecimal(academicMonths)));
                    }
                } else if (personDetails.getPeriodTypeCode().equals(PERIOD_TYPE_SUMMER_MONTHS)) {
                    BigDecimal summerMonths = personDetails.getPercentEffort().bigDecimalValue().multiply(numberOfMonths).multiply(new ScaleTwoDecimal(0.01).bigDecimalValue());
                    if (lineItem.getBudgetCategoryCode().equals(SENIOR_PERSONNEL_CATEGORY_CODE)) {
                        compensationInfo.setSummerMonths((ScaleTwoDecimal)compensationInfo.getSummerMonths().add((AbstractDecimal)new ScaleTwoDecimal(summerMonths)));
                    }
                } else {
                    BigDecimal calendarMonths = personDetails.getPercentEffort().bigDecimalValue().multiply(numberOfMonths).multiply(new ScaleTwoDecimal(0.01).bigDecimalValue());
                    if (lineItem.getBudgetCategoryCode().equals(SENIOR_PERSONNEL_CATEGORY_CODE)) {
                        compensationInfo.setCalendarMonths((ScaleTwoDecimal)compensationInfo.getCalendarMonths().add((AbstractDecimal)new ScaleTwoDecimal(calendarMonths)));
                    }
                }
                ScaleTwoDecimal totalSal = personDetails.getSalaryRequested();
                compensationInfo.setRequestedSalary((ScaleTwoDecimal)compensationInfo.getRequestedSalary().add((AbstractDecimal)totalSal));
                ScaleTwoDecimal totalSalCostSharing = personDetails.getCostSharingAmount();
                compensationInfo.setCostSharingAmount((ScaleTwoDecimal)compensationInfo.getCostSharingAmount().add((AbstractDecimal)totalSalCostSharing));
                for (BudgetPersonnelCalculatedAmount personCalculatedAmt : personDetails.getBudgetPersonnelCalculatedAmounts()) {
                    personCalculatedAmt.refreshReferenceObject("rateClass");
                    if ((!personCalculatedAmt.getRateClass().getRateClassTypeCode().equals(RATE_CLASS_TYPE_EMPLOYEE_BENEFITS) || personCalculatedAmt.getRateTypeCode().equals(RATE_TYPE_SUPPORT_STAFF_SALARIES)) && (!personCalculatedAmt.getRateClass().getRateClassTypeCode().equals(RATE_CLASS_TYPE_VACATION) || personCalculatedAmt.getRateTypeCode().equals("2"))) continue;
                    ScaleTwoDecimal fringe = personCalculatedAmt.getCalculatedCost();
                    compensationInfo.setFringe((ScaleTwoDecimal)compensationInfo.getFringe().add((AbstractDecimal)fringe));
                    ScaleTwoDecimal fringeCostSharing = personCalculatedAmt.getCalculatedCostSharing();
                    compensationInfo.setFringeCostSharing((ScaleTwoDecimal)compensationInfo.getFringeCostSharing().add((AbstractDecimal)fringeCostSharing));
                }
                BudgetPerson budgetPerson = personDetails.getBudgetPerson();
                if (budgetPerson == null) continue;
                compensationInfo.setBaseSalary(budgetPerson.getCalculationBase());
                String apptTypeCode = budgetPerson.getAppointmentType().getAppointmentTypeCode();
                if (apptTypeCode.equals(APPOINTMENT_TYPE_SUM_EMPLOYEE) || apptTypeCode.equals(APPOINTMENT_TYPE_TMP_EMPLOYEE)) continue;
                compensationInfo.setBaseSalary(budgetPerson.getCalculationBase());
            }
        }
        compensationInfo.setFundsRequested((ScaleTwoDecimal)compensationInfo.getRequestedSalary().add((AbstractDecimal)compensationInfo.getFringe()));
        compensationInfo.setNonFundsRequested((ScaleTwoDecimal)compensationInfo.getCostSharingAmount().add((AbstractDecimal)compensationInfo.getFringeCostSharing()));
    }

    public boolean keyPersonEqualsBudgetPerson(KeyPersonInfo keyPersonInfo, BudgetPersonnelDetails budgetPersonnelDetails) {
        boolean equal = false;
        if (keyPersonInfo != null && budgetPersonnelDetails != null) {
            String budgetPersonId = budgetPersonnelDetails.getPersonId();
            if (keyPersonInfo.getPersonId() != null && keyPersonInfo.getPersonId().equals(budgetPersonId) || keyPersonInfo.getRolodexId() != null && keyPersonInfo.getRolodexId().toString().equals(budgetPersonId)) {
                equal = true;
            }
        }
        return equal;
    }

    @Override
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public BudgetPersonService getBudgetPersonService() {
        return this.budgetPersonService;
    }

    public void setBudgetPersonService(BudgetPersonService budgetPersonService) {
        this.budgetPersonService = budgetPersonService;
    }

    public SponsorHierarchyService getSponsorHierarchyService() {
        return this.sponsorHierarchyService;
    }

    public void setSponsorHierarchyService(SponsorHierarchyService sponsorHierarchyService) {
        this.sponsorHierarchyService = sponsorHierarchyService;
    }
}

