/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.persistence;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrackingConnection
implements Connection {
    private static final Logger LOG = LogManager.getLogger(TrackingConnection.class);
    private final Connection connection;

    public TrackingConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("the connection was null");
        }
        try {
            ConnectionTracker.addConnection(connection);
        }
        catch (Throwable t) {
            LOG.error("could not add connection for tracking", t);
        }
        finally {
            this.connection = connection;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        try {
            ConnectionTracker.removeConnection(this.connection);
        }
        catch (Throwable t) {
            LOG.error("could not remove connection from tracking", t);
        }
        finally {
            this.connection.close();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(sql, columnNames);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.connection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.connection.isWrapperFor(iface);
    }

    private static final class ConnectionTracker {
        private static final Logger LOG = LogManager.getLogger(ConnectionTracker.class);
        private static final ThreadLocal<Map<String, Collection<ConnectionInfo>>> OPEN_CONNECTIONS = new ThreadLocal<Map<String, Collection<ConnectionInfo>>>(){

            @Override
            protected synchronized Map<String, Collection<ConnectionInfo>> initialValue() {
                return new HashMap<String, Collection<ConnectionInfo>>();
            }
        };

        private ConnectionTracker() {
            throw new UnsupportedOperationException("do not call");
        }

        public static synchronized void addConnection(Connection con) {
            if (con == null) {
                return;
            }
            String key = ConnectionTracker.getConnectionKey(con);
            if (key != null) {
                LOG.debug("Opened a connection to " + key + " by thread " + Thread.currentThread().getName());
                ConnectionTracker.logMultipleConnections(key);
                ConnectionTracker.add(key, con);
            } else {
                LOG.warn("DB Connection key is null.  will not track connection usage.");
            }
        }

        private static synchronized void add(String key, Connection con) {
            Collection<ConnectionInfo> conInfos = ConnectionTracker.getConnectionInfos(key);
            Iterator<ConnectionInfo> i = conInfos.iterator();
            while (i.hasNext()) {
                ConnectionInfo conInfo = i.next();
                if (conInfo.getConnection() != con) continue;
                i.remove();
            }
            conInfos.add(new ConnectionInfo(con, ConnectionTracker.getStackTrace()));
            OPEN_CONNECTIONS.get().put(key, conInfos);
        }

        public static synchronized void removeConnection(Connection con) {
            if (con == null) {
                return;
            }
            String key = ConnectionTracker.getConnectionKey(con);
            if (key != null) {
                LOG.debug("Closed a connection to " + key + " by thread " + Thread.currentThread().getName());
                ConnectionTracker.remove(key, con);
            }
        }

        private static synchronized void remove(String key, Connection con) {
            Collection<ConnectionInfo> conInfos = ConnectionTracker.getConnectionInfos(key);
            Iterator<ConnectionInfo> i = conInfos.iterator();
            while (i.hasNext()) {
                ConnectionInfo conInfo = i.next();
                if (conInfo.getConnection() != con) continue;
                i.remove();
            }
            OPEN_CONNECTIONS.get().put(key, conInfos);
        }

        private static synchronized Collection<ConnectionInfo> getConnectionInfos(String key) {
            ArrayList conInfos = OPEN_CONNECTIONS.get().get(key);
            return conInfos != null ? conInfos : new ArrayList();
        }

        private static String getConnectionKey(Connection con) {
            String uName = null;
            String url = null;
            try {
                uName = con.getMetaData().getUserName();
                url = con.getMetaData().getURL();
            }
            catch (SQLException e) {
                LOG.error("unable to get DB url", (Throwable)e);
            }
            return uName != null && url != null ? uName + " @ " + url : null;
        }

        private static synchronized void logMultipleConnections(String key) {
            Collection<ConnectionInfo> conInfos = OPEN_CONNECTIONS.get().get(key);
            if (conInfos != null && !conInfos.isEmpty()) {
                StringBuilder stacks = new StringBuilder();
                for (ConnectionInfo conInfo : conInfos) {
                    stacks.append(conInfo.getEstablishedStack());
                    stacks.append("\n\n");
                }
                StringBuilder msg = new StringBuilder();
                msg.append("There are ");
                msg.append(conInfos.size());
                msg.append(" connection(s) on this thread ");
                msg.append(Thread.currentThread().getName());
                msg.append(" to ");
                msg.append(key);
                msg.append(" that have not been closed.");
                msg.append(" The following stacktraces show where these connections were established: \n");
                msg.append((CharSequence)stacks);
                LOG.debug((CharSequence)msg);
            }
        }

        private static String getStackTrace() {
            StringBuilder stack = new StringBuilder();
            for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
                stack.append("\tat ");
                stack.append(elem);
                stack.append(SystemUtils.LINE_SEPARATOR);
            }
            return stack.toString();
        }

        private static final class ConnectionInfo {
            private final Connection connection;
            private final String establishedStack;

            private ConnectionInfo(Connection connection, String establishedStack) {
                this.connection = connection;
                this.establishedStack = establishedStack;
            }

            public Connection getConnection() {
                return this.connection;
            }

            public String getEstablishedStack() {
                return this.establishedStack;
            }
        }
    }
}

