/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.budget;

import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

import java.util.List;

public final class S2SOtherDirectCostInfoDto {

    private ScaleTwoDecimal materials;
    private ScaleTwoDecimal publications;
    private ScaleTwoDecimal consultants;
    private ScaleTwoDecimal computer;
    private ScaleTwoDecimal subAwards;
    private ScaleTwoDecimal equipRental;
    private ScaleTwoDecimal alterations;
    private List<S2SOtherCostDto> otherCosts;
    private ScaleTwoDecimal totalOtherDirect;

    private ScaleTwoDecimal domTravel;
    private ScaleTwoDecimal foreignTravel;
    private ScaleTwoDecimal totTravel;

    private ScaleTwoDecimal partTravel;
    private ScaleTwoDecimal partStipends;
    private ScaleTwoDecimal partOther;
    private ScaleTwoDecimal participantTotal;
    private ScaleTwoDecimal partTuition;
    private ScaleTwoDecimal partSubsistence;

    private ScaleTwoDecimal materialsCostSharing;
    private ScaleTwoDecimal publicationsCostSharing;
    private ScaleTwoDecimal consultantsCostSharing;
    private ScaleTwoDecimal computerCostSharing;
    private ScaleTwoDecimal subAwardsCostSharing;
    private ScaleTwoDecimal equipRentalCostSharing;
    private ScaleTwoDecimal alterationsCostSharing;
    private ScaleTwoDecimal domTravelCostSharing;
    private ScaleTwoDecimal foreignTravelCostSharing;
    private ScaleTwoDecimal totTravelCostSharing;
    private ScaleTwoDecimal partStipendsCostSharing;
    private ScaleTwoDecimal partTravelCostSharing;
    private ScaleTwoDecimal partOtherCostSharing;
    private ScaleTwoDecimal participantTotalCostSharing;
    private ScaleTwoDecimal totalOtherDirectCostSharing;
    private ScaleTwoDecimal partTuitionCostSharing;
    private ScaleTwoDecimal partSubsistenceCostSharing;
    private int participantTotalCount;

    public ScaleTwoDecimal getTotalOtherDirect() {
        return totalOtherDirect;
    }

    public void setTotalOtherDirect(ScaleTwoDecimal totalOtherDirect) {
        this.totalOtherDirect = totalOtherDirect;
    }

    public ScaleTwoDecimal getMaterials() {
        return materials;
    }

    public void setMaterials(ScaleTwoDecimal materials) {
        this.materials = materials;
    }

    public ScaleTwoDecimal getPublications() {
        return publications;
    }

    public void setPublications(ScaleTwoDecimal publications) {
        this.publications = publications;
    }

    public ScaleTwoDecimal getConsultants() {
        return consultants;
    }

    public void setConsultants(ScaleTwoDecimal consultants) {
        this.consultants = consultants;
    }

    public ScaleTwoDecimal getComputer() {
        return computer;
    }

    public void setComputer(ScaleTwoDecimal computer) {
        this.computer = computer;
    }

    public ScaleTwoDecimal getSubAwards() {
        return subAwards;
    }

    public void setSubAwards(ScaleTwoDecimal subAwards) {
        this.subAwards = subAwards;
    }

    public ScaleTwoDecimal getEquipRental() {
        return equipRental;
    }

    public void setEquipRental(ScaleTwoDecimal equipRental) {
        this.equipRental = equipRental;
    }

    public ScaleTwoDecimal getAlterations() {
        return alterations;
    }

    public void setAlterations(ScaleTwoDecimal alterations) {
        this.alterations = alterations;
    }

    public ScaleTwoDecimal getDomTravel() {
        return domTravel;
    }

    public void setDomTravel(ScaleTwoDecimal domTravel) {
        this.domTravel = domTravel;
    }

    public ScaleTwoDecimal getForeignTravel() {
        return foreignTravel;
    }

    public void setForeignTravel(ScaleTwoDecimal foreignTravel) {
        this.foreignTravel = foreignTravel;
    }

    public ScaleTwoDecimal getTotTravel() {
        return totTravel;
    }

    public void setTotTravel(ScaleTwoDecimal totTravel) {
        this.totTravel = totTravel;
    }

    public List<S2SOtherCostDto> getOtherCosts() {
        return otherCosts;
    }

    public void setOtherCosts(List<S2SOtherCostDto> otherCosts) {
        this.otherCosts = otherCosts;
    }

    public ScaleTwoDecimal getPartStipends() {
        return partStipends;
    }

    public void setPartStipends(ScaleTwoDecimal partStipends) {
        this.partStipends = partStipends;
    }

    public ScaleTwoDecimal getPartOther() {
        return partOther;
    }

    public void setPartOther(ScaleTwoDecimal partOther) {
        this.partOther = partOther;
    }

    public ScaleTwoDecimal getPartTravel() {
        return partTravel;
    }

    public void setPartTravel(ScaleTwoDecimal partTravel) {
        this.partTravel = partTravel;
    }

    public ScaleTwoDecimal getParticipantTotal() {
        return participantTotal;
    }

    public void setParticipantTotal(ScaleTwoDecimal participantTotal) {
        this.participantTotal = participantTotal;
    }

    public int getParticipantTotalCount() {
        return participantTotalCount;
    }

    public void setParticipantTotalCount(int participantTotalCount) {
        this.participantTotalCount = participantTotalCount;
    }

    public ScaleTwoDecimal getMaterialsCostSharing() {
        return materialsCostSharing;
    }

    public void setMaterialsCostSharing(ScaleTwoDecimal materialsCostSharing) {
        this.materialsCostSharing = materialsCostSharing;
    }

    public ScaleTwoDecimal getPublicationsCostSharing() {
        return publicationsCostSharing;
    }

    public void setPublicationsCostSharing(ScaleTwoDecimal publicationsCostSharing) {
        this.publicationsCostSharing = publicationsCostSharing;
    }

    public ScaleTwoDecimal getConsultantsCostSharing() {
        return consultantsCostSharing;
    }

    public void setConsultantsCostSharing(ScaleTwoDecimal consultantsCostSharing) {
        this.consultantsCostSharing = consultantsCostSharing;
    }

    public ScaleTwoDecimal getComputerCostSharing() {
        return computerCostSharing;
    }

    public void setComputerCostSharing(ScaleTwoDecimal computerCostSharing) {
        this.computerCostSharing = computerCostSharing;
    }

    public ScaleTwoDecimal getSubAwardsCostSharing() {
        return subAwardsCostSharing;
    }

    public void setSubAwardsCostSharing(ScaleTwoDecimal subAwardsCostSharing) {
        this.subAwardsCostSharing = subAwardsCostSharing;
    }

    public ScaleTwoDecimal getEquipRentalCostSharing() {
        return equipRentalCostSharing;
    }

    public void setEquipRentalCostSharing(ScaleTwoDecimal equipRentalCostSharing) {
        this.equipRentalCostSharing = equipRentalCostSharing;
    }

    public ScaleTwoDecimal getAlterationsCostSharing() {
        return alterationsCostSharing;
    }

    public void setAlterationsCostSharing(ScaleTwoDecimal alterationsCostSharing) {
        this.alterationsCostSharing = alterationsCostSharing;
    }

    public ScaleTwoDecimal getDomTravelCostSharing() {
        return domTravelCostSharing;
    }

    public void setDomTravelCostSharing(ScaleTwoDecimal domTravelCostSharing) {
        this.domTravelCostSharing = domTravelCostSharing;
    }

    public ScaleTwoDecimal getForeignTravelCostSharing() {
        return foreignTravelCostSharing;
    }

    public void setForeignTravelCostSharing(ScaleTwoDecimal foreignTravelCostSharing) {
        this.foreignTravelCostSharing = foreignTravelCostSharing;
    }

    public ScaleTwoDecimal getTotTravelCostSharing() {
        return totTravelCostSharing;
    }

    public void setTotTravelCostSharing(ScaleTwoDecimal totTravelCostSharing) {
        this.totTravelCostSharing = totTravelCostSharing;
    }

    public ScaleTwoDecimal getPartStipendsCostSharing() {
        return partStipendsCostSharing;
    }

    public void setPartStipendsCostSharing(ScaleTwoDecimal partStipendsCostSharing) {
        this.partStipendsCostSharing = partStipendsCostSharing;
    }

    public ScaleTwoDecimal getPartTravelCostSharing() {
        return partTravelCostSharing;
    }

    public void setPartTravelCostSharing(ScaleTwoDecimal partTravelCostSharing) {
        this.partTravelCostSharing = partTravelCostSharing;
    }

    public ScaleTwoDecimal getPartOtherCostSharing() {
        return partOtherCostSharing;
    }

    public void setPartOtherCostSharing(ScaleTwoDecimal partOtherCostSharing) {
        this.partOtherCostSharing = partOtherCostSharing;
    }

    public ScaleTwoDecimal getParticipantTotalCostSharing() {
        return participantTotalCostSharing;
    }

    public void setParticipantTotalCostSharing(ScaleTwoDecimal participantTotalCostSharing) {
        this.participantTotalCostSharing = participantTotalCostSharing;
    }

    public ScaleTwoDecimal getTotalOtherDirectCostSharing() {
        return totalOtherDirectCostSharing;
    }

    public void setTotalOtherDirectCostSharing(ScaleTwoDecimal totalOtherDirectCostSharing) {
        this.totalOtherDirectCostSharing = totalOtherDirectCostSharing;
    }

    public ScaleTwoDecimal getPartTuition() {
        return partTuition;
    }

    public void setPartTuition(ScaleTwoDecimal partTuition) {
        this.partTuition = partTuition;
    }

    public ScaleTwoDecimal getPartSubsistence() {
        return partSubsistence;
    }

    public void setPartSubsistence(ScaleTwoDecimal partSubsistence) {
        this.partSubsistence = partSubsistence;
    }

    public ScaleTwoDecimal getPartTuitionCostSharing() {
        return partTuitionCostSharing;
    }

    public void setPartTuitionCostSharing(ScaleTwoDecimal partTuitionCostSharing) {
        this.partTuitionCostSharing = partTuitionCostSharing;
    }

    public ScaleTwoDecimal getPartSubsistenceCostSharing() {
        return partSubsistenceCostSharing;
    }

    public void setPartSubsistenceCostSharing(ScaleTwoDecimal partSubsistenceCostSharing) {
        this.partSubsistenceCostSharing = partSubsistenceCostSharing;
    }
}
