/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.api.generate;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

public final class AttachmentData {
    private final String fileDataId;
    private final String fileName;
    private final String contentId;
    private final byte[] content;
    private final String contentType;
    private final String hashAlgorithm;
    private final String hashValue;
    private final String uploadUser;
    private final Date uploadTimestamp;

    public AttachmentData(String fileDataId, String fileName, String contentId, byte[] content, String contentType, String hashAlgorithm, String hashValue, String uploadUser, Date uploadTimestamp) {
        this.fileDataId = fileDataId;
        this.fileName = fileName;
        this.contentId = contentId;
        this.content = content;
        this.contentType = contentType;
        this.hashAlgorithm = hashAlgorithm;
        this.hashValue = hashValue;
        this.uploadUser = uploadUser;
        this.uploadTimestamp = uploadTimestamp;
        if (StringUtils.isBlank(fileName)) {
            throw new IllegalArgumentException("fileName is blank");
        }
        if (StringUtils.isBlank(contentId)) {
            throw new IllegalArgumentException("contentId is blank");
        }
        if (content == null || content.length == 0) {
            throw new IllegalArgumentException("content is null or empty");
        }
        if (StringUtils.isBlank(contentType)) {
            throw new IllegalArgumentException("contentType is blank");
        }
        if (StringUtils.isBlank(hashAlgorithm)) {
            throw new IllegalArgumentException("hashAlgorithm is blank");
        }
        if (StringUtils.isBlank(hashValue)) {
            throw new IllegalArgumentException("hashValue is blank");
        }
    }

    public AttachmentData(AttachmentData attachment) {
        this(attachment.fileDataId, attachment.fileName, attachment.contentId, attachment.content, attachment.contentType, attachment.hashAlgorithm, attachment.hashValue, attachment.uploadUser, attachment.uploadTimestamp);
    }

    public String getFileDataId() {
        return this.fileDataId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentId() {
        return this.contentId;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHashValue() {
        return this.hashValue;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getUploadUser() {
        return this.uploadUser;
    }

    public Date getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttachmentData)) {
            return false;
        }
        AttachmentData that = (AttachmentData)o;
        return Objects.equals(this.fileDataId, that.fileDataId) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.contentId, that.contentId) && Objects.deepEquals(this.content, that.content) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.hashAlgorithm, that.hashAlgorithm) && Objects.equals(this.hashValue, that.hashValue) && Objects.equals(this.uploadUser, that.uploadUser) && Objects.equals(this.uploadTimestamp, that.uploadTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.fileDataId, this.fileName, this.contentId, Arrays.hashCode(this.content), this.contentType, this.hashAlgorithm, this.hashValue, this.uploadUser, this.uploadTimestamp);
    }

    private static final class StringUtils {
        private StringUtils() {
            throw new UnsupportedOperationException("do not call");
        }

        public static boolean isBlank(CharSequence cs) {
            int strLen = StringUtils.length(cs);
            if (strLen == 0) {
                return true;
            }
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static int length(CharSequence cs) {
            return cs == null ? 0 : cs.length();
        }
    }
}

