/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.coeus.s2sgen.api.print;

import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;

import java.util.List;
import java.util.Set;

/**
 * This service retrieves a list of form elements to be used in printing related activities.
 */
public interface FormPackageService {

    /**
     * Retrieves form package for the requested namespaces using generators, user attached forms, s2s override,
     * or submitted XML.
     *
     * @param namespaces the requested namespaces.  If empty, will return an empty list.  Cannot be null.
     * @param pdDoc the proposal document to aid in the form element generation.  Cannot be null.
     * @return a list of form elements.  Will not return null
     */
    FormPackage retrieveFormPackage(Set<String> namespaces, ProposalDevelopmentDocumentContract pdDoc);

    /**
     * Retrieves form elements for the requested namespaces using generators, user attached forms, s2s override,
     * or submitted XML.
     *
     * @param namespaces the requested namespaces.  If empty, will return an empty list.  Cannot be null.
     * @param pdDoc the proposal document to aid in the form element generation.  Cannot be null.
     * @return a list of form elements.  Will not return null
     */
    List<FormElements> retrieveFormElements(Set<String> namespaces, ProposalDevelopmentDocumentContract pdDoc);
}
